/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.ide;

import java.util.Vector;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IOperation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IParameter;
import org.netbeans.modules.uml.core.roundtripframework.IChangeRequest;
import org.netbeans.modules.uml.core.roundtripframework.IMultipleParameterTypeChangeRequest;
import org.netbeans.modules.uml.core.roundtripframework.IParameterChangeRequest;
import org.netbeans.modules.uml.core.roundtripframework.IParameterTypeChangeRequest;
import org.netbeans.modules.uml.core.roundtripframework.IRoundTripOperationEventsSink;
import org.netbeans.modules.uml.core.support.umlsupport.IResultCell;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.integration.ide.ChangeUtils;
import org.netbeans.modules.uml.integration.ide.RoundTripSource;
import org.netbeans.modules.uml.integration.ide.events.ClassInfo;
import org.netbeans.modules.uml.integration.ide.events.MethodInfo;
import org.netbeans.modules.uml.integration.ide.events.MethodParameterInfo;
import org.netbeans.modules.uml.integration.ide.listeners.IOperationChangeListener;

public class RoundTripOperationEventsSink
extends RoundTripSource
implements IRoundTripOperationEventsSink {
    private static Vector changeListeners = new Vector();

    public void onPreOperationChangeRequest(IChangeRequest iChangeRequest, IResultCell iResultCell) {
    }

    public void onOperationChangeRequest(IChangeRequest iChangeRequest, IResultCell iResultCell) {
        try {
            ChangeUtils.say(iChangeRequest);
            this.fireOperationChangeEvent(iChangeRequest, false);
        }
        catch (Exception exception) {
            Log.stackTrace((Throwable)exception);
        }
    }

    protected void fireOperationChangeEvent(IChangeRequest iChangeRequest, boolean bl) {
        block25: {
            IElement iElement;
            block24: {
                int n = iChangeRequest.getState();
                iElement = iChangeRequest.getBefore();
                IElement iElement2 = iChangeRequest.getAfter();
                if (!(iElement instanceof IOperation)) break block24;
                IOperation iOperation = (IOperation)iElement;
                IOperation iOperation2 = (IOperation)iElement2;
                switch (n) {
                    case 2: {
                        if (!this.isValidEvent((INamedElement)iOperation2)) break;
                        MethodInfo methodInfo = new MethodInfo(null, iOperation2);
                        this.fireOperationAddedEvent(methodInfo, bl);
                        if (!methodInfo.isAccessor() && !methodInfo.isMutator()) {
                            this.scheduleForNavigation((IElement)iOperation2);
                            break;
                        }
                        break block25;
                    }
                    case 1: {
                        if (!this.isValidEvent((INamedElement)iOperation)) break;
                        MethodInfo methodInfo = new MethodInfo(null, iOperation);
                        this.fireOperationDeletedEvent(methodInfo, bl);
                        break;
                    }
                    case 0: {
                        if (!this.isValidEvent((INamedElement)iOperation) || !this.isValidEvent((INamedElement)iOperation2)) break;
                        MethodInfo methodInfo = new MethodInfo(null, iOperation);
                        MethodInfo methodInfo2 = new MethodInfo(null, iOperation2);
                        if (methodInfo.getContainingClass() == null && methodInfo2.getContainingClass() != null) {
                            methodInfo.setContainingClass(methodInfo2.getContainingClass());
                        }
                        if (iChangeRequest.getRequestDetailType() == 57) {
                            IMultipleParameterTypeChangeRequest iMultipleParameterTypeChangeRequest = (IMultipleParameterTypeChangeRequest)iChangeRequest;
                            IOperation iOperation3 = iMultipleParameterTypeChangeRequest.getImpactedOperation();
                            methodInfo = new MethodInfo(null, iOperation3);
                            methodInfo2 = new MethodInfo(null, iOperation3);
                            MethodParameterInfo[] methodParameterInfoArray = methodInfo.getParameters();
                            for (int i = 0; i < methodParameterInfoArray.length; ++i) {
                                if (!methodParameterInfoArray[i].getType().equals(iMultipleParameterTypeChangeRequest.getNewTypeName())) continue;
                                methodParameterInfoArray[i].setType(iMultipleParameterTypeChangeRequest.getOldTypeName());
                            }
                            methodInfo.setParameters(methodParameterInfoArray);
                        }
                        Log.out((String)("Firing change event for " + methodInfo.getName() + " to " + methodInfo2.getName()));
                        this.fireOperationChangedEvent(methodInfo, methodInfo2, bl);
                    }
                }
                break block25;
            }
            if (iElement instanceof IParameter) {
                if (iChangeRequest instanceof IParameterChangeRequest) {
                    IClassifier iClassifier;
                    IParameterChangeRequest iParameterChangeRequest = (IParameterChangeRequest)iChangeRequest;
                    IOperation iOperation = iParameterChangeRequest.getBeforeOperation();
                    IOperation iOperation4 = iParameterChangeRequest.getAfterOperation();
                    if (!this.isValidEvent((INamedElement)iOperation) || !this.isValidEvent((INamedElement)iOperation4)) {
                        return;
                    }
                    IElement iElement3 = iOperation.getOwner();
                    if (iElement3 == null) {
                        iElement3 = iOperation4.getOwner();
                    }
                    IClassifier iClassifier2 = iClassifier = iElement3 instanceof IClassifier ? (IClassifier)iElement3 : null;
                    if (iElement3 == null || iClassifier == null) {
                        Log.out((String)"E----- Can't find class owning operation");
                        return;
                    }
                    ClassInfo classInfo = null;
                    try {
                        classInfo = ClassInfo.getRefClassInfo(iClassifier, true);
                    }
                    catch (Exception exception) {
                        Log.stackTrace((Throwable)exception);
                    }
                    MethodInfo methodInfo = new MethodInfo(classInfo, iOperation);
                    MethodInfo methodInfo3 = new MethodInfo(classInfo, iOperation4);
                    this.fireOperationChangedEvent(methodInfo, methodInfo3, bl);
                } else {
                    IClassifier iClassifier;
                    IParameterTypeChangeRequest iParameterTypeChangeRequest = (IParameterTypeChangeRequest)iChangeRequest;
                    IParameter iParameter = iParameterTypeChangeRequest.getImpactedParameter();
                    IOperation iOperation = (IOperation)iParameter.getOwner();
                    IOperation iOperation5 = (IOperation)iParameter.getOwner();
                    if (!this.isValidEvent((INamedElement)iOperation) || !this.isValidEvent((INamedElement)iOperation5)) {
                        return;
                    }
                    IElement iElement4 = iOperation.getOwner();
                    if (iElement4 == null) {
                        iElement4 = iOperation5.getOwner();
                    }
                    IClassifier iClassifier3 = iClassifier = iElement4 instanceof IClassifier ? (IClassifier)iElement4 : null;
                    if (iElement4 == null || iClassifier == null) {
                        Log.out((String)"E----- Can't find class owning operation");
                        return;
                    }
                    ClassInfo classInfo = null;
                    try {
                        classInfo = ClassInfo.getRefClassInfo(iClassifier, true);
                    }
                    catch (Exception exception) {
                        Log.stackTrace((Throwable)exception);
                    }
                    MethodInfo methodInfo = new MethodInfo(classInfo, iOperation);
                    MethodInfo methodInfo4 = new MethodInfo(classInfo, iOperation5);
                    MethodParameterInfo[] methodParameterInfoArray = methodInfo.getParameters();
                    MethodParameterInfo methodParameterInfo = null;
                    for (int i = 0; i < methodParameterInfoArray.length; ++i) {
                        if (!methodParameterInfoArray[i].getName().equals(iParameter.getName())) continue;
                        methodParameterInfo = methodParameterInfoArray[i];
                        methodParameterInfo.setType(iParameterTypeChangeRequest.getOldTypeName());
                    }
                    this.fireOperationChangedEvent(methodInfo, methodInfo4, bl);
                }
            } else {
                Log.out((String)"Unknown event object!");
            }
        }
    }

    protected void fireOperationAddedEvent(final MethodInfo methodInfo, final boolean bl) {
        if (!this.isValidEvent(methodInfo, methodInfo.getContainingClass())) {
            return;
        }
        Log.out((String)("Operation added (M->S): " + methodInfo));
        for (int i = 0; i < changeListeners.size(); ++i) {
            final IOperationChangeListener iOperationChangeListener = (IOperationChangeListener)changeListeners.elementAt(i);
            RoundTripSource.RoundtripThread roundtripThread = new RoundTripSource.RoundtripThread(){

                public void work() {
                    RoundTripOperationEventsSink.this.setDefaultProject(methodInfo);
                    iOperationChangeListener.operationAdded(methodInfo, bl);
                }
            };
            this.queue(roundtripThread);
        }
    }

    protected void fireOperationDeletedEvent(final MethodInfo methodInfo, final boolean bl) {
        if (!this.isValidEvent(methodInfo, methodInfo.getContainingClass())) {
            return;
        }
        Log.out((String)("Operation deleted (M->S): " + methodInfo));
        for (int i = 0; i < changeListeners.size(); ++i) {
            final IOperationChangeListener iOperationChangeListener = (IOperationChangeListener)changeListeners.elementAt(i);
            RoundTripSource.RoundtripThread roundtripThread = new RoundTripSource.RoundtripThread(){

                public void work() {
                    RoundTripOperationEventsSink.this.setDefaultProject(methodInfo);
                    iOperationChangeListener.operationDeleted(methodInfo, bl);
                }
            };
            this.queue(roundtripThread);
        }
    }

    protected void fireOperationChangedEvent(final MethodInfo methodInfo, final MethodInfo methodInfo2, final boolean bl) {
        Log.out((String)("Operation changed (M->S) from " + methodInfo + " to " + methodInfo2));
        for (int i = 0; i < changeListeners.size(); ++i) {
            final IOperationChangeListener iOperationChangeListener = (IOperationChangeListener)changeListeners.elementAt(i);
            RoundTripSource.RoundtripThread roundtripThread = new RoundTripSource.RoundtripThread(){

                public void work() {
                    RoundTripOperationEventsSink.this.setDefaultProject(methodInfo2);
                    iOperationChangeListener.operationChanged(methodInfo, methodInfo2, bl);
                }
            };
            this.queue(roundtripThread);
        }
    }

    public static void addOperationChangeListener(IOperationChangeListener iOperationChangeListener) {
        if (iOperationChangeListener != null && !changeListeners.contains(iOperationChangeListener)) {
            changeListeners.add(iOperationChangeListener);
        }
    }

    public static void removeOperationChangeListener(IOperationChangeListener iOperationChangeListener) {
        if (iOperationChangeListener != null) {
            changeListeners.remove(iOperationChangeListener);
        }
    }
}

