/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.ide;

import javax.swing.SwingUtilities;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.dynamics.ILifeline;
import org.netbeans.modules.uml.core.metamodel.dynamics.IMessage;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAssociation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAssociationEnd;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAttribute;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IGeneralization;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IImplementation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.INavigableEnd;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IOperation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IStructuralFeature;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.integration.ide.ISourceNavigable;
import org.netbeans.modules.uml.integration.ide.Preferences;
import org.netbeans.modules.uml.integration.ide.SourceNavigator;
import org.netbeans.modules.uml.integration.ide.UMLSupport;
import org.netbeans.modules.uml.integration.ide.events.ClassInfo;
import org.netbeans.modules.uml.integration.ide.events.MemberInfo;
import org.netbeans.modules.uml.integration.ide.events.MethodInfo;

public abstract class SourceNavigable
implements ISourceNavigable {
    protected SourceNavigator navigator;
    private int lineNoOffset = 0;

    public void setSourceNavigator(SourceNavigator sourceNavigator) {
        this.navigator = sourceNavigator;
    }

    public SourceNavigator getSourceNavigator() {
        return this.navigator;
    }

    protected void fireNavigateEvent(IElement iElement) {
        try {
            if (UMLSupport.navigateToSource) {
                this.doFireNavigateEvent(iElement);
            }
        }
        catch (Throwable throwable) {
            Log.stackTrace((Throwable)throwable);
        }
    }

    protected void fireNavigateMethod(final MethodInfo methodInfo) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (methodInfo != null) {
                    String string = methodInfo.getFilename();
                    String string2 = null;
                    IProject iProject = methodInfo.getProject();
                    if (iProject != null) {
                        string2 = iProject.getName();
                    }
                    UMLSupport.setProjectForPath(string, string2);
                    SourceNavigable.this.navigator.navigateTo(methodInfo);
                }
            }
        });
    }

    protected void fireNavigateAttribute(final MemberInfo memberInfo) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (memberInfo != null) {
                    String string = memberInfo.getFilename();
                    String string2 = null;
                    IProject iProject = memberInfo.getProject();
                    if (iProject != null) {
                        string2 = iProject.getName();
                    }
                    UMLSupport.setProjectForPath(string, string2);
                    SourceNavigable.this.navigator.navigateTo(memberInfo);
                }
            }
        });
    }

    protected void fireNavigateClass(final ClassInfo classInfo) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (classInfo != null) {
                    String string = classInfo.getFilename();
                    String string2 = null;
                    IProject iProject = classInfo.getProject();
                    if (iProject != null) {
                        string2 = iProject.getName();
                    }
                    UMLSupport.setProjectForPath(string, string2);
                    SourceNavigable.this.navigator.navigateTo(classInfo);
                }
            }
        });
    }

    protected void doFireNavigateEvent(IElement iElement) {
        if (this.navigator == null || iElement == null) {
            return;
        }
        if (iElement instanceof IOperation) {
            IOperation iOperation = (IOperation)iElement;
            MethodInfo methodInfo = new MethodInfo(null, iOperation);
            methodInfo.setLineNo(this.lineNoOffset);
            if (methodInfo.getContainingClass() != null) {
                this.fireNavigateMethod(methodInfo);
            }
            this.lineNoOffset = 0;
        } else if (iElement instanceof IAttribute) {
            IAttribute iAttribute = (IAttribute)iElement;
            MemberInfo memberInfo = new MemberInfo((IStructuralFeature)iAttribute);
            if (memberInfo.getContainingClass() != null) {
                this.fireNavigateAttribute(memberInfo);
            }
        } else if (iElement instanceof IGeneralization) {
            IGeneralization iGeneralization = (IGeneralization)iElement;
            IClassifier iClassifier = iGeneralization.getSpecific();
            ClassInfo classInfo = new ClassInfo(iClassifier);
            this.fireNavigateClass(classInfo);
        } else if (iElement instanceof IImplementation) {
            IImplementation iImplementation = (IImplementation)iElement;
            IClassifier iClassifier = iImplementation.getImplementingClassifier();
            ClassInfo classInfo = new ClassInfo(iClassifier);
            this.fireNavigateClass(classInfo);
        } else if (iElement instanceof IAssociation) {
            IAssociation iAssociation = (IAssociation)iElement;
            ETList eTList = iAssociation.getEnds();
            if (eTList.getCount() > 0) {
                for (int i = 0; i < eTList.getCount(); ++i) {
                    IAssociationEnd iAssociationEnd = (IAssociationEnd)eTList.item(i);
                    if (!iAssociationEnd.getIsNavigable()) continue;
                    INavigableEnd iNavigableEnd = (INavigableEnd)iAssociationEnd;
                    MemberInfo memberInfo = new MemberInfo((IStructuralFeature)iNavigableEnd);
                    this.fireNavigateAttribute(memberInfo);
                    break;
                }
            }
        } else if (iElement instanceof ILifeline) {
            ILifeline iLifeline = (ILifeline)iElement;
            IClassifier iClassifier = iLifeline.getRepresentingClassifier();
            if (iClassifier != null) {
                ClassInfo classInfo = new ClassInfo(iClassifier);
                this.fireNavigateClass(classInfo);
            }
        } else if (iElement instanceof IMessage) {
            IMessage iMessage = (IMessage)iElement;
            IOperation iOperation = null;
            IElement iElement2 = iMessage.getInteraction().getOwner();
            if (iElement2 instanceof IOperation) {
                iOperation = (IOperation)iMessage.getInteraction().getOwner();
                this.lineNoOffset = iElement.getLineNumber() - 1;
            }
            if (iOperation != null) {
                this.doFireNavigateEvent((IElement)iOperation);
            }
        } else if (iElement instanceof IClassifier) {
            IClassifier iClassifier = (IClassifier)iElement;
            if (iClassifier.getName().equals(Preferences.getDefaultElementName())) {
                return;
            }
            ClassInfo classInfo = ClassInfo.getRefClassInfo(iClassifier, true);
            this.fireNavigateClass(classInfo);
        }
    }
}

