/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.ide.events;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IClass;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IEnumeration;
import org.netbeans.modules.uml.core.metamodel.core.constructs.IEnumerationLiteral;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IPackage;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IVersionableElement;
import org.netbeans.modules.uml.core.metamodel.diagrams.ICoreRelationshipDiscovery;
import org.netbeans.modules.uml.core.metamodel.diagrams.IDiagram;
import org.netbeans.modules.uml.core.metamodel.infrastructure.IDerivationClassifier;
import org.netbeans.modules.uml.core.metamodel.infrastructure.RelationFactory;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.ClassifierTemplateParameter;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAssociation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAssociationEnd;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAttribute;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IGeneralization;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IImplementation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IInterface;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.INavigableEnd;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IOperation;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IStructuralFeature;
import org.netbeans.modules.uml.core.metamodel.structure.IProject;
import org.netbeans.modules.uml.core.metamodel.structure.ISourceFileArtifact;
import org.netbeans.modules.uml.core.metamodel.structure.Project;
import org.netbeans.modules.uml.core.support.umlsupport.FileManip;
import org.netbeans.modules.uml.core.support.umlsupport.FileSysManip;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.integration.ide.JavaClassUtils;
import org.netbeans.modules.uml.integration.ide.UMLSupport;
import org.netbeans.modules.uml.integration.ide.events.ConstructorInfo;
import org.netbeans.modules.uml.integration.ide.events.ElementInfo;
import org.netbeans.modules.uml.integration.ide.events.EventFilter;
import org.netbeans.modules.uml.integration.ide.events.EventManager;
import org.netbeans.modules.uml.integration.ide.events.GenCodeUtil;
import org.netbeans.modules.uml.integration.ide.events.LiteralInfo;
import org.netbeans.modules.uml.integration.ide.events.MemberInfo;
import org.netbeans.modules.uml.integration.ide.events.MethodInfo;
import org.netbeans.modules.uml.integration.ide.events.SymbolTransaction;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassInfo
extends ElementInfo {
    private static final Logger logger = Logger.getLogger(ClassInfo.class.getName());
    public static final String DS_CLASS = "Class";
    public static final String DS_INTERFACE = "Interface";
    public static final String DS_ENUMERATION = "Enumeration";
    public static final String DS_STE_INTERFACE = "interface";
    public static final String DS_STE_ENUMERATION = "enumeration";
    private String id = null;
    private ClassInfo outerClass = null;
    private String mNewExtendedClass = null;
    private IClassifier mSuperClass = null;
    private String mNewExtendedPack = null;
    private String mRemoveExtendedPack = null;
    private String mRemoveExtendedClass = null;
    private Vector mImports = new Vector();
    private Vector mMembers = new Vector();
    private Vector mMethods = new Vector();
    private Vector mConstructors = new Vector();
    private Vector<ClassInfo> mInnerClasses = new Vector();
    private Vector mInterfaces = new Vector();
    private ArrayList<IClassifier> superInterfaces = new ArrayList();
    private Vector mLiterals = new Vector();
    private String mFilename = null;
    private Boolean mIsInnerClass = null;
    private String mOrigPackage = null;
    private String mNewPackage = null;
    private EventFilter filter = null;
    private String basePath = null;
    private boolean mIsInterface = false;
    private boolean mIsEnumeration = false;
    private boolean referenceClass = false;
    private static boolean executingAddin = false;
    private String exportSourceFolderName;
    private IClassifier classElement;
    private static Hashtable refClassInfos = new Hashtable();
    private String[] fullyQualifiedName = null;
    private String codeGenTypeFullyQualified = null;
    private String codeGenTypeShort = null;
    private HashSet<String> attrNames = null;

    public ClassInfo(int n) {
        super(n);
        this.setName("");
        this.setPackage("");
    }

    public ClassInfo(IClassifier iClassifier) {
        super((INamedElement)iClassifier);
        if (iClassifier != null) {
            ClassInfo.eraseRefClass(iClassifier);
            this.setFromClassifier(iClassifier);
        }
    }

    @Override
    public IProject getOwningProject() {
        return this.classElement != null ? this.classElement.getProject() : (this.getOuterClass() != null ? this.getOuterClass().getOwningProject() : null);
    }

    public String getSourceDirectory() {
        if (this.classElement == null) {
            return null;
        }
        try {
            IClassifier iClassifier = this.classElement;
            while ((iClassifier = iClassifier.getOwner()) != null && !(iClassifier instanceof IPackage)) {
            }
            if (iClassifier == null) {
                Log.impossible((String)("Classifier " + this.classElement.getName() + " is not in a package?"));
                return null;
            }
            IPackage iPackage = (IPackage)iClassifier;
            return iPackage.getSourceDir();
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, null, exception);
            return null;
        }
    }

    public String getExportSourcePackage() {
        if (this.classElement == null) {
            return null;
        }
        try {
            IPackage iPackage;
            String string;
            IClassifier iClassifier = this.classElement;
            while ((iClassifier = iClassifier.getOwner()) != null && !(iClassifier instanceof IPackage)) {
            }
            if (iClassifier == null) {
                Log.impossible((String)("Classifier " + this.classElement.getName() + " is not in a package?"));
                return null;
            }
            String string2 = "";
            if (!(iClassifier instanceof IProject) && (string = (iPackage = (IPackage)iClassifier).getFullyQualifiedName(false)) != null) {
                string2 = string.replace("::", File.separator);
            }
            return this.createPath(this.getExportSourceFolderName(), string2);
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, null, exception);
            return null;
        }
    }

    private String createPath(String string, String string2) {
        String string3 = string;
        if (string.length() > 0 && string2.length() > 0) {
            String string4 = FileSysManip.addBackslash((String)string);
            string4 = string4 + string2;
            string3 = FileManip.resolveVariableExpansion((String)string4);
        }
        return string3;
    }

    public String getRootSourceDirectory() {
        String string = this.getExportSourceFolderName() != null ? this.getExportSourceFolderName() : this.getSourceDirectory();
        if (string != null) {
            try {
                IClassifier iClassifier = this.classElement;
                while ((iClassifier = iClassifier.getOwner()) != null && !(iClassifier instanceof IProject)) {
                    if (!(iClassifier instanceof IPackage)) continue;
                    string = new File(string).getParent();
                }
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, null, exception);
            }
        }
        return string;
    }

    @Override
    public IProject getProject() {
        return this.classElement != null ? this.classElement.getProject() : null;
    }

    protected void setRefInfo(IClassifier iClassifier) {
        this.classElement = iClassifier;
        if (iClassifier == null) {
            return;
        }
        String string = JavaClassUtils.getFullyQualifiedName((INamedElement)iClassifier);
        this.setId(iClassifier.getXMIID());
        this.setName(JavaClassUtils.getFullInnerClassName(string));
        this.setPackage(JavaClassUtils.getPackageName(string));
        this.setIsInterface(iClassifier instanceof IInterface);
        this.setIsEnumeration(iClassifier instanceof IEnumeration);
        IElement iElement = iClassifier.getOwner();
        if (iElement instanceof IClassifier) {
            IClassifier iClassifier2 = (IClassifier)iElement;
            this.outerClass = ClassInfo.getRefClassInfo(iClassifier2, true);
        }
        this.updateFilename(null);
    }

    public void setFromClassifier(IClassifier iClassifier) {
        if (iClassifier == null || iClassifier.getName() == null) {
            return;
        }
        this.setRefInfo(iClassifier);
        this.referenceClass = JavaClassUtils.isReferenceClass(iClassifier);
        int n = JavaClassUtils.getJavaModifier(iClassifier.getVisibility());
        if (iClassifier.getIsLeaf()) {
            n |= 0x10;
        }
        if (iClassifier.getIsAbstract() && !(iClassifier instanceof IInterface)) {
            n |= 0x400;
        }
        this.setModifiers(new Integer(n));
        this.setSuperInterfaces(iClassifier);
        this.setSuperclass(iClassifier);
        if (iClassifier instanceof IEnumeration) {
            this.setLiterals((IEnumeration)iClassifier);
        }
    }

    public void setLiterals(IEnumeration iEnumeration) {
        if (this.mLiterals == null) {
            this.mLiterals = new Vector();
        } else {
            this.mLiterals.clear();
        }
        for (IEnumerationLiteral iEnumerationLiteral : iEnumeration.getLiterals()) {
            this.mLiterals.add(new LiteralInfo(this, iEnumerationLiteral));
        }
    }

    public boolean isReferenceClass() {
        return this.referenceClass;
    }

    protected IProject getOwningProject(IElement iElement) {
        for (IElement iElement2 = iElement.getOwner(); iElement2 != null; iElement2 = iElement2.getOwner()) {
            if (!(iElement2 instanceof IProject)) continue;
            return (IProject)iElement2;
        }
        return null;
    }

    public void setMethodsAndMembers(IClassifier iClassifier) {
        Object object;
        ETList eTList = iClassifier.getOperations();
        for (int i = 0; i < eTList.getCount(); ++i) {
            IOperation iOperation = (IOperation)eTList.item(i);
            this.addMethod(new MethodInfo(this, iOperation));
        }
        ETList eTList2 = iClassifier.getAttributes();
        for (int i = 0; i < eTList2.getCount(); ++i) {
            IAttribute iAttribute = (IAttribute)eTList2.item(i);
            this.addMember(new MemberInfo(this, (IStructuralFeature)iAttribute));
        }
        ETList eTList3 = iClassifier.getAssociations();
        int n = eTList3.size();
        for (int i = 0; i < n; ++i) {
            IAssociation iAssociation = (IAssociation)eTList3.get(i);
            ETList eTList4 = iAssociation.getEnds();
            if (eTList4.size() != 2) continue;
            if (eTList4.get(0) instanceof INavigableEnd && !iClassifier.isSame((IVersionableElement)(object = (INavigableEnd)eTList4.get(0)).getParticipant())) {
                this.addMember(new MemberInfo(this, (IStructuralFeature)object));
            }
            if (eTList4.get(1) instanceof INavigableEnd && !iClassifier.isSame((IVersionableElement)(object = (INavigableEnd)eTList4.get(1)).getParticipant())) {
                this.addMember(new MemberInfo(this, (IStructuralFeature)object));
            }
            if (!iClassifier.isSame((IVersionableElement)((IAssociationEnd)eTList4.get(0)).getParticipant()) || !iClassifier.isSame((IVersionableElement)((IAssociationEnd)eTList4.get(1)).getParticipant())) continue;
            object = null;
            if (eTList4.get(0) instanceof INavigableEnd) {
                object = (INavigableEnd)eTList4.get(0);
            } else if (eTList4.get(1) instanceof INavigableEnd) {
                object = (INavigableEnd)eTList4.get(1);
            }
            if (object == null) continue;
            this.addMember(new MemberInfo(this, (IStructuralFeature)object));
        }
        for (MemberInfo memberInfo : this.mMembers) {
            memberInfo.checkGenerateName();
        }
        ETList eTList5 = iClassifier.getOwnedElements();
        if (eTList5 != null) {
            for (ETList eTList4 : eTList5) {
                if (!(eTList4 instanceof IClass) && !(eTList4 instanceof IInterface) && !(eTList4 instanceof IEnumeration)) continue;
                object = ClassInfo.getRefClassInfo((IClassifier)eTList4, true, true);
                this.addInnerClass((ClassInfo)object);
            }
        }
    }

    protected void setSuperclass(IClassifier iClassifier) {
        String string = this.getSuperclass(iClassifier);
        if (string != null) {
            if (!(iClassifier instanceof IEnumeration)) {
                this.setExtendedClass(JavaClassUtils.getPackageName(string), JavaClassUtils.getFullInnerClassName(string));
            } else {
                IClassifier iClassifier2 = ((IGeneralization)iClassifier.getGeneralizations().get(0)).getGeneral();
                if (iClassifier2 instanceof IInterface) {
                    this.addSuperInterface(iClassifier2);
                }
            }
        }
    }

    protected String getSuperclass(IClassifier iClassifier) {
        IClassifier iClassifier2;
        IGeneralization iGeneralization;
        if (iClassifier == null || iClassifier instanceof IInterface || iClassifier instanceof IEnumeration) {
            return null;
        }
        ETList eTList = iClassifier.getGeneralizations();
        if (eTList != null && eTList.getCount() > 0 && (iGeneralization = (IGeneralization)eTList.item(0)) != null && (iClassifier2 = iGeneralization.getGeneral()) != null) {
            IClassifier iClassifier3;
            Object object;
            if (iClassifier2 instanceof IEnumeration) {
                return null;
            }
            if (JavaClassUtils.isAnOwner(iClassifier, iClassifier2)) {
                return null;
            }
            if (iClassifier2 instanceof IDerivationClassifier && (object = iClassifier2.getDerivation()) != null && (iClassifier3 = object.getTemplate()) instanceof IInterface) {
                this.addSuperInterface(iClassifier2);
                return null;
            }
            this.setSuperClass(iClassifier2);
            object = JavaClassUtils.getFullyQualifiedName((INamedElement)iClassifier2);
            return object;
        }
        return null;
    }

    protected void setSuperInterfaces(IClassifier iClassifier) {
        block4: {
            block3: {
                this.mInterfaces.clear();
                this.superInterfaces.clear();
                if (!this.isInterface()) break block3;
                ETList eTList = iClassifier.getGeneralizations();
                if (eTList == null || eTList.getCount() <= 0) break block4;
                for (int i = 0; i < eTList.getCount(); ++i) {
                    IClassifier iClassifier2 = ((IGeneralization)eTList.item(i)).getGeneral();
                    if (iClassifier2 == null || JavaClassUtils.isAnOwner(iClassifier, iClassifier2)) continue;
                    String string = JavaClassUtils.getFullyQualifiedName((INamedElement)iClassifier2);
                    this.addInterface(string);
                    this.superInterfaces.add(iClassifier2);
                }
                break block4;
            }
            ETList eTList = iClassifier.getImplementations();
            if (eTList != null && eTList.getCount() > 0) {
                for (int i = 0; i < eTList.getCount(); ++i) {
                    INamedElement iNamedElement = ((IImplementation)eTList.item(i)).getSupplier();
                    if (iNamedElement == null || JavaClassUtils.isAnOwner(iClassifier, (IClassifier)iNamedElement)) continue;
                    String string = JavaClassUtils.getFullyQualifiedName(iNamedElement);
                    this.addInterface(string);
                    this.superInterfaces.add((IClassifier)iNamedElement);
                }
            }
        }
    }

    public static void setExecutingAddin(boolean bl) {
        executingAddin = bl;
    }

    public static boolean isExecutingAddin() {
        return executingAddin;
    }

    public ClassInfo(String string, String string2, int n) {
        super(n);
        this.setName(string);
        this.setPackage(string2);
    }

    public ClassInfo(String string, int n) {
        super(n);
        this.setName(JavaClassUtils.getFullInnerClassName(string));
        this.setPackage(JavaClassUtils.getPackageName(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update() {
        UMLSupport uMLSupport = UMLSupport.getUMLSupport();
        IProject iProject = null;
        if (iProject != null) {
            uMLSupport.getProjectManager().setCurrentProject(iProject);
        } else if (UMLSupport.getDefaultProject() != null) {
            uMLSupport.getProjectManager().setCurrentProject(UMLSupport.getDefaultProject());
            Log.out((String)"THERE is no matching source path for this file location so symbol will be added to the default project");
        }
        EventManager eventManager = EventManager.getEventManager();
        Log.out((String)"=============================================");
        Log.out((String)("Update called: " + this));
        this.filter = eventManager.getEventFilter();
        this.filter.blockEvents(this, null);
        SymbolTransaction symbolTransaction = null;
        try {
            Log.out((String)"Creating SymbolTransaction");
            symbolTransaction = new SymbolTransaction(this);
            Log.out((String)"Done creating SymbolTransaction");
        }
        catch (Throwable throwable) {
            ErrorManager.getDefault().notify(throwable);
        }
        finally {
            this.filter.unblockEvents(this, null);
        }
        try {
            UMLSupport.setRoundTripEnabled(false);
            this.update(symbolTransaction);
        }
        finally {
            UMLSupport.setRoundTripEnabled(true);
        }
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getId() {
        return this.id;
    }

    public void setBasePath(String string) {
        this.basePath = string;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setOuterClass(ClassInfo classInfo) {
        this.outerClass = classInfo;
    }

    public ClassInfo getOuterClass() {
        return this.outerClass;
    }

    private void checkSanity() {
        int n;
        if (this.getModifiers() != null && !Modifier.isAbstract(n = this.getModifiers().intValue()) && this.isInterface()) {
            this.setModifiers(new Integer(n | 0x400));
        }
        String string = JavaClassUtils.formFullClassName(this.getExtendedPackage(), this.getExtendedClass());
        String string2 = JavaClassUtils.formFullClassName(this.getRemovedExtendedPackage(), this.getRemovedExtendedClass());
        if (string != null && string.equals(string2)) {
            this.setExtendedClass(null, null);
            this.setRemovedExtendedClass(null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(SymbolTransaction symbolTransaction) {
        if (symbolTransaction.getSymbol() == null) {
            Log.out((String)"Transaction has no IClassifier, aborting");
            return;
        }
        boolean bl = false;
        this.checkSanity();
        EventManager eventManager = EventManager.getEventManager();
        this.filter = eventManager.getEventFilter();
        try {
            Object object;
            IClassifier iClassifier = symbolTransaction.getSymbol();
            if (iClassifier == null) {
                return;
            }
            this.setId(iClassifier.getXMIID());
            if (this.getChangeType() == 2) {
                iClassifier.delete();
                return;
            }
            if (this.getImports() != null) {
                this.updateImports(eventManager, symbolTransaction);
            }
            if (this.getFilename() != null) {
                ClassInfo.setSymbolFilename(iClassifier, this.getFilename());
            }
            Log.out((String)("CI: Old package          : " + this.getPackage()));
            Log.out((String)("CI: Old name             : " + this.getName()));
            Log.out((String)("CI: New package          : " + this.getNewPackage()));
            Log.out((String)("CI: New name             : " + this.getNewName()));
            if (this.getNewPackage() != null && !this.getNewPackage().trim().equals("")) {
                object = SymbolTransaction.getClassPackage(this.getNewPackage(), this.getFilename());
                if (this.getOuterClass() == null) {
                    object.addOwnedElement((INamedElement)iClassifier);
                    bl = true;
                }
            } else if (this.getNewPackage() != null && this.getNewPackage().trim().equals("") && this.getOuterClass() == null) {
                UMLSupport.getCurrentProject().addOwnedElement((INamedElement)iClassifier);
                bl = true;
            }
            if (this.isCommentSet()) {
                try {
                    iClassifier.setDocumentation(this.getComment());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.getNewName() != null) {
                object = this.getNewName().replace('.', '$');
                if (((String)object).indexOf("$") > 0) {
                    object = ((String)object).substring(((String)object).lastIndexOf("$") + 1);
                }
                if (!iClassifier.getName().equals(object)) {
                    boolean bl2 = UMLSupport.isRoundTripEnabled();
                    UMLSupport.setRoundTripEnabled(true);
                    iClassifier.setName((String)object);
                    UMLSupport.setRoundTripEnabled(bl2);
                    if (this.getNewName().lastIndexOf("$") > 0) {
                        String string = this.getNewName().substring(0, this.getNewName().lastIndexOf("$"));
                        if (this.getPackage() != null && !this.getPackage().equals("")) {
                            string = this.getPackage() + "." + string;
                        }
                        iClassifier.setOwner((IElement)JavaClassUtils.findClassSymbol(string));
                    }
                    bl = true;
                }
            }
            if (this.getModifiers() != null) {
                eventManager.updateClassModifers(symbolTransaction, this.getModifiers());
            }
            UMLSupport.setRoundTripEnabled(true);
            if (this.getRemovedExtendedClass() != null) {
                this.filter.blockEventType(8);
                this.filter.blockEventType(45);
                Log.out((String)"Blocked Relation Delete events 8");
                try {
                    this.removeGeneralization(iClassifier);
                }
                finally {
                    this.filter.unblockEventType(8);
                    this.filter.unblockEventType(45);
                    Log.out((String)"UnBlocked Relation Delete events 8");
                }
            }
            if (!this.isEnumeration() && this.getExtendedClass() != null) {
                this.filter.blockEventType(49);
                this.filter.blockEventType(44);
                Log.out((String)"Blocking Relation Create events 49");
                try {
                    this.addGeneralization(iClassifier);
                }
                finally {
                    this.filter.unblockEventType(49);
                    this.filter.unblockEventType(44);
                    Log.out((String)"UnBlocking Relation Create events 49");
                }
            }
            try {
                this.filter.blockEventType(8);
                this.filter.blockEventType(49);
                this.filter.blockEventType(44);
                this.filter.blockEventType(45);
                this.updateInterfaces(eventManager, symbolTransaction);
            }
            finally {
                this.filter.unblockEventType(8);
                this.filter.unblockEventType(49);
                this.filter.unblockEventType(44);
                this.filter.unblockEventType(45);
            }
            UMLSupport.setRoundTripEnabled(false);
            try {
                UMLSupport.setRoundTripEnabled(false);
                this.updateMethods(symbolTransaction, 2);
                this.updateMembers(symbolTransaction, 2);
                if (this.mIsEnumeration) {
                    this.updateEnumLiterals(symbolTransaction, 2);
                }
                this.updateMethods(symbolTransaction, 1);
                this.updateMembers(symbolTransaction, 1);
                if (this.mIsEnumeration) {
                    this.updateEnumLiterals(symbolTransaction, 1);
                }
                this.updateMembers(symbolTransaction, 0);
                this.updateMethods(symbolTransaction, 0);
                if (this.mIsEnumeration) {
                    this.updateEnumLiterals(symbolTransaction, 0);
                }
            }
            finally {
                UMLSupport.setRoundTripEnabled(false);
            }
            this.updateConstructors(symbolTransaction);
            this.updateInnerClasses(eventManager, symbolTransaction);
            eventManager.setAsInterface(symbolTransaction, this.isInterface());
            eventManager.setAsEnumeration(symbolTransaction, this.isEnumeration());
        }
        catch (Exception exception) {
            logger.log(Level.WARNING, null, exception);
        }
        finally {
            if (bl) {
                ClassInfo.eraseRefClass(symbolTransaction.getSymbol());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGeneralization(IClassifier iClassifier) {
        ICoreRelationshipDiscovery iCoreRelationshipDiscovery;
        IDiagram iDiagram;
        RelationFactory relationFactory;
        IGeneralization iGeneralization;
        String string = null;
        string = JavaClassUtils.formFullClassName(this.getExtendedPackage(), this.getExtendedClass());
        if (string.equals(this.getSuperclass(iClassifier))) {
            return;
        }
        IClassifier iClassifier2 = JavaClassUtils.findClassSymbol(string);
        if (iClassifier2 == null) {
            boolean bl = UMLSupport.isRoundTripEnabled();
            UMLSupport.setRoundTripEnabled(false);
            try {
                iClassifier2 = JavaClassUtils.createDataType(JavaClassUtils.formFullClassName(this.getExtendedPackage(), this.getExtendedClass()));
            }
            finally {
                UMLSupport.setRoundTripEnabled(bl);
            }
        }
        if ((iGeneralization = (relationFactory = new RelationFactory()).createGeneralization(iClassifier2, iClassifier)) != null && (iDiagram = UMLSupport.getProduct().getDiagramManager().getCurrentDiagram()) != null && iDiagram.getDiagramKind() == 4 && (iCoreRelationshipDiscovery = iDiagram.getRelationshipDiscovery()) != null) {
            iCoreRelationshipDiscovery.createPresentationElement((IElement)iGeneralization);
        }
    }

    public void removeGeneralization(IClassifier iClassifier) {
        if (iClassifier == null) {
            return;
        }
        ETList eTList = iClassifier.getGeneralizations();
        if (eTList == null) {
            return;
        }
        int n = eTList.getCount();
        for (int i = 0; i < n; ++i) {
            IGeneralization iGeneralization = (IGeneralization)eTList.item(i);
            if (iGeneralization == null) continue;
            IClassifier iClassifier2 = iGeneralization.getGeneral();
            iGeneralization.delete();
            if (!JavaClassUtils.isReferenceClass(iClassifier2) || !JavaClassUtils.isOrphan(iClassifier2)) continue;
            iClassifier2.delete();
        }
    }

    public void addInterface(String string, String string2) {
        if (string != null && string2 != null && !JavaClassUtils.formFullClassName(string, string2).equals(JavaClassUtils.formFullClassName(this.getPackage(), this.getName()))) {
            for (int i = 0; i < this.mInterfaces.size(); ++i) {
                InterfaceChangeInfo interfaceChangeInfo = (InterfaceChangeInfo)this.mInterfaces.elementAt(i);
                if (!interfaceChangeInfo.getInterfaceName().equals(string2) || !interfaceChangeInfo.getPackage().equals(string)) continue;
                interfaceChangeInfo.setChangeType(0);
                return;
            }
            this.mInterfaces.add(new InterfaceChangeInfo(string, string2, 0));
        }
    }

    public void addInterface(String string) {
        this.addInterface(JavaClassUtils.getPackageName(string), JavaClassUtils.getFullInnerClassName(string));
    }

    public InterfaceChangeInfo[] getInterfaces() {
        Object[] objectArray = new InterfaceChangeInfo[this.mInterfaces.size()];
        this.mInterfaces.copyInto(objectArray);
        return objectArray;
    }

    public void removeInterface(String string, String string2) {
        for (int i = 0; i < this.mInterfaces.size(); ++i) {
            InterfaceChangeInfo interfaceChangeInfo = (InterfaceChangeInfo)this.mInterfaces.elementAt(i);
            if (!interfaceChangeInfo.getInterfaceName().equals(string2) || !interfaceChangeInfo.getPackage().equals(string)) continue;
            interfaceChangeInfo.setChangeType(2);
            return;
        }
        this.mInterfaces.add(new InterfaceChangeInfo(string, string2, 2));
    }

    public void removeInterface(String string) {
        this.removeInterface(JavaClassUtils.getPackageName(string), JavaClassUtils.getFullInnerClassName(string));
    }

    protected Vector getInterfaceChanges() {
        return this.mInterfaces;
    }

    public void setExtendedClass(String string, String string2) {
        if (string != null && string2 != null) {
            if (!JavaClassUtils.formFullClassName(string, string2).equals(JavaClassUtils.formFullClassName(this.getPackage(), this.getName()))) {
                this.mNewExtendedClass = string2;
                this.mNewExtendedPack = string;
            }
        } else {
            this.mNewExtendedClass = string2;
            this.mNewExtendedPack = string;
        }
    }

    public String getExtendedClass() {
        return this.mNewExtendedClass;
    }

    public String getExtendedPackage() {
        return this.mNewExtendedPack;
    }

    public String getOldSuperclass() {
        return JavaClassUtils.formFullClassName(this.getRemovedExtendedPackage(), this.getRemovedExtendedClass());
    }

    public String getNewSuperclass() {
        return JavaClassUtils.formFullClassName(this.getExtendedPackage(), this.getExtendedClass());
    }

    public void setRemovedExtendedClass(String string, String string2) {
        this.mRemoveExtendedClass = string2;
        this.mRemoveExtendedPack = string;
    }

    public String getRemovedExtendedPackage() {
        return this.mRemoveExtendedPack;
    }

    public String getRemovedExtendedClass() {
        return this.mRemoveExtendedClass;
    }

    public void setImports(Vector vector) {
        this.mImports = vector;
    }

    public Vector getImports() {
        return this.mImports;
    }

    public void addImport(String string) {
        string = GenCodeUtil.removeGenericType(string);
        if (this.getOuterClass() != null) {
            this.getOuterMostOwner().addImport(string);
        } else if (!this.mImports.contains(string)) {
            this.mImports.add(string);
        }
    }

    public void addImport(IClassifier iClassifier) {
        if (this.getOuterMostOwner().getClassElement() == this.getOuterClassifierOwner(iClassifier)) {
            return;
        }
        IPackage iPackage = iClassifier.getOwningPackage();
        if (iPackage == this.getClassElement().getOwningPackage()) {
            return;
        }
        if (iPackage == this.getClassElement()) {
            return;
        }
        if (iPackage instanceof Project) {
            return;
        }
        if (!GenCodeUtil.isValidClassType(iClassifier.getFullyQualifiedName(false))) {
            return;
        }
        if (iPackage.getFullyQualifiedName(false).equals("java::lang")) {
            return;
        }
        IClassifier iClassifier2 = this.getOuterClassifierOwner(iClassifier);
        this.addImport(JavaClassUtils.convertUMLtoJava(iClassifier2.getFullyQualifiedName(false)));
    }

    private IClassifier getOuterClassifierOwner(IClassifier iClassifier) {
        IElement iElement = iClassifier.getOwner();
        if (iElement instanceof IPackage || iElement instanceof IProject) {
            return iClassifier;
        }
        return this.getOuterClassifierOwner((IClassifier)iElement);
    }

    public void setMembers(Vector vector) {
        this.mMembers = vector;
    }

    public void addMember(MemberInfo memberInfo) {
        this.mMembers.add(memberInfo);
    }

    public Vector getMembers() {
        return this.mMembers;
    }

    public void setMethods(Vector vector) {
        this.mMethods = vector;
    }

    public void addMethod(MethodInfo methodInfo) {
        this.mMethods.add(methodInfo);
    }

    public Vector getMethods() {
        return this.mMethods;
    }

    public void setConstructors(Vector vector) {
        this.mConstructors = vector;
    }

    public void addConstructor(ConstructorInfo constructorInfo) {
        if (constructorInfo instanceof MethodInfo) {
            this.addMethod((MethodInfo)constructorInfo);
        } else {
            this.mConstructors.add(constructorInfo);
        }
    }

    public Vector getConstructors() {
        return this.mConstructors;
    }

    public void addInnerClass(ClassInfo classInfo) {
        classInfo.setOuterClass(this);
        if (this.mInnerClasses != null && !this.mInnerClasses.contains(classInfo)) {
            this.mInnerClasses.add(classInfo);
        }
    }

    public void setInnerClasses(Vector vector) {
        this.mInnerClasses = vector;
    }

    public Vector getInnerClasses() {
        return this.mInnerClasses;
    }

    public void setLiterals(Vector vector) {
        this.mLiterals = vector;
    }

    public void addLiteral(LiteralInfo literalInfo) {
        this.mLiterals.add(literalInfo);
    }

    public Vector getLiterals() {
        return this.mLiterals;
    }

    public void setFilename(String string) {
        this.mFilename = string;
    }

    public String updateFilename(String string) {
        if (this.classElement == null || this.getChangeType() == 2) {
            if (string != null) {
                this.setFilename(string);
            }
            return this.getFilename();
        }
        if (string != null) {
            this.setFilename(string);
            Log.out((String)("Updating symbol filename for " + this.classElement.getName() + " to " + string));
            ClassInfo.setSymbolFilename(this.classElement, string);
        } else {
            this.setFilename(ClassInfo.getSymbolFilename(this.classElement));
        }
        return this.getFilename();
    }

    private static ISourceFileArtifact getClassArtifact(IClassifier iClassifier) {
        ETList eTList = iClassifier.getSourceFiles();
        if (eTList == null || eTList.getCount() == 0) {
            return null;
        }
        return (ISourceFileArtifact)eTList.item(0);
    }

    public static void setSymbolFilename(IClassifier iClassifier, String string) {
        ISourceFileArtifact iSourceFileArtifact;
        if (string != null) {
            string = string.replace('/', File.separatorChar).replace('\\', File.separatorChar);
        }
        if ((iSourceFileArtifact = ClassInfo.getClassArtifact(iClassifier)) == null) {
            if (!(iClassifier.getOwner() instanceof IClassifier)) {
                iClassifier.addSourceFile(string);
            }
        } else {
            iSourceFileArtifact.setSourceFile(string);
        }
    }

    public static String getSymbolFilename(IClassifier iClassifier) {
        ISourceFileArtifact iSourceFileArtifact = ClassInfo.getClassArtifact(iClassifier);
        if (iSourceFileArtifact != null) {
            return iSourceFileArtifact.getSourceFile();
        }
        IClassifier iClassifier2 = iClassifier;
        while ((iClassifier2 = iClassifier2.getOwner()) instanceof IClassifier) {
            IClassifier iClassifier3 = iClassifier2;
            iSourceFileArtifact = ClassInfo.getClassArtifact(iClassifier3);
            if (iSourceFileArtifact == null) continue;
            return iSourceFileArtifact.getSourceFile();
        }
        return null;
    }

    @Override
    public String getFilename() {
        return this.mFilename;
    }

    public void setIsInnerClass(Boolean bl) {
        this.mIsInnerClass = bl;
    }

    public Boolean getIsInnerClass() {
        return this.mIsInnerClass;
    }

    public void setPackage(String string) {
        this.mOrigPackage = string;
    }

    public String getPackage() {
        return this.mOrigPackage;
    }

    public void setNewPackage(String string) {
        this.mNewPackage = string;
    }

    public String getNewPackage() {
        return this.mNewPackage;
    }

    public void setIsInterface(boolean bl) {
        this.mIsInterface = bl;
    }

    public boolean isInterface() {
        return this.mIsInterface;
    }

    public void setIsEnumeration(boolean bl) {
        this.mIsEnumeration = bl;
    }

    public boolean isEnumeration() {
        return this.mIsEnumeration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateMethods(SymbolTransaction symbolTransaction, int n) {
        for (int i = 0; i < this.mMethods.size(); ++i) {
            Log.out((String)"Inside updateMethods ..");
            MethodInfo methodInfo = (MethodInfo)this.mMethods.elementAt(i);
            if (methodInfo.getChangeType() != n) continue;
            try {
                this.filter.blockEvents(methodInfo, this);
                methodInfo.update(symbolTransaction);
                continue;
            }
            finally {
                this.filter.unblockEvents(methodInfo, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateMembers(SymbolTransaction symbolTransaction, int n) {
        for (int i = 0; i < this.mMembers.size(); ++i) {
            MemberInfo memberInfo = (MemberInfo)this.mMembers.elementAt(i);
            if (memberInfo.getChangeType() != n) continue;
            try {
                this.filter.blockEvents(memberInfo, this);
                memberInfo.update(symbolTransaction);
                continue;
            }
            finally {
                this.filter.unblockEvents(memberInfo, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateEnumLiterals(SymbolTransaction symbolTransaction, int n) {
        for (int i = 0; i < this.mLiterals.size(); ++i) {
            LiteralInfo literalInfo = (LiteralInfo)this.mLiterals.elementAt(i);
            if (literalInfo.getChangeType() != n) continue;
            try {
                this.filter.blockEvents(literalInfo, this);
                literalInfo.update(symbolTransaction);
                continue;
            }
            finally {
                this.filter.unblockEvents(literalInfo, this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateConstructors(SymbolTransaction symbolTransaction) {
        for (int i = 0; i < this.mConstructors.size(); ++i) {
            ConstructorInfo constructorInfo = (ConstructorInfo)this.mConstructors.elementAt(i);
            try {
                this.filter.blockEvents(constructorInfo, this);
                constructorInfo.update(symbolTransaction);
                continue;
            }
            finally {
                this.filter.unblockEvents(constructorInfo, this);
            }
        }
    }

    protected void updateInnerClasses(EventManager eventManager, SymbolTransaction symbolTransaction) {
        Log.out((String)"Inside updateInnerClasses ..............................");
        Vector vector = this.getInnerClasses();
        Log.out((String)("vector size is " + vector.size()));
        for (int i = 0; i < vector.size(); ++i) {
            ClassInfo classInfo = (ClassInfo)vector.elementAt(i);
            if (classInfo != null) {
                Log.out((String)("Updating inner class " + classInfo));
            }
            SymbolTransaction symbolTransaction2 = symbolTransaction.getInnerClass(classInfo);
            classInfo.update(symbolTransaction2);
        }
    }

    protected void updateImports(EventManager eventManager, SymbolTransaction symbolTransaction) {
    }

    protected void updateInterfaces(EventManager eventManager, SymbolTransaction symbolTransaction) {
        Log.out((String)"Inside updateInterfaces ...... ");
        Vector vector = this.getInterfaceChanges();
        for (int i = 0; i < vector.size(); ++i) {
            InterfaceChangeInfo interfaceChangeInfo = (InterfaceChangeInfo)vector.elementAt(i);
            Log.out((String)("ClassInfo.updateInterfaces: Interface is " + interfaceChangeInfo.getPackage() + "." + interfaceChangeInfo.getInterfaceName()));
            if (interfaceChangeInfo.getChangeType() == 0) {
                eventManager.addInterface(symbolTransaction, interfaceChangeInfo.getPackage(), interfaceChangeInfo.getInterfaceName());
                continue;
            }
            Log.out((String)("Removing interface " + interfaceChangeInfo.getPackage() + "." + interfaceChangeInfo.getInterfaceName()));
            eventManager.removeInterface(symbolTransaction, interfaceChangeInfo.getPackage(), interfaceChangeInfo.getInterfaceName());
        }
    }

    @Override
    public String getCode() {
        return "C";
    }

    @Override
    public Object clone() {
        ClassInfo classInfo = (ClassInfo)super.clone();
        if (this.mConstructors != null) {
            classInfo.mConstructors = (Vector)this.mConstructors.clone();
        }
        if (this.mImports != null) {
            classInfo.mImports = (Vector)this.mImports.clone();
        }
        if (this.mMembers != null) {
            classInfo.mMembers = (Vector)this.mMembers.clone();
        }
        if (this.mMethods != null) {
            classInfo.mMethods = (Vector)this.mMethods.clone();
        }
        if (this.mInnerClasses != null) {
            classInfo.mInnerClasses = (Vector)this.mInnerClasses.clone();
        }
        if (this.mInterfaces != null) {
            classInfo.mInterfaces = (Vector)this.mInterfaces.clone();
        }
        if (this.mLiterals != null) {
            classInfo.mLiterals = (Vector)this.mLiterals.clone();
        }
        return classInfo;
    }

    public String getFullClassName() {
        String string;
        String string2 = this.getPackage();
        String string3 = string = this.getName();
        if (string != null) {
            string3 = string.replace('.', '$');
        }
        return string2 == null || string2.equals("") ? string3 : string2 + "." + string3;
    }

    public IClassifier getClassElement() {
        return this.classElement;
    }

    public IClassifier retrieveClassifier() {
        this.classElement = JavaClassUtils.findClassSymbol(JavaClassUtils.formFullClassName(this.getPackage(), this.getName()));
        return this.classElement;
    }

    protected String old2new(String string, String string2) {
        return string2 != null ? string + " -> " + string2 : string;
    }

    public String toString() {
        Object object;
        Vector vector;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("ClassInfo (" + this.getFullClassName() + ") ").append(this.getChangeName()).append("\n").append(" Name       : " + this.old2new(this.getName(), this.getNewName())).append("\n").append(" Package    : " + this.old2new(this.getPackage(), this.getNewPackage())).append("\n").append(" Modifiers  : " + this.getModifierText(this.getModifiers())).append("\n");
        String string = this.getOldSuperclass();
        String string2 = this.getNewSuperclass();
        if (string != null || string2 != null) {
            if (string == null) {
                string = "<none>";
            }
            if (string2 == null) {
                string2 = "<none>";
            }
            stringBuffer.append(" Superclass : " + this.old2new(string, string2));
        }
        if (this.getMethods() != null && this.getMethods().size() > 0 || this.getConstructors() != null && this.getConstructors().size() > 0) {
            stringBuffer.append("\n --- Methods ---\n");
            vector = this.getMethods();
            for (int i = 0; i < vector.size(); ++i) {
                stringBuffer.append(vector.elementAt(i).toString() + "\n");
            }
            object = this.getConstructors();
            for (int i = 0; i < ((Vector)object).size(); ++i) {
                stringBuffer.append(((Vector)object).elementAt(i).toString() + "\n");
            }
        }
        if (this.getMembers() != null && this.getMembers().size() > 0) {
            stringBuffer.append("\n --- Fields ---\n");
            vector = this.getMembers();
            object = vector.iterator();
            while (object.hasNext()) {
                stringBuffer.append(object.next().toString() + "\n");
            }
        }
        return stringBuffer.toString();
    }

    public String getModifierText(Integer n) {
        if (n == null) {
            return null;
        }
        return Modifier.toString(n);
    }

    @Override
    public boolean matches(ElementInfo elementInfo) {
        if (!(elementInfo instanceof ClassInfo)) {
            return false;
        }
        ClassInfo classInfo = (ClassInfo)elementInfo;
        if (this.getName() != null && !this.getName().equals(classInfo.getName())) {
            return false;
        }
        if (this.getPackage() != null && !this.getPackage().equals(classInfo.getPackage())) {
            return false;
        }
        if (this.getComment() != null && !this.getComment().equals(classInfo.getComment())) {
            return false;
        }
        if (this.getExtendedClass() != null && !this.getExtendedClass().equals(classInfo.getExtendedClass())) {
            return false;
        }
        if (this.getExtendedPackage() != null && !this.getExtendedPackage().equals(classInfo.getExtendedPackage())) {
            return false;
        }
        if (this.getFilename() != null && !this.getFilename().equals(classInfo.getFilename())) {
            return false;
        }
        return this.getModifiers() == null || this.getModifiers().equals(classInfo.getModifiers());
    }

    public static ClassInfo getRefClassInfo(IClassifier iClassifier, boolean bl) {
        return ClassInfo.getRefClassInfo(iClassifier, bl, false);
    }

    public static ClassInfo getRefClassInfo(IClassifier iClassifier, boolean bl, boolean bl2) {
        if (iClassifier == null) {
            return null;
        }
        ClassInfo classInfo = null;
        if (bl) {
            classInfo = (ClassInfo)refClassInfos.get(iClassifier.getXMIID());
        }
        if (classInfo == null) {
            if (bl2) {
                classInfo = new ClassInfo(iClassifier);
                classInfo.setMethodsAndMembers(iClassifier);
                classInfo.setComment(iClassifier.getDocumentation());
            } else {
                classInfo = new ClassInfo(null);
                classInfo.setRefInfo(iClassifier);
            }
            if (bl) {
                refClassInfos.put(iClassifier.getXMIID(), classInfo);
            }
        }
        return classInfo;
    }

    public static void eraseRefClasses() {
        refClassInfos.clear();
    }

    public static void eraseRefClass(IClassifier iClassifier) {
        if (iClassifier != null) {
            refClassInfos.remove(iClassifier.getXMIID());
            Log.out((String)("Erased references to " + iClassifier.getName()));
        }
    }

    public String getExportSourceFolderName() {
        return this.exportSourceFolderName;
    }

    public void setExportSourceFolderName(String string) {
        this.exportSourceFolderName = string;
    }

    public FileObject getExportSourceFolderFileObject() {
        FileObject fileObject = null;
        try {
            File file = new File(this.getExportSourceFolderName());
            fileObject = FileUtil.createFolder((File)file);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, null, iOException);
        }
        return fileObject;
    }

    public FileObject getExportPackageFileObject() {
        return this.getExportPackageFileObject(null);
    }

    public FileObject getExportPackageFileObject(String string) {
        FileObject fileObject = null;
        try {
            String string2 = this.getExportSourcePackage();
            if (string != null) {
                string2 = string2 + File.separatorChar + string;
            }
            File file = new File(string2);
            fileObject = FileUtil.createFolder((File)file);
        }
        catch (IOException iOException) {
            logger.log(Level.WARNING, null, iOException);
        }
        return fileObject;
    }

    public IClassifier getSuperClass() {
        return this.mSuperClass;
    }

    public void setSuperClass(IClassifier iClassifier) {
        this.mSuperClass = iClassifier;
    }

    public ArrayList<IClassifier> getSuperInterfaces() {
        return this.superInterfaces;
    }

    public void setSuperInterfaces(ArrayList<IClassifier> arrayList) {
        this.superInterfaces = arrayList;
    }

    public void addSuperInterface(IClassifier iClassifier) {
        if (iClassifier != null && !this.superInterfaces.contains(iClassifier)) {
            this.superInterfaces.add(iClassifier);
        }
    }

    public ClassInfo getOuterMostOwner() {
        ClassInfo classInfo = this.getOuterClass();
        if (classInfo == null) {
            return this;
        }
        return classInfo.getOuterMostOwner();
    }

    public ClassInfo getSuperClassInfo() {
        if (this.mSuperClass != null) {
            return ClassInfo.getRefClassInfo(this.mSuperClass, true);
        }
        return null;
    }

    public ArrayList<ClassInfo> getSuperInterfaceInfos() {
        ArrayList<ClassInfo> arrayList = new ArrayList<ClassInfo>();
        if (this.superInterfaces != null) {
            for (IClassifier iClassifier : this.superInterfaces) {
                arrayList.add(ClassInfo.getRefClassInfo(iClassifier, true));
            }
        }
        return arrayList;
    }

    public String[] getFullyQualifiedCodeGenType() {
        if (this.fullyQualifiedName == null) {
            String string;
            String string2;
            IClassifier iClassifier = this.getClassElement();
            if (iClassifier == null) {
                return null;
            }
            IPackage iPackage = iClassifier.getOwningPackage();
            if (iPackage == null) {
                return null;
            }
            String string3 = iPackage.getFullyQualifiedName(false);
            if (iPackage instanceof IProject) {
                string3 = "";
            }
            if (GenCodeUtil.isValidClassType(string2 = (string = iClassifier.getFullyQualifiedName(false)))) {
                IElement iElement;
                String string4 = string3;
                if (iClassifier instanceof ClassifierTemplateParameter && (iElement = iClassifier.getOwner()) instanceof IClassifier) {
                    string4 = ((IClassifier)iElement).getFullyQualifiedName(false);
                }
                if (string4 != null && string4.length() > 0) {
                    string2 = JavaClassUtils.convertUMLtoJava(string.substring(string4.length() + 2));
                    string3 = JavaClassUtils.convertUMLtoJava(string3);
                } else {
                    string2 = JavaClassUtils.convertUMLtoJava(string);
                }
            }
            this.fullyQualifiedName = new String[]{string3, string2};
        }
        return this.fullyQualifiedName;
    }

    public String getShortClassName() {
        return JavaClassUtils.getShortClassName(this.getName());
    }

    public String getCodeGenType(boolean bl, ClassInfo classInfo) {
        if (bl) {
            if (this.codeGenTypeFullyQualified == null) {
                this.codeGenTypeFullyQualified = GenCodeUtil.getTypeCodeGenType(this.getClassElement(), bl, classInfo);
            }
            return this.codeGenTypeFullyQualified;
        }
        if (this.codeGenTypeShort == null) {
            this.codeGenTypeShort = GenCodeUtil.getTypeCodeGenType(this.getClassElement(), bl, classInfo);
        }
        return this.codeGenTypeShort;
    }

    public Vector getFieldsCodeGenSorted() {
        Vector<MemberInfo> vector = new Vector<MemberInfo>();
        for (MemberInfo memberInfo : this.mMembers) {
            vector.add(memberInfo);
        }
        Collections.sort(vector, new StaticAndAccessModifierComparator());
        return vector;
    }

    public Vector getConstructorsCodeGenSorted() {
        Vector<MethodInfo> vector = new Vector<MethodInfo>();
        for (MethodInfo methodInfo : this.mMethods) {
            IOperation iOperation = methodInfo.getOperation();
            if (iOperation == null || !iOperation.getIsConstructor()) continue;
            vector.add(methodInfo);
        }
        Collections.sort(vector, new StaticAndAccessModifierComparator());
        return vector;
    }

    public Vector getMethodsCodeGenSorted() {
        Vector<MethodInfo> vector = new Vector<MethodInfo>();
        for (MethodInfo methodInfo : this.mMethods) {
            IOperation iOperation = methodInfo.getOperation();
            if (iOperation == null || iOperation.getIsConstructor()) continue;
            vector.add(methodInfo);
        }
        Collections.sort(vector, new StaticAndAccessModifierComparator());
        return vector;
    }

    public ArrayList<String> getImportedTypes() {
        if (this.getOuterClass() != null) {
            return this.getOuterClass().getImportedTypes();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String[]> arrayList2 = this.getReferredCodeGenTypes();
        for (String[] stringArray : arrayList2) {
            if (stringArray == null || stringArray.length != 2 || stringArray[0] == null || stringArray[1] == null) continue;
            String string = stringArray[0];
            String string2 = stringArray[1];
            if (string == "" || string.equals(this.getPackage()) || string.equals("java.lang")) continue;
            String string3 = string + "." + string2;
            arrayList.add(string3);
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    public ArrayList<ClassInfo> getMemberTypes() {
        ArrayList<ClassInfo> arrayList = new ArrayList<ClassInfo>();
        for (ClassInfo classInfo : this.mInnerClasses) {
            arrayList.add(classInfo);
        }
        return arrayList;
    }

    public ArrayList<String[]> getReferredCodeGenTypes() {
        Object object;
        Cloneable cloneable;
        Iterator iterator;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        HashSet<String> hashSet = new HashSet<String>();
        if (this.mMembers != null) {
            iterator = this.mMembers.iterator();
            while (iterator.hasNext()) {
                cloneable = (MemberInfo)iterator.next();
                object = ((MemberInfo)cloneable).getReferredCodeGenTypes();
                GenCodeUtil.mergeReferredCodeGenTypes(arrayList, hashSet, object);
            }
        }
        if (this.mMethods != null) {
            iterator = this.mMethods.iterator();
            while (iterator.hasNext()) {
                cloneable = (MethodInfo)iterator.next();
                object = ((MethodInfo)cloneable).getReferredCodeGenTypes();
                GenCodeUtil.mergeReferredCodeGenTypes(arrayList, hashSet, (ArrayList<String[]>)object);
            }
        }
        if ((iterator = this.getMemberTypes()) != null) {
            cloneable = ((ArrayList)((Object)iterator)).iterator();
            while (cloneable.hasNext()) {
                object = (ClassInfo)cloneable.next();
                IClassifier iClassifier = ((ClassInfo)object).getReferredCodeGenTypes();
                GenCodeUtil.mergeReferredCodeGenTypes(arrayList, hashSet, iClassifier);
            }
        }
        if ((cloneable = GenCodeUtil.getReferredCodeGenTypes(this.mSuperClass, this)) != null) {
            GenCodeUtil.mergeReferredCodeGenTypes(arrayList, hashSet, (ArrayList<String[]>)cloneable);
        }
        if (this.superInterfaces != null) {
            for (IClassifier iClassifier : this.superInterfaces) {
                cloneable = GenCodeUtil.getReferredCodeGenTypes(iClassifier, this);
                if (cloneable == null) continue;
                GenCodeUtil.mergeReferredCodeGenTypes(arrayList, hashSet, (ArrayList<String[]>)cloneable);
            }
        }
        return arrayList;
    }

    boolean checkAddAttributeName(String string) {
        if (this.attrNames == null) {
            this.attrNames = new HashSet();
            for (MemberInfo memberInfo : this.mMembers) {
                String string2;
                if (memberInfo == null || (string2 = memberInfo.getName()) == null || string2.trim().equals("")) continue;
                this.attrNames.add(string2);
            }
        }
        if (!this.attrNames.contains(string)) {
            this.attrNames.add(string);
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class StaticAndAccessModifierComparator
    implements Comparator<ElementInfo> {
        @Override
        public int compare(ElementInfo elementInfo, ElementInfo elementInfo2) {
            int n = elementInfo.getModifiers();
            int n2 = elementInfo2.getModifiers();
            if (Modifier.isStatic(n) == Modifier.isStatic(n2)) {
                int n3 = this.compareAccessModifiers(n, n2);
                if (n3 == 0) {
                    return this.compareSpecific(elementInfo, elementInfo2);
                }
                return n3;
            }
            if (Modifier.isStatic(n)) {
                return -1;
            }
            return 1;
        }

        public int compareAccessModifiers(int n, int n2) {
            return this.getNum(n) - this.getNum(n2);
        }

        int getNum(int n) {
            if (Modifier.isPublic(n)) {
                return 1;
            }
            if (Modifier.isProtected(n)) {
                return 2;
            }
            if (Modifier.isPrivate(n)) {
                return 4;
            }
            return 3;
        }

        public int compareSpecific(ElementInfo elementInfo, ElementInfo elementInfo2) {
            if (elementInfo instanceof MethodInfo && elementInfo2 instanceof MethodInfo) {
                MethodInfo methodInfo = (MethodInfo)elementInfo;
                MethodInfo methodInfo2 = (MethodInfo)elementInfo2;
                String string = methodInfo.getMemberName();
                String string2 = methodInfo2.getMemberName();
                if (string != null && string2 != null) {
                    int n = string.compareTo(string2);
                    if (n != 0) {
                        return n;
                    }
                    if (methodInfo.isAccessor()) {
                        return -1;
                    }
                    return 1;
                }
            }
            return 0;
        }
    }

    public class InterfaceChangeInfo {
        private String mName = "";
        private String mPackage = "";
        private int mChangeType = 0;

        public InterfaceChangeInfo(String string, String string2, int n) {
            this.setInterfaceName(string, string2);
            this.setChangeType(n);
        }

        public final String getInterfaceName() {
            return this.mName;
        }

        public final String getPackage() {
            return this.mPackage;
        }

        public final String getDecoratedName() {
            return JavaClassUtils.formFullClassName(this.mPackage, this.mName);
        }

        public final void setInterfaceName(String string, String string2) {
            this.mPackage = string;
            this.mName = string2;
        }

        public final int getChangeType() {
            return this.mChangeType;
        }

        public final void setChangeType(int n) {
            this.mChangeType = n;
        }
    }
}

