/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.ide.events;

import java.util.HashSet;
import java.util.Hashtable;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.INamedElement;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IAttribute;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IOperation;
import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.netbeans.modules.uml.integration.ide.events.ClassInfo;
import org.netbeans.modules.uml.integration.ide.events.ElementInfo;

public class EventFilter {
    private Hashtable blockedEvents = new Hashtable();
    private HashSet blockedEventTypes = new HashSet();

    public boolean isValid(ElementInfo elementInfo, ClassInfo classInfo) {
        String string = this.getEventId(elementInfo, classInfo);
        return string != null && !this.isBlocked(string);
    }

    public boolean isValid(INamedElement iNamedElement) {
        String string = this.getEventId(iNamedElement);
        return string != null && !this.isBlocked(string);
    }

    public boolean isValidEventType(int n) {
        return !this.blockedEventTypes.contains(new Integer(n)) && n != 62;
    }

    protected String getEventId(ElementInfo elementInfo, ClassInfo classInfo) {
        if (elementInfo == null) {
            return null;
        }
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer = stringBuffer.append(elementInfo.getName());
            if (classInfo != null) {
                stringBuffer.append("%").append(classInfo.getId());
            }
            return stringBuffer.toString();
        }
        catch (NullPointerException nullPointerException) {
            Log.stackTrace((Throwable)nullPointerException);
            return null;
        }
    }

    public String getEventId(INamedElement iNamedElement) {
        if (iNamedElement == null) {
            return null;
        }
        IElement iElement = iNamedElement.getOwner();
        try {
            String string = iNamedElement.getName() + "%";
            if (iElement != null && iElement instanceof INamedElement) {
                string = string + iElement.getXMIID();
            }
            return string;
        }
        catch (Exception exception) {
            Log.stackTrace((Throwable)exception);
            return null;
        }
    }

    public void blockEvents(ElementInfo elementInfo, ClassInfo classInfo) {
        String string = this.getEventId(elementInfo, classInfo);
        if (string != null) {
            Log.out((String)("Blocking events for id " + string));
            this.blockedEvents.put(string, string);
            String string2 = elementInfo.getName();
            String string3 = elementInfo.getNewName();
            if (string3 != null && !string2.equals(string3)) {
                elementInfo.setName(string3);
                string = this.getEventId(elementInfo, classInfo);
                if (string != null) {
                    this.blockedEvents.put(string, string);
                }
                elementInfo.setName(string2);
            }
        }
    }

    public void blockEventType(int n) {
        this.blockedEventTypes.add(new Integer(n));
    }

    public void unblockEventType(int n) {
        this.blockedEventTypes.remove(new Integer(n));
    }

    public void unblockEvents(ElementInfo elementInfo, ClassInfo classInfo) {
        String string = this.getEventId(elementInfo, classInfo);
        if (string != null) {
            Log.out((String)("Unblocking events for id " + string));
            this.blockedEvents.remove(string);
            String string2 = elementInfo.getName();
            String string3 = elementInfo.getNewName();
            if (string3 != null && !string2.equals(string3)) {
                elementInfo.setName(string3);
                string = this.getEventId(elementInfo, classInfo);
                if (string != null) {
                    this.blockedEvents.remove(string);
                }
                elementInfo.setName(string2);
            }
        }
    }

    public void unblockAll() {
        this.blockedEvents.clear();
    }

    protected String getElementType(ElementInfo elementInfo) {
        return elementInfo.getCode();
    }

    protected String getElementType(INamedElement iNamedElement) {
        if (iNamedElement instanceof IAttribute) {
            return "F";
        }
        if (iNamedElement instanceof IOperation) {
            return "M";
        }
        return "C";
    }

    protected boolean isBlocked(String string) {
        boolean bl = string == null ? true : this.blockedEvents.containsKey(string);
        return bl;
    }
}

