/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.ide.events;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IElement;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IMultiplicity;
import org.netbeans.modules.uml.core.metamodel.core.foundation.IMultiplicityRange;
import org.netbeans.modules.uml.core.metamodel.infrastructure.IDerivationClassifier;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.ClassifierTemplateParameter;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IClassifier;
import org.netbeans.modules.uml.core.metamodel.infrastructure.coreinfrastructure.IUMLBinding;
import org.netbeans.modules.uml.core.support.umlutils.ETList;
import org.netbeans.modules.uml.integration.ide.JavaClassUtils;
import org.netbeans.modules.uml.integration.ide.events.ClassInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GenCodeUtil {
    public static final String ASTERIK = "*";

    private GenCodeUtil() {
    }

    public static boolean isValidClassType(String string) {
        return string != null && string.length() != 0 && !string.equals("void") && !string.equals("String") && !string.equals("java.lang.String") && !JavaClassUtils.isPrimitive(string);
    }

    public static String getCodeGenType(IClassifier iClassifier, String[] stringArray, boolean bl, IMultiplicity iMultiplicity, boolean bl2, ClassInfo classInfo) {
        ClassInfo classInfo2 = ClassInfo.getRefClassInfo(iClassifier, true, true);
        String string = classInfo2.getCodeGenType(bl2, classInfo);
        if (iMultiplicity != null && GenCodeUtil.isMultiDim(iMultiplicity)) {
            return GenCodeUtil.assembleMultiDimDataType(string, stringArray, bl, iMultiplicity.getRangeCount(), bl2);
        }
        return string;
    }

    public static String assembleMultiDimDataType(String string, String[] stringArray, boolean bl, long l, boolean bl2) {
        String string2;
        boolean bl3 = true;
        bl3 = JavaClassUtils.isPrimitive(string);
        if (l == 0L) {
            return string;
        }
        if (bl3 && stringArray[(int)l - 1] != null && !stringArray[(int)l - 1].equals("[]")) {
            string2 = JavaClassUtils.getPrimitiveWrapperType(string);
            string = bl2 ? "java.lang." + string2 : string2;
            bl3 = false;
        }
        string2 = "";
        String string3 = "";
        int n = 0;
        while ((long)n < l) {
            String string4 = stringArray[n];
            if (!(string4 == null || string4.trim().equals("[]") || (long)n == l - 1L && bl3)) {
                string2 = string2 + string4;
                if (!bl) {
                    return string2 + string3;
                }
                string2 = string2 + '<';
                string3 = '>' + string3;
            } else {
                string3 = "[]" + string3;
            }
            ++n;
        }
        return string2 + string + string3;
    }

    public static boolean isMultiDim(IMultiplicity iMultiplicity) {
        boolean bl;
        if (iMultiplicity == null || iMultiplicity.getRanges().size() == 0) {
            return false;
        }
        if (iMultiplicity.getRanges().size() > 1) {
            return true;
        }
        String string = ((IMultiplicityRange)iMultiplicity.getRanges().get(0)).getLower();
        String string2 = ((IMultiplicityRange)iMultiplicity.getRanges().get(0)).getUpper();
        boolean bl2 = bl = string2.equals(ASTERIK) || string.equals(ASTERIK);
        if (!bl) {
            try {
                bl = Long.valueOf(string2).intValue() > 1;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return bl;
    }

    public static String removeGenericType(String string) {
        return string.indexOf("<") == -1 ? string : string.substring(0, string.indexOf(60));
    }

    public static String[] getFullyQualifiedCodeGenType(IClassifier iClassifier) {
        ClassInfo classInfo = ClassInfo.getRefClassInfo(iClassifier, true, true);
        String[] stringArray = classInfo.getFullyQualifiedCodeGenType();
        return stringArray;
    }

    public static String getTypeName(IClassifier iClassifier, boolean bl) {
        String string = "";
        String[] stringArray = GenCodeUtil.getFullyQualifiedCodeGenType(iClassifier);
        if (stringArray != null && stringArray.length == 2) {
            string = bl ? stringArray[0] + "." + stringArray[1] : stringArray[1];
        }
        return string;
    }

    public static String getTypeCodeGenType(IClassifier iClassifier, boolean bl, ClassInfo classInfo) {
        Object object;
        IClassifier iClassifier2 = null;
        String string = "";
        if (iClassifier instanceof IDerivationClassifier) {
            object = iClassifier.getDerivation();
            if (object != null) {
                iClassifier2 = object.getTemplate();
                ETList eTList = object.getBindings();
                if (eTList != null) {
                    boolean bl2 = true;
                    for (IUMLBinding iUMLBinding : eTList) {
                        String string2;
                        if (!(iUMLBinding.getActual() instanceof IClassifier) || (string2 = GenCodeUtil.getTypeCodeGenType((IClassifier)iUMLBinding.getActual(), bl, classInfo)) == null || string2.trim().equals("")) continue;
                        if (JavaClassUtils.isPrimitive(string2)) {
                            string2 = JavaClassUtils.getPrimitiveWrapperType(string2);
                        }
                        if (!bl2) {
                            string = string + ", ";
                        } else {
                            bl2 = false;
                        }
                        string = string + string2.trim();
                    }
                    if (string != null && !string.trim().equals("")) {
                        string = "<" + string + ">";
                    }
                }
            } else {
                iClassifier2 = iClassifier;
            }
        } else {
            iClassifier2 = iClassifier;
        }
        object = (bl || GenCodeUtil.isNameCodeGenConflict(classInfo, iClassifier2)) && !(iClassifier2 instanceof ClassifierTemplateParameter) ? GenCodeUtil.getTypeName(iClassifier2, true) : GenCodeUtil.getTypeName(iClassifier2, false);
        string = (String)object + string;
        return string;
    }

    public static ArrayList<String[]> getReferredCodeGenTypes(IClassifier iClassifier, String[] stringArray, boolean bl, IMultiplicity iMultiplicity, ClassInfo classInfo) {
        ArrayList<Object> arrayList;
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        boolean bl2 = false;
        if (iClassifier instanceof IDerivationClassifier) {
            arrayList = GenCodeUtil.getReferredCodeGenTypes(iClassifier, classInfo);
        } else {
            IClassifier iClassifier2 = iClassifier;
            IElement iElement = iClassifier.getOwner();
            while (iElement != null && iElement instanceof IClassifier) {
                iClassifier2 = (IClassifier)iElement;
                iElement = iClassifier2.getOwner();
            }
            String[] stringArray2 = GenCodeUtil.getFullyQualifiedCodeGenType(iClassifier2);
            if (stringArray2 == null || stringArray2.length != 2 || stringArray2[1] == null) {
                return null;
            }
            arrayList = new ArrayList();
            if (!GenCodeUtil.isNameCodeGenConflict(classInfo, iClassifier)) {
                arrayList.add(stringArray2);
            }
            bl2 = JavaClassUtils.isPrimitive(stringArray2[1]);
        }
        boolean bl3 = true;
        if (iMultiplicity != null && GenCodeUtil.isMultiDim(iMultiplicity)) {
            int n = (int)iMultiplicity.getRangeCount();
            if (bl2 && stringArray[n - 1] != null && !stringArray[n - 1].equals("[]")) {
                bl2 = false;
            }
            for (int i = 0; i < n; ++i) {
                String string = stringArray[i];
                if (string == null || string.trim().equals("[]") || i == n - 1 && bl2) continue;
                arrayList2.add(new String[]{JavaClassUtils.getPackageName(string), JavaClassUtils.getShortClassName(string)});
                if (bl) continue;
                bl3 = false;
                break;
            }
        }
        if (bl3 && arrayList != null) {
            arrayList2.addAll(arrayList);
        }
        return arrayList2;
    }

    public static ArrayList<String[]> getReferredCodeGenTypes(IClassifier iClassifier, ClassInfo classInfo) {
        String[] stringArray;
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        IClassifier iClassifier2 = null;
        if (iClassifier instanceof IDerivationClassifier) {
            stringArray = iClassifier.getDerivation();
            if (stringArray != null) {
                iClassifier2 = stringArray.getTemplate();
                ETList eTList = stringArray.getBindings();
                if (eTList != null) {
                    for (IUMLBinding iUMLBinding : eTList) {
                        ArrayList<String[]> arrayList2;
                        if (!(iUMLBinding.getActual() instanceof IClassifier) || (arrayList2 = GenCodeUtil.getReferredCodeGenTypes((IClassifier)iUMLBinding.getActual(), classInfo)) == null) continue;
                        arrayList.addAll(arrayList2);
                    }
                }
            } else {
                String[] stringArray2 = GenCodeUtil.getFullyQualifiedCodeGenType(iClassifier);
                if (stringArray2 != null && stringArray2.length == 2) {
                    int n;
                    String string = stringArray2[1];
                    if (string != null && (n = string.indexOf(60)) > 1) {
                        string = string.substring(0, n);
                    }
                    arrayList.add(new String[]{stringArray2[0], string});
                }
            }
        } else {
            iClassifier2 = iClassifier;
        }
        if (iClassifier2 != null && !GenCodeUtil.isNameCodeGenConflict(classInfo, iClassifier2) && (stringArray = GenCodeUtil.getFullyQualifiedCodeGenType(iClassifier2)) != null && stringArray.length == 2) {
            arrayList.add(stringArray);
        }
        return arrayList;
    }

    public static void mergeReferredCodeGenTypes(ArrayList<String[]> arrayList, HashSet<String> hashSet, ArrayList<String[]> arrayList2) {
        if (arrayList2 == null) {
            return;
        }
        for (String[] stringArray : arrayList2) {
            String string;
            if (stringArray == null || stringArray.length != 2 || stringArray[0] == null || stringArray[1] == null || hashSet.contains(string = stringArray[1] + "." + stringArray[0])) continue;
            hashSet.add(string);
            arrayList.add(stringArray);
        }
    }

    public static String[] getCollectionOverrideDataTypes(IMultiplicity iMultiplicity, boolean bl) {
        if (iMultiplicity == null) {
            return null;
        }
        ETList eTList = iMultiplicity.getRanges();
        if (eTList == null) {
            return null;
        }
        String[] stringArray = new String[(int)iMultiplicity.getRangeCount()];
        Iterator iterator = eTList.iterator();
        for (int i = 0; i < stringArray.length; ++i) {
            IMultiplicityRange iMultiplicityRange;
            String string = null;
            if (iterator.hasNext() && (iMultiplicityRange = (IMultiplicityRange)iterator.next()) != null) {
                string = iMultiplicityRange.getCollectionTypeValue(true);
                if (string == null || string.trim().equals("")) {
                    string = "[]";
                }
                if (!"[]".equals(string)) {
                    string = JavaClassUtils.convertUMLtoJava(string);
                }
            }
            if (!bl && !"[]".equals(string)) {
                string = JavaClassUtils.getShortClassName(string);
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    public static boolean isNameCodeGenConflict(ClassInfo classInfo, IClassifier iClassifier) {
        if (classInfo == null) {
            return false;
        }
        IClassifier iClassifier2 = classInfo.getClassElement();
        if (iClassifier2 == null) {
            return false;
        }
        if (JavaClassUtils.isAnOwner(iClassifier2, iClassifier)) {
            return false;
        }
        String string = GenCodeUtil.getTypeName(iClassifier, false);
        if (GenCodeUtil.findConflictingByCodeGenName(classInfo, string) != null) {
            return true;
        }
        ClassInfo classInfo2 = classInfo.getOuterClass();
        if (classInfo2 != null) {
            return GenCodeUtil.isNameCodeGenConflict(classInfo2, iClassifier);
        }
        String string2 = GenCodeUtil.getTypeName(iClassifier2, false);
        return string2.equals(string);
    }

    public static ClassInfo findConflictingByCodeGenName(ClassInfo classInfo, String string) {
        Object object;
        String string2;
        String string3;
        if (classInfo == null || string == null) {
            return null;
        }
        int n = string.indexOf(".");
        if (n > -1) {
            string3 = string.substring(n + 1);
            string2 = string.substring(0, n);
        } else {
            string2 = string;
            string3 = "";
        }
        ArrayList<ClassInfo> arrayList = classInfo.getMemberTypes();
        if (arrayList != null) {
            object = arrayList.iterator();
            while (object.hasNext()) {
                ClassInfo classInfo2 = (ClassInfo)object.next();
                String string4 = GenCodeUtil.getTypeName(classInfo2.getClassElement(), false);
                int n2 = string4.lastIndexOf(".");
                if (n2 > -1) {
                    string4 = string4.substring(n2 + 1);
                }
                if (!string2.equals(string4)) continue;
                if (!string.equals("")) {
                    return classInfo2;
                }
                ClassInfo classInfo3 = GenCodeUtil.findConflictingByCodeGenName(classInfo2, string3);
                if (classInfo3 == null) continue;
                return classInfo3;
            }
        }
        if ((object = classInfo.getOuterClass()) == null) {
            if (string.equals(GenCodeUtil.getTypeName(classInfo.getClassElement(), false))) {
                return object;
            }
            return null;
        }
        return GenCodeUtil.findConflictingByCodeGenName((ClassInfo)object, string);
    }
}

