/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.integration.netbeans;

import org.netbeans.modules.uml.core.support.umlsupport.Log;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.filesystems.RepositoryAdapter;
import org.openide.filesystems.RepositoryEvent;
import org.openide.filesystems.RepositoryListener;

public class FileSystemListener
extends RepositoryAdapter {
    private static boolean mounting = false;
    private Repository repository = null;
    private static FileSystemListener defaultInstance = null;

    public static synchronized FileSystemListener getInstance() {
        if (defaultInstance == null) {
            defaultInstance = new FileSystemListener();
        }
        return defaultInstance;
    }

    public static void setMounting(boolean bl) {
        mounting = bl;
    }

    public static boolean isMounting() {
        return mounting;
    }

    public void addTo(Repository repository) {
        if (this.repository != null) {
            this.repository.removeRepositoryListener((RepositoryListener)this);
        }
        if ((this.repository = repository) != null) {
            this.repository.addRepositoryListener((RepositoryListener)this);
        }
    }

    public void fileSystemRemoved(RepositoryEvent repositoryEvent) {
        FileSystem fileSystem = repositoryEvent.getFileSystem();
        if (fileSystem instanceof LocalFileSystem && !fileSystem.isReadOnly()) {
            Log.out((String)("FSL: --------- " + fileSystem.getDisplayName()));
        }
    }

    public void fileSystemAdded(RepositoryEvent repositoryEvent) {
        if (repositoryEvent.isAdded()) {
            FileSystem fileSystem = repositoryEvent.getFileSystem();
            FileSystemListener.setMounting(false);
            if (fileSystem instanceof LocalFileSystem && !fileSystem.isReadOnly() && fileSystem.isValid()) {
                Log.out((String)("FSL: +++++++++ " + fileSystem.getDisplayName()));
            }
        }
    }
}

