/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform.ui;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JSeparator;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProjectNodeWrapper
extends FilterNode
implements Runnable,
FileStatusListener,
ChangeListener,
PropertyChangeListener {
    private Set<FileObject> files;
    private Map<FileSystem, FileStatusListener> fileSystemListeners;
    private RequestProcessor.Task task;
    private final Object privateLock = new Object();
    private boolean iconChange;
    private boolean nameChange;
    private ChangeListener sourcesListener;
    private Map<SourceGroup, PropertyChangeListener> groupsListeners;
    public static final Action GENERIC_PROJECTS_ACTIONS_MARKER = new AbstractAction(){

        public void actionPerformed(ActionEvent actionEvent) {
        }
    };

    public ProjectNodeWrapper(Node node) {
        super(node);
        this.setProjectFiles();
    }

    public Action[] getActions(boolean bl) {
        Action[] actionArray = super.getActions(bl);
        ArrayList<Action> arrayList = new ArrayList<Action>();
        for (int i = 0; i < actionArray.length; ++i) {
            if (actionArray[i] != GENERIC_PROJECTS_ACTIONS_MARKER) {
                arrayList.add(actionArray[i]);
                continue;
            }
            Lookup lookup = Lookups.forPath((String)"Projects/Actions");
            for (Object e : lookup.lookupAll(Object.class)) {
                if (e instanceof Action) {
                    arrayList.add((Action)e);
                    continue;
                }
                if (!(e instanceof JSeparator)) continue;
                arrayList.add(null);
            }
        }
        return arrayList.toArray(new Action[arrayList.size()]);
    }

    protected final void setProjectFiles() {
        Project project = (Project)this.getLookup().lookup(Project.class);
        if (project != null) {
            this.setProjectFiles(project);
        } else {
            ErrorManager.getDefault().log(1, "Node: " + this.getOriginal() + " wrapped with ProjectNodeWrapper, but does not contain a Project in the lookup!");
        }
    }

    protected final void setProjectFiles(Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        if (this.sourcesListener == null) {
            this.sourcesListener = WeakListeners.change((ChangeListener)this, (Object)sources);
            sources.addChangeListener(this.sourcesListener);
        }
        this.setGroups(Arrays.asList(sources.getSourceGroups("generic")));
    }

    private final void setGroups(Collection<SourceGroup> collection) {
        if (this.groupsListeners != null) {
            for (Map.Entry<SourceGroup, PropertyChangeListener> object : this.groupsListeners.entrySet()) {
                object.getKey().removePropertyChangeListener(object.getValue());
            }
        }
        this.groupsListeners = new HashMap<SourceGroup, PropertyChangeListener>();
        HashSet hashSet = new HashSet();
        for (SourceGroup sourceGroup : collection) {
            PropertyChangeListener propertyChangeListener = WeakListeners.propertyChange((PropertyChangeListener)this, (Object)sourceGroup);
            this.groupsListeners.put(sourceGroup, propertyChangeListener);
            sourceGroup.addPropertyChangeListener(propertyChangeListener);
            FileObject fileObject = sourceGroup.getRootFolder();
            hashSet.add(fileObject);
        }
        this.setFiles(hashSet);
    }

    protected final void setFiles(Set<FileObject> set) {
        if (this.fileSystemListeners != null) {
            for (Map.Entry<FileSystem, FileStatusListener> object : this.fileSystemListeners.entrySet()) {
                object.getKey().removeFileStatusListener(object.getValue());
            }
        }
        this.fileSystemListeners = new HashMap<FileSystem, FileStatusListener>();
        this.files = set;
        if (set == null) {
            return;
        }
        HashSet hashSet = new HashSet();
        for (FileObject fileObject : set) {
            try {
                FileSystem fileStateInvalidException = fileObject.getFileSystem();
                if (hashSet.contains(fileStateInvalidException)) continue;
                hashSet.add(fileStateInvalidException);
                FileStatusListener fileStatusListener = FileUtil.weakFileStatusListener((FileStatusListener)this, (Object)fileStateInvalidException);
                fileStateInvalidException.addFileStatusListener(fileStatusListener);
                this.fileSystemListeners.put(fileStateInvalidException, fileStatusListener);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Logger.getLogger(ProjectNodeWrapper.class.getName()).log(Level.INFO, "Cannot get " + fileObject + " filesystem, ignoring...", fileStateInvalidException);
            }
        }
    }

    public Image getIcon(int n) {
        Image image = super.getIcon(n);
        if (this.files != null && this.files.iterator().hasNext()) {
            try {
                FileObject fileObject = this.files.iterator().next();
                image = fileObject.getFileSystem().getStatus().annotateIcon(image, n, this.files);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
            }
        }
        return image;
    }

    public Image getOpenedIcon(int n) {
        Image image = super.getOpenedIcon(n);
        if (this.files != null && this.files.iterator().hasNext()) {
            try {
                FileObject fileObject = this.files.iterator().next();
                image = fileObject.getFileSystem().getStatus().annotateIcon(image, n, this.files);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                ErrorManager.getDefault().notify(1, (Throwable)fileStateInvalidException);
            }
        }
        return image;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean bl;
        boolean bl2;
        Object object = this.privateLock;
        synchronized (object) {
            bl2 = this.iconChange;
            bl = this.nameChange;
            this.iconChange = false;
            this.nameChange = false;
        }
        if (bl2) {
            this.fireIconChange();
            this.fireOpenedIconChange();
        }
        if (bl) {
            this.fireDisplayNameChange(null, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotationChanged(FileStatusEvent fileStatusEvent) {
        if (this.task == null) {
            this.task = RequestProcessor.getDefault().create((Runnable)this);
        }
        Object object = this.privateLock;
        synchronized (object) {
            if (!this.iconChange && fileStatusEvent.isIconChange() || !this.nameChange && fileStatusEvent.isNameChange()) {
                for (FileObject fileObject : this.files) {
                    if (!fileStatusEvent.hasChanged(fileObject)) continue;
                    this.iconChange |= fileStatusEvent.isIconChange();
                    this.nameChange |= fileStatusEvent.isNameChange();
                }
            }
        }
        this.task.schedule(50);
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this.setProjectFiles();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        this.setProjectFiles();
    }
}

