/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.debugger.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.Set;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Caret;
import javax.swing.text.StyledDocument;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.ant.debugger.breakpoints.AntBreakpoint;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;

public class AntBreakpointActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private static final Set actions = Collections.singleton(ActionsManager.ACTION_TOGGLE_BREAKPOINT);

    public AntBreakpointActionProvider() {
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, true);
        TopComponent.getRegistry().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)TopComponent.getRegistry()));
    }

    public void doAction(Object object) {
        int n;
        Line line = AntBreakpointActionProvider.getCurrentLine();
        if (line == null) {
            return;
        }
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        int n2 = breakpointArray.length;
        for (n = 0; n < n2; ++n) {
            if (!(breakpointArray[n] instanceof AntBreakpoint) || !((AntBreakpoint)breakpointArray[n]).getLine().equals(line)) continue;
            DebuggerManager.getDebuggerManager().removeBreakpoint(breakpointArray[n]);
            break;
        }
        if (n == n2) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)new AntBreakpoint(line));
        }
    }

    public Set getActions() {
        return actions;
    }

    static Line getCurrentLine() {
        DataObject dataObject;
        Node[] nodeArray = TopComponent.getRegistry().getCurrentNodes();
        if (nodeArray == null) {
            return null;
        }
        if (nodeArray.length != 1) {
            return null;
        }
        Node node = nodeArray[0];
        FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fileObject == null && (dataObject = (DataObject)node.getLookup().lookup(DataObject.class)) != null) {
            fileObject = dataObject.getPrimaryFile();
        }
        if (!AntBreakpointActionProvider.isAntFile(fileObject)) {
            return null;
        }
        dataObject = (LineCookie)node.getCookie(LineCookie.class);
        if (dataObject == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)node.getCookie(EditorCookie.class);
        if (editorCookie == null) {
            return null;
        }
        JEditorPane jEditorPane = AntBreakpointActionProvider.getEditorPane(editorCookie);
        if (jEditorPane == null) {
            return null;
        }
        StyledDocument styledDocument = editorCookie.getDocument();
        if (styledDocument == null) {
            return null;
        }
        Caret caret = jEditorPane.getCaret();
        if (caret == null) {
            return null;
        }
        int n = NbDocument.findLineNumber((StyledDocument)styledDocument, (int)caret.getDot());
        try {
            Line.Set set = dataObject.getLineSet();
            assert (set != null) : dataObject;
            return set.getCurrent(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    private static JEditorPane getEditorPane_(EditorCookie editorCookie) {
        JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
        if (jEditorPaneArray == null || jEditorPaneArray.length < 1) {
            return null;
        }
        return jEditorPaneArray[0];
    }

    private static JEditorPane getEditorPane(final EditorCookie editorCookie) {
        if (SwingUtilities.isEventDispatchThread()) {
            return AntBreakpointActionProvider.getEditorPane_(editorCookie);
        }
        final JEditorPane[] jEditorPaneArray = new JEditorPane[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    jEditorPaneArray[0] = AntBreakpointActionProvider.getEditorPane_(editorCookie);
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify(invocationTargetException.getTargetException());
        }
        catch (InterruptedException interruptedException) {
            ErrorManager.getDefault().notify((Throwable)interruptedException);
        }
        return jEditorPaneArray[0];
    }

    private static boolean isAntFile(FileObject fileObject) {
        if (fileObject == null) {
            return false;
        }
        return fileObject.getMIMEType().equals("text/x-ant+xml");
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = AntBreakpointActionProvider.getCurrentLine() != null;
        this.setEnabled(ActionsManager.ACTION_TOGGLE_BREAKPOINT, bl);
    }
}

