/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.classpath.j2ee;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.java.api.common.classpath.ClassPathItem;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupport;
import org.netbeans.modules.java.api.common.classpath.j2ee.BaseClassPathSupport;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.openide.util.Parameters;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebClassPathSupport
extends BaseClassPathSupport<Item> {
    public static final String TAG_WEB_MODULE_LIBRARIES = "web-module-libraries";
    public static final String TAG_WEB_MODULE_ADDITIONAL_LIBRARIES = "web-module-additional-libraries";
    private static final String TAG_PATH_IN_WAR = "path-in-war";
    private static final String TAG_FILE = "file";
    private static final String TAG_LIBRARY = "library";
    private final String[] projectConfigurationNameSpaceList;

    public static WebClassPathSupport create(PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper, String[] stringArray, String string, String string2, String string3, String string4, String[] stringArray2) {
        Parameters.notNull((CharSequence)"projectConfigurationNameSpaceList", (Object)stringArray2);
        return new WebClassPathSupport(propertyEvaluator, referenceHelper, antProjectHelper, stringArray, string, string2, string3, string4, stringArray2);
    }

    private WebClassPathSupport(PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper, AntProjectHelper antProjectHelper, String[] stringArray, String string, String string2, String string3, String string4, String[] stringArray2) {
        super(propertyEvaluator, referenceHelper, antProjectHelper, stringArray, string, string2, string3, string4);
        assert (stringArray2 != null);
        this.projectConfigurationNameSpaceList = stringArray2;
    }

    @Override
    public List<Item> itemsList(String string, String string2) {
        List<ClassPathSupport.Item> list = this.delegate.itemsList(string);
        Map<String, String> map = null;
        map = string2 != null ? this.createWarIncludesMap(this.antProjectHelper, string2) : Collections.emptyMap();
        ArrayList<Item> arrayList = new ArrayList<Item>(list.size());
        for (ClassPathSupport.Item item : list) {
            arrayList.add(this.createItem(item, map));
        }
        return arrayList;
    }

    @Override
    public String[] encodeToStrings(List<Item> list, String string) {
        String[] stringArray;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (Item item : list) {
            String string2 = this.delegate.getReference(item.delegate);
            if (string2 == null) continue;
            arrayList2.add(string2);
            item.setReference(string2);
            if (string == null) continue;
            arrayList.add(CommonProjectUtils.getAntPropertyName(string2));
        }
        if (string != null) {
            stringArray = new ArrayList<Item>(list);
            this.putIncludedLibraries(arrayList, (List<Item>)stringArray, this.antProjectHelper, string);
        }
        stringArray = new String[arrayList2.size()];
        for (int i = 0; i < arrayList2.size(); ++i) {
            stringArray[i] = i < arrayList2.size() - 1 ? (String)arrayList2.get(i) + ":" : (String)arrayList2.get(i);
        }
        return stringArray;
    }

    private Item createItem(ClassPathSupport.Item item, Map<String, String> map) {
        Item item2 = null;
        switch (item.getType()) {
            case CLASSPATH: {
                item2 = new Item(item, null, null, item.getReference(), null);
                break;
            }
            case LIBRARY: 
            case ARTIFACT: 
            case JAR: {
                String string = item.getReference();
                item2 = new Item(item, null, null, string, map.get(string));
                break;
            }
            default: {
                assert (false) : "Unknown classpath item type for " + item;
                break;
            }
        }
        return item2;
    }

    private Map<String, String> createWarIncludesMap(AntProjectHelper antProjectHelper, String string) {
        LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
        for (int i = this.projectConfigurationNameSpaceList.length - 1; i >= 0; --i) {
            Element element;
            String string2 = this.projectConfigurationNameSpaceList[i];
            Element element2 = antProjectHelper.createAuxiliaryConfiguration().getConfigurationFragment("data", string2, true);
            if (element2 == null || (element = (Element)element2.getElementsByTagNameNS(string2, string).item(0)) == null) continue;
            NodeList nodeList = element.getChildNodes();
            for (int j = 0; j < nodeList.getLength(); ++j) {
                String string3;
                if (nodeList.item(j).getNodeType() != 1) continue;
                Element element3 = (Element)nodeList.item(j);
                Node node = element3.getElementsByTagNameNS(string2, TAG_FILE).item(0);
                NodeList nodeList2 = element3.getElementsByTagNameNS(string2, TAG_PATH_IN_WAR);
                String string4 = WebClassPathSupport.findText(node);
                string4 = string4.substring(2, string4.length() - 1);
                if (string.equals(TAG_WEB_MODULE_ADDITIONAL_LIBRARIES)) {
                    string3 = Item.PATH_IN_WAR_NONE;
                    if (nodeList2.getLength() > 0 && (string3 = WebClassPathSupport.findText((Element)nodeList2.item(0))) == null) {
                        string3 = "";
                    }
                    linkedHashMap.put(string4, string3);
                    continue;
                }
                string3 = null;
                string3 = nodeList2.getLength() > 0 ? WebClassPathSupport.findText(nodeList2.item(0)) : Item.PATH_IN_WAR_NONE;
                linkedHashMap.put(string4, string3);
            }
            return linkedHashMap;
        }
        if (linkedHashMap.isEmpty()) {
            return Collections.emptyMap();
        }
        return linkedHashMap;
    }

    private void putIncludedLibraries(List<String> list, List<Item> list2, AntProjectHelper antProjectHelper, String string) {
        assert (list != null);
        assert (antProjectHelper != null);
        assert (string != null);
        Element element = antProjectHelper.getPrimaryConfigurationData(true);
        Document document = element.getOwnerDocument();
        Element element2 = (Element)element.getElementsByTagNameNS(this.projectConfigurationNameSpace, string).item(0);
        if (element2 == null) {
            element2 = document.createElementNS(this.projectConfigurationNameSpace, string);
            element.appendChild(element2);
        }
        while (element2.hasChildNodes()) {
            element2.removeChild(element2.getChildNodes().item(0));
        }
        Iterator<Item> iterator = list2.iterator();
        for (String string2 : list) {
            element2.appendChild(this.createLibraryElement(document, string2, iterator.next()));
        }
        antProjectHelper.putPrimaryConfigurationData(element, true);
    }

    private Element createLibraryElement(Document document, String string, Item item) {
        Element element = document.createElementNS(this.projectConfigurationNameSpace, TAG_LIBRARY);
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        WebClassPathSupport.getFilesForItem(item, arrayList, arrayList2);
        if (arrayList.size() > 0) {
            element.setAttribute("files", "" + arrayList.size());
        }
        if (arrayList2.size() > 0) {
            element.setAttribute("dirs", "" + arrayList2.size());
        }
        Element element2 = document.createElementNS(this.projectConfigurationNameSpace, TAG_FILE);
        element.appendChild(element2);
        element2.appendChild(document.createTextNode("${" + string + "}"));
        if (item.getPathInWAR() != null) {
            Element element3 = document.createElementNS(this.projectConfigurationNameSpace, TAG_PATH_IN_WAR);
            element3.appendChild(document.createTextNode(item.getPathInWAR()));
            element.appendChild(element3);
        }
        return element;
    }

    public static final class Item
    extends BaseClassPathSupport.Item {
        public static final String PATH_IN_WAR_LIB = "WEB-INF/lib";
        public static final String PATH_IN_WAR_DIR = "WEB-INF/classes";
        public static final String PATH_IN_WAR_APPLET = "";
        public static final String PATH_IN_WAR_NONE = null;
        private String pathInWar;
        private String eval;

        Item(ClassPathSupport.Item item, String string, String string2, String string3, String string4) {
            super(item, string3, string);
            this.pathInWar = string4;
            this.eval = string2;
        }

        public static Item create(Library library, String string, String string2) {
            ClassPathSupport.Item item = ClassPathSupport.Item.create(library, string);
            String string3 = library.getName();
            return new Item(item, "${libs." + string3 + ".classpath}", string3, string, string2);
        }

        public static Item create(AntArtifact antArtifact, URI uRI, String string, String string2) {
            ClassPathSupport.Item item = ClassPathSupport.Item.create(antArtifact, uRI, string);
            return new Item(item, null, antArtifact.getArtifactLocations()[0].toString(), string, string2);
        }

        public static Item create(File file, String string, String string2) {
            ClassPathSupport.Item item = ClassPathSupport.Item.create(file, string);
            return new Item(item, null, file.getPath(), string, string2);
        }

        public static Item create(String string, String string2) {
            ClassPathSupport.Item item = ClassPathSupport.Item.create(string);
            return new Item(item, null, null, string, string2);
        }

        public static Item createBroken(ClassPathItem.Type type, String string, String string2) {
            ClassPathSupport.Item item = ClassPathSupport.Item.createBroken(type, string);
            return new Item(item, null, null, string, string2);
        }

        public static Item createBroken(File file, String string, String string2) {
            ClassPathSupport.Item item = ClassPathSupport.Item.createBroken(file, string);
            return new Item(item, null, null, string, string2);
        }

        public boolean canDelete() {
            return this.getType() != ClassPathItem.Type.CLASSPATH;
        }

        public String getPathInWAR() {
            return this.pathInWar;
        }

        public void setPathInWAR(String string) {
            this.pathInWar = string;
        }

        public String getEvaluated() {
            if (this.eval == null) {
                return this.getRaw();
            }
            return this.eval;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(200);
            stringBuilder.append(this.delegate.toString());
            stringBuilder.append(", raw = ");
            stringBuilder.append(this.getRaw());
            stringBuilder.append(", eval = ");
            stringBuilder.append(this.eval);
            stringBuilder.append(", pathInWar = ");
            stringBuilder.append(this.pathInWar);
            return stringBuilder.toString();
        }
    }
}

