/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.components.items;

import java.awt.Image;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignEventFilter;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.components.MidpValueSupport;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class ItemSupport {
    private static final InfoPresenter.Resolver SVG_MENU_ELEMENT_RESOLVER = new ElementResolver("string", "org/netbeans/modules/vmd/midpnb/resources/svg_menu_element_16.png");

    public static InfoPresenter.Resolver createSVGMenuElementInfoResolver() {
        return SVG_MENU_ELEMENT_RESOLVER;
    }

    private static class ElementResolver
    implements InfoPresenter.Resolver {
        private String propertyName;
        private Image icon;

        private ElementResolver(String string, String string2) {
            this.propertyName = string;
            this.icon = Utilities.loadImage((String)string2);
        }

        public DesignEventFilter getEventFilter(DesignComponent designComponent) {
            return new DesignEventFilter(new DesignEventFilter[0]).addComponentFilter(designComponent, false);
        }

        public String getDisplayName(DesignComponent designComponent, InfoPresenter.NameType nameType) {
            switch (nameType) {
                case PRIMARY: {
                    return this.resolveName(designComponent);
                }
                case SECONDARY: {
                    return NbBundle.getMessage(ItemSupport.class, (String)"TYPE_Element");
                }
                case TERTIARY: {
                    return null;
                }
            }
            throw Debug.illegalState((Object[])new Object[0]);
        }

        private String resolveName(DesignComponent designComponent) {
            return MidpValueSupport.getHumanReadableString((PropertyValue)designComponent.readProperty(this.propertyName));
        }

        public boolean isEditable(DesignComponent designComponent) {
            return true;
        }

        public String getEditableName(DesignComponent designComponent) {
            PropertyValue propertyValue = designComponent.readProperty(this.propertyName);
            if (propertyValue.getKind() == PropertyValue.Kind.VALUE) {
                return MidpTypes.getString((PropertyValue)propertyValue);
            }
            return "";
        }

        public void setEditableName(DesignComponent designComponent, String string) {
            assert (string != null);
            designComponent.writeProperty(this.propertyName, MidpTypes.createStringValue((String)string));
        }

        public Image getIcon(DesignComponent designComponent, InfoPresenter.IconType iconType) {
            return iconType == InfoPresenter.IconType.COLOR_16x16 ? this.icon : null;
        }
    }
}

