/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midpnb.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collections;
import java.util.regex.Pattern;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.TypeID;
import org.netbeans.modules.vmd.midp.components.MidpTypes;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.usercode.PropertyEditorUserCode;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class PropertyEditorPhoneNumber
extends PropertyEditorUserCode
implements PropertyEditorElement {
    private CustomEditor customEditor;
    private JRadioButton radioButton;
    private String label;
    private TypeID parentTypeID;

    private PropertyEditorPhoneNumber(String string, String string2, TypeID typeID) {
        super(string2);
        this.label = string;
        this.parentTypeID = typeID;
        this.initComponents();
        this.initElements(Collections.singleton(this));
    }

    public static PropertyEditorPhoneNumber createInstance(String string, String string2) {
        return new PropertyEditorPhoneNumber(string, string2, null);
    }

    public static PropertyEditorPhoneNumber createInstance(String string, String string2, TypeID typeID) {
        return new PropertyEditorPhoneNumber(string, string2, typeID);
    }

    private void initComponents() {
        this.radioButton = new JRadioButton();
        Mnemonics.setLocalizedText((AbstractButton)this.radioButton, (String)this.label);
        this.customEditor = new CustomEditor();
    }

    public JComponent getCustomEditorComponent() {
        return this.customEditor;
    }

    public JRadioButton getRadioButton() {
        return this.radioButton;
    }

    public boolean isInitiallySelected() {
        return true;
    }

    public boolean isVerticallyResizable() {
        return false;
    }

    public String getAsText() {
        String string = super.getAsText();
        if (string != null) {
            return string;
        }
        Object object = ((PropertyValue)super.getValue()).getPrimitiveValue();
        return String.valueOf(object);
    }

    public void setTextForPropertyValue(String string) {
        this.saveValue(string);
    }

    public String getTextForPropertyValue() {
        return null;
    }

    public void updateState(PropertyValue propertyValue) {
        if (propertyValue != null) {
            this.customEditor.setText(String.valueOf(propertyValue.getPrimitiveValue()));
        } else {
            this.customEditor.setText("");
        }
        this.radioButton.setSelected(!this.isCurrentValueAUserCodeType());
    }

    private void saveValue(String string) {
        string = string.replaceAll("[^0-9]", "");
        super.setValue((Object)MidpTypes.createStringValue((String)string));
    }

    public void customEditorOKButtonPressed() {
        super.customEditorOKButtonPressed();
        if (this.radioButton.isSelected()) {
            this.saveValue(this.customEditor.getText());
        }
    }

    public Boolean canEditAsText() {
        PropertyValue propertyValue;
        if (!this.isCurrentValueAUserCodeType() && (propertyValue = (PropertyValue)super.getValue()) == null) {
            return false;
        }
        return false;
    }

    public boolean canWrite() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return super.canWrite();
    }

    public boolean supportsCustomEditor() {
        if (!this.isWriteableByParentType()) {
            return false;
        }
        return super.supportsCustomEditor();
    }

    private boolean isWriteableByParentType() {
        if (this.component == null || this.component.get() == null) {
            return false;
        }
        if (this.parentTypeID != null) {
            final DesignComponent designComponent = (DesignComponent)this.component.get();
            final DesignComponent[] designComponentArray = new DesignComponent[1];
            designComponent.getDocument().getTransactionManager().readAccess(new Runnable(){

                public void run() {
                    designComponentArray[0] = designComponent.getParentComponent();
                }
            });
            if (designComponentArray[0] != null && this.parentTypeID.equals((Object)designComponentArray[0].getType())) {
                return false;
            }
        }
        return true;
    }

    private class CustomEditor
    extends JPanel
    implements ActionListener,
    DocumentListener,
    FocusListener {
        private JTextField textField;

        public CustomEditor() {
            PropertyEditorPhoneNumber.this.radioButton.addFocusListener(this);
            this.initComponents();
        }

        private void initComponents() {
            this.setLayout(new BorderLayout());
            this.textField = new JTextField();
            this.textField.getDocument().addDocumentListener(this);
            this.textField.addFocusListener(this);
            this.add((Component)this.textField, "South");
        }

        public void setText(String string) {
            this.textField.setText(string);
        }

        public String getText() {
            return this.textField.getText();
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (this.textField.hasFocus()) {
                PropertyEditorPhoneNumber.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (this.textField.hasFocus()) {
                PropertyEditorPhoneNumber.this.radioButton.setSelected(true);
                this.checkNumberStatus();
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }

        private void checkNumberStatus() {
            if (!Pattern.matches("[+\\d\\-]+", this.textField.getText())) {
                PropertyEditorPhoneNumber.this.displayWarning(NbBundle.getMessage(PropertyEditorPhoneNumber.class, (String)"LBL_PhoneNumber_Warning"));
            } else {
                PropertyEditorPhoneNumber.this.clearErrorStatus();
            }
        }

        public void focusGained(FocusEvent focusEvent) {
            if (focusEvent.getSource() == PropertyEditorPhoneNumber.this.radioButton || focusEvent.getSource() == this.textField) {
                this.checkNumberStatus();
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            PropertyEditorPhoneNumber.this.clearErrorStatus();
        }
    }
}

