/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.complib;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.FileChannel;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.visualweb.api.designerapi.DesignerServiceHack;
import org.openide.ErrorManager;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.modules.InstalledFileLocator;

public class IdeUtil {
    private static final Logger logger = Logger.getLogger(IdeUtil.class.getPackage().getName());
    private static File raveClusterDir;
    private static File complibStateDir;

    public static Logger getLogger() {
        return logger;
    }

    public static void logWarning(Throwable throwable) {
        ErrorManager.getDefault().notify(1, throwable);
    }

    public static void logWarning(String string) {
        IdeUtil.logWarning(new Throwable(string));
    }

    public static void logWarning(String string, Throwable throwable) {
        IdeUtil.logWarning(new Throwable(string, throwable));
    }

    public static void logError(Throwable throwable) {
        ErrorManager.getDefault().notify(65536, throwable);
    }

    public static void logError(String string) {
        IdeUtil.logError(new Throwable(string));
    }

    public static void logError(String string, Throwable throwable) {
        IdeUtil.logError(new Throwable(string, throwable));
    }

    public static void printDebug(String string) {
        System.err.println(string);
    }

    public static Project getActiveProject() {
        FileObject fileObject = DesignerServiceHack.getDefault().getCurrentFile();
        if (fileObject == null) {
            return null;
        }
        return FileOwnerQuery.getOwner((FileObject)fileObject);
    }

    public static Project fileToProject(File file) {
        try {
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject != null && fileObject.isFolder()) {
                return ProjectManager.getDefault().findProject(fileObject);
            }
            return null;
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
            return null;
        }
    }

    public static String removeWhiteSpace(String string) {
        String[] stringArray = string.split("\\s+");
        if (stringArray.length <= 1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(stringArray[0]);
        for (int i = 1; i < stringArray.length; ++i) {
            stringBuffer.append('_');
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    public static void unzip(File file, File file2) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zipInputStream = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            int n;
            Object object;
            File file3 = new File(file2, zipEntry.getName().replace('/', File.separatorChar));
            if (zipEntry.isDirectory()) {
                if ((file3.exists() || file3.mkdirs()) && file3.isDirectory()) continue;
                throw new IOException("Unable to create dir: " + file3.getPath());
            }
            if (!(file3.getParent() == null || (((File)(object = new File(file3.getParent()))).exists() || ((File)object).mkdirs()) && ((File)object).isDirectory())) {
                throw new IOException("Unable to create dir: " + ((File)object).getPath());
            }
            object = new FileOutputStream(file3);
            byte[] byArray = new byte[512];
            while ((n = zipInputStream.read(byArray, 0, byArray.length)) != -1) {
                ((OutputStream)object).write(byArray, 0, n);
            }
            zipInputStream.closeEntry();
            ((OutputStream)object).close();
        }
        zipInputStream.close();
    }

    public static void runAntTask(File file, String string, Properties properties) throws IOException {
        ExecutorTask executorTask = ActionUtils.runTarget((FileObject)FileUtil.toFileObject((File)file), (String[])new String[]{string}, (Properties)properties);
        int n = executorTask.result();
        if (n != 0) {
            throw new IOException("Ant task execution failed");
        }
    }

    public static String removeExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        return string.substring(0, n);
    }

    public static File findUniqueFile(File file, String string, String string2) {
        assert (file.isDirectory());
        String string3 = string + string2;
        File file2 = new File(file, string3);
        int n = 0;
        while (file2.exists()) {
            string3 = string + "_" + ++n + string2;
            file2 = new File(file, string3);
        }
        return file2;
    }

    public static File getNetBeansInstallDirectory() {
        File file = IdeUtil.getRaveClusterDirectory();
        if (file != null) {
            return file.getParentFile();
        }
        return null;
    }

    public static File getRaveSamplesDirectory() {
        return new File(IdeUtil.getRaveClusterDirectory(), "samples");
    }

    private static File getRaveClusterDirectory() {
        File file;
        if (raveClusterDir == null && (file = InstalledFileLocator.getDefault().locate("modules/org-netbeans-modules-visualweb-complib.jar", null, false)) != null) {
            raveClusterDir = file.getParentFile().getParentFile();
        }
        return raveClusterDir;
    }

    public static void copyFileRecursive(File file, File file2) throws IOException {
        File file3 = null;
        file3 = file2.isDirectory() ? new File(file2, file.getName()) : file2;
        if (file.isDirectory()) {
            file3.mkdir();
            File[] fileArray = file.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                IdeUtil.copyFileRecursive(fileArray[i], file3);
            }
        } else {
            IdeUtil.copyFile(file, file3);
        }
    }

    public static boolean deleteRecursive(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = IdeUtil.deleteRecursive(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static File freeJarFile(File file) throws IOException {
        String string;
        String string2;
        boolean bl = System.getProperty("os.name").toLowerCase().indexOf("windows") != -1;
        String string3 = System.getProperty("toolbox.makeTempCopy", Boolean.toString(bl));
        if (!Boolean.valueOf(string3).booleanValue()) {
            return file;
        }
        String string4 = file.getName();
        int n = string4.lastIndexOf(46);
        if (n != -1 && n + 1 < string4.length()) {
            string2 = string4.substring(0, n) + "_";
            string = string4.substring(n);
        } else {
            string2 = string4;
            string = null;
        }
        File file2 = File.createTempFile(string2, string);
        file2.deleteOnExit();
        IdeUtil.copyFile(file, file2);
        return file2;
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        FileChannel fileChannel2 = new FileOutputStream(file2).getChannel();
        fileChannel2.transferFrom(fileChannel, 0L, fileChannel.size());
        fileChannel.close();
        fileChannel2.close();
    }

    public static String baseClassName(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        if (string.length() > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static String baseName(String string) {
        int n = string.lastIndexOf(File.separatorChar);
        if (n < 0) {
            return string;
        }
        if (string.length() > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public static File getProjectLibraryDirectory(Project project) {
        FileObject fileObject = project.getProjectDirectory();
        File file = FileUtil.toFile((FileObject)fileObject);
        return new File(file, "lib");
    }

    public static String getCodeNameBase() {
        return IdeUtil.class.getPackage().getName();
    }

    public static File getComplibStateDir() {
        String string;
        File file;
        if (complibStateDir == null && !(complibStateDir = new File(file = FileUtil.toFile((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot()), string = IdeUtil.getCodeNameBase().replace('.', '-'))).exists() && !complibStateDir.mkdirs()) {
            IllegalStateException illegalStateException = new IllegalStateException("Unable to create dir: " + complibStateDir);
            IdeUtil.logError(illegalStateException);
            throw illegalStateException;
        }
        return complibStateDir;
    }
}

