/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.complib;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Version
implements Comparable<Version> {
    private int major;
    private int minor;
    private int micro;

    public Version(int n, int n2, int n3) {
        if (n < 0 || n2 < 0 || n3 < 0) {
            throw new IllegalArgumentException("No arguments must be less than 0");
        }
        this.major = n;
        this.minor = n2;
        this.micro = n3;
    }

    public Version(String string) {
        String[] stringArray = string.split("\\.");
        try {
            this.major = Integer.parseInt(stringArray[0]);
            if (this.major < 0) {
                throw new IllegalArgumentException("Bad version format, required major version < 0: " + string);
            }
            this.minor = Integer.parseInt(stringArray[1]);
            if (this.minor < 0) {
                throw new IllegalArgumentException("Bad version format, required minor version < 0: " + string);
            }
            if (stringArray.length > 2) {
                this.micro = Integer.parseInt(stringArray[2]);
                if (this.micro < 0) {
                    throw new IllegalArgumentException("Bad version format, optional micro version < 0: " + string);
                }
            } else {
                this.micro = 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("Bad version format " + string);
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Version) {
            Version version = (Version)object;
            if (this.getMajor() == version.getMajor() && this.getMinor() == version.getMinor()) {
                return this.getMicro() == version.getMicro();
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.getMajor() + this.getMinor() + this.getMicro();
    }

    public String toString() {
        String string = this.major + "." + this.minor;
        if (this.micro != 0) {
            string = string + "." + this.micro;
        }
        return string;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMicro() {
        return this.micro;
    }

    public int getMinor() {
        return this.minor;
    }

    @Override
    public int compareTo(Version version) {
        int n = new Integer(this.major).compareTo(version.major);
        if (n != 0) {
            return n;
        }
        n = new Integer(this.minor).compareTo(version.minor);
        if (n != 0) {
            return n;
        }
        return new Integer(this.micro).compareTo(version.micro);
    }
}

