/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion.util;

import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.xml.namespace.QName;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.TokenItem;
import org.netbeans.modules.xml.schema.completion.spi.CompletionContext;
import org.netbeans.modules.xml.schema.completion.spi.CompletionModelProvider;
import org.netbeans.modules.xml.schema.completion.util.CompletionUtil;
import org.netbeans.modules.xml.schema.completion.util.DefaultModelProvider;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.dom.EmptyTag;
import org.netbeans.modules.xml.text.syntax.dom.EndTag;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.netbeans.modules.xml.text.syntax.dom.Tag;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionContextImpl
extends CompletionContext {
    private static final Logger logger = Logger.getLogger(CompletionContextImpl.class.getName());
    private int completionAtOffset = -1;
    private FileObject primaryFile;
    private String typedChars;
    private TokenItem token;
    private SyntaxElement element;
    private CompletionUtil.DocRoot docRoot;
    private char lastTypedChar;
    private CompletionContext.CompletionType completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
    private List<QName> pathFromRoot;
    private String schemaLocation;
    private String noNamespaceSchemaLocation;
    private String defaultNamespace;
    private BaseDocument document;
    private HashMap<String, CompletionModelProvider.CompletionModel> nsModelMap = new HashMap();
    private List<CompletionModelProvider.CompletionModel> noNSModels = new ArrayList<CompletionModelProvider.CompletionModel>();
    private HashMap<String, String> declaredNamespaces = new HashMap();
    private HashMap<String, String> suggestedNamespaces = new HashMap();
    private boolean fromNoNamespace = false;
    private CompletionModelProvider.CompletionModel noNamespaceModel;
    private transient List<String> existingAttributes;
    public static final String PREFIX = "ns";
    public static final String XSI_SCHEMALOCATION = "schemaLocation";
    public static final String XSI_NONS_SCHEMALOCATION = "noNamespaceSchemaLocation";

    public CompletionContextImpl(FileObject fileObject, XMLSyntaxSupport xMLSyntaxSupport, int n) {
        try {
            this.completionAtOffset = n;
            this.primaryFile = fileObject;
            this.document = xMLSyntaxSupport.getDocument();
            this.element = xMLSyntaxSupport.getElementChain(n);
            this.token = xMLSyntaxSupport.getPreviousToken(n);
            this.docRoot = CompletionUtil.getDocRoot((Document)this.document);
            this.lastTypedChar = xMLSyntaxSupport.lastTypedChar();
            this.populateNamespaces();
        }
        catch (Exception exception) {
            logger.log(Level.SEVERE, exception.getMessage());
        }
    }

    @Override
    public CompletionContext.CompletionType getCompletionType() {
        return this.completionType;
    }

    @Override
    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    @Override
    public List<QName> getPathFromRoot() {
        return this.pathFromRoot;
    }

    @Override
    public FileObject getPrimaryFile() {
        return this.primaryFile;
    }

    @Override
    public BaseDocument getBaseDocument() {
        return this.document;
    }

    @Override
    public HashMap<String, String> getDeclaredNamespaces() {
        return this.declaredNamespaces;
    }

    @Override
    public String getTypedChars() {
        return this.typedChars;
    }

    public boolean isSchemaAwareCompletion() {
        return this.schemaLocation != null || this.noNamespaceSchemaLocation != null;
    }

    public List<URI> getSchemas() {
        ArrayList<URI> arrayList = new ArrayList<URI>();
        if (this.schemaLocation != null) {
            CompletionUtil.loadSchemaURIs(this.schemaLocation, arrayList, false);
            return arrayList;
        }
        if (this.noNamespaceSchemaLocation != null) {
            CompletionUtil.loadSchemaURIs(this.noNamespaceSchemaLocation, arrayList, true);
            return arrayList;
        }
        return arrayList;
    }

    private void populateNamespaces() {
        if (this.docRoot == null) {
            return;
        }
        String string = this.docRoot.getName();
        String string2 = "xmlns";
        String string3 = CompletionUtil.getPrefixFromTag(string);
        if (string3 != null) {
            string2 = string2 + ":" + string3;
        }
        List<CompletionUtil.DocRootAttribute> list = this.docRoot.getAttributes();
        for (int i = 0; i < list.size(); ++i) {
            CompletionUtil.DocRootAttribute docRootAttribute = list.get(i);
            String string4 = docRootAttribute.getName();
            if (CompletionUtil.getLocalNameFromTag(string4).equals(XSI_SCHEMALOCATION)) {
                this.schemaLocation = docRootAttribute.getValue().trim();
                continue;
            }
            if (CompletionUtil.getLocalNameFromTag(string4).equals(XSI_NONS_SCHEMALOCATION)) {
                this.noNamespaceSchemaLocation = docRootAttribute.getValue().trim();
                continue;
            }
            if (!docRootAttribute.getName().startsWith("xmlns")) continue;
            if (docRootAttribute.getName().equals(string2)) {
                this.defaultNamespace = docRootAttribute.getValue();
            }
            this.declaredNamespaces.put(docRootAttribute.getName(), docRootAttribute.getValue());
        }
    }

    public boolean initContext() {
        try {
            this.fromNoNamespace = false;
            this.noNamespaceModel = null;
            int n = this.token.getTokenID().getNumericID();
            switch (n) {
                case 1: {
                    String string = this.token.getImage().trim();
                    if (string != null && string.equals("") && this.token.getPrevious().getImage().trim().equals("/>")) {
                        this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                        break;
                    }
                    if (string != null && string.equals("") && this.token.getPrevious().getImage().trim().equals(">")) {
                        this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_VALUE;
                        break;
                    }
                    if (string != null && !string.equals("<") && this.token.getPrevious().getImage().trim().equals(">")) {
                        this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                        break;
                    }
                    if (string != null && string.startsWith("<")) {
                        this.typedChars = string.substring(1);
                    }
                    this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT;
                    this.pathFromRoot = this.getPathFromRoot(this.element);
                    break;
                }
                case 4: {
                    if (this.element instanceof EndTag) {
                        this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                        break;
                    }
                    if (this.element instanceof EmptyTag) {
                        if (this.token != null && this.token.getImage().trim().equals("/>")) {
                            this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                            break;
                        }
                        EmptyTag emptyTag = (EmptyTag)this.element;
                        if (this.element.getElementOffset() + 1 == this.completionAtOffset) {
                            this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT;
                            this.pathFromRoot = this.getPathFromRoot(this.element.getPrevious());
                            break;
                        }
                        if (this.completionAtOffset > this.element.getElementOffset() + 1 && this.completionAtOffset <= this.element.getElementOffset() + 1 + emptyTag.getTagName().length()) {
                            this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT;
                            this.typedChars = emptyTag.getTagName();
                            this.pathFromRoot = this.getPathFromRoot(this.element.getPrevious());
                            break;
                        }
                        this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ATTRIBUTE;
                        this.pathFromRoot = this.getPathFromRoot(this.element);
                        break;
                    }
                    if (this.element instanceof StartTag) {
                        if (this.token != null && this.token.getImage().trim().equals(">")) {
                            this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                            break;
                        }
                        if (this.element.getElementOffset() + 1 == this.completionAtOffset) {
                            this.typedChars = null;
                        } else {
                            StartTag startTag = (StartTag)this.element;
                            this.typedChars = startTag.getTagName();
                        }
                    }
                    if (this.lastTypedChar == '>') {
                        this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_VALUE;
                        break;
                    }
                    this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ELEMENT;
                    this.pathFromRoot = this.getPathFromRoot(this.element.getPrevious());
                    break;
                }
                case 5: {
                    this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ATTRIBUTE;
                    this.typedChars = this.token.getImage();
                    this.pathFromRoot = this.getPathFromRoot(this.element);
                    break;
                }
                case 6: 
                case 7: 
                case 11: {
                    this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                    break;
                }
                case 2: {
                    TokenItem tokenItem;
                    this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                    for (tokenItem = this.token.getPrevious(); tokenItem != null && tokenItem.getTokenID().getNumericID() == 2; tokenItem = tokenItem.getPrevious()) {
                    }
                    if (tokenItem.getTokenID().getNumericID() == 7 || tokenItem.getTokenID().getNumericID() == 4) {
                        this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_ATTRIBUTE;
                        this.pathFromRoot = this.getPathFromRoot(this.element);
                    }
                    break;
                }
                default: {
                    this.completionType = CompletionContext.CompletionType.COMPLETION_TYPE_UNKNOWN;
                    break;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public List<CompletionUtil.DocRootAttribute> getDocRootAttributes() {
        return this.docRoot.getAttributes();
    }

    public CompletionUtil.DocRoot getDocRoot() {
        return this.docRoot;
    }

    private List<QName> getPathFromRoot(SyntaxElement syntaxElement) {
        if (syntaxElement == null) {
            return null;
        }
        Stack<Tag> stack = new Stack<Tag>();
        if (syntaxElement instanceof EmptyTag) {
            stack.push((Tag)syntaxElement);
        }
        while (syntaxElement != null) {
            if (syntaxElement instanceof EndTag || syntaxElement instanceof StartTag && stack.isEmpty()) {
                stack.push((Tag)syntaxElement);
                if (this.defaultNamespace == null && (syntaxElement instanceof StartTag || syntaxElement instanceof EmptyTag) && this.isRootInNoNSModels((Tag)syntaxElement)) break;
                syntaxElement = syntaxElement.getPrevious();
                continue;
            }
            if (syntaxElement instanceof StartTag) {
                EndTag endTag;
                StartTag startTag = (StartTag)syntaxElement;
                if (stack.peek() instanceof EndTag) {
                    endTag = (EndTag)stack.peek();
                    if (endTag.getTagName().equals(startTag.getTagName())) {
                        stack.pop();
                    }
                } else {
                    endTag = (SyntaxElement)stack.peek();
                    if (this.isRoot((Tag)endTag)) break;
                    stack.push((Tag)syntaxElement);
                }
            }
            syntaxElement = syntaxElement.getPrevious();
        }
        return this.createPath(stack);
    }

    private ArrayList<QName> createPath(Stack<Tag> stack) {
        ArrayList<QName> arrayList = new ArrayList<QName>();
        while (!stack.isEmpty()) {
            String string;
            Tag tag = stack.pop();
            String string2 = tag.getTagName();
            String string3 = CompletionUtil.getPrefixFromTag(string2);
            String string4 = CompletionUtil.getLocalNameFromTag(string2);
            if (this.fromNoNamespace) {
                arrayList.add(new QName(string4));
                continue;
            }
            QName qName = null;
            qName = string3 == null ? ((string = tag.getAttribute("xmlns")) == null ? new QName(this.defaultNamespace, string4) : new QName(string, string4)) : new QName(this.declaredNamespaces.get("xmlns:" + string3), string4, string3);
            arrayList.add(qName);
        }
        return arrayList;
    }

    private boolean isRoot(Tag tag) {
        String string = tag.getTagName();
        String string2 = tag.getAttribute("xmlns");
        if (this.defaultNamespace == null && this.isRootInNoNSModels(tag)) {
            return true;
        }
        String string3 = CompletionUtil.getPrefixFromTag(string);
        if (string3 == null) {
            CompletionModelProvider.CompletionModel completionModel;
            if (string2 != null && CompletionUtil.isRoot(string, completionModel = this.getCompletionModelMap().get(string2))) {
                return true;
            }
            completionModel = this.getCompletionModelMap().get(this.getDefaultNamespace());
            if (CompletionUtil.isRoot(string, completionModel)) {
                return true;
            }
            return this.isRootInNoNSModels(tag);
        }
        String string4 = this.getDeclaredNamespaces().get("xmlns:" + string3);
        CompletionModelProvider.CompletionModel completionModel = this.getCompletionModelMap().get(string4);
        return CompletionUtil.isRoot(string, completionModel);
    }

    private boolean isRootInNoNSModels(Tag tag) {
        for (CompletionModelProvider.CompletionModel completionModel : this.noNSModels) {
            if (!CompletionUtil.isRoot(tag.getTagName(), completionModel)) continue;
            this.fromNoNamespace = true;
            this.noNamespaceModel = completionModel;
            return true;
        }
        return false;
    }

    public CompletionModelProvider.CompletionModel getActiveNoNSModel() {
        return this.noNamespaceModel;
    }

    public HashMap<String, CompletionModelProvider.CompletionModel> getCompletionModelMap() {
        return this.nsModelMap;
    }

    public List<CompletionModelProvider.CompletionModel> getNoNamespaceModels() {
        return this.noNSModels;
    }

    public List<CompletionModelProvider.CompletionModel> getCompletionModels() {
        ArrayList<CompletionModelProvider.CompletionModel> arrayList = new ArrayList<CompletionModelProvider.CompletionModel>();
        arrayList.addAll(this.nsModelMap.values());
        arrayList.addAll(this.noNSModels);
        return arrayList;
    }

    public void addCompletionModel(CompletionModelProvider.CompletionModel completionModel) {
        String string = completionModel.getTargetNamespace();
        if (string == null && !this.noNSModels.contains(completionModel)) {
            this.noNSModels.add(completionModel);
            return;
        }
        if (this.nsModelMap.get(string) == null) {
            this.nsModelMap.put(string, completionModel);
        }
    }

    public boolean initModels() {
        Lookup.Template template = new Lookup.Template(CompletionModelProvider.class);
        Lookup.Result result = Lookup.getDefault().lookup(template);
        Collection collection = result.allInstances();
        if (collection == null || collection.size() == 0) {
            return false;
        }
        for (Object e : collection) {
            CompletionModelProvider completionModelProvider = (CompletionModelProvider)e;
            List<CompletionModelProvider.CompletionModel> list = completionModelProvider.getModels(this);
            if (list == null || list.size() == 0) continue;
            for (CompletionModelProvider.CompletionModel completionModel : list) {
                this.populateModelMap(completionModel);
            }
        }
        if (this.nsModelMap.size() == 0 && this.noNSModels.size() == 0) {
            this.specialCompletion();
        }
        return this.nsModelMap.size() != 0 || this.noNSModels.size() != 0;
    }

    private void populateModelMap(CompletionModelProvider.CompletionModel completionModel) {
        String string = completionModel.getSchemaModel().getSchema().getTargetNamespace();
        if (string == null) {
            this.noNSModels.add(completionModel);
            return;
        }
        this.nsModelMap.put(string, completionModel);
    }

    private void specialCompletion() {
        String[] stringArray;
        if (this.primaryFile == null) {
            return;
        }
        File file = FileUtil.toFile((FileObject)this.primaryFile);
        if (file == null || !file.isFile()) {
            return;
        }
        for (String string : stringArray = CompletionUtil.getDeclaredNamespaces(file)) {
            try {
                DefaultModelProvider defaultModelProvider = new DefaultModelProvider(this);
                CompletionModelProvider.CompletionModel completionModel = defaultModelProvider.getCompletionModel(new URI(string), false);
                this.populateModelMap(completionModel);
            }
            catch (Exception exception) {
                logger.log(Level.WARNING, exception.getMessage());
            }
        }
    }

    String suggestPrefix(String string) {
        String string2;
        String string32;
        if (string == null) {
            return null;
        }
        for (String string32 : this.getDeclaredNamespaces().keySet()) {
            string2 = this.getDeclaredNamespaces().get(string32);
            if (!string2.equals(string)) continue;
            return string32;
        }
        for (String string32 : this.suggestedNamespaces.keySet()) {
            string2 = this.suggestedNamespaces.get(string32);
            if (!string2.equals(string)) continue;
            return string32;
        }
        int n = this.suggestedNamespaces.size() + 1;
        string32 = PREFIX + n;
        string2 = "xmlns:" + string32;
        while (this.getDeclaredNamespaces().get(string2) != null) {
            string32 = PREFIX + n++;
            string2 = "xmlns:" + string32;
        }
        this.suggestedNamespaces.put(string32, string);
        return string32;
    }

    public boolean isPrefixBeingUsed(String string) {
        return this.getDeclaredNamespaces().get("xmlns:" + string) != null;
    }

    public String getTargetNamespaceByPrefix(String string) {
        for (CompletionModelProvider.CompletionModel completionModel : this.getCompletionModelMap().values()) {
            if (!string.equals(completionModel.getSuggestedPrefix())) continue;
            return completionModel.getTargetNamespace();
        }
        return null;
    }

    private boolean fromSameNamespace(StartTag startTag, StartTag startTag2) {
        String string = CompletionUtil.getPrefixFromTag(startTag2.getTagName());
        String string2 = CompletionUtil.getPrefixFromTag(startTag.getTagName());
        String string3 = string2 == null ? this.declaredNamespaces.get("xmlns") : this.declaredNamespaces.get("xmlns:" + string2);
        String string4 = string == null ? this.declaredNamespaces.get("xmlns") : this.declaredNamespaces.get("xmlns:" + string);
        return string3 == null && string4 == null || string3 != null && string3.equals(string4) || string4 != null && string4.equals(string3);
    }

    List<String> getExistingAttributes() {
        if (this.existingAttributes != null) {
            return this.existingAttributes;
        }
        this.existingAttributes = new ArrayList<String>();
        for (TokenItem tokenItem = this.token.getPrevious(); tokenItem != null && tokenItem.getTokenID().getNumericID() != 4; tokenItem = tokenItem.getPrevious()) {
            if (tokenItem.getTokenID().getNumericID() != 5) continue;
            this.existingAttributes.add(tokenItem.getImage());
        }
        return this.existingAttributes;
    }
}

