/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.schema.completion.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.Document;
import javax.xml.namespace.QName;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.xml.axi.AXIComponent;
import org.netbeans.modules.xml.axi.AXIDocument;
import org.netbeans.modules.xml.axi.AXIModel;
import org.netbeans.modules.xml.axi.AXIModelFactory;
import org.netbeans.modules.xml.axi.AbstractAttribute;
import org.netbeans.modules.xml.axi.AbstractElement;
import org.netbeans.modules.xml.axi.AnyAttribute;
import org.netbeans.modules.xml.axi.AnyElement;
import org.netbeans.modules.xml.axi.Attribute;
import org.netbeans.modules.xml.axi.Element;
import org.netbeans.modules.xml.schema.completion.AttributeResultItem;
import org.netbeans.modules.xml.schema.completion.CompletionResultItem;
import org.netbeans.modules.xml.schema.completion.ElementResultItem;
import org.netbeans.modules.xml.schema.completion.spi.CompletionContext;
import org.netbeans.modules.xml.schema.completion.spi.CompletionModelProvider;
import org.netbeans.modules.xml.schema.completion.util.CompletionContextImpl;
import org.netbeans.modules.xml.schema.completion.util.CompletionModelEx;
import org.netbeans.modules.xml.schema.model.Form;
import org.netbeans.modules.xml.text.syntax.SyntaxElement;
import org.netbeans.modules.xml.text.syntax.dom.StartTag;
import org.openide.xml.XMLUtil;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionUtil {
    private static final Logger logger = Logger.getLogger(CompletionUtil.class.getName());

    private CompletionUtil() {
    }

    public static StartTag getRoot(SyntaxElement syntaxElement) {
        StartTag startTag = null;
        while (syntaxElement != null) {
            if (syntaxElement instanceof StartTag) {
                startTag = (StartTag)syntaxElement;
            }
            syntaxElement = syntaxElement.getPrevious();
        }
        return startTag;
    }

    public static void printPath(List<QName> list) {
        StringBuffer stringBuffer = new StringBuffer();
        for (QName qName : list) {
            if (stringBuffer.toString().equals("")) {
                stringBuffer.append(qName);
                continue;
            }
            stringBuffer.append("/" + qName);
        }
    }

    public static boolean isRoot(String string, CompletionModelProvider.CompletionModel completionModel) {
        if (completionModel == null) {
            return false;
        }
        AXIModel aXIModel = AXIModelFactory.getDefault().getModel(completionModel.getSchemaModel());
        for (AbstractElement abstractElement : aXIModel.getRoot().getChildElements()) {
            if (!string.endsWith(abstractElement.getName())) continue;
            return true;
        }
        return false;
    }

    public static String getPrefixFromTag(String string) {
        if (string == null) {
            return null;
        }
        return string.indexOf(":") == -1 ? null : string.substring(0, string.indexOf(":"));
    }

    public static String getLocalNameFromTag(String string) {
        if (string == null) {
            return null;
        }
        return string.indexOf(":") == -1 ? string : string.substring(string.indexOf(":") + 1, string.length());
    }

    public static String getPrefixFromNamespaceDeclaration(String string) {
        if (string == null) {
            return null;
        }
        return string.indexOf(":") == -1 ? null : string.substring(string.indexOf(":") + 1);
    }

    public static List<String> getPrefixesAgainstTargetNamespace(CompletionContextImpl completionContextImpl, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<DocRootAttribute> list = completionContextImpl.getDocRootAttributes();
        for (int i = 0; i < list.size(); ++i) {
            DocRootAttribute docRootAttribute = list.get(i);
            if (!docRootAttribute.getName().startsWith("xmlns") || !docRootAttribute.getValue().equals(string)) continue;
            String string2 = CompletionUtil.getPrefixFromNamespaceDeclaration(docRootAttribute.getName());
            arrayList.add(string2);
        }
        return arrayList;
    }

    public static void loadSchemaURIs(String string, List<URI> list, boolean bl) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.replaceAll("\n", " "), " ");
        while (stringTokenizer.hasMoreTokens()) {
            URI uRI = null;
            try {
                String string2;
                String string3 = stringTokenizer.nextToken().trim();
                if (bl) {
                    uRI = URI.create(string3);
                    if (uRI == null) continue;
                    list.add(uRI);
                    continue;
                }
                if (!stringTokenizer.hasMoreTokens() || (uRI = URI.create(string2 = stringTokenizer.nextToken().trim())) == null) continue;
                list.add(uRI);
            }
            catch (Exception exception) {}
        }
    }

    public static List<CompletionResultItem> getAttributes(CompletionContextImpl completionContextImpl) {
        Element element = CompletionUtil.findAXIElementAtContext(completionContextImpl);
        if (element == null) {
            return null;
        }
        ArrayList<CompletionResultItem> arrayList = new ArrayList<CompletionResultItem>();
        for (AbstractAttribute abstractAttribute : element.getAttributes()) {
            AXIComponent aXIComponent = abstractAttribute.getOriginal();
            if (aXIComponent.getTargetNamespace() == null) {
                CompletionResultItem completionResultItem = CompletionUtil.createResultItem(aXIComponent, null, completionContextImpl);
                if (completionResultItem == null) continue;
                arrayList.add(completionResultItem);
                continue;
            }
            if (aXIComponent instanceof AnyAttribute) {
                arrayList.addAll(CompletionUtil.substituteAny((AXIComponent)((AnyAttribute)aXIComponent), completionContextImpl));
                continue;
            }
            CompletionUtil.addNSAwareCompletionItems(aXIComponent, completionContextImpl, null, arrayList);
        }
        return arrayList;
    }

    public static List<CompletionResultItem> getElements(CompletionContextImpl completionContextImpl) {
        Element element = CompletionUtil.findAXIElementAtContext(completionContextImpl);
        if (element == null) {
            return null;
        }
        ArrayList<CompletionResultItem> arrayList = new ArrayList<CompletionResultItem>();
        for (AbstractElement abstractElement : element.getChildElements()) {
            AXIComponent aXIComponent = abstractElement.getOriginal();
            if (aXIComponent.getTargetNamespace() == null) {
                CompletionResultItem completionResultItem = CompletionUtil.createResultItem(aXIComponent, null, completionContextImpl);
                if (completionResultItem == null) continue;
                arrayList.add(completionResultItem);
                continue;
            }
            if (aXIComponent instanceof AnyElement) {
                arrayList.addAll(CompletionUtil.substituteAny((AXIComponent)((AnyElement)aXIComponent), completionContextImpl));
                continue;
            }
            CompletionUtil.addNSAwareCompletionItems(aXIComponent, completionContextImpl, null, arrayList);
        }
        return arrayList;
    }

    public static List<CompletionResultItem> getElementValues(CompletionContextImpl completionContextImpl) {
        return null;
    }

    private static void addNSAwareCompletionItems(AXIComponent aXIComponent, CompletionContextImpl completionContextImpl, CompletionModelProvider.CompletionModel completionModel, List<CompletionResultItem> list) {
        String string = completionContextImpl.getTypedChars();
        CompletionResultItem completionResultItem = null;
        if (!CompletionUtil.isFormQualified(aXIComponent)) {
            completionResultItem = CompletionUtil.createResultItem(aXIComponent, null, completionContextImpl);
            if (completionResultItem == null) {
                return;
            }
            if (string == null) {
                list.add(completionResultItem);
            } else if (completionResultItem.getReplacementText().startsWith(string)) {
                list.add(completionResultItem);
            }
            return;
        }
        List<String> list2 = CompletionUtil.getPrefixes(completionContextImpl, aXIComponent, completionModel);
        if (list2.size() == 0) {
            list2.add(null);
        }
        for (String string2 : list2) {
            completionResultItem = CompletionUtil.createResultItem(aXIComponent, string2, completionContextImpl);
            if (completionResultItem == null) continue;
            if (string == null) {
                list.add(completionResultItem);
                continue;
            }
            if (!completionResultItem.getReplacementText().startsWith(string)) continue;
            list.add(completionResultItem);
        }
    }

    private static CompletionResultItem createResultItem(AXIComponent aXIComponent, String string, CompletionContextImpl completionContextImpl) {
        CompletionResultItem completionResultItem = null;
        if (aXIComponent instanceof AbstractElement) {
            completionResultItem = string == null ? new ElementResultItem((AbstractElement)aXIComponent, (CompletionContext)completionContextImpl) : new ElementResultItem((AbstractElement)aXIComponent, string, completionContextImpl);
        }
        if (aXIComponent instanceof AbstractAttribute) {
            Attribute attribute = (Attribute)aXIComponent;
            if (string == null) {
                if (!completionContextImpl.getExistingAttributes().contains(attribute.getName())) {
                    completionResultItem = new AttributeResultItem((AbstractAttribute)aXIComponent, (CompletionContext)completionContextImpl);
                }
            } else if (!completionContextImpl.getExistingAttributes().contains(string + ":" + attribute.getName())) {
                completionResultItem = new AttributeResultItem((AbstractAttribute)aXIComponent, string, completionContextImpl);
            }
        }
        return completionResultItem;
    }

    private static List<String> getPrefixes(CompletionContextImpl completionContextImpl, AXIComponent aXIComponent, CompletionModelProvider.CompletionModel completionModel) {
        List<Object> list = new ArrayList();
        if (completionModel == null) {
            if (!completionContextImpl.getDefaultNamespace().equals(aXIComponent.getTargetNamespace())) {
                list = CompletionUtil.getPrefixesAgainstTargetNamespace(completionContextImpl, aXIComponent.getTargetNamespace());
                if (list.size() != 0) {
                    return list;
                }
                String string = completionContextImpl.suggestPrefix("ns1");
                CompletionModelEx completionModelEx = new CompletionModelEx(completionContextImpl, string, aXIComponent.getModel().getSchemaModel());
                completionContextImpl.addCompletionModel(completionModelEx);
                list.add(string);
                return list;
            }
            return CompletionUtil.getPrefixesAgainstTargetNamespace(completionContextImpl, aXIComponent.getTargetNamespace());
        }
        list = CompletionUtil.getPrefixesAgainstTargetNamespace(completionContextImpl, completionModel.getTargetNamespace());
        if (list.size() == 0) {
            list.add(completionModel.getSuggestedPrefix());
        }
        return list;
    }

    private static boolean isFormQualified(AXIComponent aXIComponent) {
        if (aXIComponent instanceof Attribute) {
            AXIComponent aXIComponent2 = aXIComponent.getOriginal();
            if (((Attribute)aXIComponent2).isReference() || aXIComponent2.getParent() instanceof AXIDocument) {
                return true;
            }
            Attribute attribute = (Attribute)aXIComponent;
            return attribute.getForm() == Form.QUALIFIED;
        }
        if (aXIComponent instanceof Element) {
            AXIComponent aXIComponent3 = aXIComponent.getOriginal();
            if (((Element)aXIComponent3).isReference() || aXIComponent3.getParent() instanceof AXIDocument) {
                return true;
            }
            Element element = (Element)aXIComponent;
            return element.getForm() == Form.QUALIFIED;
        }
        return false;
    }

    private static Element findAXIElementAtContext(CompletionContextImpl completionContextImpl) {
        List<QName> list = completionContextImpl.getPathFromRoot();
        if (list == null || list.size() == 0) {
            return null;
        }
        CompletionModelProvider.CompletionModel completionModel = null;
        QName qName = completionContextImpl.getPathFromRoot().get(0);
        String string = qName.getNamespaceURI();
        completionModel = string != null && string.equals("") ? completionContextImpl.getActiveNoNSModel() : completionContextImpl.getCompletionModelMap().get(string);
        if (completionModel == null) {
            return null;
        }
        AXIModel aXIModel = AXIModelFactory.getDefault().getModel(completionModel.getSchemaModel());
        AXIDocument aXIDocument = aXIModel.getRoot();
        if (aXIDocument == null) {
            return null;
        }
        AXIComponent aXIComponent = null;
        for (QName qName2 : list) {
            aXIComponent = CompletionUtil.findChildElement((AXIComponent)aXIDocument, qName2);
            aXIDocument = aXIComponent;
        }
        if (aXIComponent != null && aXIComponent instanceof Element) {
            return (Element)aXIComponent;
        }
        return null;
    }

    private static AXIComponent findChildElement(AXIComponent aXIComponent, QName qName) {
        if (aXIComponent == null) {
            return null;
        }
        for (AbstractElement abstractElement : aXIComponent.getChildElements()) {
            if (!(abstractElement instanceof Element)) continue;
            Element element = (Element)abstractElement;
            if (!qName.getLocalPart().equals(element.getName())) continue;
            return abstractElement;
        }
        return null;
    }

    private static List<CompletionResultItem> substituteAny(AXIComponent aXIComponent, CompletionContextImpl completionContextImpl) {
        ArrayList<CompletionResultItem> arrayList = new ArrayList<CompletionResultItem>();
        String string = aXIComponent.getTargetNamespace();
        String string2 = aXIComponent.getModel().getRoot().getTargetNamespace();
        for (CompletionModelProvider.CompletionModel completionModel : completionContextImpl.getCompletionModels()) {
            if (string.equals("##other") && string2 != null && !string2.equals(completionModel.getTargetNamespace())) {
                CompletionUtil.populateItemsForAny(completionModel, aXIComponent, completionContextImpl, arrayList);
            }
            if (string.equals("##targetNamespace") && string2 != null && string2.equals(completionModel.getTargetNamespace())) {
                CompletionUtil.populateItemsForAny(completionModel, aXIComponent, completionContextImpl, arrayList);
            }
            if (string.equals("##local") && completionModel.getTargetNamespace() == null) {
                CompletionUtil.populateItemsForAny(completionModel, aXIComponent, completionContextImpl, arrayList);
            }
            if (!string.startsWith("##") && completionModel.getTargetNamespace() != null && string.indexOf(completionModel.getTargetNamespace()) != -1) {
                CompletionUtil.populateItemsForAny(completionModel, aXIComponent, completionContextImpl, arrayList);
            }
            if (!string.equals("##any")) continue;
            CompletionUtil.populateItemsForAny(completionModel, aXIComponent, completionContextImpl, arrayList);
        }
        return arrayList;
    }

    private static void populateItemsForAny(CompletionModelProvider.CompletionModel completionModel, AXIComponent aXIComponent, CompletionContextImpl completionContextImpl, List<CompletionResultItem> list) {
        AXIModel aXIModel = AXIModelFactory.getDefault().getModel(completionModel.getSchemaModel());
        if (aXIComponent instanceof AnyElement) {
            for (Element element : aXIModel.getRoot().getElements()) {
                CompletionUtil.addNSAwareCompletionItems((AXIComponent)element, completionContextImpl, completionModel, list);
            }
        }
        if (aXIComponent instanceof AnyAttribute) {
            for (Element element : aXIModel.getRoot().getAttributes()) {
                CompletionUtil.addNSAwareCompletionItems((AXIComponent)element, completionContextImpl, completionModel, list);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] getDeclaredNamespaces(File file) {
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(file);
            InputSource inputSource = new InputSource(fileReader);
            NsHandler nsHandler = CompletionUtil.getNamespaces(inputSource);
            String[] stringArray = nsHandler.getNamespaces();
            return stringArray;
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.log(Level.INFO, fileNotFoundException.getMessage());
        }
        finally {
            try {
                if (fileReader != null) {
                    fileReader.close();
                }
            }
            catch (Exception exception) {
                logger.log(Level.INFO, exception.getMessage());
            }
        }
        return null;
    }

    private static NsHandler getNamespaces(InputSource inputSource) {
        NsHandler nsHandler = new NsHandler();
        try {
            XMLReader xMLReader = XMLUtil.createXMLReader((boolean)false, (boolean)true);
            xMLReader.setContentHandler(nsHandler);
            xMLReader.parse(inputSource);
        }
        catch (Exception exception) {
            logger.log(Level.INFO, exception.getMessage());
        }
        return nsHandler;
    }

    public static boolean isDTDBasedDocument(Document document) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            if (token.id() != XMLTokenId.DECLARATION) continue;
            return true;
        }
        return false;
    }

    public static int getNamespaceInsertionOffset(Document document) {
        int n = 0;
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        while (tokenSequence.moveNext()) {
            Token token = tokenSequence.token();
            if (token.id() != XMLTokenId.TAG || !((Object)token.text()).toString().equals(">")) continue;
            n = token.offset(tokenHierarchy);
        }
        return n;
    }

    public static DocRoot getDocRoot(Document document) {
        TokenHierarchy tokenHierarchy = TokenHierarchy.get((Document)document);
        TokenSequence tokenSequence = tokenHierarchy.tokenSequence();
        ArrayList<DocRootAttribute> arrayList = new ArrayList<DocRootAttribute>();
        String string = null;
        while (tokenSequence.moveNext()) {
            Token token;
            Token token2 = tokenSequence.token();
            if (token2.id() != XMLTokenId.TAG) continue;
            String string2 = ((Object)token2.text()).toString();
            if (string == null && string2.startsWith("<")) {
                string = string2.substring(1, string2.length());
            }
            String string3 = null;
            while (tokenSequence.moveNext() && ((token = tokenSequence.token()).id() != XMLTokenId.TAG || !((Object)token.text()).toString().equals(">"))) {
                if (token.id() == XMLTokenId.ARGUMENT) {
                    string3 = ((Object)token.text()).toString();
                }
                if (token.id() != XMLTokenId.VALUE || string3 == null) continue;
                String string4 = ((Object)token.text()).toString();
                if (string4.startsWith("'") || string4.startsWith("\"")) {
                    string4 = string4.substring(1, string4.length() - 1);
                }
                arrayList.add(new DocRootAttribute(string3, string4));
                string3 = null;
            }
        }
        return new DocRoot(string, arrayList);
    }

    public static class DocRootAttribute {
        private String name;
        private String value;

        DocRootAttribute(String string, String string2) {
            this.name = string;
            this.value = string2;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.name + "=" + this.value;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DocRoot {
        private String name;
        private List<DocRootAttribute> attributes;

        DocRoot(String string, List<DocRootAttribute> list) {
            this.name = string;
            this.attributes = new ArrayList<DocRootAttribute>(list);
        }

        public String getName() {
            return this.name;
        }

        public List<DocRootAttribute> getAttributes() {
            return this.attributes;
        }
    }

    private static class NsHandler
    extends DefaultHandler {
        Set<String> namespaces = new HashSet<String>();
        private Map<String, String> mapping = new HashMap<String, String>();

        NsHandler() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            if (attributes.getLength() > 0) {
                String string4 = attributes.getValue("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
                if (string4 == null) {
                    return;
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string4);
                if (stringTokenizer.countTokens() % 2 == 0) {
                    while (stringTokenizer.hasMoreElements()) {
                        String string5 = stringTokenizer.nextToken();
                        String string6 = stringTokenizer.nextToken();
                        this.mapping.put(string5, string6);
                    }
                }
            }
        }

        public void startPrefixMapping(String string, String string2) throws SAXException {
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(string2)) {
                return;
            }
            this.namespaces.add(string2);
        }

        String[] getNamespaces() {
            String[] stringArray = new String[this.namespaces.size()];
            this.namespaces.toArray(stringArray);
            return stringArray;
        }
    }
}

