/*
 * Decompiled with CFR 0.152.
 */
package prefuse.render;

import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import prefuse.render.AbstractShapeRenderer;
import prefuse.util.ColorLib;
import prefuse.util.GraphicsLib;
import prefuse.visual.VisualItem;

public class AxisRenderer
extends AbstractShapeRenderer {
    private Line2D m_line = new Line2D.Double();
    private Rectangle2D m_box = new Rectangle2D.Double();
    private int m_xalign;
    private int m_yalign;
    private int m_ascent;

    public AxisRenderer() {
        this(0, 3);
    }

    public AxisRenderer(int xalign, int yalign) {
        this.m_xalign = xalign;
        this.m_yalign = yalign;
    }

    protected Shape getRawShape(VisualItem item) {
        double ty;
        double tx;
        double x1 = item.getDouble(VisualItem.X);
        double y1 = item.getDouble(VisualItem.Y);
        double x2 = item.getDouble(VisualItem.X2);
        double y2 = item.getDouble(VisualItem.Y2);
        this.m_line.setLine(x1, y1, x2, y2);
        if (!item.canGetString(VisualItem.LABEL)) {
            return this.m_line;
        }
        String label = item.getString(VisualItem.LABEL);
        if (label == null) {
            return this.m_line;
        }
        FontMetrics fm = DEFAULT_GRAPHICS.getFontMetrics(item.getFont());
        this.m_ascent = fm.getAscent();
        int h = fm.getHeight();
        int w = fm.stringWidth(label);
        switch (this.m_xalign) {
            case 2: {
                tx = x1 + (x2 - x1) / 2.0 - (double)(w / 2);
                break;
            }
            case 1: {
                tx = x2 - (double)w;
                break;
            }
            default: {
                tx = x1;
            }
        }
        switch (this.m_yalign) {
            case 2: {
                ty = y1 + (y2 - y1) / 2.0 - (double)h;
                break;
            }
            case 4: {
                ty = y1 - (double)h;
                break;
            }
            default: {
                ty = y2;
            }
        }
        this.m_box.setFrame(tx, ty, w, h);
        return this.m_box;
    }

    public void render(Graphics2D g, VisualItem item) {
        Shape s = this.getShape(item);
        GraphicsLib.paint(g, item, this.m_line, this.getStroke(item), this.getRenderType(item));
        if (s == this.m_box) {
            float x = (float)this.m_box.getMinX();
            float y = (float)this.m_box.getMinY() + (float)this.m_ascent;
            String str = item.getString(VisualItem.LABEL);
            g.setFont(item.getFont());
            g.setColor(ColorLib.getColor(item.getTextColor()));
            g.drawString(str, x, y);
        }
    }

    public boolean locatePoint(Point2D p, VisualItem item) {
        Shape s = this.getShape(item);
        if (s == null) {
            return false;
        }
        if (s == this.m_box && this.m_box.contains(p)) {
            return true;
        }
        double width = Math.max(2.0, item.getSize());
        double halfWidth = width / 2.0;
        return s.intersects(p.getX() - halfWidth, p.getY() - halfWidth, width, width);
    }

    public void setBounds(VisualItem item) {
        if (!this.m_manageBounds) {
            return;
        }
        Shape shape = this.getShape(item);
        if (shape == null) {
            item.setBounds(item.getX(), item.getY(), 0.0, 0.0);
        } else if (shape == this.m_line) {
            GraphicsLib.setBounds(item, shape, this.getStroke(item));
        } else {
            this.m_box.add(this.m_line.getX1(), this.m_line.getY1());
            this.m_box.add(this.m_line.getX2(), this.m_line.getY2());
            item.setBounds(this.m_box.getMinX(), this.m_box.getMinY(), this.m_box.getWidth(), this.m_box.getHeight());
        }
    }
}

