/*
 * Decompiled with CFR 0.152.
 */
package prefuse.util.display;

import java.util.Arrays;
import prefuse.util.ArrayLib;
import prefuse.visual.VisualItem;
import prefuse.visual.sort.ItemSorter;

public class RenderingQueue {
    private static final int DEFAULT_SIZE = 256;
    public ItemSorter sort = new ItemSorter();
    public VisualItem[] ritems = new VisualItem[256];
    public int[] rscores = new int[256];
    public int rsize = 0;
    public VisualItem[] pitems = new VisualItem[256];
    public int[] pscores = new int[256];
    public int psize = 0;
    public boolean psorted = false;
    static transient VisualItem[] items_buf;
    static transient int[] scores_buf;

    public void clear() {
        Arrays.fill(this.ritems, 0, this.rsize, null);
        Arrays.fill(this.pitems, 0, this.psize, null);
        this.rsize = 0;
        this.psize = 0;
    }

    public void addToRenderQueue(VisualItem item) {
        if (this.ritems.length == this.rsize) {
            int capacity = 3 * this.ritems.length / 2 + 1;
            VisualItem[] q = new VisualItem[capacity];
            int[] s = new int[capacity];
            System.arraycopy(this.ritems, 0, q, 0, this.rsize);
            System.arraycopy(this.rscores, 0, s, 0, this.rsize);
            this.ritems = q;
            this.rscores = s;
        }
        this.ritems[this.rsize] = item;
        this.rscores[this.rsize++] = this.sort != null ? this.sort.score(item) : 0;
    }

    public void addToPickingQueue(VisualItem item) {
        if (this.pitems.length == this.psize) {
            int capacity = 3 * this.pitems.length / 2 + 1;
            VisualItem[] q = new VisualItem[capacity];
            int[] s = new int[capacity];
            System.arraycopy(this.pitems, 0, q, 0, this.psize);
            System.arraycopy(this.pscores, 0, s, 0, this.psize);
            this.pitems = q;
            this.pscores = s;
        }
        this.pitems[this.psize] = item;
        this.pscores[this.psize++] = this.sort != null ? this.sort.score(item) : 0;
        this.psorted = false;
    }

    public void sortRenderQueue() {
        this.sort(this.ritems, this.rscores, this.rsize);
    }

    public void sortPickingQueue() {
        this.sort(this.pitems, this.pscores, this.psize);
        this.psorted = true;
    }

    private void sort(VisualItem[] items, int[] scores, int size) {
        if (this.sort == null) {
            return;
        }
        if (items_buf == null || items_buf.length < size) {
            items_buf = new VisualItem[items.length];
            scores_buf = new int[scores.length];
        }
        ArrayLib.sort(scores, items, scores_buf, items_buf, 0, size);
    }
}

