/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.errorhandler;

import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.visualweb.errorhandler.DebugProtocol;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.windows.WindowManager;

public class ClientSocketConnectionThread
extends Thread {
    BufferedReader in = null;
    PrintWriter out = null;
    StringBuffer message = new StringBuffer();
    boolean connected = true;
    Socket clientSocket = null;
    String threadName = null;
    DebugProtocol debugProtocol = new DebugProtocol();
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    public ClientSocketConnectionThread(ThreadGroup threadGroup, String string, Socket socket) {
        super(threadGroup, string);
        this.threadName = string;
        this.clientSocket = socket;
    }

    public void run() {
        String string = null;
        try {
            this.in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            this.out = new PrintWriter(this.clientSocket.getOutputStream(), true);
        }
        catch (IOException iOException) {
            this.displayText("Could not get client socket I/O : " + iOException.getLocalizedMessage());
        }
        while (this.connected) {
            try {
                string = this.in.readLine();
                if (string != null) {
                    this.processText(string, true);
                    this.message.append(string + "\n");
                    continue;
                }
                this.connected = false;
                this.disconnect();
            }
            catch (IOException iOException) {
                this.displayText(iOException.getLocalizedMessage() + " - " + this.threadName);
                this.connected = false;
                this.disconnect();
            }
        }
    }

    public void disconnect() {
        if (this.connected) {
            try {
                this.out.close();
                this.in.close();
                this.clientSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.out = null;
            this.in = null;
            this.clientSocket = null;
            this.connected = false;
        }
    }

    public void sendMessage(String string) {
        if (this.out != null) {
            this.out.println(string);
        }
    }

    public String getMessage() {
        return this.message.toString();
    }

    private void displayText(String string) {
        this.processText(string, false);
    }

    private void processText(String string, boolean bl) {
        if (bl) {
            String string2 = this.debugProtocol.processInput(string);
            if (this.debugProtocol.getState() == 3) {
                this.disconnect();
                this.debugProtocol.setState(0);
            }
            if (this.debugProtocol.getState() == 4) {
                this.disconnect();
                this.showErrorLine(this.debugProtocol.getErrorInfo());
                this.debugProtocol.setState(0);
            }
        }
    }

    private void showErrorLine(DebugProtocol.ErrorInfo errorInfo) {
        String string = errorInfo.getFilePath();
        int n = errorInfo.getLineNumber();
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        Project project = null;
        String string2 = "src/" + string;
        FileObject fileObject = null;
        for (int i = 0; fileObject == null && projectArray != null && i < projectArray.length; ++i) {
            Project project2 = projectArray[i];
            try {
                FileObject fileObject2 = project2.getProjectDirectory().getFileObject(string2);
                if (fileObject2 == null) continue;
                fileObject = fileObject2;
                project = project2;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (project == null) {
            return;
        }
        try {
            DataObject dataObject = DataObject.find(fileObject);
            new ErrorLineMarker().markError(dataObject, n);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            ErrorManager.getDefault().notify(16, (Throwable)dataObjectNotFoundException);
        }
    }

    private static final class ErrorLineMarker
    extends Annotation
    implements PropertyChangeListener {
        private ErrorLineMarker() {
        }

        public void markError(DataObject dataObject, int n) {
            try {
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = ClientSocketConnectionThread.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                if (editorCookie != null) {
                    if (n == -1) {
                        editorCookie.open();
                    } else {
                        editorCookie.openDocument();
                        final Line line = editorCookie.getLineSet().getOriginal(n - 1);
                        if (!line.isDeleted()) {
                            SwingUtilities.invokeLater(new Runnable(){

                                public void run() {
                                    ErrorLineMarker.this.attachAsNeeded(line);
                                    line.show(2);
                                    WindowManager.getDefault().getMainWindow().toFront();
                                }
                            });
                        }
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify(16, (Throwable)dataObjectNotFoundException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                ErrorManager.getDefault().notify(16, (Throwable)indexOutOfBoundsException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(16, (Throwable)iOException);
            }
        }

        private synchronized void attachAsNeeded(Line line) {
            if (this.getAttachedAnnotatable() == null) {
                Line line2 = line;
                this.attach((Annotatable)line2);
                line2.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private synchronized void doDetach() {
            Annotatable annotatable = this.getAttachedAnnotatable();
            if (annotatable != null) {
                annotatable.removePropertyChangeListener((PropertyChangeListener)this);
                this.detach();
            }
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || string.equals("text") || string.equals("deleted")) {
                this.doDetach();
            }
        }

        public String getAnnotationType() {
            return "com-sun-rave-errorhandler-error";
        }

        public String getShortDescription() {
            return "Error Handler Marker";
        }
    }
}

