/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.errorhandler;

import java.util.StringTokenizer;

public class DebugProtocol {
    public static final int STATE_WAITING = 0;
    public static final int STATE_DEBUG_REQUEST = 1;
    public static final int STATE_CLIENT_RCOGNIZED = 2;
    public static final int STATE_CLIENT_UNRCOGNIZED = 3;
    public static final int STATE_DONE = 4;
    public static String DEBUG_CLIENT_ID = "DEBUG_CLIENT_ID";
    public static String DEBUG_CLIENT_NAME = "Creator Debug Client";
    public static String DEBUG_REQUEST_START = "DEBUG_REQUEST_START";
    public static String DEBUG_REQUEST_END = "DEBUG_REQUEST_END";
    public static String DEBUG_CLASS_NAME = "ClassName";
    public static String DEBUG_FILE_NAME = "FileName";
    public static String DEBUG_METHOD_NAME = "MethodName";
    public static String DEBUG_LINE_NUMBER = "LineNumber";
    public static String DEBUG_DELIMITER = ":";
    private int state = 0;
    ErrorInfo errorInfo = null;
    StringTokenizer tokenizer;

    public String processInput(String string) {
        String string2 = null;
        if (this.state == 0) {
            this.tokenizer = new StringTokenizer(string, DEBUG_DELIMITER);
            String string3 = this.tokenizer.nextToken();
            if (string3.startsWith(DEBUG_CLIENT_ID)) {
                String string4 = this.tokenizer.nextToken();
                if (string4.equals(DEBUG_CLIENT_NAME)) {
                    string2 = "Client recognized";
                    this.state = 2;
                    return string2;
                }
                string2 = "Client unrecognized continuing ..";
                this.state = 3;
                return string2;
            }
            string2 = "Client unrecognized disconnecting ..";
            this.state = 3;
        } else if (this.state == 2) {
            if (string.startsWith(DEBUG_REQUEST_START)) {
                string2 = "Debug Request Received";
                this.state = 1;
                this.errorInfo = new ErrorInfo();
                return string2;
            }
        } else if (this.state == 1) {
            if (string.startsWith(DEBUG_REQUEST_END)) {
                string2 = "Debug Request Completed";
                this.processRequest();
                this.state = 4;
                return string2;
            }
            this.tokenizer = new StringTokenizer(string, DEBUG_DELIMITER);
            String string5 = this.tokenizer.nextToken();
            if (string5.startsWith(DEBUG_CLASS_NAME)) {
                String string6 = this.tokenizer.nextToken();
                string2 = "Class Name - " + string6;
                this.errorInfo.setClassName(string6);
                return string2;
            }
            if (string5.startsWith(DEBUG_FILE_NAME)) {
                String string7 = this.tokenizer.nextToken();
                string2 = "File Name - " + string7;
                this.errorInfo.setFileName(string7);
                return string2;
            }
            if (string5.startsWith(DEBUG_METHOD_NAME)) {
                String string8 = this.tokenizer.nextToken();
                string2 = "Method Name - " + string8;
                this.errorInfo.setMethodName(string8);
                return string2;
            }
            if (string5.startsWith(DEBUG_LINE_NUMBER)) {
                String string9 = this.tokenizer.nextToken();
                string2 = "Line Number - " + string9;
                try {
                    this.errorInfo.setLineNumber(Integer.parseInt(string9));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                return string2;
            }
        }
        return string2;
    }

    private void processRequest() {
    }

    public int getState() {
        return this.state;
    }

    public void setState(int n) {
        this.state = n;
        if (n == 0) {
            this.errorInfo = null;
        }
    }

    public ErrorInfo getErrorInfo() {
        return this.errorInfo;
    }

    public class ErrorInfo {
        String className = null;
        String fileName = null;
        String methodName = null;
        String filePath = null;
        int lineNumber;

        public void setClassName(String string) {
            this.className = string;
        }

        public void setMethodName(String string) {
            this.methodName = string;
        }

        public void setFileName(String string) {
            this.fileName = string;
        }

        public void setLineNumber(int n) {
            this.lineNumber = n;
        }

        public int getLineNumber() {
            return this.lineNumber;
        }

        public String getFilePath() {
            return this.className.replace('.', '/') + ".java";
        }
    }
}

