/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.attach.wizard.steps;

import javax.swing.event.ChangeListener;
import org.netbeans.modules.profiler.attach.wizard.WizardContext;
import org.netbeans.modules.profiler.attach.wizard.functors.ConditionalFunctor;
import org.netbeans.modules.profiler.attach.wizard.functors.TrueConditionalFunctor;
import org.netbeans.modules.profiler.attach.wizard.screen.WizardScreen;
import org.netbeans.modules.profiler.attach.wizard.steps.WizardStep;
import org.netbeans.modules.profiler.attach.wizard.steps.WizardStepVisitor;

public class SimpleWizardStep
implements WizardStep {
    private static final int NAVIGATION_STATE_BEGIN = 1;
    private static final int NAVIGATION_STATE_END = 2;
    private ConditionalFunctor condition;
    private String title;
    private WizardContext context;
    private WizardScreen attachedScreen;
    private boolean currentFlag = false;
    private int navigationState = 0;

    public SimpleWizardStep(String string, WizardScreen wizardScreen) {
        this(null, string, wizardScreen);
    }

    public SimpleWizardStep(String string, WizardScreen wizardScreen, ConditionalFunctor conditionalFunctor) {
        this(null, string, wizardScreen, conditionalFunctor);
    }

    public SimpleWizardStep(WizardContext wizardContext, String string, WizardScreen wizardScreen) {
        this(wizardContext, string, wizardScreen, new TrueConditionalFunctor());
    }

    public SimpleWizardStep(WizardContext wizardContext, String string, WizardScreen wizardScreen, ConditionalFunctor conditionalFunctor) {
        this.context = wizardContext;
        this.title = string;
        wizardScreen.setTitle(string);
        this.attachedScreen = wizardScreen;
        this.condition = conditionalFunctor;
    }

    public WizardScreen getAttachedScreen() {
        return this.attachedScreen;
    }

    public boolean isBegin() {
        return (this.navigationState & 1) > 0;
    }

    public void setCurrent() {
        this.currentFlag = true;
    }

    public boolean isCurrent() {
        return this.currentFlag;
    }

    public boolean isEnd() {
        return (this.navigationState & 2) > 0;
    }

    public void setFirst() {
        if (this.canHandle()) {
            this.navigationState = 0;
            this.currentFlag = true;
            if (this.context != null) {
                this.attachedScreen.onEnter(this.context);
            }
        } else {
            this.navigationState = 3;
        }
    }

    public boolean isFirst() {
        return true;
    }

    public void setLast() {
        if (this.canHandle()) {
            this.navigationState = 0;
            this.currentFlag = true;
            if (this.context != null) {
                this.attachedScreen.onEnter(this.context);
            }
        } else {
            this.navigationState = 3;
        }
    }

    public boolean isLast() {
        return true;
    }

    public void setNext() {
        if (this.context != null) {
            this.attachedScreen.onExit(this.context);
        }
        this.navigationState = 2;
        this.currentFlag = false;
    }

    public void setPrevious() {
        if (this.context != null) {
            this.attachedScreen.onExit(this.context);
        }
        this.navigationState = 1;
        this.currentFlag = false;
    }

    public int getStepIndex() {
        return 0;
    }

    public String getTitle() {
        return this.title;
    }

    public void setWizardContext(WizardContext wizardContext) {
        this.context = wizardContext;
    }

    public void accept(WizardStepVisitor wizardStepVisitor, WizardContext wizardContext, int n) {
        if (this.canHandle()) {
            wizardStepVisitor.visit(this, wizardContext, n);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.attachedScreen.addChangeListener(changeListener);
    }

    public boolean canBack() {
        return this.attachedScreen.canBack(this.context);
    }

    public boolean canFinish() {
        return this.attachedScreen.canFinish(this.context);
    }

    public boolean canHandle() {
        return this.condition.evaluate(this.context);
    }

    public boolean canNext() {
        return this.attachedScreen.canNext(this.context);
    }

    public boolean onCancel() {
        return this.attachedScreen.onCancel(this.context);
    }

    public void onFinish() {
        this.attachedScreen.onFinish(this.context);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.attachedScreen.removeChangeListener(changeListener);
    }
}

