/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.refactoring.ui;

import java.awt.Component;
import java.awt.Dimension;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.api.WhereUsedQuery;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.netbeans.modules.refactoring.spi.ui.RefactoringCustomUI;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.netbeans.modules.xml.nbprefuse.AnalysisViewer;
import org.netbeans.modules.xml.nbprefuse.View;
import org.netbeans.modules.xml.refactoring.XMLRefactoringTransaction;
import org.netbeans.modules.xml.refactoring.ui.GraphHelper;
import org.netbeans.modules.xml.refactoring.ui.RenamePanel;
import org.netbeans.modules.xml.refactoring.ui.WhereUsedQueryUI;
import org.netbeans.modules.xml.refactoring.ui.views.WhereUsedView;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import prefuse.data.Graph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileRenameRefactoringUI
implements RefactoringUI,
RefactoringCustomUI {
    private WhereUsedQuery query;
    private WhereUsedView view;
    private RenamePanel panel;
    String newName;
    private Model target;
    String oldFileName;
    String displayName;
    private RenameRefactoring refactoring;

    public FileRenameRefactoringUI(Model model, String string) {
        this.target = model;
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)model));
        this.oldFileName = ((FileObject)model.getModelSource().getLookup().lookup(FileObject.class)).getName();
        this.displayName = string != null ? string : this.oldFileName;
        XMLRefactoringTransaction xMLRefactoringTransaction = new XMLRefactoringTransaction((Referenceable)model, (AbstractRefactoring)this.refactoring);
        this.refactoring.getContext().add((Object)xMLRefactoringTransaction);
        this.refactoring.getContext().add((Object)this.oldFileName);
    }

    public FileRenameRefactoringUI(Model model) {
        this.target = model;
        this.refactoring = new RenameRefactoring(Lookups.singleton((Object)model));
        this.displayName = this.oldFileName = ((FileObject)model.getModelSource().getLookup().lookup(FileObject.class)).getName();
        XMLRefactoringTransaction xMLRefactoringTransaction = new XMLRefactoringTransaction((Referenceable)model, (AbstractRefactoring)this.refactoring);
        this.refactoring.getContext().add((Object)xMLRefactoringTransaction);
        this.refactoring.getContext().add((Object)this.oldFileName);
    }

    public CustomRefactoringPanel getPanel(ChangeListener changeListener) {
        if (this.panel == null) {
            this.panel = new RenamePanel(this.displayName, changeListener, NbBundle.getMessage(RenamePanel.class, (String)"LBL_FileRename"), true, false);
        }
        return this.panel;
    }

    public Problem setParameters() {
        this.newName = this.panel.getNameValue();
        if (this.refactoring instanceof RenameRefactoring) {
            this.refactoring.setNewName(this.newName);
        }
        return this.refactoring.checkParameters();
    }

    public boolean isQuery() {
        return false;
    }

    public boolean hasParameters() {
        return true;
    }

    public AbstractRefactoring getRefactoring() {
        return this.refactoring;
    }

    public String getName() {
        return new MessageFormat(NbBundle.getMessage(FileRenameRefactoringUI.class, (String)"LBL_FileRename")).format(new Object[]{this.oldFileName});
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(FileRenameRefactoringUI.class);
    }

    public String getDescription() {
        return new MessageFormat(NbBundle.getMessage(FileRenameRefactoringUI.class, (String)"DSC_Rename")).format(new Object[]{this.oldFileName, this.refactoring.getNewName()});
    }

    public Problem checkParameters() {
        this.newName = this.panel.getNameValue();
        if (this.refactoring instanceof RenameRefactoring) {
            this.refactoring.setNewName(this.newName);
        }
        return this.refactoring.fastCheckParameters();
    }

    public View getView() {
        return this.view;
    }

    public void setView(View view) {
        this.view = (WhereUsedView)WhereUsedView.class.cast(view);
    }

    public Referenceable getTarget() {
        return this.target;
    }

    public Component getCustomComponent(Collection<RefactoringElement> collection) {
        RefactoringElement refactoringElement2;
        WhereUsedView whereUsedView = new WhereUsedView((Referenceable)this.target);
        GraphHelper graphHelper = new GraphHelper((Referenceable)this.target);
        ArrayList<TreeElement> arrayList = new ArrayList<TreeElement>();
        for (RefactoringElement refactoringElement2 : collection) {
            TreeElement treeElement = TreeElementFactory.getTreeElement((Object)refactoringElement2);
            if (treeElement == null) continue;
            arrayList.add(treeElement);
        }
        Graph graph = graphHelper.loadGraph(arrayList);
        whereUsedView.setGraph(graph);
        refactoringElement2 = new AnalysisViewer();
        refactoringElement2.setCurrentView((View)whereUsedView);
        refactoringElement2.getPanel().setMinimumSize(new Dimension(10, 10));
        refactoringElement2.getPanel().setPreferredSize(new Dimension(10, 10));
        whereUsedView.showView((AnalysisViewer)refactoringElement2);
        return refactoringElement2.getPanel();
    }

    public Icon getCustomIcon() {
        return new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/xml/refactoring/resources/graphical_view_refactoring.png"));
    }

    public String getCustomToolTip() {
        return NbBundle.getMessage(WhereUsedQueryUI.class, (String)"LBL_ShowGraph");
    }
}

