/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.refactoring.ui.views;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.tree.DefaultTreeModel;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.xml.nbprefuse.AggregateDragControl;
import org.netbeans.modules.xml.nbprefuse.AnalysisViewer;
import org.netbeans.modules.xml.nbprefuse.EdgeFillColorAction;
import org.netbeans.modules.xml.nbprefuse.EdgeStrokeColorAction;
import org.netbeans.modules.xml.nbprefuse.FindUsagesFocusControl;
import org.netbeans.modules.xml.nbprefuse.MouseoverActionControl;
import org.netbeans.modules.xml.nbprefuse.NodeExpansionMouseControl;
import org.netbeans.modules.xml.nbprefuse.NodeFillColorAction;
import org.netbeans.modules.xml.nbprefuse.NodeStrokeColorAction;
import org.netbeans.modules.xml.nbprefuse.NodeTextColorAction;
import org.netbeans.modules.xml.nbprefuse.PopupMouseControl;
import org.netbeans.modules.xml.nbprefuse.View;
import org.netbeans.modules.xml.nbprefuse.layout.AggregateLayout;
import org.netbeans.modules.xml.nbprefuse.layout.NbFruchtermanReingoldLayout;
import org.netbeans.modules.xml.nbprefuse.render.CompositionEdgeRenderer;
import org.netbeans.modules.xml.nbprefuse.render.FindUsagesRendererFactory;
import org.netbeans.modules.xml.nbprefuse.render.GeneralizationEdgeRenderer;
import org.netbeans.modules.xml.nbprefuse.render.NbLabelRenderer;
import org.netbeans.modules.xml.nbprefuse.render.ReferenceEdgeRenderer;
import org.netbeans.modules.xml.refactoring.spi.AnalysisUtilities;
import org.netbeans.modules.xml.xam.Component;
import org.netbeans.modules.xml.xam.Model;
import org.netbeans.modules.xml.xam.Referenceable;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;
import prefuse.Display;
import prefuse.Visualization;
import prefuse.action.Action;
import prefuse.action.ActionList;
import prefuse.action.RepaintAction;
import prefuse.action.animate.ColorAnimator;
import prefuse.action.animate.QualityControlAnimator;
import prefuse.action.animate.VisibilityAnimator;
import prefuse.action.assignment.DataColorAction;
import prefuse.activity.Pacer;
import prefuse.activity.SlowInSlowOutPacer;
import prefuse.controls.Control;
import prefuse.controls.ControlAdapter;
import prefuse.controls.NeighborHighlightControl;
import prefuse.controls.PanControl;
import prefuse.controls.ToolTipControl;
import prefuse.controls.WheelZoomControl;
import prefuse.controls.ZoomControl;
import prefuse.data.Graph;
import prefuse.data.Tuple;
import prefuse.data.tuple.TupleSet;
import prefuse.render.EdgeRenderer;
import prefuse.render.PolygonRenderer;
import prefuse.render.Renderer;
import prefuse.render.RendererFactory;
import prefuse.util.ColorLib;
import prefuse.visual.AggregateItem;
import prefuse.visual.AggregateTable;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WhereUsedView
implements View,
PropertyChangeListener {
    private Model model;
    private Referenceable query;
    private Graph graph;
    private Display display = null;
    private JPanel displayPanel;
    private boolean isPrimitive;
    private boolean usePacer = false;
    private DefaultTreeModel defaultTreeModel;
    private static int paletteCount = 0;
    public static final String NODE_SELECTION_CHANGE = "node-selection-change";

    public WhereUsedView(Referenceable referenceable) {
        if (referenceable != null) {
            this.query = referenceable;
            if (referenceable instanceof Component) {
                this.model = ((Component)referenceable).getModel();
            } else if (referenceable instanceof Model) {
                this.model = (Model)referenceable;
            } else {
                throw new IllegalArgumentException("Expect Component or Model");
            }
        }
    }

    public Referenceable getQueryComponent() {
        return this.query;
    }

    public boolean showView(AnalysisViewer analysisViewer) {
        boolean bl = false;
        final Visualization visualization = new Visualization();
        if (this.graph == null) {
            ErrorManager.getDefault().log(65536, NbBundle.getMessage(WhereUsedView.class, (String)"LBL_Graph_Not_Created_Error"));
            return bl;
        }
        try {
            Cloneable cloneable;
            Object object;
            this.display = new Display();
            this.display.setBackground(Color.WHITE);
            visualization.addGraph("graph", this.graph);
            this.display.setVisualization(visualization);
            int n = 0;
            if (this.graph.getNodeCount() > 1) {
                object = visualization.addAggregates("aggregates");
                object.addColumn(VisualItem.POLYGON, float[].class);
                object.addColumn("id", Integer.TYPE, (Object)-1);
                object.addColumn("is-file-group-aggregate", Boolean.TYPE, (Object)false);
                cloneable = new ArrayList();
                n = this.createAggregates(visualization, (AggregateTable)object, (List<NodeItem>)((Object)cloneable));
                AnalysisUtilities.expandCollapseFileNodes((List<NodeItem>)((Object)cloneable));
            }
            object = analysisViewer.getPanel().getBounds().getSize();
            cloneable = this.display.getBounds().getSize();
            if (((Dimension)object).width < 1 || ((Dimension)object).height < 1) {
                int n2 = WindowManager.getDefault().getMainWindow().getWidth() - 100;
                this.display.setSize(((Dimension)object).width < 1 ? n2 : ((Dimension)object).width, ((Dimension)object).height < 1 ? 200 : ((Dimension)object).height);
                analysisViewer.getPanel().setSize(this.display.getSize());
            } else if (!((Dimension)object).equals(cloneable)) {
                this.display.setSize(((Dimension)object).width, ((Dimension)object).height);
            }
            this.displayPanel = new JPanel(new BorderLayout());
            this.displayPanel.add((java.awt.Component)this.display, "Center");
            analysisViewer.addDisplayPanel(this.displayPanel);
            PolygonRenderer polygonRenderer = new PolygonRenderer(1);
            polygonRenderer.setCurveSlack(0.15f);
            visualization.setRendererFactory((RendererFactory)new FindUsagesRendererFactory(new NbLabelRenderer(), new NbLabelRenderer(), (Renderer)new GeneralizationEdgeRenderer(), (Renderer)new CompositionEdgeRenderer(), (Renderer)new ReferenceEdgeRenderer(), (Renderer)new EdgeRenderer(), (Renderer)polygonRenderer));
            final int[][] nArrayArray = new int[][]{AnalysisUtilities.getHSBPalette(n + 1, 0.17f, 1.0f, null), ColorLib.getGrayscalePalette((int)n), ColorLib.getCoolPalette((int)n), ColorLib.getHotPalette((int)n), ColorLib.getInterpolatedPalette((int)n, (int)new Color(204, 255, 255).getRGB(), (int)new Color(255, 204, 255).getRGB())};
            final RepaintAction repaintAction = new RepaintAction();
            visualization.putAction("action-repaint", (Action)repaintAction);
            DataColorAction dataColorAction = new DataColorAction("aggregates", "id", 0, VisualItem.FILLCOLOR, nArrayArray[0]);
            NodeFillColorAction nodeFillColorAction = new NodeFillColorAction();
            NodeTextColorAction nodeTextColorAction = new NodeTextColorAction();
            NodeStrokeColorAction nodeStrokeColorAction = new NodeStrokeColorAction();
            EdgeStrokeColorAction edgeStrokeColorAction = new EdgeStrokeColorAction();
            EdgeFillColorAction edgeFillColorAction = new EdgeFillColorAction();
            ActionList actionList = new ActionList();
            actionList.add((Action)nodeFillColorAction);
            actionList.add((Action)nodeTextColorAction);
            actionList.add((Action)nodeStrokeColorAction);
            actionList.add((Action)edgeStrokeColorAction);
            actionList.add((Action)edgeFillColorAction);
            actionList.add((Action)dataColorAction);
            visualization.putAction("action-draw", (Action)actionList);
            ActionList actionList2 = new ActionList(visualization);
            actionList2.add((Action)nodeFillColorAction);
            actionList2.add((Action)nodeTextColorAction);
            actionList2.add((Action)nodeStrokeColorAction);
            actionList2.add((Action)edgeStrokeColorAction);
            actionList2.add((Action)edgeFillColorAction);
            actionList2.add((Action)dataColorAction);
            visualization.putAction("action-update", (Action)actionList2);
            ActionList actionList3 = new ActionList(visualization);
            actionList3.add((Action)nodeFillColorAction);
            actionList3.add((Action)nodeTextColorAction);
            actionList3.add((Action)nodeStrokeColorAction);
            actionList3.add((Action)edgeStrokeColorAction);
            actionList3.add((Action)edgeFillColorAction);
            actionList3.add((Action)dataColorAction);
            actionList3.add((Action)repaintAction);
            visualization.putAction("action-update-repaint", (Action)actionList3);
            AggregateLayout aggregateLayout = new AggregateLayout(visualization, "aggregates");
            visualization.putAction("action-aggregate-layout", (Action)aggregateLayout);
            ActionList actionList4 = new ActionList(visualization);
            actionList4.add((Action)nodeFillColorAction);
            actionList4.add((Action)nodeTextColorAction);
            actionList4.add((Action)nodeStrokeColorAction);
            actionList4.add((Action)edgeStrokeColorAction);
            actionList4.add((Action)edgeFillColorAction);
            actionList4.add((Action)dataColorAction);
            actionList4.add((Action)aggregateLayout);
            actionList4.add((Action)repaintAction);
            visualization.putAction("action-update-aggregate-layout-repaint", (Action)actionList4);
            ActionList actionList5 = new ActionList();
            actionList5.add((Action)new NbFruchtermanReingoldLayout("graph"));
            actionList5.add((Action)aggregateLayout);
            actionList5.add((Action)repaintAction);
            visualization.putAction("action-layout", (Action)actionList5);
            ActionList actionList6 = new ActionList();
            actionList6.add((Action)new NbFruchtermanReingoldLayout("graph"));
            actionList6.add((Action)aggregateLayout);
            actionList6.add((Action)repaintAction);
            visualization.putAction("action-layout-repaint", (Action)actionList6);
            this.display.setHighQuality(true);
            this.display.addControlListener((Control)new AggregateDragControl());
            this.display.addControlListener((Control)new PanControl());
            this.display.addControlListener((Control)new ZoomControl());
            this.display.addControlListener((Control)new WheelZoomControl());
            this.display.addControlListener((Control)new ToolTipControl("tooltip"));
            FindUsagesFocusControl findUsagesFocusControl = new FindUsagesFocusControl(1, "action-update-repaint");
            FindUsagesFocusControl findUsagesFocusControl2 = new FindUsagesFocusControl(2, "action-update-aggregate-layout-repaint");
            findUsagesFocusControl.addGraphNodeSelectionChangeListener((PropertyChangeListener)analysisViewer);
            this.display.addControlListener((Control)findUsagesFocusControl);
            this.display.addControlListener((Control)findUsagesFocusControl2);
            this.display.addControlListener((Control)new MouseoverActionControl("action-update-repaint"));
            this.display.addControlListener((Control)new NeighborHighlightControl("action-update-repaint"));
            this.display.addControlListener((Control)new PopupMouseControl());
            this.display.addControlListener((Control)new NodeExpansionMouseControl(visualization, "action-update-aggregate-layout-repaint"));
            this.display.addControlListener((Control)new ControlAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (mouseEvent.isAltDown()) {
                        paletteCount++;
                        if (paletteCount > nArrayArray.length - 1) {
                            paletteCount = 0;
                        }
                        DataColorAction dataColorAction = new DataColorAction("aggregates", "id", 0, VisualItem.FILLCOLOR, nArrayArray[1]);
                        ActionList actionList = new ActionList();
                        actionList.add((Action)dataColorAction);
                        actionList.add((Action)repaintAction);
                        visualization.putAction("drawAggr", (Action)actionList);
                        visualization.run("drawAggr");
                        String string = null;
                        switch (paletteCount) {
                            case 0: {
                                string = "HSB Palette:  Saturation 10f, Brightness 150f";
                                break;
                            }
                            case 1: {
                                string = "Grayscale Palette";
                                break;
                            }
                            case 2: {
                                string = "Cool Palette";
                                break;
                            }
                            case 3: {
                                string = "Hot Palette";
                                break;
                            }
                            case 4: {
                                string = "Interpolated (204,255,255) to (255,204,255)";
                            }
                        }
                    }
                }
            });
            if (this.usePacer) {
                ActionList actionList7 = new ActionList(1500L, 40L);
                actionList7.setPacingFunction((Pacer)new SlowInSlowOutPacer());
                actionList7.add((Action)new QualityControlAnimator());
                actionList7.add((Action)new VisibilityAnimator());
                actionList7.add((Action)new ColorAnimator());
                actionList7.add((Action)repaintAction);
                visualization.putAction("action-animate", (Action)actionList7);
                visualization.runAfter("action-layout-repaint", "action-animate");
                this.usePacer(false);
            }
            visualization.runAfter("action-draw", "action-layout-repaint");
            visualization.run("action-draw");
            bl = true;
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
        return bl;
    }

    private int createAggregates(Visualization visualization, AggregateTable aggregateTable, List<NodeItem> list) {
        HashMap<Integer, AggregateItem> hashMap = new HashMap<Integer, AggregateItem>();
        Iterator iterator = visualization.getGroup("graph.nodes").tuples();
        while (iterator.hasNext()) {
            Integer n = null;
            NodeItem nodeItem = (NodeItem)NodeItem.class.cast(iterator.next());
            if (nodeItem.getBoolean("is-query-node")) continue;
            if (nodeItem.canGetInt("file-group") && (n = Integer.valueOf(nodeItem.getInt("file-group"))) == -1 && nodeItem.canGetInt("file-node-file-group")) {
                list.add(nodeItem);
                n = nodeItem.getInt("file-node-file-group");
            }
            if (n == null) continue;
            AggregateItem aggregateItem = null;
            if (hashMap.containsKey(n)) {
                aggregateItem = (AggregateItem)hashMap.get(n);
            } else {
                aggregateItem = (AggregateItem)aggregateTable.addItem();
                aggregateItem.setInt("id", n.intValue());
                aggregateItem.setBoolean("is-file-group-aggregate", true);
                hashMap.put(n, aggregateItem);
            }
            aggregateItem.addItem((VisualItem)nodeItem);
        }
        return hashMap.size();
    }

    public void usePacer(boolean bl) {
        this.usePacer = bl;
    }

    public boolean getMaximizeWidth() {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals(NODE_SELECTION_CHANGE)) {
            Object object = propertyChangeEvent.getNewValue();
            if (object instanceof RefactoringElement) {
                object = ((RefactoringElement)object).getLookup().lookup(Object.class);
            }
            if (this.display == null || this.graph == null) {
                return;
            }
            Visualization visualization = this.display.getVisualization();
            TupleSet tupleSet = visualization.getFocusGroup(Visualization.FOCUS_ITEMS);
            tupleSet.clear();
            if (object == null) {
                visualization.run("action-update-repaint");
                return;
            }
            TupleSet tupleSet2 = visualization.getGroup("graph.nodes");
            Iterator iterator = tupleSet2.tuples();
            while (iterator.hasNext()) {
                Tuple tuple = (Tuple)iterator.next();
                Object object2 = tuple.get("user-obj");
                if (object2 == null && tuple.canGetString("xam-component")) {
                    object2 = (Component)tuple.get("xam-component");
                }
                FileObject fileObject = (FileObject)tuple.get("file-object");
                if (object2 != object && fileObject != object) continue;
                tupleSet.setTuple(tuple);
                break;
            }
            visualization.run("action-update-repaint");
        }
    }

    public void setGraph(Graph graph) {
        this.graph = graph;
    }

    public Object[] createModels() {
        return null;
    }
}

