/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.dwarfdiscovery.provider;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.discovery.api.FolderProperties;
import org.netbeans.modules.cnd.discovery.api.ItemProperties;
import org.netbeans.modules.cnd.discovery.api.ProjectProperties;
import org.netbeans.modules.cnd.discovery.api.SourceFileProperties;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfFolder;
import org.netbeans.modules.cnd.dwarfdiscovery.provider.DwarfSource;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DwarfProject
implements ProjectProperties {
    private static boolean gatherFolders = true;
    private ItemProperties.LanguageKind language;
    private Set<String> userIncludes = new LinkedHashSet<String>();
    private Set<String> systemIncludes = new LinkedHashSet<String>();
    private Map<String, String> userMacros = new HashMap<String, String>();
    private Map<String, FolderProperties> folders = new HashMap<String, FolderProperties>();

    public DwarfProject(ItemProperties.LanguageKind languageKind) {
        this.language = languageKind;
    }

    void update(SourceFileProperties sourceFileProperties) {
        this.userIncludes.addAll(sourceFileProperties.getUserInludePaths());
        for (String string : sourceFileProperties.getUserInludePaths()) {
            this.userIncludes.add(DwarfSource.convertRelativePathToAbsolute(sourceFileProperties, string));
        }
        this.userMacros.putAll(sourceFileProperties.getUserMacros());
        if (gatherFolders) {
            this.updateFolder(sourceFileProperties);
        }
    }

    private void updateFolder(SourceFileProperties sourceFileProperties) {
        FolderProperties folderProperties;
        File file = new File(sourceFileProperties.getItemPath());
        String string = FileUtil.normalizeFile((File)file.getParentFile()).getAbsolutePath();
        if (Utilities.isWindows()) {
            string = string.replace('\\', '/');
        }
        if ((folderProperties = this.folders.get(string)) == null) {
            this.folders.put(string, new DwarfFolder(string, sourceFileProperties));
        } else {
            ((DwarfFolder)folderProperties).update(sourceFileProperties);
        }
    }

    public List<FolderProperties> getConfiguredFolders() {
        return new ArrayList<FolderProperties>(this.folders.values());
    }

    public String getMakePath() {
        return null;
    }

    public String getBinaryPath() {
        return null;
    }

    public ProjectProperties.BinaryKind getBinaryKind() {
        return null;
    }

    public List<String> getUserInludePaths() {
        return new ArrayList<String>(this.userIncludes);
    }

    public List<String> getSystemInludePaths() {
        return new ArrayList<String>(this.systemIncludes);
    }

    public Map<String, String> getUserMacros() {
        return this.userMacros;
    }

    public Map<String, String> getSystemMacros() {
        return null;
    }

    public ItemProperties.LanguageKind getLanguageKind() {
        return this.language;
    }
}

