/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.sql.project.wsdl;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.wsdl.Definition;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.project.Project;
import org.netbeans.modules.sql.project.wsdl.ExtensionFilter;
import org.netbeans.modules.sql.project.wsdl.JBIFileWriter;
import org.netbeans.modules.sql.project.wsdl.SQLEngineFileGenerator;
import org.netbeans.modules.sql.project.wsdl.SQLMapWriter;
import org.netbeans.modules.sql.project.wsdl.WSDLGenerator;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ActionImpl
extends CallableSystemAction {
    private static final long serialVersionUID = 1L;
    public static final String NAME = "Name";
    private String mSrcDirectoryLocation;
    private String mBuildDirectoryLocation;
    private String mBaseDirectoryLocation;
    private String dbURL = "";
    private String jndi_name = "";
    private String transactionRequired = "";
    private static final String CONNECTION_FILE = "connectivityInfo.xml";
    private String engineFileName = "sqlse_engine.xml";
    private JFrame frame;
    DatabaseConnection dbConn = null;
    Connection conn = null;
    Project project = null;

    public void setProject(Project project) {
        this.project = project;
    }

    public String getName() {
        return NbBundle.getMessage(ActionImpl.class, (String)"LBL_Generate_WSDL");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public void performAction() {
    }

    public boolean asynchronous() {
        return false;
    }

    public void setEnabled(boolean bl) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.execute();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getSrcDirectoryLocation() {
        return this.mSrcDirectoryLocation;
    }

    public void setSrcDirectoryLocation(String string) {
        this.mSrcDirectoryLocation = string;
    }

    public void setBaseDirectoryLocation(String string) {
        this.mBaseDirectoryLocation = string;
    }

    public String getBuildDirectoryLocation() {
        return this.mBuildDirectoryLocation;
    }

    public void setBuildDirectoryLocation(String string) {
        this.mBuildDirectoryLocation = string;
        this.engineFileName = "sqlse_engine.xml";
    }

    public static List getFilesRecursively(File file, FileFilter fileFilter) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (!file.isDirectory()) {
            return arrayList;
        }
        File[] fileArray = file.listFiles(fileFilter);
        int n = fileArray.length;
        for (int i = 0; i < n; ++i) {
            if (fileArray[i].isDirectory()) {
                arrayList.addAll(ActionImpl.getFilesRecursively(fileArray[i], fileFilter));
                continue;
            }
            arrayList.add(fileArray[i]);
        }
        return arrayList;
    }

    public static List getFilesRecursively(File file, String[] stringArray) {
        ExtensionFilter extensionFilter = null;
        if (stringArray[0].equals(".sql")) {
            extensionFilter = new ExtensionFilter(stringArray);
        }
        return ActionImpl.getFilesRecursively(file, extensionFilter);
    }

    public void execute() throws Exception {
        HashMap hashMap = new HashMap();
        try {
            Object object;
            String string = this.project.getProjectDirectory().getPath();
            this.mBuildDirectoryLocation = string + "/build";
            this.mSrcDirectoryLocation = string + "/src";
            File file = new File(this.mSrcDirectoryLocation);
            if (!file.exists()) {
                throw new Exception("Directory " + this.mSrcDirectoryLocation + " does not exit.");
            }
            int n = string.length();
            String string2 = string.substring(string.lastIndexOf(File.separator) + 1, string.length());
            if (string2.length() == n) {
                string2 = string.substring(string.lastIndexOf("/") + 1, string.length());
            }
            boolean bl = new File(this.mBuildDirectoryLocation + "/META-INF").mkdirs();
            SQLEngineFileGenerator sQLEngineFileGenerator = new SQLEngineFileGenerator(this.mBuildDirectoryLocation + "/" + this.engineFileName, string2);
            String string3 = file.getAbsolutePath();
            String[] stringArray = new String[]{".sql"};
            List list = ActionImpl.getFilesRecursively(file, stringArray);
            this.readConnectionInfo(CONNECTION_FILE);
            this.getDatabaseConnection();
            if (this.conn == null) {
                throw new Exception("Unable to retrieve any database connections with the url " + this.dbURL + "\n Please associate a Connection for the sql file in netbeans runtime tab or if it exists, connect to the external");
            }
            int n2 = list.size();
            for (int i = 0; i < n2; ++i) {
                object = (File)list.get(i);
                if (object == null) continue;
                sQLEngineFileGenerator.addSQLDefinition(((File)object).getName(), this.dbConn);
            }
            sQLEngineFileGenerator.persistEngineFile(this.jndi_name, this.transactionRequired);
            WSDLGenerator wSDLGenerator = new WSDLGenerator(this.conn, list, string2, string3, this.engineFileName);
            wSDLGenerator.setDBConnection(this.dbConn);
            Definition definition = wSDLGenerator.generateWSDL();
            object = new SQLMapWriter(list, definition, new File(this.mBuildDirectoryLocation).getCanonicalPath());
            ((SQLMapWriter)object).writeMap();
            JBIFileWriter jBIFileWriter = new JBIFileWriter(this.mBuildDirectoryLocation + "/META-INF/jbi.xml", this.mBuildDirectoryLocation + "/sqlmap.xml", this.mBuildDirectoryLocation);
            jBIFileWriter.writeJBI();
            this.project.getProjectDirectory().refresh();
            JOptionPane.showMessageDialog(this.frame, NbBundle.getMessage(ActionImpl.class, (String)"LBL_WSDL_Generated"), "Information", 1);
        }
        catch (Exception exception) {
            throw new Exception(exception.getMessage());
        }
    }

    private void readConnectionInfo(String string) throws Exception {
        if (string.endsWith(".xml")) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            try {
                Node node;
                Node node2;
                Object object;
                Object object2;
                Document document = documentBuilderFactory.newDocumentBuilder().parse(new File(this.mSrcDirectoryLocation, CONNECTION_FILE));
                NodeList nodeList = document.getDocumentElement().getElementsByTagName("database-url");
                if (nodeList != null && (object2 = nodeList.item(0)) != null && (object = object2.getAttributes().getNamedItem("value")) != null) {
                    this.dbURL = object.getNodeValue();
                }
                if ((object2 = document.getDocumentElement().getElementsByTagName("jndi-name")) != null && (object = object2.item(0)) != null && (node2 = object.getAttributes().getNamedItem("value")) != null) {
                    this.jndi_name = node2.getNodeValue();
                }
                if ((object = document.getDocumentElement().getElementsByTagName("transaction-required")) != null && (node2 = object.item(0)) != null && (node = node2.getAttributes().getNamedItem("value")) != null) {
                    this.transactionRequired = node.getNodeValue();
                }
            }
            catch (SAXException sAXException) {
            }
            catch (IOException iOException) {
            }
            catch (ParserConfigurationException parserConfigurationException) {}
        } else {
            throw new Exception("No File with name connectivityInfo.xml was found in the src directory");
        }
    }

    private void getDatabaseConnection() {
        DatabaseConnection[] databaseConnectionArray = ConnectionManager.getDefault().getConnections();
        if (this.dbConn == null) {
            for (int i = 0; i < databaseConnectionArray.length; ++i) {
                if (!databaseConnectionArray[i].getDatabaseURL().equalsIgnoreCase(this.dbURL)) continue;
                this.dbConn = databaseConnectionArray[i];
                this.conn = this.dbConn.getJDBCConnection();
                break;
            }
        }
        if (this.dbConn != null && this.conn == null) {
            ConnectionManager.getDefault().showConnectionDialog(this.dbConn);
            this.conn = this.dbConn.getJDBCConnection();
        }
    }
}

