/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsf.framework;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.common.Util;
import org.netbeans.modules.j2ee.deployment.devmodules.api.Deployment;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eePlatform;
import org.netbeans.modules.visualweb.project.jsf.api.JsfProjectUtils;
import org.netbeans.modules.visualweb.project.jsf.framework.JSFConfigurationPanel;
import org.netbeans.modules.visualweb.project.jsf.framework.JSFUtils;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class JSFConfigurationPanelVisual
extends JPanel
implements HelpCtx.Provider,
DocumentListener {
    private Project project;
    private JSFConfigurationPanel panel;
    private boolean customizer;
    private ArrayList<Library> jsfLibraries;
    private boolean webModule25Version;
    private String serverInstanceID;
    private boolean addJSF = false;
    private boolean addJAXRPC = false;
    private boolean addRowset = false;
    private boolean beanPackageModified = false;
    private JLabel beanPackageLabel;
    protected JTextField beanPackageTextField;
    private ButtonGroup buttonGroup1;
    private JComboBox cbLibraries;
    private JCheckBox cbPackageJars;
    private JCheckBox cbValidate;
    private JCheckBox cbVerify;
    private JPanel confPanel;
    private JPanel jPanel1;
    private JButton jbBrowse;
    private JTabbedPane jsfTabbedPane;
    private JTextField jtFolder;
    private JTextField jtVersion;
    private JLabel lDirectory;
    private JLabel lServletName;
    private JLabel lURLPattern;
    private JLabel lVersion;
    private JPanel libPanel;
    private JRadioButton rbNewLibrary;
    private JRadioButton rbNoneLibrary;
    private JRadioButton rbRegisteredLibrary;
    private JTextField tServletName;
    private JTextField tURLPattern;

    public JSFConfigurationPanelVisual(JSFConfigurationPanel jSFConfigurationPanel, Project project, boolean bl) {
        this.project = project;
        this.panel = jSFConfigurationPanel;
        this.customizer = bl;
        this.initComponents();
        this.remove(this.jsfTabbedPane);
        this.add((Component)this.confPanel, "card10");
        this.initLibraries();
        this.tURLPattern.getDocument().addDocumentListener(this);
        this.cbPackageJars.setVisible(false);
        if (bl) {
            this.enableComponents(false);
        } else {
            this.updateLibrary();
        }
    }

    private void initLibraries() {
        Library[] libraryArray = LibraryManager.getDefault().getLibraries();
        Vector<String> vector = new Vector<String>();
        this.jsfLibraries = new ArrayList();
        for (int i = 0; i < libraryArray.length; ++i) {
            if (!libraryArray[i].getName().startsWith("JSF-") && !libraryArray[i].getName().equals("jsf12")) continue;
            String string = libraryArray[i].getDisplayName();
            vector.add(string);
            this.jsfLibraries.add(libraryArray[i]);
        }
        this.cbLibraries.setModel(new DefaultComboBoxModel(vector));
        if (vector.size() == 0) {
            this.rbRegisteredLibrary.setEnabled(false);
            this.cbLibraries.setEnabled(false);
            this.rbNewLibrary.setSelected(true);
            this.panel.setLibrary(null);
        } else {
            this.rbRegisteredLibrary.setEnabled(true);
            this.rbRegisteredLibrary.setSelected(true);
            this.cbLibraries.setEnabled(true);
        }
        this.repaint();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jsfTabbedPane = new JTabbedPane();
        this.confPanel = new JPanel();
        this.beanPackageLabel = new JLabel();
        this.beanPackageTextField = new JTextField();
        this.lServletName = new JLabel();
        this.tServletName = new JTextField();
        this.lURLPattern = new JLabel();
        this.tURLPattern = new JTextField();
        this.cbValidate = new JCheckBox();
        this.cbVerify = new JCheckBox();
        this.cbPackageJars = new JCheckBox();
        this.jPanel1 = new JPanel();
        this.libPanel = new JPanel();
        this.rbRegisteredLibrary = new JRadioButton();
        this.cbLibraries = new JComboBox();
        this.rbNewLibrary = new JRadioButton();
        this.lDirectory = new JLabel();
        this.jtFolder = new JTextField();
        this.jbBrowse = new JButton();
        this.lVersion = new JLabel();
        this.jtVersion = new JTextField();
        this.rbNoneLibrary = new JRadioButton();
        this.setLayout(new CardLayout());
        this.beanPackageLabel.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/project/jsf/framework/Bundle").getString("MNE_DefaultBackingPackageLabelMnemonic").charAt(0));
        this.beanPackageLabel.setLabelFor(this.beanPackageTextField);
        this.beanPackageLabel.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_DefaultBackingPackageLabel"));
        this.beanPackageTextField.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                JSFConfigurationPanelVisual.this.beanPackageTextFieldKeyReleased(keyEvent);
            }
        });
        this.lServletName.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/project/jsf/framework/Bundle").getString("MNE_lServletName").charAt(0));
        this.lServletName.setLabelFor(this.tServletName);
        this.lServletName.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_Servlet_Name"));
        this.tServletName.setEditable(false);
        this.tServletName.setText("Faces Servlet");
        this.lURLPattern.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/project/jsf/framework/Bundle").getString("MNE_lURLPattern").charAt(0));
        this.lURLPattern.setLabelFor(this.tURLPattern);
        this.lURLPattern.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_URL_Pattern"));
        this.tURLPattern.setText("/faces/*");
        this.cbValidate.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/project/jsf/framework/Bundle").getString("MNE_cbValidate").charAt(0));
        this.cbValidate.setSelected(true);
        this.cbValidate.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"CB_Validate_XML"));
        this.cbValidate.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbValidate.setMargin(new Insets(0, 0, 0, 0));
        this.cbVerify.setMnemonic(ResourceBundle.getBundle("org/netbeans/modules/visualweb/project/jsf/framework/Bundle").getString("MNE_cbVerify").charAt(0));
        this.cbVerify.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"CB_Verify_Objects"));
        this.cbVerify.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbVerify.setMargin(new Insets(0, 0, 0, 0));
        this.cbPackageJars.setSelected(true);
        this.cbPackageJars.setText(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"CB_Package_JARs"));
        this.cbPackageJars.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.cbPackageJars.setMargin(new Insets(0, 0, 0, 0));
        this.jPanel1.setEnabled(false);
        this.jPanel1.setFocusable(false);
        this.jPanel1.setRequestFocusEnabled(false);
        GroupLayout groupLayout = new GroupLayout((Container)this.confPanel);
        this.confPanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jPanel1, -2, 395, -2).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add(11, 11, 11).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0, 1, -2).add((Component)this.cbPackageJars)).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.beanPackageLabel).add((Component)this.lServletName).add((GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0, 1, -2).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lURLPattern).add((Component)this.cbValidate)))).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addPreferredGap(0).add((Component)this.cbVerify)).add((Component)this.tServletName, -1, 345, Short.MAX_VALUE).add((Component)this.tURLPattern, -1, 345, Short.MAX_VALUE).add((Component)this.beanPackageTextField, -1, 345, Short.MAX_VALUE)))))).add(12, 12, 12)));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.beanPackageLabel).add((Component)this.beanPackageTextField, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lServletName).add((Component)this.tServletName, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lURLPattern).add((Component)this.tURLPattern, -2, -1, -2)).add(17, 17, 17).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.cbValidate).add((Component)this.cbVerify)).addPreferredGap(0).add((Component)this.cbPackageJars).add(51, 51, 51).add((Component)this.jPanel1, -2, -1, -2)));
        this.beanPackageTextField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ACSD_DefaultBackingPackageDesc"));
        this.tServletName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ACSD_ServletName"));
        this.tURLPattern.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ACSD_Mapping"));
        this.cbValidate.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ACSD_ValidateXML"));
        this.cbVerify.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ACSD_VerifyObjects"));
        this.cbPackageJars.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"ACSD_PackageJarToWar"));
        this.jsfTabbedPane.addTab(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_TAB_Configuration"), this.confPanel);
        this.libPanel.setAlignmentX(0.2f);
        this.libPanel.setAlignmentY(0.2f);
        this.buttonGroup1.add(this.rbRegisteredLibrary);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/visualweb/project/jsf/framework/Bundle");
        this.rbRegisteredLibrary.setText(resourceBundle.getString("LBL_REGISTERED_LIBRARIES"));
        this.rbRegisteredLibrary.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbRegisteredLibrary.setMargin(new Insets(0, 0, 0, 0));
        this.rbRegisteredLibrary.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JSFConfigurationPanelVisual.this.rbRegisteredLibraryItemStateChanged(itemEvent);
            }
        });
        this.cbLibraries.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbLibraries.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JSFConfigurationPanelVisual.this.cbLibrariesActionPerformed(actionEvent);
            }
        });
        this.buttonGroup1.add(this.rbNewLibrary);
        this.rbNewLibrary.setText(resourceBundle.getString("LBL_CREATE_NEW_LIBRARY"));
        this.rbNewLibrary.setToolTipText(resourceBundle.getString("MSG_CreatingLibraries"));
        this.rbNewLibrary.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbNewLibrary.setMargin(new Insets(0, 0, 0, 0));
        this.rbNewLibrary.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JSFConfigurationPanelVisual.this.rbNewLibraryItemStateChanged(itemEvent);
            }
        });
        this.lDirectory.setText(resourceBundle.getString("LBL_INSTALL_DIR"));
        this.lDirectory.setToolTipText(resourceBundle.getString("HINT_JSF_Directory"));
        this.jtFolder.setToolTipText(resourceBundle.getString("HINT_JSF_Directory"));
        this.jtFolder.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                JSFConfigurationPanelVisual.this.jtFolderKeyPressed(keyEvent);
            }
        });
        this.jbBrowse.setText(resourceBundle.getString("LBL_Browse"));
        this.jbBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JSFConfigurationPanelVisual.this.jbBrowseActionPerformed(actionEvent);
            }
        });
        this.lVersion.setText(resourceBundle.getString("LBL_VERSION"));
        this.lVersion.setToolTipText(resourceBundle.getString("HINT_Version"));
        this.jtVersion.setToolTipText(resourceBundle.getString("HINT_Version"));
        this.jtVersion.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                JSFConfigurationPanelVisual.this.jtVersionKeyReleased(keyEvent);
            }
        });
        this.buttonGroup1.add(this.rbNoneLibrary);
        this.rbNoneLibrary.setText(resourceBundle.getString("LBL_Any_Library"));
        this.rbNoneLibrary.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.rbNoneLibrary.setMargin(new Insets(0, 0, 0, 0));
        this.rbNoneLibrary.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                JSFConfigurationPanelVisual.this.rbNoneLibraryItemStateChanged(itemEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout((Container)this.libPanel);
        this.libPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((Component)this.rbRegisteredLibrary).addPreferredGap(0).add((Component)this.cbLibraries, 0, 332, Short.MAX_VALUE)).add((Component)this.rbNewLibrary, -1, 478, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add(17, 17, 17).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.lDirectory).add((Component)this.lVersion)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(2).add((Component)this.jtVersion, -1, 282, Short.MAX_VALUE).add((Component)this.jtFolder, -1, 282, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jbBrowse)).add((Component)this.rbNoneLibrary, -1, 478, Short.MAX_VALUE)).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.rbRegisteredLibrary).add((Component)this.cbLibraries, -2, -1, -2)).addPreferredGap(0).add((Component)this.rbNewLibrary).add(7, 7, 7).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.jbBrowse).add((Component)this.lDirectory).add((Component)this.jtFolder, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.lVersion).add((Component)this.jtVersion, -2, -1, -2)).addPreferredGap(0).add((Component)this.rbNoneLibrary).addContainerGap(125, Short.MAX_VALUE)));
        this.jsfTabbedPane.addTab(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_TAB_Libraries"), this.libPanel);
        this.add((Component)this.jsfTabbedPane, "card10");
    }

    private void beanPackageTextField1KeyReleased(KeyEvent keyEvent) {
    }

    private void beanPackageTextFieldKeyReleased(KeyEvent keyEvent) {
        this.beanPackageModified = this.beanPackageTextField.getText().length() != 0;
        this.panel.fireChangeEvent();
    }

    private void rbNoneLibraryItemStateChanged(ItemEvent itemEvent) {
        this.updateLibrary();
    }

    private void jtVersionKeyReleased(KeyEvent keyEvent) {
        this.checkNewLibrarySetting();
    }

    private void rbNewLibraryItemStateChanged(ItemEvent itemEvent) {
        this.updateLibrary();
    }

    private void cbLibrariesActionPerformed(ActionEvent actionEvent) {
        this.panel.setLibrary(this.jsfLibraries.get(this.cbLibraries.getSelectedIndex()));
    }

    private void rbRegisteredLibraryItemStateChanged(ItemEvent itemEvent) {
        this.updateLibrary();
    }

    private void jbBrowseActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_SelectLibraryLocation"));
        jFileChooser.setFileSelectionMode(1);
        if (0 == jFileChooser.showOpenDialog(this)) {
            File file = jFileChooser.getSelectedFile();
            this.jtFolder.setText(file.getAbsolutePath());
            this.checkNewLibrarySetting();
        }
    }

    private void jtFolderKeyPressed(KeyEvent keyEvent) {
        this.checkNewLibrarySetting();
    }

    void enableComponents(boolean bl) {
        int n;
        Component[] componentArray = this.confPanel.getComponents();
        for (n = 0; n < componentArray.length; ++n) {
            componentArray[n].setEnabled(bl);
        }
        componentArray = this.libPanel.getComponents();
        for (n = 0; n < componentArray.length; ++n) {
            componentArray[n].setEnabled(bl);
        }
    }

    boolean valid() {
        String string;
        String string2;
        ExtenderController extenderController = this.panel.getController();
        String string3 = this.beanPackageTextField.getText();
        if (!this.customizer && !JsfProjectUtils.isValidJavaPackageName(string3)) {
            String string4 = NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"MSG_InvalidPackage");
            extenderController.setErrorMessage(string4);
            return false;
        }
        String string5 = this.tURLPattern.getText();
        if (string5 == null || string5.trim().equals("")) {
            extenderController.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"MSG_URLPatternIsEmpty"));
            return false;
        }
        if (!this.isPatternValid(string5)) {
            extenderController.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"MSG_URLPatternIsNotValid"));
            return false;
        }
        if (!this.customizer) {
            ExtenderController.Properties properties = extenderController.getProperties();
            string2 = (String)properties.getProperty("j2eeLevel");
            string = (String)properties.getProperty("serverInstanceID");
            if (string2 != null && string != null) {
                boolean bl = string2.equals("1.5");
                if (!string.equals(this.serverInstanceID) || bl != this.webModule25Version) {
                    this.webModule25Version = bl;
                    this.serverInstanceID = string;
                    this.initLibSettings(this.webModule25Version, this.serverInstanceID);
                }
            }
            this.initBackwardsKitSettings("1.5".equals(string2), string);
        }
        boolean bl = false;
        if (this.addJSF && (this.rbNewLibrary.isSelected() && (this.jtFolder.getText().trim().length() <= 0 || this.jtVersion.getText().trim().length() <= 0) || this.rbRegisteredLibrary.isSelected() && this.cbLibraries.getItemCount() <= 0)) {
            bl = true;
        }
        if (bl || this.addJAXRPC || this.addRowset) {
            extenderController.setErrorMessage(JsfProjectUtils.getBackwardsKitMesg(bl, this.addJAXRPC, this.addRowset));
            return false;
        }
        if (this.rbNewLibrary.isSelected()) {
            string2 = this.jtFolder.getText().trim();
            string = this.jtVersion.getText().trim();
            if (string2.length() <= 0) {
                extenderController.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_EmptyJSFFolder"));
                return false;
            }
            File file = new File(string2);
            if (!file.exists()) {
                extenderController.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_NonExistingJSFFolder"));
                return false;
            }
            if (!file.isDirectory()) {
                extenderController.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_NotJSFFolder"));
                return false;
            }
            FileObject fileObject = FileUtil.toFileObject((File)file);
            FileObject[] fileObjectArray = fileObject.getChildren();
            int n = 0;
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FileObject fileObject2 = fileObjectArray[i];
                if (!fileObject2.getName().equalsIgnoreCase("jsf-api") && !fileObject2.getName().equalsIgnoreCase("jsf-impl")) continue;
                ++n;
            }
            if (n != 2) {
                extenderController.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_NotValidJSFFolder"));
                return false;
            }
            if (string.length() <= 0) {
                extenderController.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_EmptyJSFVersion"));
                return false;
            }
            Library library = JSFUtils.getJSFLibrary(string);
            if (library != null) {
                extenderController.setErrorMessage(NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"LBL_AlreadyExists"));
                return false;
            }
        }
        extenderController.setErrorMessage(null);
        return true;
    }

    protected boolean isBeanPackageModified() {
        return this.beanPackageModified;
    }

    private boolean isPatternValid(String string) {
        String string2;
        if (string.startsWith("*.") && (string2 = string.substring(2)).indexOf(46) == -1 && string2.indexOf(42) == -1 && string2.indexOf(47) == -1 && !string2.trim().equals("")) {
            return true;
        }
        return string.length() > 3 && string.endsWith("/*") && string.startsWith("/");
    }

    void update() {
        ExtenderController.Properties properties = this.panel.getController().getProperties();
        this.webModule25Version = "1.5".equals((String)properties.getProperty("j2eeLevel"));
        this.serverInstanceID = (String)properties.getProperty("serverInstanceID");
        this.initLibSettings(this.webModule25Version, this.serverInstanceID);
        this.initBackwardsKitSettings(this.webModule25Version, this.serverInstanceID);
    }

    private void initLibSettings(boolean bl, String string) {
        try {
            this.addJSF = false;
            J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(string);
            File[] fileArray = j2eePlatform != null ? j2eePlatform.getClasspathEntries() : new File[]{};
            boolean bl2 = Util.containsClass(Arrays.asList(fileArray), (String)"javax.faces.FacesException");
            if (bl2) {
                this.rbNoneLibrary.setSelected(true);
            } else if (bl) {
                Library library = LibraryManager.getDefault().getLibrary("jsf12");
                if (library != null) {
                    this.rbRegisteredLibrary.setSelected(true);
                    this.cbLibraries.setSelectedItem(library.getDisplayName());
                } else {
                    this.rbNewLibrary.setSelected(true);
                }
            } else {
                Library library = LibraryManager.getDefault().getLibrary("jsf1102");
                if (library != null) {
                    this.rbRegisteredLibrary.setSelected(true);
                    this.cbLibraries.setSelectedItem(library.getDisplayName());
                } else {
                    this.rbNewLibrary.setSelected(true);
                }
                this.addJSF = true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void initBackwardsKitSettings(boolean bl, String string) {
        File[] fileArray;
        Object object;
        this.addJAXRPC = false;
        if (!bl && (object = LibraryManager.getDefault().getLibrary("jaxrpc16")) == null) {
            try {
                J2eePlatform j2eePlatform = Deployment.getDefault().getJ2eePlatform(string);
                fileArray = j2eePlatform != null ? j2eePlatform.getClasspathEntries() : new File[]{};
                this.addJAXRPC = !Util.containsClass(Arrays.asList(fileArray), (String)"javax.xml.rpc.Service");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        String string2 = object = this.project == null ? null : JsfProjectUtils.getSourceLevel(this.project);
        if (object == null) {
            fileArray = this.panel.getController().getProperties();
            object = (String)fileArray.getProperty("setSourceLevel");
        }
        this.addRowset = false;
        if ("1.4".equals(object) && (fileArray = LibraryManager.getDefault().getLibrary("rowset-ri")) == null) {
            this.addRowset = true;
        }
    }

    void store(WizardDescriptor wizardDescriptor) {
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(JSFConfigurationPanelVisual.class);
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.panel.fireChangeEvent();
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.panel.fireChangeEvent();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.panel.fireChangeEvent();
    }

    public String getBeanPackage() {
        return this.beanPackageTextField.getText();
    }

    public void setBeanPackage(String string) {
        this.beanPackageTextField.setText(string);
    }

    public String getServletName() {
        return this.tServletName.getText();
    }

    public void setServletName(String string) {
        this.tServletName.setText(string);
    }

    public String getURLPattern() {
        return this.tURLPattern.getText();
    }

    public void setURLPattern(String string) {
        this.tURLPattern.setText(string);
    }

    public boolean validateXML() {
        return this.cbValidate.isSelected();
    }

    public void setValidateXML(boolean bl) {
        this.cbValidate.setSelected(bl);
    }

    public boolean verifyObjects() {
        return this.cbVerify.isSelected();
    }

    public void setVerifyObjects(boolean bl) {
        this.cbVerify.setSelected(bl);
    }

    public boolean packageJars() {
        return this.cbPackageJars.isSelected();
    }

    private void updateLibrary() {
        if (this.cbLibraries.getItemCount() == 0) {
            this.rbRegisteredLibrary.setEnabled(false);
        }
        if (this.rbNoneLibrary.isSelected()) {
            this.enableNewLibraryComponent(false);
            this.enableDefinedLibraryComponent(false);
            this.panel.setLibraryType(JSFConfigurationPanel.LibraryType.NONE);
            this.panel.getController().setErrorMessage(null);
        } else if (this.rbRegisteredLibrary.isSelected()) {
            this.enableNewLibraryComponent(false);
            this.enableDefinedLibraryComponent(true);
            this.panel.setLibraryType(JSFConfigurationPanel.LibraryType.USED);
            if (this.jsfLibraries.size() > 0) {
                this.panel.setLibrary(this.jsfLibraries.get(this.cbLibraries.getSelectedIndex()));
            }
            this.panel.getController().setErrorMessage(null);
        } else if (this.rbNewLibrary.isSelected()) {
            this.enableNewLibraryComponent(true);
            this.enableDefinedLibraryComponent(false);
            this.panel.setLibraryType(JSFConfigurationPanel.LibraryType.NEW);
            this.checkNewLibrarySetting();
        }
    }

    private void enableDefinedLibraryComponent(boolean bl) {
        this.cbLibraries.setEnabled(bl);
    }

    private void enableNewLibraryComponent(boolean bl) {
        this.lDirectory.setEnabled(bl);
        this.jtFolder.setEnabled(bl);
        this.jbBrowse.setEnabled(bl);
        this.lVersion.setEnabled(bl);
        this.jtVersion.setEnabled(bl);
    }

    private void checkNewLibrarySetting() {
        String string = null;
        String string2 = this.jtFolder.getText();
        if (string2 == null || "".equals(string2)) {
            string = NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"MSG_PathIsNotFaceletsFolder");
        } else {
            File file = new File(string2);
            if (!JSFUtils.isJSFInstallFolder(file)) {
                string = NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"MSG_PathIsNotFaceletsFolder");
            } else {
                this.panel.setInstallFolder(file);
                String string3 = this.jtVersion.getText().trim();
                if (string3 == null || "".equals(string3)) {
                    string = NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"MSG_VersionHasToBeDefined");
                } else {
                    String string4 = "jsf-" + JSFUtils.convertLibraryVersion(string3);
                    int n = this.jsfLibraries.size();
                    for (int i = 0; i < n; ++i) {
                        if (!this.jsfLibraries.get(i).getName().equals(string4)) continue;
                        string = NbBundle.getMessage(JSFConfigurationPanelVisual.class, (String)"MSG_VersionAlreadyExist");
                    }
                }
                if (string == null) {
                    this.panel.setNewLibraryVersion(this.jtVersion.getText().trim());
                }
            }
        }
        this.panel.getController().setErrorMessage(string);
    }
}

