/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.visualweb.project.jsf.ui;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class PageLayoutData {
    FileObject templateFileObject;

    public PageLayoutData(FileObject fileObject) {
        this.templateFileObject = fileObject;
    }

    public String getName() {
        String string = (String)this.templateFileObject.getAttribute("SystemFileSystem.localizingBundle");
        String string2 = (String)this.templateFileObject.getAttribute("name");
        if (string2 != null) {
            try {
                return NbBundle.getBundle((String)string).getString(string2);
            }
            catch (Exception exception) {
                return string2;
            }
        }
        return this.templateFileObject.getName();
    }

    public int getPosition() {
        return (Integer)this.templateFileObject.getAttribute("position");
    }

    public FileObject getFileObject() {
        return this.templateFileObject;
    }

    public Image getIcon() {
        return this.loadImage("icon");
    }

    public Image getPreviewImage() {
        return this.loadImage("previewImage");
    }

    public String getDescription() {
        String string = (String)this.templateFileObject.getAttribute("SystemFileSystem.localizingBundle");
        String string2 = (String)this.templateFileObject.getAttribute("description");
        if (string2 != null) {
            try {
                return NbBundle.getBundle((String)string).getString(string2);
            }
            catch (Exception exception) {
                return string2;
            }
        }
        return NbBundle.getMessage(PageLayoutData.class, (String)"NO_PREVIEW_TEXT");
    }

    public boolean isPageLayoutTemplate() {
        if (this.templateFileObject.getAttribute("pageLayoutTemplate") != null) {
            return (Boolean)this.templateFileObject.getAttribute("pageLayoutTemplate");
        }
        return false;
    }

    private Image loadImage(String string) {
        Object object = this.templateFileObject.getAttribute(string);
        if (object instanceof Image) {
            return (Image)object;
        }
        if (object instanceof URL) {
            try {
                return Toolkit.getDefaultToolkit().getImage((URL)object);
            }
            catch (Exception exception) {
                ErrorManager.getDefault().notify((Throwable)exception);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void copyResources(FileObject fileObject) throws IOException {
        if (this.templateFileObject.getAttribute("resources") != null) {
            URL uRL = (URL)this.templateFileObject.getAttribute("resources");
            ZipInputStream zipInputStream = null;
            try {
                ZipEntry zipEntry;
                zipInputStream = new ZipInputStream(uRL.openConnection().getInputStream());
                while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                    String string = zipEntry.getName();
                    if (zipEntry.isDirectory()) {
                        FileUtil.createFolder((FileObject)fileObject, (String)string);
                        continue;
                    }
                    FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
                    FileLock fileLock = fileObject2.lock();
                    FileUtil.copy((InputStream)zipInputStream, (OutputStream)fileObject2.getOutputStream(fileLock));
                    fileLock.releaseLock();
                }
            }
            finally {
                if (zipInputStream != null) {
                    zipInputStream.close();
                }
            }
        }
    }
}

