/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.codegen.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.uml.codegen.dataaccess.TemplateTableModel;
import org.netbeans.modules.uml.codegen.dataaccess.xmlbeans.DomainObject;
import org.netbeans.modules.uml.codegen.dataaccess.xmlbeans.Family;
import org.netbeans.modules.uml.codegen.dataaccess.xmlbeans.TemplateFamilies;
import org.netbeans.modules.uml.codegen.dataaccess.xmlbeans.TemplateFamiliesHandler;
import org.netbeans.modules.uml.codegen.ui.DomainTreeNode;
import org.netbeans.modules.uml.codegen.ui.TemplatesTableRowPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class DomainTemplatesManagerPanel
extends JPanel
implements ActionListener,
TreeModelListener,
ListSelectionListener {
    private TemplateFamiliesHandler dataHandler = null;
    private boolean dirtyTreeExpand = false;
    private Map<String, Boolean> treeExpandState = new HashMap<String, Boolean>();
    private static final Icon DOMAIN_OBJECT_NODE_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/uml/resources/images/templates.png"));
    private static final Icon TEMPLATE_FAMILY_NODE_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/uml/resources/images/default-category.gif"));
    private static final String[] ELEMENT_TYPE_CHOICE_BUNDLE_KEYS = new String[]{"VAL_ElementType_NodeSelected", "VAL_ElementType_Class", "VAL_ElementType_Interface", "VAL_ElementType_Enumeration", "VAL_ElementType_Action", "VAL_ElementType_Component", "VAL_ElementType_Datatype", "VAL_ElementType_Invocation", "VAL_ElementType_Lifeline", "VAL_ElementType_Node", "VAL_ElementType_SimpleState", "VAL_ElementType_UseCase", "VAL_ElementType_AbortedFinalState", "VAL_ElementType_ActivityFinalNode", "VAL_ElementType_ChoicePseudoState", "VAL_ElementType_CombinedFragment", "VAL_ElementType_Comment", "VAL_ElementType_CompositeState", "VAL_ElementType_DataStore", "VAL_ElementType_Decision", "VAL_ElementType_DeepHistoryState", "VAL_ElementType_DeploymentSpecification", "VAL_ElementType_DerivationClassifier", "VAL_ElementType_EntryPointState", "VAL_ElementType_FinalState", "VAL_ElementType_FlowFinal", "VAL_ElementType_InitialNode", "VAL_ElementType_JunctionState", "VAL_ElementType_Package", "VAL_ElementType_ParameterUsage", "VAL_ElementType_ShallowHistoryState", "VAL_ElementType_Signal", "VAL_ElementType_SubmachineState"};
    private static final int ENABLE_ADD_REMOVE_BUTTONS = 0;
    private static final int ENABLE_ADD_BUTTON = 1;
    private static final int ENABLE_REMOVE_BUTTON = 2;
    private static final int DISABLE_ADD_REMOVE_BUTTONS = 3;
    private JButton addButton;
    private JButton addRowButton;
    private JLabel descriptionLabel;
    private JScrollPane descriptionScroll;
    private JTextArea descriptionTextArea;
    private JLabel domainTemplatesLabel;
    private JComboBox modelElementCombo;
    private JLabel modelElementLabel;
    private JButton modifyRowButton;
    private JLabel outputParamsLabel;
    private JButton removeButton;
    private JButton removeRowButton;
    private JLabel stereotypeLabel;
    private JTextField stereotypeText;
    private JPanel templatePropsPanel;
    private JTable templatesTable;
    private JScrollPane templatesTableScroll;
    private JTree templatesTree;
    private JPanel templatesTreePanel;
    private JScrollPane treeScroll;

    public DomainTemplatesManagerPanel() {
        this.initComponents();
        this.registerListeners();
        this.populateElementTypeChoices();
        this.populateTemplatesTreeValues(false);
        this.clearTemplatesTable();
        this.templatesTree.getSelectionModel().setSelectionMode(1);
        this.dirtyTreeExpand = false;
        this.enableTableModifyingButtons(false);
    }

    private void registerListeners() {
        this.addButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.addRowButton.addActionListener(this);
        this.modifyRowButton.addActionListener(this);
        this.removeRowButton.addActionListener(this);
    }

    private void populateElementTypeChoices() {
        for (String string : ELEMENT_TYPE_CHOICE_BUNDLE_KEYS) {
            this.modelElementCombo.addItem(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)string));
        }
    }

    private void populateTemplatesTreeValues(boolean bl) {
        this.enableTreeModifyingButtons(3);
        this.enableTemplatePropsFields(false);
        this.dataHandler = TemplateFamiliesHandler.getInstance(bl);
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode();
        defaultMutableTreeNode.setUserObject(new DomainTreeNode(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"LBL_TemplateFamilies")));
        DefaultTreeCellRenderer defaultTreeCellRenderer = (DefaultTreeCellRenderer)this.templatesTree.getCellRenderer();
        defaultTreeCellRenderer.setLeafIcon(DOMAIN_OBJECT_NODE_ICON);
        defaultTreeCellRenderer.setClosedIcon(TEMPLATE_FAMILY_NODE_ICON);
        defaultTreeCellRenderer.setOpenIcon(TEMPLATE_FAMILY_NODE_ICON);
        Family[] familyArray = this.dataHandler.getTemplateFamilies().getFamily();
        int n = 0;
        int n2 = familyArray.length;
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = new DefaultMutableTreeNode[n2];
        for (Family family : familyArray) {
            DomainObject[] domainObjectArray;
            String string = family.getName();
            DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode();
            defaultMutableTreeNode2.setUserObject(new DomainTreeNode(string, false, string, null));
            defaultMutableTreeNode.add(defaultMutableTreeNode2);
            defaultMutableTreeNodeArray[n] = null;
            if (Boolean.valueOf(family.isExpanded()).booleanValue()) {
                defaultMutableTreeNodeArray[n] = defaultMutableTreeNode2;
            }
            for (DomainObject domainObject : domainObjectArray = family.getDomainObject()) {
                DefaultMutableTreeNode defaultMutableTreeNode3 = null;
                String string2 = domainObject.getName();
                defaultMutableTreeNode3 = new DefaultMutableTreeNode();
                defaultMutableTreeNode3.setUserObject(new DomainTreeNode(string2, false, string, string2));
                defaultMutableTreeNode2.add(defaultMutableTreeNode3);
            }
            ++n;
        }
        this.templatesTree.setModel(new DefaultTreeModel(defaultMutableTreeNode));
        for (n = 0; n < n2; ++n) {
            if (defaultMutableTreeNodeArray[n] == null || defaultMutableTreeNodeArray[n].getChildCount() <= 0) continue;
            this.templatesTree.scrollPathToVisible(new TreePath(((DefaultMutableTreeNode)defaultMutableTreeNodeArray[n].getFirstChild()).getPath()));
        }
        this.templatesTree.getModel().addTreeModelListener(this);
    }

    public void store() {
        this.persistTreeExpandState();
        this.dataHandler.save();
    }

    public void load() {
        this.populateTemplatesTreeValues(false);
    }

    public void cancel() {
        this.dataHandler.reset();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Cancel")) {
            this.dataHandler.reset();
            this.persistTreeExpandState();
            this.dataHandler.save();
        } else if (string.equals("ADD")) {
            this.persistTreeExpandState();
            TemplateFamilies templateFamilies = this.dataHandler.getTemplateFamilies();
            Family[] familyArray = templateFamilies.getFamily();
            TreePath treePath = this.templatesTree.getSelectionPath();
            int n = this.templatesTree.getRowForPath(treePath);
            int n2 = 0;
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            String string2 = null;
            String string3 = null;
            boolean bl = false;
            switch (treePath.getPathCount()) {
                case 0: {
                    return;
                }
                case 1: {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPath()[0];
                    Family family = new Family();
                    family.setExpanded(Boolean.TRUE);
                    string3 = string2 = NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"LBL_DefaultFamilyName");
                    int n3 = 1;
                    while (!bl) {
                        if (templateFamilies.isUniqueFamilyName(string2)) {
                            bl = true;
                        } else {
                            string2 = string3 + n3;
                        }
                        ++n3;
                    }
                    n2 = familyArray.length;
                    family.setName(string2);
                    templateFamilies.addFamily(family);
                    ((DefaultTreeModel)this.templatesTree.getModel()).insertNodeInto(new DefaultMutableTreeNode(family.getName(), false), defaultMutableTreeNode, n2);
                    this.populateTemplatesTreeValues(false);
                    this.selectTreeNode(n2 + n, false);
                    break;
                }
                case 2: {
                    Family family = templateFamilies.getFamilyByName(treePath.getLastPathComponent().toString());
                    DomainObject[] domainObjectArray = family.getDomainObject();
                    defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPath()[1];
                    DomainObject domainObject = new DomainObject();
                    string3 = string2 = NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"LBL_DefaultDomainName");
                    int n4 = 1;
                    while (!bl) {
                        if (family.isUniqueDomainName(string2)) {
                            bl = true;
                        } else {
                            string2 = string3 + n4;
                        }
                        ++n4;
                    }
                    n2 = domainObjectArray.length;
                    domainObject.setName(string2);
                    family.addDomainObject(domainObject);
                    ((DefaultTreeModel)this.templatesTree.getModel()).insertNodeInto(new DefaultMutableTreeNode(domainObject.getName(), false), defaultMutableTreeNode, n2);
                    this.populateTemplatesTreeValues(false);
                    this.selectTreeNode(n2 + n, false);
                    break;
                }
                case 3: {
                    return;
                }
            }
        } else if (string.equals("REMOVE")) {
            TemplateFamilies templateFamilies = null;
            this.persistTreeExpandState();
            TreePath treePath = this.templatesTree.getSelectionPath();
            DefaultMutableTreeNode defaultMutableTreeNode = null;
            TreeNode treeNode = null;
            int n = this.templatesTree.getRowForPath(treePath);
            switch (treePath.getPathCount()) {
                case 0: 
                case 1: {
                    return;
                }
                case 2: {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPath()[1];
                    treeNode = defaultMutableTreeNode.getParent();
                    templateFamilies = this.dataHandler.getTemplateFamilies();
                    templateFamilies.removeFamily(templateFamilies.getFamilyByName(defaultMutableTreeNode.toString()));
                    ((DefaultTreeModel)this.templatesTree.getModel()).removeNodeFromParent(defaultMutableTreeNode);
                    this.populateTemplatesTreeValues(false);
                    this.selectTreeNode(n, true);
                    break;
                }
                case 3: {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getPath()[2];
                    treeNode = defaultMutableTreeNode.getParent();
                    templateFamilies = this.dataHandler.getTemplateFamilies();
                    Family family = templateFamilies.getFamilyByName(treeNode.toString());
                    family.removeDomainObject(family.getDomainByName(defaultMutableTreeNode.toString()));
                    ((DefaultTreeModel)this.templatesTree.getModel()).removeNodeFromParent(defaultMutableTreeNode);
                    this.populateTemplatesTreeValues(false);
                    this.selectTreeNode(n, true);
                }
            }
        } else if (string.equals("ADD_ROW")) {
            this.displayTemplatesRowPanel(true);
            this.templatesTable.setFocusable(true);
            int n = this.templatesTable.getRowCount() - 1;
            this.templatesTable.getSelectionModel().setSelectionInterval(n, n);
            this.updateOutputParametersTable();
            this.enableTableModifyingButtons(true);
        } else if (string.equals("MODIFY_ROW")) {
            if (this.templatesTable.getSelectedRow() == -1) {
                this.enableTableModifyingButtons(false);
            } else {
                this.displayTemplatesRowPanel(false);
                this.templatesTable.setFocusable(true);
            }
            this.updateOutputParametersTable();
        } else if (string.equals("REMOVE_ROW")) {
            int n = this.templatesTable.getSelectedRow();
            if (n == -1) {
                this.enableTableModifyingButtons(false);
            } else {
                ((DefaultTableModel)this.templatesTable.getModel()).removeRow(this.templatesTable.getSelectedRow());
                this.templatesTable.setFocusable(true);
                if (n > 0) {
                    --n;
                }
                if (this.templatesTable.getRowCount() > 0) {
                    this.templatesTable.getSelectionModel().setSelectionInterval(n, n);
                    this.enableTableModifyingButtons(true);
                } else {
                    this.enableTableModifyingButtons(false);
                }
            }
            this.updateOutputParametersTable();
        }
    }

    private void selectTreeNode(int n, boolean bl) {
        n = bl ? (n >= this.templatesTree.getRowCount() ? this.templatesTree.getRowCount() - 1 : --n) : ++n;
        this.templatesTree.scrollRowToVisible(n);
        this.templatesTree.setSelectionRow(n);
        this.templatesTree.requestFocusInWindow();
    }

    private boolean displayTemplatesRowPanel(boolean bl) {
        TemplatesTableRowPanel templatesTableRowPanel = null;
        DefaultTableModel defaultTableModel = (DefaultTableModel)this.templatesTable.getModel();
        int n = this.templatesTable.getSelectedRow();
        templatesTableRowPanel = bl ? new TemplatesTableRowPanel() : new TemplatesTableRowPanel((String)defaultTableModel.getValueAt(n, 0), (String)defaultTableModel.getValueAt(n, 1), (String)defaultTableModel.getValueAt(n, 2), (String)defaultTableModel.getValueAt(n, 3));
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)templatesTableRowPanel, NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"LBL_TemplatesTableRowDialogTitle"), true, 2, NotifyDescriptor.OK_OPTION, 0, null, (ActionListener)templatesTableRowPanel);
        templatesTableRowPanel.requestFocus();
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == NotifyDescriptor.OK_OPTION) {
            if (bl) {
                defaultTableModel.addRow(new String[]{templatesTableRowPanel.getFilenameFormat(), templatesTableRowPanel.getExtension(), templatesTableRowPanel.getFolder(), templatesTableRowPanel.getTemplateFilename()});
            } else {
                defaultTableModel.setValueAt(templatesTableRowPanel.getFilenameFormat(), n, 0);
                defaultTableModel.setValueAt(templatesTableRowPanel.getExtension(), n, 1);
                defaultTableModel.setValueAt(templatesTableRowPanel.getFolder(), n, 2);
                defaultTableModel.setValueAt(templatesTableRowPanel.getTemplateFilename(), n, 3);
            }
            return true;
        }
        return false;
    }

    private void initComponents() {
        this.templatesTreePanel = new JPanel();
        this.treeScroll = new JScrollPane();
        this.templatesTree = new JTree();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.templatePropsPanel = new JPanel();
        this.modelElementLabel = new JLabel();
        this.modelElementCombo = new JComboBox();
        this.stereotypeLabel = new JLabel();
        this.stereotypeText = new JTextField();
        this.descriptionLabel = new JLabel();
        this.descriptionScroll = new JScrollPane();
        this.descriptionTextArea = new JTextArea();
        this.templatesTableScroll = new JScrollPane();
        this.templatesTable = new JTable();
        this.addRowButton = new JButton();
        this.modifyRowButton = new JButton();
        this.removeRowButton = new JButton();
        this.outputParamsLabel = new JLabel();
        this.domainTemplatesLabel = new JLabel();
        this.templatesTree.setAutoscrolls(true);
        this.templatesTree.setEditable(true);
        this.templatesTree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                DomainTemplatesManagerPanel.this.templatesTreeValueChanged(treeSelectionEvent);
            }
        });
        this.treeScroll.setViewportView(this.templatesTree);
        this.templatesTree.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSN_DomainTemplatesTree"));
        this.templatesTree.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSD_DomainTemplatesTree"));
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"BTN_Add"));
        this.addButton.setActionCommand("ADD");
        this.addButton.setMargin(new Insets(2, 10, 2, 10));
        this.addButton.setMaximumSize(new Dimension(133, 25));
        this.addButton.setMinimumSize(new Dimension(79, 25));
        this.addButton.setPreferredSize(new Dimension(79, 25));
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"BTN_Remove"));
        this.removeButton.setActionCommand("REMOVE");
        this.removeButton.setMargin(new Insets(2, 10, 2, 10));
        this.removeButton.setMaximumSize(new Dimension(133, 25));
        GroupLayout groupLayout = new GroupLayout((Container)this.templatesTreePanel);
        this.templatesTreePanel.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(1, 1, 1).add((Component)this.addButton, -1, 110, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.removeButton, -2, 68, Short.MAX_VALUE)).add(2, (Component)this.treeScroll, -1, 185, Short.MAX_VALUE)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.treeScroll, -1, 322, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.addButton, -2, -1, -2).add((Component)this.removeButton, -2, -1, -2)).addContainerGap()));
        this.addButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSN_AddButton"));
        this.addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSD_AddButton"));
        this.removeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSN_RemoveButton"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSD_RemoveButton"));
        this.modelElementLabel.setLabelFor(this.modelElementCombo);
        Mnemonics.setLocalizedText((JLabel)this.modelElementLabel, (String)NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"LBL_Model_Element"));
        this.modelElementCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                DomainTemplatesManagerPanel.this.modelElementComboItemStateChanged(itemEvent);
            }
        });
        this.stereotypeLabel.setLabelFor(this.stereotypeText);
        Mnemonics.setLocalizedText((JLabel)this.stereotypeLabel, (String)NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"LBL_Stereotype"));
        this.stereotypeText.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                DomainTemplatesManagerPanel.this.stereotypeTextKeyReleased(keyEvent);
            }
        });
        this.descriptionLabel.setLabelFor(this.descriptionTextArea);
        Mnemonics.setLocalizedText((JLabel)this.descriptionLabel, (String)NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"LBL_Description"));
        this.descriptionTextArea.setColumns(20);
        this.descriptionTextArea.setLineWrap(true);
        this.descriptionTextArea.setRows(2);
        this.descriptionTextArea.setTabSize(4);
        this.descriptionTextArea.setWrapStyleWord(true);
        this.descriptionTextArea.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                DomainTemplatesManagerPanel.this.descriptionTextAreaKeyReleased(keyEvent);
            }
        });
        this.descriptionScroll.setViewportView(this.descriptionTextArea);
        this.descriptionTextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSN_Description"));
        this.descriptionTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSD_Description"));
        this.templatesTableScroll.setBorder(null);
        this.templatesTable.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}}, new String[]{"Filename Format", "Extension", "Folder Path", "Template File"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class, String.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int n) {
                return this.types[n];
            }

            public boolean isCellEditable(int n, int n2) {
                return this.canEdit[n2];
            }
        });
        this.templatesTable.setNextFocusableComponent(this.addRowButton);
        this.templatesTable.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                DomainTemplatesManagerPanel.this.templatesTableFocusGained(focusEvent);
            }

            public void focusLost(FocusEvent focusEvent) {
                DomainTemplatesManagerPanel.this.templatesTableFocusLost(focusEvent);
            }
        });
        this.templatesTableScroll.setViewportView(this.templatesTable);
        this.templatesTable.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSN_OutputParameters"));
        this.templatesTable.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSD_OutputParameters"));
        Mnemonics.setLocalizedText((AbstractButton)this.addRowButton, (String)NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"BTN_Add_Row"));
        this.addRowButton.setActionCommand("ADD_ROW");
        this.addRowButton.setMargin(new Insets(2, 10, 2, 10));
        Mnemonics.setLocalizedText((AbstractButton)this.modifyRowButton, (String)NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"BTN_Modify_Row"));
        this.modifyRowButton.setActionCommand("MODIFY_ROW");
        this.modifyRowButton.setMargin(new Insets(2, 10, 2, 10));
        this.modifyRowButton.setMaximumSize(new Dimension(133, 25));
        this.modifyRowButton.setPreferredSize(new Dimension(125, 25));
        Mnemonics.setLocalizedText((AbstractButton)this.removeRowButton, (String)NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"BTN_Remove_Row"));
        this.removeRowButton.setActionCommand("REMOVE_ROW");
        this.removeRowButton.setMargin(new Insets(2, 10, 2, 10));
        this.removeRowButton.setMaximumSize(new Dimension(133, 25));
        this.removeRowButton.setPreferredSize(new Dimension(125, 25));
        this.outputParamsLabel.setLabelFor(this.templatesTable);
        Mnemonics.setLocalizedText((JLabel)this.outputParamsLabel, (String)NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"LBL_Templates"));
        GroupLayout groupLayout2 = new GroupLayout((Container)this.templatePropsPanel);
        this.templatePropsPanel.setLayout((LayoutManager)groupLayout2);
        groupLayout2.setHorizontalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add(2, (Component)this.templatesTableScroll, -1, 549, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.stereotypeLabel).add((Component)this.modelElementLabel).add((Component)this.descriptionLabel)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.stereotypeText, -1, 476, Short.MAX_VALUE).add((Component)this.modelElementCombo, 0, 476, Short.MAX_VALUE).add((Component)this.descriptionScroll, -1, 476, Short.MAX_VALUE))).add((Component)this.outputParamsLabel, -1, 549, Short.MAX_VALUE).add(2, (GroupLayout.Group)groupLayout2.createSequentialGroup().addContainerGap().add((Component)this.addRowButton, -1, 199, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.modifyRowButton, -1, 164, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.removeRowButton, -1, 164, Short.MAX_VALUE))).addContainerGap()));
        groupLayout2.setVerticalGroup((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((GroupLayout.Group)groupLayout2.createSequentialGroup().add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.modelElementLabel).add((Component)this.modelElementCombo, -2, -1, -2)).add(7, 7, 7).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.stereotypeLabel).add((Component)this.stereotypeText, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)groupLayout2.createParallelGroup(1).add((Component)this.descriptionLabel).add((Component)this.descriptionScroll, -2, 82, -2)).addPreferredGap(1).add((Component)this.outputParamsLabel).addPreferredGap(0).add((Component)this.templatesTableScroll, -2, 141, -2).addPreferredGap(1).add((GroupLayout.Group)groupLayout2.createParallelGroup(3).add((Component)this.removeRowButton, -2, -1, -2).add((Component)this.modifyRowButton, -2, -1, -2).add((Component)this.addRowButton)).addContainerGap(25, Short.MAX_VALUE)));
        this.modelElementCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSN_ElementType"));
        this.modelElementCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSD_ElementType"));
        this.stereotypeText.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSD_Stereotype"));
        this.stereotypeText.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSD_Stereotype"));
        this.addRowButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSN_AddTemplateRow"));
        this.addRowButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSD_AddTemplateRowButton"));
        this.modifyRowButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSN_EditTemplateRowButton"));
        this.modifyRowButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSD_EditTemplateRowButton"));
        this.removeRowButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSN_RemoveTemplateRow"));
        this.removeRowButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSD_RemoveTemplateRow"));
        this.outputParamsLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSD_OutputParameters"));
        this.domainTemplatesLabel.setLabelFor(this.templatesTree);
        Mnemonics.setLocalizedText((JLabel)this.domainTemplatesLabel, (String)NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"LBL_DomainObjects_PanelTitle"));
        GroupLayout groupLayout3 = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout3);
        groupLayout3.setHorizontalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().add((Component)this.templatesTreePanel, -1, -1, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.templatePropsPanel, -1, -1, Short.MAX_VALUE)).add((Component)this.domainTemplatesLabel)).addContainerGap()));
        groupLayout3.setVerticalGroup((GroupLayout.Group)groupLayout3.createParallelGroup(1).add((GroupLayout.Group)groupLayout3.createSequentialGroup().addContainerGap().add((Component)this.domainTemplatesLabel).addPreferredGap(0).add((GroupLayout.Group)groupLayout3.createParallelGroup(2, false).add(1, (Component)this.templatePropsPanel, -1, -1, Short.MAX_VALUE).add(1, (Component)this.templatesTreePanel, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSN_TemplatesOptionsPanel"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"ACSD_TemplatesOptionPanel"));
    }

    private void modelElementComboItemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() != this.modelElementCombo || this.modelElementCombo.getSelectedItem() == null || this.templatesTree == null || this.templatesTree.getSelectionPath() == null || this.templatesTree.getSelectionPath().getPathCount() != 3) {
            return;
        }
        TemplateFamilies templateFamilies = this.dataHandler.getTemplateFamilies();
        String string = this.templatesTree.getSelectionPath().getParentPath().getLastPathComponent().toString();
        String string2 = this.templatesTree.getSelectionPath().getLastPathComponent().toString();
        templateFamilies.getFamilyByName(string).getDomainByName(string2).setModelElement(this.modelElementCombo.getSelectedItem().toString());
    }

    private void templatesTableFocusGained(FocusEvent focusEvent) {
        this.enableTableModifyingButtons(true);
    }

    private void templatesTableFocusLost(FocusEvent focusEvent) {
        if (focusEvent.getOppositeComponent() != this.addRowButton && focusEvent.getOppositeComponent() != this.modifyRowButton && focusEvent.getOppositeComponent() != this.removeRowButton) {
            this.templatesTable.getSelectionModel().clearSelection();
            this.enableTableModifyingButtons(false);
        }
    }

    private void templatesTreeValueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (treeSelectionEvent.getOldLeadSelectionPath() != null && treeSelectionEvent.getOldLeadSelectionPath().getPathCount() > 2) {
            this.updateTreeModel(treeSelectionEvent.getOldLeadSelectionPath().getPath()[1].toString(), treeSelectionEvent.getOldLeadSelectionPath().getPath()[2].toString());
        }
        switch (treeSelectionEvent.getPath().getPathCount()) {
            case 0: {
                this.enableTreeModifyingButtons(3);
                this.enableTableModifyingButtons(false);
                this.clearTemplateProps();
                this.clearTemplatesTable();
                this.enableTemplatesTable(false);
                break;
            }
            case 1: {
                this.enableTreeModifyingButtons(1);
                this.enableTableModifyingButtons(false);
                this.clearTemplateProps();
                this.clearTemplatesTable();
                this.enableTemplatesTable(false);
                break;
            }
            case 2: {
                this.enableTreeModifyingButtons(0);
                this.clearTemplateProps();
                this.clearTemplatesTable();
                this.enableTemplatesTable(false);
                this.enableTableModifyingButtons(false);
                break;
            }
            case 3: {
                String string = null;
                String string2 = null;
                if (treeSelectionEvent.getNewLeadSelectionPath() != null) {
                    string = treeSelectionEvent.getNewLeadSelectionPath().getParentPath().getLastPathComponent().toString();
                    string2 = treeSelectionEvent.getNewLeadSelectionPath().getLastPathComponent().toString();
                } else if (this.templatesTree.getSelectionPath() != null) {
                    string = this.templatesTree.getSelectionPath().getParentPath().getLastPathComponent().toString();
                    string2 = this.templatesTree.getSelectionPath().getLastPathComponent().toString();
                }
                this.enableTreeModifyingButtons(2);
                this.enableTableModifyingButtons(true);
                this.enableTemplatesTable(true);
                this.populateTemplateProps(string, string2);
            }
        }
    }

    private void stereotypeTextKeyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource() != this.stereotypeText || this.templatesTree == null || this.templatesTree.getSelectionPath() == null || this.templatesTree.getSelectionPath().getPathCount() != 3) {
            return;
        }
        TemplateFamilies templateFamilies = this.dataHandler.getTemplateFamilies();
        String string = this.templatesTree.getSelectionPath().getParentPath().getLastPathComponent().toString();
        String string2 = this.templatesTree.getSelectionPath().getLastPathComponent().toString();
        templateFamilies.getFamilyByName(string).getDomainByName(string2).setStereotype(this.stereotypeText.getText());
    }

    private void descriptionTextAreaKeyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource() != this.descriptionTextArea || this.templatesTree == null || this.templatesTree.getSelectionPath() == null || this.templatesTree.getSelectionPath().getPathCount() != 3) {
            return;
        }
        TemplateFamilies templateFamilies = this.dataHandler.getTemplateFamilies();
        String string = this.templatesTree.getSelectionPath().getParentPath().getLastPathComponent().toString();
        String string2 = this.templatesTree.getSelectionPath().getLastPathComponent().toString();
        templateFamilies.getFamilyByName(string).getDomainByName(string2).setDescription(this.descriptionTextArea.getText());
    }

    private void updateOutputParametersTable() {
        if (this.templatesTree == null || this.templatesTree.getSelectionPath() == null || this.templatesTree.getSelectionPath().getPathCount() != 3) {
            return;
        }
        TemplateFamilies templateFamilies = this.dataHandler.getTemplateFamilies();
        String string = this.templatesTree.getSelectionPath().getParentPath().getLastPathComponent().toString();
        String string2 = this.templatesTree.getSelectionPath().getLastPathComponent().toString();
        templateFamilies.getFamilyByName(string).getDomainByName(string2).updateTemplates((DefaultTableModel)this.templatesTable.getModel());
    }

    private void updateTreeModel(String string, String string2) {
        DomainObject domainObject = this.dataHandler.getTemplateFamilies().getFamilyByName(string).getDomainByName(string2);
        if (domainObject != null) {
            domainObject.setModelElement(this.modelElementCombo.getSelectedItem() == null ? null : this.modelElementCombo.getSelectedItem().toString());
            domainObject.setStereotype(this.stereotypeText.getText());
            domainObject.setDescription(this.descriptionTextArea.getText());
            domainObject.updateTemplates((DefaultTableModel)this.templatesTable.getModel());
        }
    }

    private void enableTreeModifyingButtons(int n) {
        switch (n) {
            case 0: {
                this.addButton.setEnabled(true);
                this.removeButton.setEnabled(true);
                break;
            }
            case 1: {
                this.addButton.setEnabled(true);
                this.removeButton.setEnabled(false);
                break;
            }
            case 2: {
                this.addButton.setEnabled(false);
                this.removeButton.setEnabled(true);
                break;
            }
            case 3: {
                this.addButton.setEnabled(false);
                this.removeButton.setEnabled(false);
            }
        }
    }

    private void enableTableModifyingButtons(boolean bl) {
        boolean bl2 = bl;
        if (bl2) {
            bl2 = this.templatesTable.getSelectedRowCount() != 0;
        }
        this.addRowButton.setEnabled(true);
        this.modifyRowButton.setEnabled(bl2);
        this.removeRowButton.setEnabled(bl2);
    }

    private void clearTemplateProps() {
        this.enableTemplatePropsFields(false);
        this.modelElementCombo.setSelectedIndex(0);
        this.stereotypeText.setText("");
        this.descriptionTextArea.setText("");
    }

    private void populateTemplateProps(String string, String string2) {
        if (string == null || string2 == null) {
            this.enableTemplatePropsFields(false);
            this.clearTemplateProps();
            this.clearTemplatesTable();
            return;
        }
        DomainObject domainObject = this.dataHandler.getTemplateFamilies().getFamilyByName(string).getDomainByName(string2);
        if (domainObject != null) {
            this.enableTemplatePropsFields(true);
            this.modelElementCombo.setSelectedItem(domainObject.getModelElement());
            this.stereotypeText.setText(domainObject.getStereotype());
            this.descriptionTextArea.setText(domainObject.getDescription());
            this.populateTemplatesTable(domainObject.getTemplatesTableData());
        }
    }

    private void enableTemplatePropsFields(boolean bl) {
        this.templatePropsPanel.setEnabled(bl);
        this.modelElementCombo.setEnabled(bl);
        this.stereotypeText.setEnabled(bl);
        this.descriptionTextArea.setEnabled(bl);
        this.templatesTableScroll.setEnabled(bl);
        this.templatesTable.setEnabled(bl);
        this.enableTemplatesTable(bl);
    }

    private void populateTemplatesTable(String[][] stringArray) {
        DefaultTableModel defaultTableModel = stringArray != null ? new TemplateTableModel(stringArray) : new DefaultTableModel();
        this.templatesTable.setModel(defaultTableModel);
    }

    private void clearTemplatesTable() {
        this.populateTemplatesTable(new String[0][4]);
    }

    private void enableTemplatesTable(boolean bl) {
        this.templatesTableScroll.setEnabled(bl);
        this.templatesTable.setEnabled(bl);
    }

    private void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        if (treeExpansionEvent.getPath().getPathCount() == 1) {
            return;
        }
        this.setNodeExpandedState(((DefaultMutableTreeNode)treeExpansionEvent.getPath().getLastPathComponent()).toString(), true);
    }

    private void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        if (treeExpansionEvent.getPath().getPathCount() == 1) {
            return;
        }
        this.setNodeExpandedState(((DefaultMutableTreeNode)treeExpansionEvent.getPath().getLastPathComponent()).getUserObject().toString(), false);
    }

    private void setNodeExpandedState(String string, boolean bl) {
        this.dirtyTreeExpand = true;
        this.treeExpandState.put(string, bl);
        this.dataHandler.getTemplateFamilies().getFamilyByName(string).setExpanded(bl);
    }

    private void persistTreeExpandState() {
        if (!this.dirtyTreeExpand) {
            return;
        }
        TemplateFamilies templateFamilies = this.dataHandler.getTemplateFamilies();
        Set<String> set = this.treeExpandState.keySet();
        for (String string : set) {
            Boolean bl = this.treeExpandState.get(string);
            if (bl != null) {
                Family family = templateFamilies.getFamilyByName(string);
                if (family == null) continue;
                family.setExpanded(bl);
                continue;
            }
            this.treeExpandState.remove(string);
        }
        this.dirtyTreeExpand = false;
    }

    public void treeNodesInserted(TreeModelEvent treeModelEvent) {
    }

    public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
    }

    public void treeStructureChanged(TreeModelEvent treeModelEvent) {
    }

    public void treeNodesChanged(TreeModelEvent treeModelEvent) {
        TemplateFamilies templateFamilies = this.dataHandler.getTemplateFamilies();
        int n = treeModelEvent.getChildIndices()[0];
        String string = ((DefaultMutableTreeNode)treeModelEvent.getChildren()[0]).getUserObject().toString();
        if (treeModelEvent.getPath().length == 0) {
            ((DefaultMutableTreeNode)treeModelEvent.getChildren()[0]).setUserObject(NbBundle.getMessage(DomainTemplatesManagerPanel.class, (String)"LBL_TemplateFamilies"));
        } else if (treeModelEvent.getPath().length == 1) {
            String string2 = templateFamilies.getFamily()[n].getName();
            if (!string.equals(string2) && templateFamilies.isUniqueFamilyName(string)) {
                templateFamilies.getFamily()[n].setName(string);
            } else {
                ((DefaultMutableTreeNode)treeModelEvent.getChildren()[0]).setUserObject(string2);
            }
        } else if (treeModelEvent.getPath().length == 2) {
            String string3 = treeModelEvent.getPath()[1].toString();
            Family family = templateFamilies.getFamilyByName(string3);
            String string4 = family.getDomainObject()[n].getName();
            if (!string.equals(string4) && family.isUniqueDomainName(string)) {
                templateFamilies.getFamilyByName(string3).getDomainObject()[n].setName(string);
            } else {
                ((DefaultMutableTreeNode)treeModelEvent.getChildren()[0]).setUserObject(string4);
            }
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableTableModifyingButtons(this.templatesTable.getSelectedRowCount() > 0);
    }
}

