/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.uml.codegen.ui.customizer;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.netbeans.modules.uml.codegen.ui.customizer.TabbedPanelModel;

public class TabbedPanel
extends JPanel {
    public static int EXPAND_ONE = 1;
    public static int EXPAND_SOME = 2;
    public static int EXPAND_ALL = 3;
    public ImageIcon expanded;
    public ImageIcon collapsed;
    private static Color bColor = new Color(Math.max((int)((double)SystemColor.control.getRed() * 0.9), 0), Math.max((int)((double)SystemColor.control.getGreen() * 0.9), 0), Math.max((int)((double)SystemColor.control.getBlue() * 0.9), 0));
    private TabbedPanelModel model;
    private int selectedIndex = -1;
    private Set<Integer> selectedIndexes = new HashSet<Integer>();
    private int expansionPolicy;
    private boolean fill;
    private JComponent selectedComponent;
    private JComponent[] titles;
    private Vector<ActionListener> listeners = new Vector();
    private Listener listener = new Listener();

    public TabbedPanel(TabbedPanelModel tabbedPanelModel, int n, boolean bl) {
        this.model = tabbedPanelModel;
        this.expansionPolicy = n;
        this.fill = bl;
        this.addKeyListener(this.listener);
        this.refreshPanels();
        this.setBorder(new LineBorder(new Color(127, 157, 185)));
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.expanded = new ImageIcon(classLoader.getResource("org/netbeans/modules/uml/codegen/resources/expanded.gif"));
        this.collapsed = new ImageIcon(classLoader.getResource("org/netbeans/modules/uml/codegen/resources/collapsed.gif"));
    }

    public int getExpansionPolicy() {
        return this.expansionPolicy;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public boolean isExpanded(int n) {
        if (n == this.selectedIndex) {
            return true;
        }
        return this.selectedIndexes.contains(new Integer(n));
    }

    public void setSelectedIndex(int n) {
        int n2;
        int n3 = n2 = n >= 0 ? n : this.selectedIndex;
        if (this.expansionPolicy == EXPAND_ALL) {
            Integer n4 = new Integer(n);
            if (!this.selectedIndexes.remove(n4)) {
                this.selectedIndexes.add(n4);
            }
        } else {
            this.selectedIndex = n;
        }
        this.refreshPanels();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (n2 >= 0) {
                    TabbedPanel.this.titles[n2].requestFocus();
                }
            }
        });
    }

    public JComponent getSelectedComponent() {
        return this.selectedComponent;
    }

    public String getSelectedCategory() {
        int n = this.getSelectedIndex();
        if (n < 0) {
            return null;
        }
        return (String)this.model.getCategories().get(n);
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.remove(actionListener);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        Vector vector = (Vector)this.listeners.clone();
        Iterator iterator = vector.iterator();
        while (iterator.hasNext()) {
            ((ActionListener)iterator.next()).actionPerformed(actionEvent);
        }
    }

    public void refreshPanels() {
        Object object;
        this.removeAll();
        this.selectedComponent = null;
        if (this.expansionPolicy == EXPAND_ONE && this.selectedIndex < 0) {
            this.selectedIndex = 0;
        }
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 1;
        List list = this.model.getCategories();
        int n = list.size();
        boolean bl = true;
        this.titles = new JComponent[n];
        for (int i = 0; i < n; ++i) {
            object = (String)list.get(i);
            JComponent jComponent = this.createTitleComponent((String)object, this.model.getToolTip((String)object), i);
            this.add((Component)jComponent, gridBagConstraints);
            this.titles[i] = jComponent;
            if ((this.expansionPolicy != EXPAND_ALL || !this.selectedIndexes.contains(new Integer(i))) && i != this.selectedIndex) continue;
            this.selectedComponent = this.model.getPanel((String)list.get(i));
            this.add((Component)this.selectedComponent, gridBagConstraints);
        }
        gridBagConstraints.weighty = 1.0;
        object = new JPanel();
        ((JComponent)object).setOpaque(false);
        this.add((Component)object, gridBagConstraints);
        this.revalidate();
        this.repaint();
        this.fireActionPerformed(new ActionEvent(this, 0, "selectedIndex"));
    }

    protected JComponent createTitleComponent(String string, String string2, int n) {
        JLabel jLabel = new JLabel(string, n == this.selectedIndex ? this.expanded : this.collapsed, 2);
        jLabel.setFont(jLabel.getFont().deriveFont(1));
        jLabel.setBackground(bColor);
        jLabel.setOpaque(true);
        jLabel.putClientProperty("index", new Integer(n));
        jLabel.addMouseListener(this.listener);
        jLabel.setBorder(new EmptyBorder(1, 1, 1, 1));
        jLabel.setCursor(Cursor.getPredefinedCursor(12));
        return jLabel;
    }

    private class Listener
    implements ActionListener,
    KeyListener,
    MouseListener {
        private Listener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AbstractButton abstractButton = (AbstractButton)actionEvent.getSource();
            int n = (Integer)abstractButton.getClientProperty("index");
            if (n == TabbedPanel.this.selectedIndex) {
                TabbedPanel.this.setSelectedIndex(-1);
            } else {
                TabbedPanel.this.setSelectedIndex(n);
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
        }

        public void keyPressed(KeyEvent keyEvent) {
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (!(mouseEvent.getSource() instanceof JLabel)) {
                return;
            }
            JLabel jLabel = (JLabel)mouseEvent.getSource();
            int n = (Integer)jLabel.getClientProperty("index");
            if (n == TabbedPanel.this.selectedIndex) {
                if (TabbedPanel.this.expansionPolicy != EXPAND_ONE) {
                    TabbedPanel.this.setSelectedIndex(-1);
                }
            } else {
                TabbedPanel.this.setSelectedIndex(n);
            }
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            if (!(mouseEvent.getSource() instanceof JLabel)) {
                return;
            }
            JLabel jLabel = (JLabel)mouseEvent.getSource();
            jLabel.setBackground(SystemColor.control);
            TabbedPanel.this.revalidate();
            TabbedPanel.this.repaint();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            if (!(mouseEvent.getSource() instanceof JLabel)) {
                return;
            }
            JLabel jLabel = (JLabel)mouseEvent.getSource();
            jLabel.setBackground(bColor);
            TabbedPanel.this.revalidate();
            TabbedPanel.this.repaint();
        }
    }
}

