/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.css.editor.model.CssModel;
import org.netbeans.modules.css.editor.model.CssRule;
import org.netbeans.modules.css.editor.model.CssRuleItem;
import org.netbeans.modules.css.visual.api.CssRuleContext;
import org.netbeans.modules.css.visual.api.StyleBuilderTopComponent;
import org.netbeans.modules.css.visual.ui.preview.CssPreviewTopComponent;
import org.netbeans.modules.css.visual.ui.preview.CssPreviewable;
import org.netbeans.modules.editor.NbEditorDocument;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;

public class CssEditorSupport {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private CssRule selected = null;
    private List<CssPreviewable.Listener> previewableListeners = new ArrayList<CssPreviewable.Listener>();
    private static final Logger LOGGER = Logger.getLogger("css.visual");
    private static final int RULE_UPDATE_DELAY = 100;
    private final PaneAwareRunnable RULE_UPDATE = new PaneAwareRunnable();
    private final RequestProcessor.Task RULE_UPDATE_TASK = RequestProcessor.getDefault().create((Runnable)this.RULE_UPDATE);
    private static CssEditorSupport INSTANCE;
    private TopComponent current;
    private JEditorPane editorPane;
    private Document document;
    private FileObject fileObject;
    private CssModel model;
    private boolean caretListenerRegistered = false;
    private static final boolean DEBUG;
    private PropertyChangeListener CSS_STYLE_DATA_LISTENER = new PropertyChangeListener(){

        public void propertyChange(final PropertyChangeEvent propertyChangeEvent) {
            final NbEditorDocument nbEditorDocument = (NbEditorDocument)CssEditorSupport.this.document;
            if (nbEditorDocument != null) {
                nbEditorDocument.runAtomic(new Runnable(){

                    public void run() {
                        block11: {
                            CssRuleItem cssRuleItem = (CssRuleItem)propertyChangeEvent.getOldValue();
                            CssRuleItem cssRuleItem2 = (CssRuleItem)propertyChangeEvent.getNewValue();
                            if (CssEditorSupport.this.selected == null) {
                                throw new IllegalStateException("CssRuleContent event fired, but selected rule is null!");
                            }
                            CssRule cssRule = CssEditorSupport.this.selected;
                            try {
                                if (cssRuleItem != null && cssRuleItem2 == null) {
                                    int n;
                                    int n2;
                                    int n3;
                                    int n4 = cssRuleItem.key().offset();
                                    int n5 = Utilities.getRowStart((BaseDocument)nbEditorDocument, (int)n4);
                                    if (n5 <= (n3 = cssRule.getRuleOpenBracketOffset())) {
                                        n5 = n3 + 1;
                                    }
                                    if ((n2 = Utilities.getRowEnd((BaseDocument)nbEditorDocument, (int)n4) + LINE_SEPARATOR.length()) > (n = cssRule.getRuleCloseBracketOffset())) {
                                        n2 = n;
                                    }
                                    nbEditorDocument.remove(n5, n2 - n5);
                                    break block11;
                                }
                                if (cssRuleItem == null && cssRuleItem2 != null) {
                                    List list = cssRule.ruleContent().ruleItems();
                                    int n = nbEditorDocument.getFormatter().getShiftWidth();
                                    boolean bl = false;
                                    if (!list.isEmpty()) {
                                        CssRuleItem cssRuleItem3 = (CssRuleItem)list.get(list.size() - 1);
                                        if (cssRuleItem3.semicolonOffset() == -1) {
                                            nbEditorDocument.insertString(cssRuleItem3.value().offset() + cssRuleItem3.value().name().trim().length(), ";", null);
                                        }
                                        bl = Utilities.getLineOffset((BaseDocument)nbEditorDocument, (int)cssRule.getRuleCloseBracketOffset()) == Utilities.getLineOffset((BaseDocument)nbEditorDocument, (int)cssRuleItem3.key().offset());
                                    } else {
                                        bl = Utilities.getLineOffset((BaseDocument)nbEditorDocument, (int)cssRule.getRuleCloseBracketOffset()) == Utilities.getLineOffset((BaseDocument)nbEditorDocument, (int)cssRule.getRuleOpenBracketOffset());
                                    }
                                    int n6 = cssRule.getRuleCloseBracketOffset();
                                    String string = (bl ? LINE_SEPARATOR : "") + CssEditorSupport.this.makeIndentString(n) + cssRuleItem2.key().name() + ": " + cssRuleItem2.value().name() + ";" + LINE_SEPARATOR;
                                    nbEditorDocument.insertString(n6, string, null);
                                    break block11;
                                }
                                if (cssRuleItem != null && cssRuleItem2 != null) {
                                    nbEditorDocument.remove(cssRuleItem.key().offset(), cssRuleItem.key().name().length());
                                    nbEditorDocument.insertString(cssRuleItem.key().offset(), cssRuleItem2.key().name(), null);
                                    int n = cssRuleItem2.key().name().length() - cssRuleItem.key().name().length();
                                    nbEditorDocument.remove(cssRuleItem.value().offset() + n, cssRuleItem.value().name().length());
                                    nbEditorDocument.insertString(cssRuleItem.value().offset() + n, cssRuleItem2.value().name(), null);
                                    break block11;
                                }
                                throw new IllegalArgumentException("Invalid PropertyChangeEvent - both old and new values are null!");
                            }
                            catch (Throwable throwable) {
                                throwable.printStackTrace();
                            }
                        }
                    }
                });
            }
        }
    };
    private final PropertyChangeListener MODEL_LISTENER = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName().equals("modelUpdated")) {
                CssEditorSupport.this.d("model updated");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (CssEditorSupport.this.editorPane == null) {
                            return;
                        }
                        CssEditorSupport.this.d("model updated from AWT");
                        CssEditorSupport.this.updateSelectedRule(CssEditorSupport.this.editorPane.getCaret().getDot());
                        if (!CssEditorSupport.this.caretListenerRegistered) {
                            CssEditorSupport.this.editorPane.addCaretListener(CssEditorSupport.this.CARET_LISTENER);
                            CssEditorSupport.this.d("added caret listener");
                            CssEditorSupport.this.caretListenerRegistered = true;
                        }
                    }
                });
            } else {
                final boolean bl = propertyChangeEvent.getPropertyName().equals("modelInvalid");
                CssEditorSupport.this.d("model invalid");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (CssEditorSupport.this.selected != null) {
                            CssEditorSupport.this.selected.ruleContent().removePropertyChangeListener(CssEditorSupport.this.CSS_STYLE_DATA_LISTENER);
                            CssEditorSupport.this.d("removed css style data listener from " + CssEditorSupport.this.selected);
                            CssEditorSupport.this.selected = null;
                        }
                        if (CssEditorSupport.this.caretListenerRegistered) {
                            CssEditorSupport.this.editorPane.removeCaretListener(CssEditorSupport.this.CARET_LISTENER);
                            CssEditorSupport.this.d("removed caret listener");
                            CssEditorSupport.this.caretListenerRegistered = false;
                        }
                        if (bl) {
                            StyleBuilderTopComponent.findInstance().setPanelMode(3);
                            CssEditorSupport.this.firePreviewableDeactivated();
                        } else {
                            StyleBuilderTopComponent.findInstance().setPanelMode(1);
                        }
                    }
                });
            }
        }
    };
    private CaretListener CARET_LISTENER = new CaretListener(){

        public void caretUpdate(CaretEvent caretEvent) {
            Object object = caretEvent.getSource();
            if (object instanceof JEditorPane) {
                CssEditorSupport.this.d("caret event; dot=" + caretEvent.getDot());
                CssEditorSupport.this.RULE_UPDATE.setPane((JEditorPane)object);
                CssEditorSupport.this.RULE_UPDATE_TASK.schedule(100);
            }
        }
    };

    public static synchronized CssEditorSupport getDefault() {
        if (INSTANCE == null) {
            INSTANCE = new CssEditorSupport();
        }
        return INSTANCE;
    }

    private String makeIndentString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public void cssTCActivated(TopComponent topComponent) {
        this.d("activated: " + topComponent.getName());
        if (this.current != null) {
            if (this.current == topComponent) {
                return;
            }
            this.cssTCDeactivated();
        }
        this.current = topComponent;
        this.editorPane = this.getEditorPane(topComponent);
        if (this.editorPane == null) {
            return;
        }
        this.document = this.editorPane.getDocument();
        if (this.document == null) {
            return;
        }
        this.fileObject = (FileObject)topComponent.getLookup().lookup(FileObject.class);
        this.model = CssModel.get((Document)this.document);
        if (!this.caretListenerRegistered) {
            this.d("added caret listener: " + topComponent.getName());
            this.editorPane.addCaretListener(this.CARET_LISTENER);
        }
        this.model.addPropertyChangeListener(this.MODEL_LISTENER);
        this.d("added model listener: " + topComponent.getName());
        if (this.selected != null) {
            this.d("removed css styledatalistener from old " + this.selected + ": " + topComponent.getName());
            this.selected.ruleContent().removePropertyChangeListener(this.CSS_STYLE_DATA_LISTENER);
            this.selected = null;
        }
        if (this.editorPane.getCaret().getDot() == 0 && this.model.rules().size() > 0) {
            this.d("setting caret to first rule: " + topComponent.getName());
            this.editorPane.getCaret().setDot(((CssRule)this.model.rules().get(0)).getRuleNameOffset());
        }
        this.updateSelectedRule(this.editorPane.getCaret().getDot());
        this.d("activated exit: " + topComponent.getName());
    }

    public void cssTCDeactivated() {
        this.d("deactivated: " + this.current);
        this.RULE_UPDATE_TASK.cancel();
        this.d("rule update task cancelled: " + this.current);
        if (this.model != null) {
            this.model.removePropertyChangeListener(this.MODEL_LISTENER);
            this.d("removed model listener: " + this.current);
            this.model = null;
        }
        if (this.selected != null) {
            this.selected.ruleContent().removePropertyChangeListener(this.CSS_STYLE_DATA_LISTENER);
            this.d("removed css style data listener: " + this.current);
            this.selected = null;
        }
        this.current = null;
        if (this.caretListenerRegistered) {
            if (this.editorPane != null) {
                this.editorPane.removeCaretListener(this.CARET_LISTENER);
                this.d("removed caret listener: " + this.current);
            }
            this.caretListenerRegistered = false;
        }
        this.editorPane = null;
        this.fileObject = null;
        this.d("deactivated exit: " + this.current);
    }

    private JEditorPane getEditorPane(TopComponent topComponent) {
        JEditorPane[] jEditorPaneArray;
        EditorCookie editorCookie = (EditorCookie)topComponent.getLookup().lookup(EditorCookie.class);
        if (editorCookie != null && (jEditorPaneArray = editorCookie.getOpenedPanes()).length > 0) {
            return jEditorPaneArray[0];
        }
        return null;
    }

    private synchronized void updateSelectedRule(int n) {
        this.d("update selected rule " + this.current.getName() + " to position " + n);
        if (this.document == null || this.model == null) {
            this.d("document == null or model == null, exiting");
            return;
        }
        LOGGER.log(Level.FINE, "updateSelectedRule(" + n + ")");
        if (this.model.rules() == null) {
            return;
        }
        CssRule cssRule = this.model.ruleForOffset(n);
        LOGGER.log(Level.FINE, cssRule == null ? "NO rule" : "found a rule");
        this.d("selected rule:" + cssRule);
        if (cssRule == null) {
            if (this.selected != null) {
                this.selected.ruleContent().removePropertyChangeListener(this.CSS_STYLE_DATA_LISTENER);
                this.d("no selected rule, removing css style data listener");
                this.selected = null;
            }
            StyleBuilderTopComponent.findInstance().setPanelMode(4);
            this.firePreviewableDeactivated();
        } else {
            if (cssRule == this.selected) {
                this.d("already selected rule selected, exiting");
                return;
            }
            if (this.selected != null) {
                this.selected.ruleContent().removePropertyChangeListener(this.CSS_STYLE_DATA_LISTENER);
                this.d("removed css style data listener from previous rule: " + this.selected);
            }
            this.selected = cssRule;
            cssRule.ruleContent().addPropertyChangeListener(this.CSS_STYLE_DATA_LISTENER);
            this.d("added property change listener to the new rule: " + this.selected);
            CssRuleContext cssRuleContext = new CssRuleContext(cssRule, this.model, this.document, FileUtil.toFile((FileObject)this.fileObject.getParent()));
            StyleBuilderTopComponent styleBuilderTopComponent = StyleBuilderTopComponent.findInstance();
            styleBuilderTopComponent.setContent(cssRuleContext);
            styleBuilderTopComponent.setPanelMode(2);
            this.d("stylebuilder UI updated");
            this.firePreviewableActivated(cssRuleContext);
        }
        this.d("updateselected rule exit");
    }

    public void addListener(CssPreviewable.Listener listener) {
        this.previewableListeners.add(listener);
    }

    public void removeListener(CssPreviewable.Listener listener) {
        this.previewableListeners.remove(listener);
    }

    private void firePreviewableActivated(CssRuleContext cssRuleContext) {
        CssPreviewTopComponent.findInstance().activate(cssRuleContext);
    }

    private void firePreviewableDeactivated() {
        CssPreviewTopComponent.findInstance().deactivate();
    }

    private void d(String string) {
        if (DEBUG) {
            LOGGER.log(Level.INFO, string);
        }
    }

    static {
        DEBUG = Boolean.getBoolean("issue_129209_debug");
    }

    private class PaneAwareRunnable
    implements Runnable {
        private JEditorPane editor = null;

        private PaneAwareRunnable() {
        }

        public void setPane(JEditorPane jEditorPane) {
            this.editor = jEditorPane;
        }

        public void run() {
            if (this.editor != null) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CssEditorSupport.this.updateSelectedRule(PaneAwareRunnable.this.editor.getCaret().getDot());
                    }
                });
            }
        }
    }
}

