/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.visual.ui.preview;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import javax.swing.text.Document;
import org.netbeans.modules.css.editor.CssEditorSupport;
import org.netbeans.modules.css.visual.api.StyleBuilderTopComponent;
import org.netbeans.modules.css.visual.ui.preview.CssPreviewTopComponent;
import org.openide.cookies.EditorCookie;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public class CSSTCController
implements PropertyChangeListener {
    public static WeakReference<CSSTCController> instance;
    private TopComponent lastCSSTC = null;

    public static synchronized CSSTCController getDefault() {
        CSSTCController cSSTCController;
        if (instance == null) {
            instance = new WeakReference<CSSTCController>(new CSSTCController());
        }
        if ((cSSTCController = (CSSTCController)instance.get()) == null) {
            cSSTCController = new CSSTCController();
            instance = new WeakReference<CSSTCController>(cSSTCController);
            return cSSTCController;
        }
        return (CSSTCController)instance.get();
    }

    public CSSTCController() {
        TopComponent.Registry registry = WindowManager.getDefault().getRegistry();
        registry.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)registry));
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        TopComponent topComponent;
        if ("activated".equals(propertyChangeEvent.getPropertyName())) {
            TopComponent topComponent2 = (TopComponent)propertyChangeEvent.getNewValue();
            if (this.isCSSTC(topComponent2)) {
                this.previewableActivated(topComponent2);
            } else {
                if (topComponent2 instanceof CssPreviewTopComponent || topComponent2 instanceof StyleBuilderTopComponent) {
                    return;
                }
                if (WindowManager.getDefault().isOpenedEditorTopComponent(topComponent2) && this.lastCSSTC != null) {
                    this.notPreviewableActivated();
                }
            }
        } else if (this.lastCSSTC != null && "tcClosed".equals(propertyChangeEvent.getPropertyName()) && (topComponent = (TopComponent)propertyChangeEvent.getNewValue()) == this.lastCSSTC) {
            this.notPreviewableActivated();
        }
    }

    private boolean isCSSTC(TopComponent topComponent) {
        String string;
        if (topComponent == null) {
            return false;
        }
        Document document = this.getDocument(topComponent);
        return document != null && (string = (String)document.getProperty("mimeType")) != null && "text/x-css".equals(string);
    }

    private Document getDocument(TopComponent topComponent) {
        Lookup lookup = topComponent.getLookup();
        if (lookup == null) {
            return null;
        }
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        if (editorCookie != null) {
            return editorCookie.getDocument();
        }
        return null;
    }

    private void previewableActivated(TopComponent topComponent) {
        this.lastCSSTC = topComponent;
        WindowManager.getDefault().findTopComponentGroup("Csswsgrp").open();
        CssEditorSupport.getDefault().cssTCActivated(topComponent);
    }

    private void notPreviewableActivated() {
        this.lastCSSTC = null;
        WindowManager.getDefault().findTopComponentGroup("Csswsgrp").close();
        CssEditorSupport.getDefault().cssTCDeactivated();
    }
}

