/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.turbo.TurboProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DiskMapTurboProvider
implements TurboProvider {
    static final String ATTR_STATUS_MAP = "mercurial.STATUS_MAP";
    private static final int STATUS_VALUABLE = -10;
    private static final String CACHE_DIRECTORY = "mercurialcache";
    private File cacheStore;
    private int storeSerial;
    private int cachedStoreSerial = -1;
    private Map<File, FileInformation> cachedValues;

    DiskMapTurboProvider() {
        this.initCacheStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Map<File, FileInformation> getAllModifiedValues() {
        if (this.cachedStoreSerial != this.storeSerial || this.cachedValues == null) {
            this.cachedValues = new HashMap<File, FileInformation>();
            File[] fileArray = this.cacheStore.listFiles();
            for (int i = 0; i < fileArray.length; ++i) {
                File file = fileArray[i];
                if (!file.getName().endsWith(".bin")) continue;
                FilterInputStream filterInputStream = null;
                try {
                    int n = 0;
                    while (true) {
                        try {
                            filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                        }
                        catch (IOException iOException) {
                            if (++n > 7) {
                                throw iOException;
                            }
                            Thread.sleep(n * 30);
                            continue;
                        }
                        break;
                    }
                    block17: while (true) {
                        int n2 = ((DataInputStream)filterInputStream).readInt();
                        ((DataInputStream)filterInputStream).readInt();
                        String string = this.readChars((DataInputStream)filterInputStream, n2);
                        Map<File, FileInformation> map = this.readValue((DataInputStream)filterInputStream, string);
                        Iterator<File> iterator = map.keySet().iterator();
                        while (true) {
                            if (!iterator.hasNext()) continue block17;
                            File file2 = iterator.next();
                            FileInformation fileInformation = map.get(file2);
                            if ((fileInformation.getStatus() & 0xFFFFFFF6) == 0) continue;
                            this.cachedValues.put(file2, fileInformation);
                        }
                        break;
                    }
                }
                catch (EOFException eOFException) {
                    if (filterInputStream == null) continue;
                    try {
                        filterInputStream.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                }
                catch (Exception exception) {
                    try {
                        Mercurial.LOG.log(Level.WARNING, null, exception);
                        continue;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        if (filterInputStream != null) {
                            try {
                                filterInputStream.close();
                            }
                            catch (IOException iOException) {}
                        }
                    }
                }
            }
            this.cachedStoreSerial = this.storeSerial;
            this.cachedValues = Collections.unmodifiableMap(this.cachedValues);
        }
        return this.cachedValues;
    }

    public boolean recognizesAttribute(String string) {
        return ATTR_STATUS_MAP.equals(string);
    }

    public boolean recognizesEntity(Object object) {
        return object instanceof File;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized Object readEntry(Object var1_1, String var2_2, TurboProvider.MemoryCache var3_3) {
        block28: {
            if (!DiskMapTurboProvider.$assertionsDisabled && !(var1_1 instanceof File)) {
                throw new AssertionError();
            }
            if (!DiskMapTurboProvider.$assertionsDisabled && var2_2 == null) {
                throw new AssertionError();
            }
            var4_4 = false;
            var5_5 = (File)var1_1;
            var6_6 = this.getStore(var5_5);
            if (!var6_6.isFile()) {
                return null;
            }
            var7_7 = var5_5.getAbsolutePath();
            var8_8 = var7_7.length();
            var9_9 = null;
            try {
                var10_10 = 0;
                while (true) {
                    try {
                        var9_9 = new DataInputStream(new BufferedInputStream(new FileInputStream(var6_6)));
                    }
                    catch (IOException var11_15) {
                        if (++var10_10 > 7) {
                            throw var11_15;
                        }
                        Thread.sleep(var10_10 * 30);
                        continue;
                    }
                    break;
                }
lbl24:
                // 2 sources

                while (true) {
                    var11_16 = var9_9.readInt();
                    var12_17 = var9_9.readInt();
                    if (var11_16 != var8_8) {
                        this.skip(var9_9, var11_16 * 2 + var12_17);
                        continue;
                    }
                    var13_18 = this.readChars((DataInputStream)var9_9, var11_16);
                    if (var7_7.equals(var13_18)) {
                        var14_19 = this.readValue((DataInputStream)var9_9, var13_18);
                        if (var9_9 == null) return var14_19;
                    }
                    ** GOTO lbl-1000
                    break;
                }
            }
            catch (EOFException var10_11) {
                if (var9_9 != null) {
                    try {
                        var9_9.close();
                    }
                    catch (IOException var10_12) {}
                }
                break block28;
            }
            catch (Exception var10_13) {
                try {
                    Mercurial.LOG.log(Level.INFO, null, var10_13);
                    var4_4 = true;
                    break block28;
                }
                catch (Throwable var16_21) {
                    throw var16_21;
                }
                finally {
                    if (var9_9 != null) {
                        try {
                            var9_9.close();
                        }
                        catch (IOException var10_14) {}
                    }
                }
            }
            try {
                var9_9.close();
                return var14_19;
            }
            catch (IOException var15_20) {
                // empty catch block
            }
            return var14_19;
lbl-1000:
            // 1 sources

            {
                this.skip(var9_9, var12_17);
                ** continue;
            }
        }
        if (var4_4 == false) return null;
        var6_6.delete();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean writeEntry(Object object, String string, Object object2) {
        File file;
        File file2;
        block35: {
            assert (object instanceof File);
            assert (string != null);
            if (object2 != null) {
                if (!(object2 instanceof Map)) {
                    return false;
                }
                if (!this.isValuable(object2)) {
                    object2 = null;
                }
            }
            File file3 = (File)object;
            String string2 = file3.getAbsolutePath();
            int n = string2.length();
            file2 = this.getStore(file3);
            if (object2 == null && !file2.exists()) {
                return true;
            }
            file = new File(file2.getParentFile(), file2.getName() + ".new");
            FilterOutputStream filterOutputStream = null;
            FilterInputStream filterInputStream = null;
            try {
                filterOutputStream = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                if (object2 != null) {
                    this.writeEntry((DataOutputStream)filterOutputStream, string2, object2);
                }
                if (!file2.exists()) break block35;
                int n2 = 0;
                while (true) {
                    try {
                        filterInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file2)));
                    }
                    catch (IOException iOException) {
                        if (++n2 > 7) {
                            throw iOException;
                        }
                        Thread.sleep(n2 * 30);
                        continue;
                    }
                    break;
                }
                while (true) {
                    int n3;
                    try {
                        n3 = ((DataInputStream)filterInputStream).readInt();
                    }
                    catch (EOFException eOFException) {
                        break;
                    }
                    int n4 = ((DataInputStream)filterInputStream).readInt();
                    if (n3 == n) {
                        String string3 = this.readChars((DataInputStream)filterInputStream, n3);
                        if (string2.equals(string3)) {
                            this.skip(filterInputStream, n4);
                            continue;
                        }
                        ((DataOutputStream)filterOutputStream).writeInt(n3);
                        ((DataOutputStream)filterOutputStream).writeInt(n4);
                        ((DataOutputStream)filterOutputStream).writeChars(string3);
                        DiskMapTurboProvider.copyStreams(filterOutputStream, filterInputStream, n4);
                        continue;
                    }
                    ((DataOutputStream)filterOutputStream).writeInt(n3);
                    ((DataOutputStream)filterOutputStream).writeInt(n4);
                    DiskMapTurboProvider.copyStreams(filterOutputStream, filterInputStream, n4 + n3 * 2);
                }
            }
            catch (Exception exception) {
                Mercurial.LOG.log(Level.WARNING, "writeEntry(): Copy: {0} to: {1}", new Object[]{file2.getAbsolutePath(), file.getAbsolutePath()});
                boolean bl = true;
                return bl;
            }
            finally {
                if (filterOutputStream != null) {
                    try {
                        filterOutputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (filterInputStream != null) {
                    try {
                        filterInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        ++this.storeSerial;
        file2.delete();
        file.renameTo(file2);
        return true;
    }

    private void skip(InputStream inputStream, long l) throws IOException {
        while (l > 0L) {
            long l2 = inputStream.skip(l);
            if (l2 < 0L) {
                throw new EOFException("Missing " + l + " bytes.");
            }
            l -= l2;
        }
    }

    private String readChars(DataInputStream dataInputStream, int n) throws IOException {
        StringBuffer stringBuffer = new StringBuffer(n);
        while (n-- > 0) {
            stringBuffer.append(dataInputStream.readChar());
        }
        return stringBuffer.toString();
    }

    private Map<File, FileInformation> readValue(DataInputStream dataInputStream, String string) throws IOException {
        HashMap<File, FileInformation> hashMap = new HashMap<File, FileInformation>();
        int n = dataInputStream.readInt();
        while (n-- > 0) {
            int n2;
            int n3 = dataInputStream.readInt();
            String string2 = this.readChars(dataInputStream, n3);
            File file = new File(string, string2);
            FileInformation fileInformation = new FileInformation(n2 & 0xFFFF, (n2 = dataInputStream.readInt()) > 65535);
            hashMap.put(file, fileInformation);
        }
        return hashMap;
    }

    private void writeEntry(DataOutputStream dataOutputStream, String string, Object object) throws IOException {
        Map map = (Map)object;
        Set set = map.keySet();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(set.size() * 50);
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream2.writeInt(set.size());
        for (File file : set) {
            FileInformation fileInformation = (FileInformation)map.get(file);
            dataOutputStream2.writeInt(file.getName().length());
            dataOutputStream2.writeChars(file.getName());
            dataOutputStream2.writeInt(fileInformation.getStatus() + (fileInformation.isDirectory() ? 65536 : 0));
        }
        dataOutputStream2.close();
        Object object2 = byteArrayOutputStream.toByteArray();
        dataOutputStream.writeInt(string.length());
        dataOutputStream.writeInt(((Object)object2).length);
        dataOutputStream.writeChars(string);
        dataOutputStream.write((byte[])object2);
    }

    private boolean isValuable(Object object) {
        Map map = (Map)object;
        for (FileInformation fileInformation : map.values()) {
            if ((fileInformation.getStatus() & 0xFFFFFFF6) == 0) continue;
            return true;
        }
        return false;
    }

    private File getStore(File file) {
        String string = file.getAbsolutePath();
        int n = string.hashCode();
        return new File(this.cacheStore, Integer.toString(n % 173 + 172) + ".bin");
    }

    private void initCacheStore() {
        String string = System.getProperty("netbeans.user");
        if (string != null) {
            this.cacheStore = new File(new File(new File(string, "var"), "cache"), CACHE_DIRECTORY);
        } else {
            File file = FileUtil.toFile((FileObject)Repository.getDefault().getDefaultFileSystem().getRoot());
            this.cacheStore = new File(file, CACHE_DIRECTORY);
        }
        this.cacheStore.mkdirs();
    }

    private static void copyStreams(OutputStream outputStream, InputStream inputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[4096];
        do {
            n2 = n <= 4096 ? n : 4096;
            if ((n2 = inputStream.read(byArray, 0, n2)) < 0) {
                throw new EOFException("Missing " + n + " bytes.");
            }
            outputStream.write(byArray, 0, n2);
        } while ((n -= n2) != 0);
        outputStream.flush();
    }
}

