/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.mercurial.DiskMapTurboProvider;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatus;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.turbo.CustomProviders;
import org.netbeans.modules.turbo.Turbo;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileStatusCache {
    public static final String PROP_FILE_STATUS_CHANGED = "status.changed";
    private static final Map<File, FileInformation> NOT_MANAGED_MAP = new NotManagedMap();
    public static final FileStatus REPOSITORY_STATUS_UNKNOWN = null;
    private static final FileInformation FILE_INFORMATION_EXCLUDED = new FileInformation(2, false);
    private static final FileInformation FILE_INFORMATION_EXCLUDED_DIRECTORY = new FileInformation(2, true);
    private static final FileInformation FILE_INFORMATION_UPTODATE_DIRECTORY = new FileInformation(8, true);
    private static final FileInformation FILE_INFORMATION_UPTODATE = new FileInformation(8, false);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED = new FileInformation(1, false);
    private static final FileInformation FILE_INFORMATION_NOTMANAGED_DIRECTORY = new FileInformation(1, true);
    private static final FileInformation FILE_INFORMATION_UNKNOWN = new FileInformation(0, false);
    private static final FileInformation FILE_INFORMATION_NEWLOCALLY = new FileInformation(4, false);
    public static final FileInformation FILE_INFORMATION_CONFLICT = new FileInformation(64, false);
    public static final FileInformation FILE_INFORMATION_REMOVEDLOCALLY = new FileInformation(256, false);
    private PropertyChangeSupport listenerSupport = new PropertyChangeSupport(this);
    private final Turbo turbo;
    private final String FILE_STATUS_MAP = "mercurial.STATUS_MAP";
    private DiskMapTurboProvider cacheProvider;
    private Mercurial hg = Mercurial.getInstance();
    private Set<FileSystem> filesystemsToRefresh;

    FileStatusCache() {
        this.cacheProvider = new DiskMapTurboProvider();
        this.turbo = Turbo.createCustom((CustomProviders)new CustomProviders(){
            private final Set providers;
            {
                this.providers = Collections.singleton(FileStatusCache.this.cacheProvider);
            }

            public Iterator providers() {
                return this.providers.iterator();
            }
        }, (int)200, (int)5000);
    }

    public File[] listFiles(File file) {
        Set<File> set = this.getScannedFiles(file, null).keySet();
        return set.toArray(new File[set.size()]);
    }

    public boolean containsFileOfStatus(VCSContext vCSContext, int n) {
        Map<File, FileInformation> map = this.cacheProvider.getAllModifiedValues();
        if (map == null) {
            Mercurial.LOG.log(Level.FINE, "containsFileOfStatus(): allFiles == null");
            return false;
        }
        Set set = vCSContext.getRootFiles();
        Set set2 = vCSContext.getExclusions();
        Set<File> set3 = map.keySet();
        boolean bl = set2 != null && set2.size() > 0;
        boolean bl2 = false;
        for (File file : set3) {
            FileInformation fileInformation = map.get(file);
            if ((fileInformation.getStatus() & n) == 0) continue;
            for (File file2 : set) {
                if (VersioningSupport.isFlat((File)file2)) {
                    if (!file.equals(file2) && !file.getParentFile().equals(file2)) continue;
                    bl2 = true;
                    break;
                }
                if (!Utils.isAncestorOrEqual((File)file2, (File)file)) continue;
                File file3 = this.hg.getTopmostManagedParent(file);
                File file4 = this.hg.getTopmostManagedParent(file2);
                if (!file4.equals(file3)) continue;
                bl2 = true;
                break;
            }
            if (bl2 && bl) {
                for (File file2 : set2) {
                    if (Utils.isAncestorOrEqual((File)file2, (File)file)) continue;
                    return true;
                }
                continue;
            }
            if (!bl2) continue;
            return true;
        }
        return false;
    }

    public File[] listFiles(VCSContext vCSContext, int n) {
        Object object;
        Object object2;
        HashSet<File> hashSet = new HashSet<File>();
        Map<File, FileInformation> map = this.cacheProvider.getAllModifiedValues();
        if (map == null) {
            Mercurial.LOG.log(Level.FINE, "FileStatusCache: listFiles(): allFiles == null");
            return new File[0];
        }
        block0: for (File file : map.keySet()) {
            object2 = map.get(file);
            if ((((FileInformation)object2).getStatus() & n) == 0) continue;
            object = vCSContext.getRootFiles();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                File file2 = (File)iterator.next();
                if (VersioningSupport.isFlat((File)file2)) {
                    if (!file.equals(file2) && !file.getParentFile().equals(file2)) continue;
                    hashSet.add(file);
                    continue block0;
                }
                if (!Utils.isAncestorOrEqual((File)file2, (File)file)) continue;
                File file3 = this.hg.getTopmostManagedParent(file);
                File file4 = this.hg.getTopmostManagedParent(file2);
                if (!file4.equals(file3)) continue;
                hashSet.add(file);
                continue block0;
            }
        }
        if (vCSContext.getExclusions().size() > 0) {
            for (File file : vCSContext.getExclusions()) {
                object2 = hashSet.iterator();
                while (object2.hasNext()) {
                    object = (File)object2.next();
                    if (!Utils.isAncestorOrEqual((File)file, (File)object)) continue;
                    object2.remove();
                }
            }
        }
        return hashSet.toArray(new File[hashSet.size()]);
    }

    public File[] listFiles(File[] fileArray, int n) {
        HashSet<File> hashSet = new HashSet<File>();
        Map<File, FileInformation> map = this.cacheProvider.getAllModifiedValues();
        block0: for (File file : map.keySet()) {
            FileInformation fileInformation = map.get(file);
            if ((fileInformation.getStatus() & n) == 0) continue;
            for (int i = 0; i < fileArray.length; ++i) {
                File file2 = fileArray[i];
                if (VersioningSupport.isFlat((File)file2)) {
                    if (!file.getParentFile().equals(file2)) continue;
                    hashSet.add(file);
                    continue block0;
                }
                if (!Utils.isAncestorOrEqual((File)file2, (File)file)) continue;
                hashSet.add(file);
                continue block0;
            }
        }
        return hashSet.toArray(new File[hashSet.size()]);
    }

    public FileInformation getStatus(File file) {
        if (file.isDirectory() && (this.hg.isAdministrative(file) || HgUtils.isIgnored(file))) {
            return FILE_INFORMATION_EXCLUDED_DIRECTORY;
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        Map<File, FileInformation> map = this.getScannedFiles(file2, null);
        if (map == NOT_MANAGED_MAP) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        FileInformation fileInformation = map.get(file);
        if (fileInformation != null) {
            return fileInformation;
        }
        if (!this.exists(file)) {
            return FILE_INFORMATION_UNKNOWN;
        }
        if (file.isDirectory()) {
            return this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
        }
        return new FileInformation(8, false);
    }

    FileInformation getCachedStatus(File file, boolean bl) {
        FileInformation fileInformation;
        File file2 = file.getParentFile();
        if (file2 == null) {
            return FILE_INFORMATION_NOTMANAGED_DIRECTORY;
        }
        Map map = (Map)this.turbo.readEntry((Object)file2, "mercurial.STATUS_MAP");
        FileInformation fileInformation2 = fileInformation = map != null ? (FileInformation)map.get(file) : null;
        if (fileInformation != null) {
            return fileInformation;
        }
        if (file.isDirectory()) {
            if (this.hg.isAdministrative(file) || HgUtils.isIgnored(file, bl)) {
                return FILE_INFORMATION_EXCLUDED_DIRECTORY;
            }
            return FILE_INFORMATION_UPTODATE_DIRECTORY;
        }
        return fileInformation;
    }

    private FileInformation refresh(File file, FileStatus fileStatus, boolean bl) {
        Mercurial.LOG.log(Level.FINE, "refresh(): {0}", file);
        File file2 = file.getParentFile();
        if (file2 == null) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        Map<File, FileInformation> map = this.getScannedFiles(file2, null);
        if (map == NOT_MANAGED_MAP && fileStatus == REPOSITORY_STATUS_UNKNOWN) {
            return FILE_INFORMATION_NOTMANAGED;
        }
        FileInformation fileInformation = map.get(file);
        FileInformation fileInformation2 = this.createFileInformation(file);
        if (FileStatusCache.equivalent(fileInformation2, fileInformation)) {
            if (bl) {
                this.fireFileStatusChanged(file, fileInformation, fileInformation2);
            }
            return fileInformation2;
        }
        if (fileInformation == null && !fileInformation2.isDirectory() && fileInformation2.getStatus() == 8) {
            if (bl) {
                this.fireFileStatusChanged(file, fileInformation, fileInformation2);
            }
            return fileInformation2;
        }
        file = FileUtil.normalizeFile((File)file);
        file2 = FileUtil.normalizeFile((File)file2);
        HashMap<File, FileInformation> hashMap = new HashMap<File, FileInformation>(map);
        if (fileInformation2.getStatus() == 0) {
            hashMap.remove(file);
            this.turbo.writeEntry((Object)file, "mercurial.STATUS_MAP", null);
        } else if (fileInformation2.getStatus() == 8 && file.isFile()) {
            hashMap.remove(file);
        } else {
            hashMap.put(file, fileInformation2);
        }
        assert (!hashMap.containsKey(file2));
        this.turbo.writeEntry((Object)file2, "mercurial.STATUS_MAP", hashMap.size() == 0 ? null : hashMap);
        if (file.isDirectory() && this.needRecursiveRefresh(fileInformation2, fileInformation)) {
            File[] fileArray = this.listFiles(file);
            for (int i = 0; i < fileArray.length; ++i) {
                this.refresh(fileArray[i], REPOSITORY_STATUS_UNKNOWN);
            }
        }
        this.fireFileStatusChanged(file, fileInformation, fileInformation2);
        return fileInformation2;
    }

    private FileInformation createFileInformation(File file) {
        return this.createFileInformation(file, true);
    }

    private FileInformation createFileInformation(File file, Boolean bl) {
        FileInformation fileInformation;
        Mercurial.LOG.log(Level.FINE, "createFileInformation(): {0} {1}", new Object[]{file, bl});
        if (file == null) {
            return FILE_INFORMATION_UNKNOWN;
        }
        if (this.hg.isAdministrative(file)) {
            return FILE_INFORMATION_EXCLUDED_DIRECTORY;
        }
        File file2 = this.hg.getTopmostManagedParent(file);
        if (file2 == null) {
            return FILE_INFORMATION_UNKNOWN;
        }
        if (file.isDirectory()) {
            if (HgUtils.isIgnored(file)) {
                return FILE_INFORMATION_EXCLUDED_DIRECTORY;
            }
            return FILE_INFORMATION_UPTODATE_DIRECTORY;
        }
        if (!bl.booleanValue()) {
            if (HgUtils.isIgnored(file)) {
                return FILE_INFORMATION_EXCLUDED;
            }
            return null;
        }
        try {
            fileInformation = HgCommand.getSingleStatus(file2, file.getParent(), file.getName());
        }
        catch (HgException hgException) {
            Mercurial.LOG.log(Level.FINE, "createFileInformation() file: {0} {1}", new Object[]{file.getAbsolutePath(), hgException.toString()});
            return FILE_INFORMATION_UNKNOWN;
        }
        return fileInformation;
    }

    public FileInformation refresh(File file, FileStatus fileStatus) {
        return this.refresh(file, fileStatus, false);
    }

    public FileInformation refreshForce(File file, FileStatus fileStatus) {
        return this.refresh(file, fileStatus, true);
    }

    public Map<File, FileInformation> getScannedFiles(File file, Map<File, FileInformation> map) {
        Map<File, FileInformation> map2 = (Map<File, FileInformation>)this.turbo.readEntry((Object)file, "mercurial.STATUS_MAP");
        if (map2 != null) {
            return map2;
        }
        if (this.isNotManagedByDefault(file) && map == null) {
            return NOT_MANAGED_MAP;
        }
        file = FileUtil.normalizeFile((File)file);
        map2 = this.scanFolder(file, map);
        assert (!map2.containsKey(file));
        this.turbo.writeEntry((Object)file, "mercurial.STATUS_MAP", map2);
        if (map == null) {
            for (File file2 : map2.keySet()) {
                FileInformation fileInformation = map2.get(file2);
                if ((fileInformation.getStatus() & 0x19D6) == 0) continue;
                this.fireFileStatusChanged(file2, null, fileInformation);
            }
        }
        return map2;
    }

    public void refreshFileStatus(File file, FileInformation fileInformation, Map<File, FileInformation> map) {
        this.refreshFileStatus(file, fileInformation, map, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refreshFileStatus(File file, FileInformation fileInformation, Map<File, FileInformation> map, boolean bl) {
        if (file == null || fileInformation == null) {
            return;
        }
        File file2 = file.getParentFile();
        if (file2 == null) {
            return;
        }
        Map<File, FileInformation> map2 = this.getScannedFiles(file2, map);
        if (map2 == null || map2 == NOT_MANAGED_MAP) {
            return;
        }
        FileInformation fileInformation2 = map2.get(file);
        if (FileStatusCache.equivalent(fileInformation, fileInformation2)) {
            if (FileStatusCache.equivalent(FILE_INFORMATION_NEWLOCALLY, fileInformation)) {
                if (!HgUtils.isIgnored(file)) return;
                Mercurial.LOG.log(Level.FINE, "refreshFileStatus() file: {0} was LocallyNew but is NotSharable", file.getAbsolutePath());
                fileInformation = FILE_INFORMATION_EXCLUDED;
            } else if (!FileStatusCache.equivalent(FILE_INFORMATION_REMOVEDLOCALLY, fileInformation)) {
                return;
            }
        }
        if (FileStatusCache.equivalent(FILE_INFORMATION_NEWLOCALLY, fileInformation)) {
            if (FileStatusCache.equivalent(FILE_INFORMATION_EXCLUDED, fileInformation2)) {
                Mercurial.LOG.log(Level.FINE, "refreshFileStatus() file: {0} was LocallyNew but is Excluded", file.getAbsolutePath());
                return;
            }
            if (fileInformation2 == null && HgUtils.isIgnored(file)) {
                Mercurial.LOG.log(Level.FINE, "refreshFileStatus() file: {0} was LocallyNew but current is null and is not NotSharable", file.getAbsolutePath());
                fileInformation = FILE_INFORMATION_EXCLUDED;
            }
        }
        file = FileUtil.normalizeFile((File)file);
        file2 = FileUtil.normalizeFile((File)file2);
        HashMap<File, FileInformation> hashMap = new HashMap<File, FileInformation>(map2);
        if (fileInformation.getStatus() == 0) {
            hashMap.remove(file);
            this.turbo.writeEntry((Object)file, "mercurial.STATUS_MAP", null);
        } else if (fileInformation.getStatus() == 8 && file.isFile()) {
            hashMap.remove(file);
        } else {
            hashMap.put(file, fileInformation);
        }
        assert (!map2.containsKey(file2));
        this.turbo.writeEntry((Object)file2, "mercurial.STATUS_MAP", hashMap);
        if (map == null) {
            this.fireFileStatusChanged(file, fileInformation2, fileInformation);
            return;
        } else {
            if (!bl) return;
            this.fireFileStatusChanged(file, null, fileInformation);
        }
    }

    private static boolean equivalent(FileInformation fileInformation, FileInformation fileInformation2) {
        FileStatus fileStatus;
        if (fileInformation2 == null || fileInformation.getStatus() != fileInformation2.getStatus() || fileInformation.isDirectory() != fileInformation2.isDirectory()) {
            return false;
        }
        FileStatus fileStatus2 = fileInformation.getStatus(null);
        return fileStatus2 == (fileStatus = fileInformation2.getStatus(null)) || fileStatus2 == null || fileStatus == null || FileStatusCache.equal(fileStatus2, fileStatus);
    }

    private static boolean equal(FileStatus fileStatus, FileStatus fileStatus2) {
        return true;
    }

    private boolean needRecursiveRefresh(FileInformation fileInformation, FileInformation fileInformation2) {
        if (fileInformation.getStatus() == 2 || fileInformation2 != null && fileInformation2.getStatus() == 2) {
            return true;
        }
        return fileInformation.getStatus() == 1 || fileInformation2 != null && fileInformation2.getStatus() == 1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void refreshAll(File file) {
        if (file.isDirectory()) {
            File file2 = Mercurial.getInstance().getTopmostManagedParent(file);
            if (file2 == null) {
                return;
            }
            Map map = (Map)this.turbo.readEntry((Object)file, "mercurial.STATUS_MAP");
            try {
                Map<File, FileInformation> map2 = HgCommand.getInterestingStatus(file2, file);
                for (File file3 : map2.keySet()) {
                    FileInformation fileInformation = map2.get(file3);
                    Mercurial.LOG.log(Level.FINE, "refreshAll() file: {0} {1} ", new Object[]{file3.getAbsolutePath(), fileInformation});
                    this.refreshFileStatus(file3, fileInformation, map2, true);
                }
                if (map == null) return;
                for (File file3 : map.keySet()) {
                    if (map2.containsKey(file3)) continue;
                    Mercurial.LOG.log(Level.FINE, "refreshAll() uninteresting file: {0}", file3);
                    this.refresh(file3, REPOSITORY_STATUS_UNKNOWN);
                }
                return;
            }
            catch (HgException hgException) {
                Mercurial.LOG.log(Level.FINE, "refreshAll() file: {0} {1} { 2} ", new Object[]{file2.getAbsolutePath(), file.getAbsolutePath(), hgException.toString()});
                return;
            }
        } else {
            this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
        }
    }

    public void refreshCached(File file, FileStatus fileStatus) {
        this.refresh(file, fileStatus);
    }

    public void refreshCached(File file) {
        if (file.isDirectory()) {
            File file2 = Mercurial.getInstance().getTopmostManagedParent(file);
            if (file2 == null) {
                return;
            }
            File[] fileArray = new File[]{file};
            File[] fileArray2 = this.listFiles(fileArray, -1);
            if (fileArray2.length == 0) {
                return;
            }
            try {
                Map<File, FileInformation> map = HgCommand.getAllStatus(file2, file);
                for (int i = 0; i < fileArray2.length; ++i) {
                    File file3 = fileArray2[i];
                    FileInformation fileInformation = map.get(file3);
                    if (fileInformation == null) {
                        this.refresh(file3, REPOSITORY_STATUS_UNKNOWN);
                        continue;
                    }
                    this.refreshFileStatus(file3, fileInformation, null);
                }
            }
            catch (HgException hgException) {
                Mercurial.LOG.log(Level.FINE, "refreshCached() file: {0} {1} { 2} ", new Object[]{file2.getAbsolutePath(), file.getAbsolutePath(), hgException.toString()});
            }
        } else {
            this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
        }
    }

    public void refreshCached(VCSContext vCSContext) {
        for (File file : vCSContext.getRootFiles()) {
            this.refreshCached(file);
        }
    }

    public void addToCache(Set<File> set) {
        Object object;
        FileInformation fileInformation = new FileInformation(4, null, false);
        HashMap<Object, HashMap<File, FileInformation>> hashMap = new HashMap<Object, HashMap<File, FileInformation>>(set.size());
        for (File file : set) {
            object = file.getParentFile();
            file = FileUtil.normalizeFile((File)file);
            HashMap<File, FileInformation> hashMap2 = (HashMap<File, FileInformation>)hashMap.get(object = FileUtil.normalizeFile((File)object));
            if (hashMap2 == null) {
                hashMap2 = new HashMap<File, FileInformation>(20);
                hashMap.put(object, hashMap2);
            }
            hashMap2.put(file, fileInformation);
        }
        for (File file : hashMap.keySet()) {
            file = FileUtil.normalizeFile((File)file);
            object = (Map)hashMap.get(file);
            this.turbo.writeEntry((Object)file, "mercurial.STATUS_MAP", object);
        }
    }

    Map<File, FileInformation> getAllModifiedFiles() {
        return this.cacheProvider.getAllModifiedValues();
    }

    void directoryContentChanged(File file) {
        Map map = (Map)this.turbo.readEntry((Object)file, "mercurial.STATUS_MAP");
        if (map != null) {
            for (File file2 : map.keySet()) {
                this.refresh(file2, REPOSITORY_STATUS_UNKNOWN);
            }
        }
    }

    void cleanUp() {
        Map<File, FileInformation> map = this.cacheProvider.getAllModifiedValues();
        for (File file : map.keySet()) {
            FileInformation fileInformation = map.get(file);
            if ((fileInformation.getStatus() & 0x19D4) != 0) {
                this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
                continue;
            }
            if (fileInformation.getStatus() != 2 || this.exists(file)) continue;
            this.refresh(file, REPOSITORY_STATUS_UNKNOWN);
        }
    }

    private boolean isNotManagedByDefault(File file) {
        return !file.exists();
    }

    private Map<File, FileInformation> scanFolder(File file, Map<File, FileInformation> map) {
        File[] fileArray = file.listFiles();
        if (fileArray == null) {
            fileArray = map == null ? new File[]{} : map.keySet().toArray(new File[map.keySet().size()]);
        }
        HashMap<File, FileInformation> hashMap = new HashMap<File, FileInformation>(fileArray.length);
        Mercurial.LOG.log(Level.FINE, "scanFolder(): {0}", file);
        if (this.hg.isAdministrative(file)) {
            hashMap.put(file, FILE_INFORMATION_EXCLUDED_DIRECTORY);
            return hashMap;
        }
        File file2 = this.hg.getTopmostManagedParent(file);
        if (file2 == null) {
            for (File file3 : fileArray) {
                if (!file3.isDirectory() || this.hg.getTopmostManagedParent(file3) == null) continue;
                if (this.hg.isAdministrative(file3) || HgUtils.isIgnored(file3)) {
                    Mercurial.LOG.log(Level.FINE, "scanFolder NotMng Ignored Dir {0}: exclude SubDir: {1}", new Object[]{file.getAbsolutePath(), file3.getName()});
                    hashMap.put(file3, FILE_INFORMATION_EXCLUDED_DIRECTORY);
                    continue;
                }
                Mercurial.LOG.log(Level.FINE, "scanFolder NotMng Dir {0}: up to date Dir: {1}", new Object[]{file.getAbsolutePath(), file3.getName()});
                hashMap.put(file3, FILE_INFORMATION_UPTODATE_DIRECTORY);
            }
            return hashMap;
        }
        boolean bl = HgUtils.isIgnored(file);
        if (bl) {
            for (File file4 : fileArray) {
                if (HgUtils.isPartOfMercurialMetadata(file4)) continue;
                if (file4.isDirectory()) {
                    hashMap.put(file4, FILE_INFORMATION_EXCLUDED_DIRECTORY);
                    Mercurial.LOG.log(Level.FINE, "scanFolder Mng Ignored Dir {0}: exclude SubDir: {1}", new Object[]{file.getAbsolutePath(), file4.getName()});
                    continue;
                }
                Mercurial.LOG.log(Level.FINE, "scanFolder Mng Ignored Dir {0}: exclude File: {1}", new Object[]{file.getAbsolutePath(), file4.getName()});
                hashMap.put(file4, FILE_INFORMATION_EXCLUDED);
            }
            return hashMap;
        }
        if (!Mercurial.getInstance().isGoodVersion()) {
            return hashMap;
        }
        if (map == null) {
            try {
                map = HgCommand.getInterestingStatus(file2, file);
            }
            catch (HgException hgException) {
                Mercurial.LOG.log(Level.FINE, "scanFolder() getInterestingStatus Exception: dir: {0} {1}", new Object[]{file.getAbsolutePath(), hgException.toString()});
                return hashMap;
            }
        }
        if (map == null) {
            return hashMap;
        }
        for (File file5 : fileArray) {
            if (HgUtils.isPartOfMercurialMetadata(file5)) continue;
            if (file5.isDirectory()) {
                if (this.hg.isAdministrative(file5) || HgUtils.isIgnored(file5)) {
                    Mercurial.LOG.log(Level.FINE, "scanFolder Mng Dir {0}: exclude Dir: {1}", new Object[]{file.getAbsolutePath(), file5.getName()});
                    hashMap.put(file5, FILE_INFORMATION_EXCLUDED_DIRECTORY);
                    continue;
                }
                Mercurial.LOG.log(Level.FINE, "scanFolder Mng Dir {0}: up to date Dir: {1}", new Object[]{file.getAbsolutePath(), file5.getName()});
                hashMap.put(file5, FILE_INFORMATION_UPTODATE_DIRECTORY);
                continue;
            }
            FileInformation fileInformation = map.get(file5);
            if (fileInformation == null) {
                fileInformation = this.createFileInformation(file5, false);
            }
            if (fileInformation == null || fileInformation.getStatus() == 8) continue;
            hashMap.put(file5, fileInformation);
        }
        return hashMap;
    }

    private boolean exists(File file) {
        if (!file.exists()) {
            return false;
        }
        return file.getAbsolutePath().equals(FileUtil.normalizeFile((File)file).getAbsolutePath());
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerSupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.listenerSupport.removePropertyChangeListener(propertyChangeListener);
    }

    private void fireFileStatusChanged(File file, FileInformation fileInformation, FileInformation fileInformation2) {
        this.listenerSupport.firePropertyChange(PROP_FILE_STATUS_CHANGED, null, new ChangedEvent(file, fileInformation, fileInformation2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshDirtyFileSystems() {
        Set<FileSystem> set = this.getFilesystemsToRefresh();
        FileSystem[] fileSystemArray = new FileSystem[set.size()];
        Set<FileSystem> set2 = set;
        synchronized (set2) {
            fileSystemArray = set.toArray(new FileSystem[set.size()]);
            set.clear();
        }
        for (int i = 0; i < fileSystemArray.length; ++i) {
            fileSystemArray[i].refresh(true);
        }
    }

    private Set<FileSystem> getFilesystemsToRefresh() {
        if (this.filesystemsToRefresh == null) {
            this.filesystemsToRefresh = new HashSet<FileSystem>();
        }
        return this.filesystemsToRefresh;
    }

    public static class ChangedEvent {
        private File file;
        private FileInformation oldInfo;
        private FileInformation newInfo;

        public ChangedEvent(File file, FileInformation fileInformation, FileInformation fileInformation2) {
            this.file = file;
            this.oldInfo = fileInformation;
            this.newInfo = fileInformation2;
        }

        public File getFile() {
            return this.file;
        }

        public FileInformation getOldInfo() {
            return this.oldInfo;
        }

        public FileInformation getNewInfo() {
            return this.newInfo;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class NotManagedMap
    extends AbstractMap<File, FileInformation> {
        private NotManagedMap() {
        }

        @Override
        public Set<Map.Entry<File, FileInformation>> entrySet() {
            return Collections.emptySet();
        }
    }
}

