/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.commit;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgFileNode;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.commit.CommitOptions;
import org.netbeans.modules.mercurial.ui.commit.CommitPanel;
import org.netbeans.modules.mercurial.ui.commit.CommitTable;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgProjectUtils;
import org.netbeans.modules.mercurial.util.HgRepositoryContextCache;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.DialogBoundsPreserver;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningEvent;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommitAction
extends ContextAction {
    static final String RECENT_COMMIT_MESSAGES = "recentCommitMessage";
    private final VCSContext context;

    public CommitAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    @Override
    public boolean isEnabled() {
        FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
        return fileStatusCache.containsFileOfStatus(this.context, 6612);
    }

    @Override
    public void performAction(ActionEvent actionEvent) {
        File file = HgUtils.getRootFile(this.context);
        if (file == null) {
            OutputLogger outputLogger = OutputLogger.getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
            outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE"));
            outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE_SEP"));
            outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_NOT_SUPPORTED_INVIEW_INFO"));
            outputLogger.output("");
            outputLogger.closeLog();
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_NOT_SUPPORTED_INVIEW"), NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_NOT_SUPPORTED_INVIEW_TITLE"), 1);
            return;
        }
        String string = Utils.getContextDisplayName((VCSContext)this.context);
        CommitAction.commit(string, this.context);
    }

    public static void commit(String string, final VCSContext vCSContext) {
        Object object;
        Object[] objectArray;
        Object object2;
        FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
        File[] fileArray = vCSContext.getRootFiles().toArray(new File[vCSContext.getRootFiles().size()]);
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        File file2 = HgUtils.getRootFile(vCSContext);
        if (file2 == null) {
            return;
        }
        String string2 = HgProjectUtils.getProjectName(file2);
        if (string2 == null) {
            object2 = HgUtils.getProjectFile(vCSContext);
            string2 = HgProjectUtils.getProjectName((File)object2);
        }
        object2 = string2;
        File[][] fileArray2 = Utils.splitFlatOthers((File[])fileArray);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < fileArray2.length; ++i) {
            int n;
            boolean bl;
            fileArray = fileArray2[i];
            boolean bl2 = bl = i == 1;
            if (bl) {
                objectArray = fileStatusCache.listFiles(vCSContext, 6612);
                for (n = 0; n < objectArray.length; ++n) {
                    for (int j = 0; j < fileArray.length; ++j) {
                        if (!HgUtils.isParentOrEqual(fileArray[j], objectArray[n]) || arrayList.contains(objectArray[n])) continue;
                        arrayList.add(objectArray[n]);
                    }
                }
                continue;
            }
            objectArray = HgUtils.flatten(fileArray, 6612);
            for (n = 0; n < objectArray.length; ++n) {
                if (arrayList.contains(objectArray[n])) continue;
                arrayList.add(objectArray[n]);
            }
        }
        if (arrayList.size() == 0) {
            return;
        }
        final CommitPanel commitPanel = new CommitPanel();
        final CommitTable commitTable = new CommitTable(commitPanel.filesLabel, CommitTable.COMMIT_COLUMNS, new String[]{"path"});
        commitPanel.setCommitTable(commitTable);
        ArrayList<HgFileNode> arrayList2 = new ArrayList<HgFileNode>(arrayList.size());
        for (File file3 : arrayList) {
            object = new HgFileNode(file3);
            arrayList2.add((HgFileNode)object);
        }
        objectArray = arrayList2.toArray(new HgFileNode[arrayList.size()]);
        commitTable.setNodes((HgFileNode[])objectArray);
        JComponent jComponent = commitTable.getComponent();
        commitPanel.filesPanel.setLayout(new BorderLayout());
        commitPanel.filesPanel.add((Component)jComponent, "Center");
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)commitPanel, NbBundle.getMessage(CommitAction.class, (String)"CTL_CommitDialog_Title", (Object)string));
        dialogDescriptor.setModal(true);
        object = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)object, (String)NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Commit"));
        ((JButton)object).getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommitAction.class, (String)"ACSN_Commit_Action_Commit"));
        ((JButton)object).getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitAction.class, (String)"ACSD_Commit_Action_Commit"));
        JButton jButton = new JButton(NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Cancel"));
        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)NbBundle.getMessage(CommitAction.class, (String)"CTL_Commit_Action_Cancel"));
        jButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(CommitAction.class, (String)"ACSN_Commit_Action_Cancel"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(CommitAction.class, (String)"ACSD_Commit_Action_Cancel"));
        ((AbstractButton)object).setEnabled(false);
        dialogDescriptor.setOptions(new Object[]{object, jButton});
        dialogDescriptor.setHelpCtx(new HelpCtx(CommitAction.class));
        commitPanel.addVersioningListener(new VersioningListener((JButton)object){
            final /* synthetic */ JButton val$commitButton;
            {
                this.val$commitButton = jButton;
            }

            public void versioningEvent(VersioningEvent versioningEvent) {
                CommitAction.refreshCommitDialog(commitPanel, commitTable, this.val$commitButton);
            }
        });
        commitTable.getTableModel().addTableModelListener(new TableModelListener((JButton)object){
            final /* synthetic */ JButton val$commitButton;
            {
                this.val$commitButton = jButton;
            }

            public void tableChanged(TableModelEvent tableModelEvent) {
                CommitAction.refreshCommitDialog(commitPanel, commitTable, this.val$commitButton);
            }
        });
        ((AbstractButton)object).setEnabled(CommitAction.containsCommitable(commitTable));
        commitPanel.putClientProperty("contentTitle", string);
        commitPanel.putClientProperty("DialogDescriptor", dialogDescriptor);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.addWindowListener((WindowListener)new DialogBoundsPreserver(HgModuleConfig.getDefault().getPreferences(), "hg.commit.dialog"));
        dialog.pack();
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == object) {
            final Map<HgFileNode, CommitOptions> map = commitTable.getCommitFiles();
            final String string3 = commitPanel.messageTextArea.getText();
            Utils.insert((Preferences)HgModuleConfig.getDefault().getPreferences(), (String)RECENT_COMMIT_MESSAGES, (String)string3, (int)20);
            RequestProcessor requestProcessor = Mercurial.getInstance().getRequestProcessor(file2.getAbsolutePath());
            HgProgressSupport hgProgressSupport = new HgProgressSupport((String)object2){
                final /* synthetic */ String val$prjName;
                {
                    this.val$prjName = string2;
                }

                public void perform() {
                    OutputLogger outputLogger = this.getLogger();
                    CommitAction.performCommit(string3, map, vCSContext, this, this.val$prjName, outputLogger);
                }
            };
            hgProgressSupport.start(requestProcessor, file2.getAbsolutePath(), NbBundle.getMessage(CommitAction.class, (String)"LBL_Commit_Progress"));
        }
    }

    private static boolean containsCommitable(CommitTable commitTable) {
        Map<HgFileNode, CommitOptions> map = commitTable.getCommitFiles();
        for (CommitOptions commitOptions : map.values()) {
            if (commitOptions == CommitOptions.EXCLUDE) continue;
            return true;
        }
        return false;
    }

    private static void refreshCommitDialog(CommitPanel commitPanel, CommitTable commitTable, JButton jButton) {
        String string;
        Object object;
        HgFileNode hgFileNode2;
        ResourceBundle resourceBundle = NbBundle.getBundle(CommitAction.class);
        Map<HgFileNode, CommitOptions> map = commitTable.getCommitFiles();
        HashSet hashSet = new HashSet();
        boolean bl = false;
        boolean bl2 = jButton.isEnabled();
        for (HgFileNode hgFileNode2 : map.keySet()) {
            int n;
            object = map.get(hgFileNode2);
            if (object == CommitOptions.EXCLUDE || ((n = hgFileNode2.getInformation().getStatus()) & 0x6A0) == 0 && n != 64) continue;
            bl2 = false;
            string = n == 64 ? resourceBundle.getString("MSG_CommitForm_ErrorConflicts") : resourceBundle.getString("MSG_CommitForm_ErrorRemoteChanges");
            commitPanel.setErrorLabel("<html><font color=\"#002080\">" + string + "</font></html>");
            bl = true;
        }
        if (hashSet.size() > 1) {
            commitTable.setColumns(new String[]{"name", "branch", "status", "action", "path"});
        } else {
            commitTable.setColumns(new String[]{"name", "status", "action", "path"});
        }
        String string2 = (String)commitPanel.getClientProperty("contentTitle");
        hgFileNode2 = (DialogDescriptor)commitPanel.getClientProperty("DialogDescriptor");
        if (hashSet.size() <= 1) {
            String string3;
            String string4 = string3 = hashSet.size() == 0 ? null : (String)hashSet.iterator().next();
            if (string3 == null) {
                hgFileNode2.setTitle(MessageFormat.format(resourceBundle.getString("CTL_CommitDialog_Title"), string2));
                object = "";
            } else {
                hgFileNode2.setTitle(MessageFormat.format(resourceBundle.getString("CTL_CommitDialog_Title_Branch"), string2, string3));
                string = MessageFormat.format(resourceBundle.getString("MSG_CommitForm_InfoBranch"), string3);
                object = "<html><font color=\"#002080\">" + string + "</font></html>";
            }
        } else {
            hgFileNode2.setTitle(MessageFormat.format(resourceBundle.getString("CTL_CommitDialog_Title_Branches"), string2));
            String string5 = resourceBundle.getString("MSG_CommitForm_ErrorMultipleBranches");
            object = "<html><font color=\"#CC0000\">" + string5 + "</font></html>";
        }
        if (!bl) {
            commitPanel.setErrorLabel((String)object);
            bl2 = true;
        }
        jButton.setEnabled(bl2 && CommitAction.containsCommitable(commitTable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void performCommit(String string, Map<HgFileNode, CommitOptions> map, VCSContext vCSContext, HgProgressSupport hgProgressSupport, String string2, OutputLogger outputLogger) {
        FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
        File file = HgUtils.getRootFile(vCSContext);
        ArrayList<File> arrayList = new ArrayList<File>();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        ArrayList<File> arrayList3 = new ArrayList<File>();
        Iterator<HgFileNode> iterator = map.keySet().iterator();
        ArrayList<String> arrayList4 = new ArrayList<String>();
        ArrayList<String> arrayList5 = new ArrayList<String>();
        while (iterator.hasNext()) {
            if (hgProgressSupport.isCanceled()) {
                return;
            }
            HgFileNode hgFileNode = iterator.next();
            CommitOptions object2 = map.get(hgFileNode);
            if (object2 != CommitOptions.EXCLUDE) {
                int n = fileStatusCache.getStatus(hgFileNode.getFile()).getStatus();
                if ((n & 4) != 0) {
                    arrayList.add(hgFileNode.getFile());
                } else if ((n & 0x800) != 0) {
                    arrayList2.add(hgFileNode.getFile());
                }
                arrayList3.add(hgFileNode.getFile());
                arrayList5.add(hgFileNode.getFile().getAbsolutePath());
                continue;
            }
            arrayList4.add(hgFileNode.getFile().getAbsolutePath());
        }
        if (hgProgressSupport.isCanceled()) {
            return;
        }
        if (!arrayList4.isEmpty()) {
            HgModuleConfig.getDefault().addExclusionPaths(arrayList4);
        }
        if (!arrayList5.isEmpty()) {
            HgModuleConfig.getDefault().removeExclusionPaths(arrayList5);
        }
        try {
            try {
                outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE"));
                outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE_SEP"));
                outputLogger.output(string);
                if (arrayList.size() > 0) {
                    HgCommand.doAdd(file, arrayList, outputLogger);
                    for (File file2 : arrayList) {
                        outputLogger.output("hg add " + file2.getName());
                    }
                }
                if (arrayList2.size() > 0) {
                    HgCommand.doRemove(file, arrayList2, outputLogger);
                    for (File file3 : arrayList2) {
                        outputLogger.output("hg delete " + file3.getName());
                    }
                }
                HgCommand.doCommit(file, arrayList3, string, outputLogger);
                HgRepositoryContextCache.setHasHistory(vCSContext);
                if (arrayList3.size() == 1) {
                    outputLogger.output(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_INIT_SEP_ONE", (Object)arrayList3.size(), (Object)string2));
                } else {
                    outputLogger.output(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_INIT_SEP", (Object)arrayList3.size(), (Object)string2));
                }
                for (File file4 : arrayList3) {
                    outputLogger.output("\t" + file4.getAbsolutePath());
                }
                Object var18_25 = null;
                fileStatusCache.refreshCached(vCSContext);
                outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_DONE"));
                outputLogger.output("");
            }
            catch (HgException hgException) {
                NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
                DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
                Object var18_26 = null;
                fileStatusCache.refreshCached(vCSContext);
                outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_DONE"));
                outputLogger.output("");
            }
        }
        catch (Throwable throwable) {
            Object var18_27 = null;
            fileStatusCache.refreshCached(vCSContext);
            outputLogger.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_DONE"));
            outputLogger.output("");
            throw throwable;
        }
    }
}

