/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.diff;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.diff.DiffTopComponent;
import org.netbeans.modules.mercurial.ui.diff.MultiDiffPanel;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.util.NbBundle;

public class DiffAction
extends ContextAction {
    private final VCSContext context;

    public DiffAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        boolean bl;
        String string = Utils.getContextDisplayName((VCSContext)this.context);
        File file = HgUtils.getRootFile(this.context);
        File[] fileArray = this.context.getRootFiles().toArray(new File[this.context.getRootFiles().size()]);
        boolean bl2 = bl = file == null || fileArray == null || fileArray.length == 0;
        if (bl) {
            OutputLogger outputLogger = OutputLogger.getLogger(Mercurial.MERCURIAL_OUTPUT_TAB_TITLE);
            outputLogger.outputInRed(NbBundle.getMessage(DiffAction.class, (String)"MSG_DIFF_TITLE"));
            outputLogger.outputInRed(NbBundle.getMessage(DiffAction.class, (String)"MSG_DIFF_TITLE_SEP"));
            outputLogger.outputInRed(NbBundle.getMessage(DiffAction.class, (String)"MSG_DIFF_NOT_SUPPORTED_INVIEW_INFO"));
            outputLogger.output("");
            outputLogger.closeLog();
            JOptionPane.showMessageDialog(null, NbBundle.getMessage(DiffAction.class, (String)"MSG_DIFF_NOT_SUPPORTED_INVIEW"), NbBundle.getMessage(DiffAction.class, (String)"MSG_DIFF_NOT_SUPPORTED_INVIEW_TITLE"), 1);
            return;
        }
        DiffAction.diff(this.context, 0, string);
    }

    public boolean isEnabled() {
        FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
        return fileStatusCache.containsFileOfStatus(this.context, 6612);
    }

    public static void diff(VCSContext vCSContext, int n, String string) {
        MultiDiffPanel multiDiffPanel = new MultiDiffPanel(vCSContext, n, string);
        DiffTopComponent diffTopComponent = new DiffTopComponent(multiDiffPanel);
        diffTopComponent.setName(NbBundle.getMessage(DiffAction.class, (String)"CTL_DiffPanel_Title", (Object)string));
        diffTopComponent.open();
        diffTopComponent.requestActive();
    }

    public static void diff(File file, String string, String string2) {
        MultiDiffPanel multiDiffPanel = new MultiDiffPanel(file, string, string2);
        DiffTopComponent diffTopComponent = new DiffTopComponent(multiDiffPanel);
        diffTopComponent.setName(NbBundle.getMessage(DiffAction.class, (String)"CTL_DiffPanel_Title", (Object)file.getName()));
        diffTopComponent.open();
        diffTopComponent.requestActive();
    }
}

