/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.log;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import javax.swing.SwingUtilities;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.log.SearchHistoryTopComponent;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class SearchHistoryAction
extends ContextAction {
    private final VCSContext context;
    static final int DIRECTORY_ENABLED_STATUS = -8;
    static final int FILE_ENABLED_STATUS = -8;

    public SearchHistoryAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    protected String getBaseName(Node[] nodeArray) {
        return "CTL_MenuItem_SearchHistory";
    }

    protected int getFileEnabledStatus() {
        return -8;
    }

    protected int getDirectoryEnabledStatus() {
        return -8;
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction(ActionEvent actionEvent) {
        String string = NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SearchHistory_Title", (Object)Utils.getContextDisplayName((VCSContext)this.context));
        SearchHistoryAction.openHistory(this.context, string);
    }

    public static void openHistory(final VCSContext vCSContext, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (vCSContext == null) {
                    return;
                }
                SearchHistoryAction.outputSearchContextTab(vCSContext, "MSG_Log_Title");
                SearchHistoryTopComponent searchHistoryTopComponent = new SearchHistoryTopComponent(vCSContext);
                searchHistoryTopComponent.setDisplayName(string);
                searchHistoryTopComponent.open();
                searchHistoryTopComponent.requestActive();
            }
        });
    }

    private static void outputSearchContextTab(VCSContext vCSContext, String string) {
        File file = HgUtils.getRootFile(vCSContext);
        OutputLogger outputLogger = OutputLogger.getLogger(file.getAbsolutePath());
        outputLogger.outputInRed(NbBundle.getMessage(SearchHistoryAction.class, (String)string));
        outputLogger.outputInRed(NbBundle.getMessage(SearchHistoryAction.class, (String)"MSG_Log_Title_Sep"));
        File[] fileArray = vCSContext.getFiles().toArray(new File[0]);
        outputLogger.output(NbBundle.getMessage(SearchHistoryAction.class, (String)"MSG_LOG_CONTEXT_SEP"));
        for (File file2 : fileArray) {
            outputLogger.output(file2.getAbsolutePath());
        }
        outputLogger.outputInRed("");
        outputLogger.closeLog();
    }

    public static void openIncoming(final VCSContext vCSContext, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (vCSContext == null) {
                    return;
                }
                SearchHistoryAction.outputSearchContextTab(vCSContext, "MSG_LogIncoming_Title");
                SearchHistoryTopComponent searchHistoryTopComponent = new SearchHistoryTopComponent(vCSContext);
                searchHistoryTopComponent.setDisplayName(string);
                searchHistoryTopComponent.open();
                searchHistoryTopComponent.requestActive();
                searchHistoryTopComponent.searchIncoming();
            }
        });
    }

    public static void openOut(final VCSContext vCSContext, final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (vCSContext == null) {
                    return;
                }
                SearchHistoryAction.outputSearchContextTab(vCSContext, "MSG_LogOut_Title");
                SearchHistoryTopComponent searchHistoryTopComponent = new SearchHistoryTopComponent(vCSContext);
                searchHistoryTopComponent.setDisplayName(string);
                searchHistoryTopComponent.open();
                searchHistoryTopComponent.requestActive();
                searchHistoryTopComponent.searchOut();
            }
        });
    }

    public static void openSearch(String string, String string2, String string3, Date date) {
        SearchHistoryAction.openSearch(SearchHistoryAction.getDefaultContext(), string, string2, string3, date);
    }

    public static void openSearch(VCSContext vCSContext, String string, String string2, String string3, Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, 1);
        Date date2 = calendar.getTime();
        calendar.setTime(date);
        calendar.add(5, -1);
        Date date3 = calendar.getTime();
        if (string2 != null && string2.indexOf(10) != -1) {
            string2 = string2.substring(0, string2.indexOf(10));
        }
        SearchHistoryTopComponent searchHistoryTopComponent = new SearchHistoryTopComponent(vCSContext, string2, string3, date3, date2);
        String string4 = NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SearchHistory_Title", (Object)string);
        searchHistoryTopComponent.setDisplayName(string4);
        searchHistoryTopComponent.open();
        searchHistoryTopComponent.requestActive();
        searchHistoryTopComponent.search();
    }

    private static VCSContext getDefaultContext() {
        Node[] nodeArray = TopComponent.getRegistry().getActivatedNodes();
        return nodeArray != null ? VCSContext.forNodes((Node[])nodeArray) : VCSContext.EMPTY;
    }

    public static void openSearch(String string, File file, long l) {
        SearchHistoryTopComponent searchHistoryTopComponent = new SearchHistoryTopComponent(string, file, l);
        String string2 = NbBundle.getMessage(SearchHistoryAction.class, (String)"CTL_SearchHistory_Title", (Object)string);
        searchHistoryTopComponent.setDisplayName(string2);
        searchHistoryTopComponent.open();
        searchHistoryTopComponent.requestActive();
        searchHistoryTopComponent.search();
    }
}

