/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.merge;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class MergeRevisionsPanel
extends JPanel {
    private File repository;
    private RequestProcessor.Task refreshViewTask;
    private Thread refreshViewThread;
    private static final RequestProcessor rp = new RequestProcessor("MercurialMerge", 1);
    private static final int HG_HEAD_TARGET_LIMIT = 100;
    private JComboBox revisionsComboBox;
    private JLabel revisionsLabel;

    public MergeRevisionsPanel(File file) {
        this.repository = file;
        this.refreshViewTask = rp.create((Runnable)new RefreshViewTask());
        this.initComponents();
        this.refreshViewTask.schedule(0);
    }

    public String getSelectedRevision() {
        String string = (String)this.revisionsComboBox.getSelectedItem();
        if (string != null) {
            int n = string.indexOf(" (");
            string = n > 0 ? string.substring(0, n) : null;
        }
        return string;
    }

    private void initComponents() {
        this.revisionsLabel = new JLabel();
        this.revisionsComboBox = new JComboBox();
        this.revisionsLabel.setText(NbBundle.getMessage(MergeRevisionsPanel.class, (String)"MSG_MERGE_CHOOSE_REVISION"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().add(42, 42, 42).add((Component)this.revisionsLabel).addPreferredGap(0, 51, Short.MAX_VALUE).add((Component)this.revisionsComboBox, -2, 147, -2).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().add(27, 27, 27).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.revisionsComboBox, -2, -1, -2).add((Component)this.revisionsLabel)).addContainerGap(42, Short.MAX_VALUE)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupModels() {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(MergeRevisionsPanel.class, (String)"MSG_MERGE_REFRESHING_HEAD_VERSIONS"));
        try {
            this.refreshViewThread = Thread.currentThread();
            Thread.interrupted();
            progressHandle.start();
            this.refreshRevisions();
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            SwingUtilities.invokeLater(new Runnable(progressHandle){
                final /* synthetic */ ProgressHandle val$ph;
                {
                    this.val$ph = progressHandle;
                }

                public void run() {
                    this.val$ph.finish();
                    MergeRevisionsPanel.this.refreshViewThread = null;
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void refreshRevisions() {
        try {
            List<String> list = HgCommand.getHeadChangeSetIds(this.repository);
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            if (list == null) {
                boolean bl = false;
                linkedHashSet.add(NbBundle.getMessage(MergeRevisionsPanel.class, (String)"MSG_MERGE_HEAD_REVISION_DEFAULT"));
            } else {
                int n = list.size();
                for (int i = 0; i < n && i < 100; ++i) {
                    linkedHashSet.add(list.get(i));
                }
            }
            DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel(new Vector(linkedHashSet));
            this.revisionsComboBox.setModel(defaultComboBoxModel);
            if (linkedHashSet.size() > 0) {
                this.revisionsComboBox.setSelectedIndex(0);
            }
        }
        catch (HgException hgException) {
            Exceptions.printStackTrace((Throwable)hgException);
        }
    }

    private class RefreshViewTask
    implements Runnable {
        private RefreshViewTask() {
        }

        public void run() {
            MergeRevisionsPanel.this.setupModels();
        }
    }
}

