/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.status;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.Calendar;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgProgressSupport;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.ui.status.HgVersioningTopComponent;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;

public class StatusAction
extends ContextAction {
    private final VCSContext context;

    public StatusAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        File[] fileArray = this.context.getRootFiles().toArray(new File[this.context.getRootFiles().size()]);
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        HgVersioningTopComponent hgVersioningTopComponent = HgVersioningTopComponent.findInstance();
        hgVersioningTopComponent.setContentTitle(Utils.getContextDisplayName((VCSContext)this.context));
        hgVersioningTopComponent.setContext(this.context);
        hgVersioningTopComponent.open();
        hgVersioningTopComponent.requestActive();
        hgVersioningTopComponent.performRefreshAction();
    }

    public boolean isEnabled() {
        return HgUtils.getRootFile(this.context) != null;
    }

    public static void executeStatus(VCSContext vCSContext, HgProgressSupport hgProgressSupport) {
        if (vCSContext == null || vCSContext.getRootFiles().size() == 0) {
            return;
        }
        File file = HgUtils.getRootFile(vCSContext);
        if (file == null) {
            return;
        }
        try {
            FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
            Calendar calendar = Calendar.getInstance();
            fileStatusCache.refreshCached(vCSContext);
            Calendar calendar2 = Calendar.getInstance();
            Mercurial.LOG.log(Level.FINE, "executeStatus: refreshCached took {0} millisecs", calendar2.getTimeInMillis() - calendar.getTimeInMillis());
            for (File file2 : vCSContext.getRootFiles()) {
                if (hgProgressSupport.isCanceled()) {
                    return;
                }
                if (file2.isDirectory()) {
                    Map<File, FileInformation> map = HgCommand.getInterestingStatus(file, file2);
                    if (map.isEmpty()) continue;
                    Set<File> set = map.keySet();
                    Map<File, Map<File, FileInformation>> map2 = HgUtils.getInterestingDirs(map, set);
                    calendar = Calendar.getInstance();
                    for (File file3 : set) {
                        if (hgProgressSupport.isCanceled()) {
                            return;
                        }
                        FileInformation fileInformation = map.get(file3);
                        fileStatusCache.refreshFileStatus(file3, fileInformation, map2.get(file3.isDirectory() ? file3 : file3.getParentFile()));
                    }
                    calendar2 = Calendar.getInstance();
                    Mercurial.LOG.log(Level.FINE, "executeStatus: process interesting files took {0} millisecs", calendar2.getTimeInMillis() - calendar.getTimeInMillis());
                    continue;
                }
                fileStatusCache.refresh(file2, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
            }
        }
        catch (HgException hgException) {
            hgProgressSupport.annotate(hgException);
        }
    }
}

