/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.view;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JOptionPane;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.OutputLogger;
import org.netbeans.modules.mercurial.config.HgConfigFiles;
import org.netbeans.modules.mercurial.ui.actions.ContextAction;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.mercurial.util.HgUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ViewAction
extends ContextAction {
    private final VCSContext context;
    private static final String HG_SCRIPTS_DIR = "scripts";

    public ViewAction(String string, VCSContext vCSContext) {
        this.context = vCSContext;
        this.putValue("Name", string);
    }

    public void performAction(ActionEvent actionEvent) {
        final File file = HgUtils.getRootFile(this.context);
        if (file == null) {
            return;
        }
        String string = file.getAbsolutePath();
        RequestProcessor requestProcessor = RequestProcessor.getDefault();
        requestProcessor.post(new Runnable(){

            public void run() {
                ViewAction.performView(file);
            }
        });
    }

    static void performView(File file) {
        OutputLogger outputLogger = OutputLogger.getLogger(file.getAbsolutePath());
        try {
            outputLogger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_TITLE"));
            outputLogger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_TITLE_SEP"));
            String string = "hgk";
            if (Utilities.isWindows()) {
                string = string + ".cmd";
            }
            boolean bl = false;
            if (HgUtils.isInUserPath(string)) {
                bl = true;
            } else if (HgUtils.isSolaris()) {
                File file2 = new File("/usr/demo/mercurial", string);
                if (file2.exists() && file2.isFile()) {
                    bl = true;
                }
            } else if (Utilities.isWindows()) {
                bl = HgUtils.isInUserPath(HG_SCRIPTS_DIR + File.separator + string);
            }
            boolean bl2 = HgConfigFiles.getInstance().containsProperty("extensions", "hgext.hgk");
            if (!bl) {
                outputLogger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_HGK_NOT_FOUND_INFO"));
                outputLogger.output("");
                JOptionPane.showMessageDialog(null, NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_HGK_NOT_FOUND"), NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_HGK_NOT_FOUND_TITLE"), 1);
                outputLogger.closeLog();
                return;
            }
            if (!bl2) {
                boolean bl3 = false;
                bl3 = HgUtils.confirmDialog(ViewAction.class, "MSG_VIEW_SETHGK_PROP_CONFIRM_TITLE", "MSG_VIEW_SETHGK_PROP_CONFIRM_QUERY");
                if (bl3) {
                    outputLogger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_SETHGK_PROP_DO_INFO"));
                    HgConfigFiles.getInstance().setProperty("hgext.hgk", "");
                } else {
                    outputLogger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_NOTSETHGK_PROP_INFO"));
                    outputLogger.output("");
                    outputLogger.closeLog();
                    return;
                }
            }
            outputLogger.outputInRed(NbBundle.getMessage(ViewAction.class, (String)"MSG_VIEW_LAUNCH_INFO", (Object)file.getAbsolutePath()));
            outputLogger.output("");
            HgCommand.doView(file, outputLogger);
            outputLogger.closeLog();
        }
        catch (HgException hgException) {
            NotifyDescriptor.Exception exception = new NotifyDescriptor.Exception((Throwable)hgException);
            DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)exception);
        }
    }

    public boolean isEnabled() {
        return HgUtils.getRootFile(this.context) != null;
    }
}

