/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.ui.wizards;

import java.awt.Component;
import java.awt.Dialog;
import java.io.File;
import java.text.MessageFormat;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.mercurial.ui.clone.CloneAction;
import org.netbeans.modules.mercurial.ui.wizards.CloneDestinationDirectoryWizardPanel;
import org.netbeans.modules.mercurial.ui.wizards.ClonePathsWizardPanel;
import org.netbeans.modules.mercurial.ui.wizards.CloneRepositoryWizardPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;

public final class CloneWizardAction
extends CallableSystemAction
implements ChangeListener {
    private WizardDescriptor.Panel<WizardDescriptor>[] panels;
    private static CloneWizardAction instance;
    private WizardDescriptor wizardDescriptor;
    private CloneRepositoryWizardPanel cloneRepositoryWizardPanel;
    private CloneDestinationDirectoryWizardPanel cloneDestinationDirectoryWizardPanel;
    private ClonePathsWizardPanel clonePathsWizardPanel;
    private PanelsIterator wizardIterator;
    private String errorMessage;

    public static synchronized CloneWizardAction getInstance() {
        if (instance == null) {
            instance = new CloneWizardAction();
        }
        return instance;
    }

    public void performAction() {
        boolean bl;
        this.wizardIterator = new PanelsIterator();
        this.wizardDescriptor = new WizardDescriptor((WizardDescriptor.Iterator)this.wizardIterator);
        this.wizardDescriptor.setTitleFormat(new MessageFormat("{0}"));
        this.wizardDescriptor.setTitle(NbBundle.getMessage(CloneWizardAction.class, (String)"CTL_Clone"));
        Dialog dialog = DialogDisplayer.getDefault().createDialog((DialogDescriptor)this.wizardDescriptor);
        dialog.setVisible(true);
        dialog.toFront();
        boolean bl2 = bl = this.wizardDescriptor.getValue() != WizardDescriptor.FINISH_OPTION;
        if (!bl) {
            String string = (String)this.wizardDescriptor.getProperty("repository");
            String string2 = (String)this.wizardDescriptor.getProperty("username");
            String string3 = (String)this.wizardDescriptor.getProperty("password");
            String string4 = (String)this.wizardDescriptor.getProperty("directory");
            String string5 = (String)this.wizardDescriptor.getProperty("cloneName");
            String string6 = (String)this.wizardDescriptor.getProperty("defaultPullPath");
            String string7 = (String)this.wizardDescriptor.getProperty("defaultPushPath");
            File file = new File(string4, string5);
            CloneAction.performClone(string, file.getAbsolutePath(), true, null, string6, string7);
        }
    }

    public void stateChanged(ChangeEvent changeEvent) {
        if (this.wizardIterator == null) {
            return;
        }
        WizardDescriptor.Panel panel = this.wizardIterator.current();
        if (panel == null) {
            return;
        }
        if (panel == this.cloneRepositoryWizardPanel) {
            this.errorMessage = this.cloneRepositoryWizardPanel.getErrorMessage();
        } else if (panel == this.clonePathsWizardPanel) {
            this.errorMessage = this.clonePathsWizardPanel.getErrorMessage();
        } else if (panel == this.cloneDestinationDirectoryWizardPanel) {
            this.errorMessage = this.cloneDestinationDirectoryWizardPanel.getErrorMessage();
        }
        if (this.wizardDescriptor != null) {
            this.wizardDescriptor.putProperty("WizardPanel_errorMessage", (Object)this.errorMessage);
        }
    }

    public String getName() {
        return "Start Sample Wizard";
    }

    public String iconResource() {
        return null;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(CloneWizardAction.class);
    }

    protected boolean asynchronous() {
        return false;
    }

    private class PanelsIterator
    extends WizardDescriptor.ArrayIterator {
        PanelsIterator() {
        }

        protected WizardDescriptor.Panel[] initializePanels() {
            WizardDescriptor.Panel[] panelArray = new WizardDescriptor.Panel[2];
            CloneWizardAction.this.cloneRepositoryWizardPanel = new CloneRepositoryWizardPanel();
            CloneWizardAction.this.clonePathsWizardPanel = new ClonePathsWizardPanel();
            CloneWizardAction.this.cloneDestinationDirectoryWizardPanel = new CloneDestinationDirectoryWizardPanel();
            panelArray = new WizardDescriptor.Panel[]{CloneWizardAction.this.cloneRepositoryWizardPanel, CloneWizardAction.this.clonePathsWizardPanel, CloneWizardAction.this.cloneDestinationDirectoryWizardPanel};
            panelArray[0].addChangeListener((ChangeListener)CloneWizardAction.this);
            panelArray[1].addChangeListener((ChangeListener)CloneWizardAction.this);
            String[] stringArray = new String[panelArray.length];
            for (int i = 0; i < panelArray.length; ++i) {
                Component component = panelArray[i].getComponent();
                stringArray[i] = component.getName();
                if (!(component instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)component;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
            return panelArray;
        }
    }
}

