/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.modules.mercurial.FileInformation;
import org.netbeans.modules.mercurial.FileStatusCache;
import org.netbeans.modules.mercurial.HgException;
import org.netbeans.modules.mercurial.HgModuleConfig;
import org.netbeans.modules.mercurial.Mercurial;
import org.netbeans.modules.mercurial.ui.status.SyncFileNode;
import org.netbeans.modules.mercurial.util.HgCommand;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HgUtils {
    private static final Pattern httpPasswordPattern = Pattern.compile("(https*://)(\\w+\\b):(\\b\\S*)@");
    private static final String httpPasswordReplacementStr = "$1$2:\\*\\*\\*\\*@";
    private static final Pattern metadataPattern = Pattern.compile(".*\\" + File.separatorChar + "(\\.)hg(\\" + File.separatorChar + ".*|$)");
    private static final String[] HG_IGNORE_FILES = new String[]{"\\.orig$", "\\.orig\\..*$", "\\.chg\\..*$", "\\.rej$", "\\.conflict\\~$"};
    private static final String HG_IGNORE_ORIG_FILES = "\\.orig$";
    private static final String HG_IGNORE_ORIG_ANY_FILES = "\\.orig\\..*$";
    private static final String HG_IGNORE_CHG_ANY_FILES = "\\.chg\\..*$";
    private static final String HG_IGNORE_REJ_ANY_FILES = "\\.rej$";
    private static final String HG_IGNORE_CONFLICT_ANY_FILES = "\\.conflict\\~$";
    private static final String FILENAME_HGIGNORE = ".hgignore";
    private static HashMap<String, Set<Pattern>> ignorePatterns;
    private static int HG_NUM_PATTERNS_TO_CHECK;

    public static Date addDaysToDate(Date date, int n) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, n);
        return calendar.getTime();
    }

    public static String getTodaysDateStr() {
        Date date = new Date();
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    public static String getLastWeeksDateStr() {
        Date date = HgUtils.addDaysToDate(new Date(), -7);
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    public static boolean isSolaris() {
        return System.getProperty("os.name").equals("SunOS");
    }

    public static String replaceHttpPassword(String string) {
        Matcher matcher = httpPasswordPattern.matcher(string);
        return matcher.replaceAll(httpPasswordReplacementStr);
    }

    public static List<String> replaceHttpPassword(List<String> list) {
        if (list == null) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (String string : list) {
            arrayList.add(HgUtils.replaceHttpPassword(string));
        }
        return arrayList;
    }

    public static boolean isInUserPath(String string) {
        String string2 = HgUtils.findInUserPath(string);
        return string2 != null && !string2.equals("");
    }

    public static String findInUserPath(String string) {
        String[] stringArray;
        String string2 = System.getenv().get("PATH");
        if (string2 == null) {
            string2 = System.getenv().get("Path");
        }
        if (string2 == null) {
            string2 = System.getenv().get("path");
        }
        String string3 = System.getProperty("path.separator");
        if (string2 == null || string3 == null) {
            return "";
        }
        for (String string4 : stringArray = string2.split(string3)) {
            File file = new File(string4, string);
            if (!file.exists() || file.isDirectory()) continue;
            return string4;
        }
        return "";
    }

    public static boolean confirmDialog(Class clazz, String string, String string2) {
        int n = JOptionPane.showOptionDialog(null, NbBundle.getMessage((Class)clazz, (String)string2), NbBundle.getMessage((Class)clazz, (String)string), 0, 3, null, null, null);
        return n == 0;
    }

    public static void warningDialog(Class clazz, String string, String string2) {
        JOptionPane.showMessageDialog(null, NbBundle.getMessage((Class)clazz, (String)string2), NbBundle.getMessage((Class)clazz, (String)string), 2);
    }

    public static String stripDoubleSlash(String string) {
        if (Utilities.isWindows()) {
            return string.replace("\\\\", "\\");
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static File fixPathsInIniFileOnWindows(File file) {
        File file2;
        block28: {
            PrintWriter printWriter;
            BufferedReader bufferedReader;
            block26: {
                block24: {
                    if (!Utilities.isWindows()) {
                        return null;
                    }
                    file2 = null;
                    bufferedReader = null;
                    printWriter = null;
                    if (file != null && file.isFile() && file.canWrite()) break block24;
                    File file3 = null;
                    Object var7_8 = null;
                    try {
                        if (printWriter != null) {
                            printWriter.close();
                        }
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return file3;
                }
                file2 = File.createTempFile("hg-", "tmp");
                if (file2 != null) break block26;
                File file4 = null;
                Object var7_9 = null;
                try {
                    if (printWriter != null) {
                        printWriter.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return file4;
            }
            bufferedReader = new BufferedReader(new FileReader(file));
            printWriter = new PrintWriter(new FileWriter(file2));
            String string = null;
            String string2 = null;
            while ((string = bufferedReader.readLine()) != null) {
                string2 = string.replace("\\\\", "\\");
                printWriter.println(string2.replace("\\", "\\\\"));
                printWriter.flush();
            }
            Object var7_10 = null;
            try {
                if (printWriter != null) {
                    printWriter.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                break block28;
            }
            catch (IOException iOException) {}
            break block28;
            {
                catch (IOException iOException) {
                    Object var7_11 = null;
                    try {
                        if (printWriter != null) {
                            printWriter.close();
                        }
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        break block28;
                    }
                    catch (IOException iOException2) {}
                }
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                try {
                    if (printWriter != null) {
                        printWriter.close();
                    }
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        return file2;
    }

    public static boolean isLocallyAdded(File file) {
        if (file == null) {
            return false;
        }
        Mercurial mercurial = Mercurial.getInstance();
        return (mercurial.getFileStatusCache().getStatus(file).getStatus() & 0x1000) != 0;
    }

    private static void resetIgnorePatterns(File file) {
        if (ignorePatterns == null) {
            return;
        }
        String string = file.getAbsolutePath();
        ignorePatterns.remove(string);
    }

    private static Set<Pattern> getIgnorePatterns(File file) {
        String string;
        Set<Pattern> set;
        if (ignorePatterns == null) {
            ignorePatterns = new HashMap();
        }
        if ((set = ignorePatterns.get(string = file.getAbsolutePath())) == null) {
            set = new HashSet<Pattern>(5);
            HgUtils.addIgnorePatterns(set, file);
            ignorePatterns.put(string, set);
        }
        return set;
    }

    public static boolean isIgnored(File file) {
        return HgUtils.isIgnored(file, true);
    }

    public static boolean isIgnored(File file, boolean bl) {
        int n;
        Object object;
        Object object2;
        if (file == null) {
            return false;
        }
        String string = file.getPath();
        File file2 = Mercurial.getInstance().getTopmostManagedParent(file);
        if (file2 == null || file2.equals(file)) {
            return false;
        }
        if (file.isDirectory()) {
            object2 = ProjectManager.getDefault();
            object = FileUtil.toFileObject((File)file);
            if (object != null && object2.isProject((FileObject)object)) {
                return false;
            }
        }
        object2 = HgUtils.getIgnorePatterns(file2);
        string = string.substring(file2.getAbsolutePath().length() + 1);
        object = object2.iterator();
        while (object.hasNext()) {
            Pattern pattern = (Pattern)object.next();
            if (!pattern.matcher(string).find()) continue;
            return true;
        }
        object = file.getParentFile();
        while (!((File)object).equals(file2)) {
            if (HgUtils.isIgnored((File)object, false)) {
                return true;
            }
            object = ((File)object).getParentFile();
        }
        if (FILENAME_HGIGNORE.equals(file.getName())) {
            return false;
        }
        return bl && (n = SharabilityQuery.getSharability((File)file)) == 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void createIgnored(File file) {
        block16: {
            File file2;
            Mercurial mercurial;
            BufferedWriter bufferedWriter;
            block15: {
                if (file == null) {
                    return;
                }
                bufferedWriter = null;
                mercurial = Mercurial.getInstance();
                File file3 = mercurial.getTopmostManagedParent(file);
                if (file3 == null) {
                    return;
                }
                file2 = new File(file3, FILENAME_HGIGNORE);
                if (!file2.exists()) {
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file2)));
                    for (String string : HG_IGNORE_FILES) {
                        bufferedWriter.write(string + "\n");
                    }
                    break block15;
                }
                HgUtils.addToExistingIgnoredFile(file2);
            }
            Object var10_10 = null;
            try {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
                mercurial.getFileStatusCache().refresh(file2, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
            }
            catch (IOException iOException) {
                Mercurial.LOG.log(Level.FINE, "createIgnored(): File {0} - {1}", new Object[]{file2.getAbsolutePath(), iOException.toString()});
            }
            break block16;
            {
                catch (IOException iOException) {
                    Mercurial.LOG.log(Level.FINE, "createIgnored(): File {0} - {1}", new Object[]{file2.getAbsolutePath(), iOException.toString()});
                    Object var10_11 = null;
                    try {
                        if (bufferedWriter != null) {
                            bufferedWriter.close();
                        }
                        mercurial.getFileStatusCache().refresh(file2, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                    }
                    catch (IOException iOException2) {
                        Mercurial.LOG.log(Level.FINE, "createIgnored(): File {0} - {1}", new Object[]{file2.getAbsolutePath(), iOException2.toString()});
                    }
                }
            }
            catch (Throwable throwable) {
                Object var10_12 = null;
                try {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                    mercurial.getFileStatusCache().refresh(file2, FileStatusCache.REPOSITORY_STATUS_UNKNOWN);
                }
                catch (IOException iOException) {
                    Mercurial.LOG.log(Level.FINE, "createIgnored(): File {0} - {1}", new Object[]{file2.getAbsolutePath(), iOException.toString()});
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void addToExistingIgnoredFile(File var0) {
        block45: {
            block44: {
                if (var0 == null) return;
                if (var0.exists() == false) return;
                if (!var0.canWrite()) {
                    return;
                }
                var1_1 = null;
                var2_2 = null;
                var3_3 = null;
                var4_4 = false;
                var5_5 = false;
                var6_6 = false;
                var7_7 = false;
                var8_8 = false;
                if (!HgUtils.$assertionsDisabled && HgUtils.HG_IGNORE_FILES.length != HgUtils.HG_NUM_PATTERNS_TO_CHECK) {
                    throw new AssertionError();
                }
                try {
                    try {
                        var1_1 = new File(var0.getAbsolutePath() + ".tmp");
                        if (var1_1 == null) {
                            var11_9 = null;
                            break block44;
                        }
                        var2_2 = new BufferedReader(new FileReader(var0));
                        var3_3 = new PrintWriter(new FileWriter(var1_1));
                        var9_21 = null;
                        while ((var9_21 = var2_2.readLine()) != null) {
                            if (!var4_4 && var9_21.equals("\\.orig\\..*$")) {
                                var4_4 = true;
                            } else if (!var5_5 && var9_21.equals("\\.orig$")) {
                                var5_5 = true;
                            } else if (!var6_6 && var9_21.equals("\\.chg\\..*$")) {
                                var6_6 = true;
                            } else if (!var7_7 && var9_21.equals("\\.rej$")) {
                                var7_7 = true;
                            } else if (!var8_8 && var9_21.equals("\\.conflict\\~$")) {
                                var8_8 = true;
                            }
                            var3_3.println(var9_21);
                            var3_3.flush();
                        }
                        if (!var4_4) {
                            var3_3.println("\\.orig\\..*$");
                            var3_3.flush();
                        }
                        if (!var5_5) {
                            var3_3.println("\\.orig$");
                            var3_3.flush();
                        }
                        if (!var6_6) {
                            var3_3.println("\\.chg\\..*$");
                            var3_3.flush();
                        }
                        if (!var7_7) {
                            var3_3.println("\\.rej$");
                            var3_3.flush();
                        }
                        if (!var8_8) {
                            var3_3.println("\\.conflict\\~$");
                            var3_3.flush();
                        }
                        break block45;
                    }
                    catch (IOException var9_22) {
                        var11_11 = null;
                        try {
                            if (var3_3 != null) {
                                var3_3.close();
                            }
                            if (var2_2 != null) {
                                var2_2.close();
                            }
                            v0 = var12_17 = var4_4 == false || var5_5 == false || var6_6 == false || var7_7 == false || var8_8 == false;
                            if (!var12_17) {
                                var1_1.delete();
                                return;
                            }
                            if (!HgUtils.confirmDialog(HgUtils.class, "MSG_IGNORE_FILES_TITLE", "MSG_IGNORE_FILES")) {
                                var1_1.delete();
                                return;
                            }
                            if (var1_1 == null) return;
                            if (var1_1.isFile() == false) return;
                            if (var1_1.canWrite() == false) return;
                            if (var0 == null) return;
                            var0.delete();
                            var1_1.renameTo(var0);
                            return;
                        }
                        catch (IOException var12_18) {
                            return;
                        }
                    }
                }
                catch (Throwable var10_23) {
                    var11_12 = null;
                    ** try [egrp 2[TRYBLOCK] [6 : 361->477)] { 
lbl91:
                    // 1 sources

                    if (var3_3 != null) {
                        var3_3.close();
                    }
                    if (var2_2 != null) {
                        var2_2.close();
                    }
                    v1 = var12_19 = var4_4 == false || var5_5 == false || var6_6 == false || var7_7 == false || var8_8 == false;
                    if (!var12_19) {
                        var1_1.delete();
                        throw var10_23;
                    }
                    if (!HgUtils.confirmDialog(HgUtils.class, "MSG_IGNORE_FILES_TITLE", "MSG_IGNORE_FILES")) {
                        var1_1.delete();
                        return;
                    }
                    if (var1_1 == null) throw var10_23;
                    if (var1_1.isFile() == false) throw var10_23;
                    if (var1_1.canWrite() == false) throw var10_23;
                    if (var0 == null) throw var10_23;
                    var0.delete();
                    var1_1.renameTo(var0);
                    throw var10_23;
lbl113:
                    // 1 sources

                    catch (IOException var12_20) {
                        // empty catch block
                    }
                    throw var10_23;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 361->477)] { 
lbl118:
            // 1 sources

            if (var3_3 != null) {
                var3_3.close();
            }
            if (var2_2 != null) {
                var2_2.close();
            }
            v2 = var12_13 = var4_4 == false || var5_5 == false || var6_6 == false || var7_7 == false || var8_8 == false;
            if (!var12_13) {
                var1_1.delete();
                return;
            }
            if (!HgUtils.confirmDialog(HgUtils.class, "MSG_IGNORE_FILES_TITLE", "MSG_IGNORE_FILES")) {
                var1_1.delete();
                return;
            }
            if (var1_1 == null) return;
            if (var1_1.isFile() == false) return;
            if (var1_1.canWrite() == false) return;
            if (var0 == null) return;
            var0.delete();
            var1_1.renameTo(var0);
            return;
lbl140:
            // 1 sources

            catch (IOException var12_14) {
                // empty catch block
            }
            return;
        }
        var11_10 = null;
        try {}
        catch (IOException var12_16) {}
        if (var3_3 != null) {
            var3_3.close();
        }
        if (var2_2 != null) {
            var2_2.close();
        }
        v3 = var12_15 = var4_4 == false || var5_5 == false || var6_6 == false || var7_7 == false || var8_8 == false;
        if (!var12_15) {
            var1_1.delete();
            return;
        }
        if (!HgUtils.confirmDialog(HgUtils.class, "MSG_IGNORE_FILES_TITLE", "MSG_IGNORE_FILES")) {
            var1_1.delete();
            return;
        }
        if (var1_1 == null) return;
        if (var1_1.isFile() == false) return;
        if (var1_1.canWrite() == false) return;
        if (var0 == null) return;
        var0.delete();
        var1_1.renameTo(var0);
        return;
    }

    private static void addIgnorePatterns(Set<Pattern> set, File file) {
        Set<String> set2;
        try {
            set2 = HgUtils.readIgnoreEntries(file);
        }
        catch (IOException iOException) {
            return;
        }
        for (String string : set2) {
            if ("!".equals(string)) {
                set.clear();
                continue;
            }
            try {
                set.add(Pattern.compile(string));
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Boolean ignoreContainsSyntax(File file) throws IOException {
        File file2 = new File(file, FILENAME_HGIGNORE);
        Boolean bl = false;
        if (!file2.canRead()) {
            return bl;
        }
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(file2));
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray;
                String string2 = string.trim();
                int n = string2.indexOf("#");
                if (n != -1) {
                    if (n == 0) continue;
                    string2 = string2.substring(0, n - 1);
                }
                if (!(stringArray = string2.split(" "))[0].equals("syntax:")) continue;
                bl = true;
                break;
            }
            Object var9_8 = null;
            if (bufferedReader == null) return bl;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bufferedReader.close();
            return bl;
        }
        catch (IOException iOException) {}
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Set<String> readIgnoreEntries(File file) throws IOException {
        File file2 = new File(file, FILENAME_HGIGNORE);
        HashSet<String> hashSet = new HashSet<String>(5);
        if (!file2.canRead()) {
            return hashSet;
        }
        BufferedReader bufferedReader = null;
        try {
            String string;
            bufferedReader = new BufferedReader(new FileReader(file2));
            while ((string = bufferedReader.readLine()) != null) {
                String[] stringArray;
                String string2 = string.trim();
                if (string2.length() == 0) continue;
                int n = string2.indexOf("#");
                if (n != -1) {
                    if (n == 0) continue;
                    string2 = string2.substring(0, n - 1);
                }
                if ((stringArray = string2.split(" "))[0].equals("syntax:")) continue;
                hashSet.addAll(Arrays.asList(stringArray));
            }
            Object var9_8 = null;
            if (bufferedReader == null) return hashSet;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (bufferedReader == null) throw throwable;
            try {
                bufferedReader.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bufferedReader.close();
            return hashSet;
        }
        catch (IOException iOException) {}
        return hashSet;
    }

    private static String computePatternToIgnore(File file, File file2) {
        String string = file2.getAbsolutePath().substring(file.getAbsolutePath().length() + 1);
        return string.replace(' ', '?').replace(File.separatorChar, '/');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeIgnoreEntries(File file, Set set) throws IOException {
        File file2 = new File(file, FILENAME_HGIGNORE);
        FileObject fileObject = FileUtil.toFileObject((File)file2);
        if (set.size() == 0) {
            if (fileObject != null) {
                fileObject.delete();
            }
            return;
        }
        if (fileObject == null || !fileObject.isValid()) {
            fileObject = FileUtil.toFileObject((File)file);
            fileObject = fileObject.createData(FILENAME_HGIGNORE);
        }
        FileLock fileLock = fileObject.lock();
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(fileObject.getOutputStream(fileLock));
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                printWriter.println(iterator.next());
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            fileLock.releaseLock();
            if (printWriter != null) {
                printWriter.close();
            }
            HgUtils.resetIgnorePatterns(file);
            throw throwable;
        }
        fileLock.releaseLock();
        if (printWriter != null) {
            printWriter.close();
        }
        HgUtils.resetIgnorePatterns(file);
    }

    public static void addIgnored(File file, File[] fileArray) throws IOException {
        if (HgUtils.ignoreContainsSyntax(file).booleanValue()) {
            HgUtils.warningDialog(HgUtils.class, "MSG_UNABLE_TO_IGNORE_TITLE", "MSG_UNABLE_TO_IGNORE");
            return;
        }
        Set<String> set = HgUtils.readIgnoreEntries(file);
        for (File file2 : fileArray) {
            String string = HgUtils.computePatternToIgnore(file, file2);
            set.add(string);
        }
        HgUtils.writeIgnoreEntries(file, set);
    }

    public static void removeIgnored(File file, File[] fileArray) throws IOException {
        if (HgUtils.ignoreContainsSyntax(file).booleanValue()) {
            HgUtils.warningDialog(HgUtils.class, "MSG_UNABLE_TO_UNIGNORE_TITLE", "MSG_UNABLE_TO_UNIGNORE");
            return;
        }
        Set<String> set = HgUtils.readIgnoreEntries(file);
        for (File file2 : fileArray) {
            String string = HgUtils.computePatternToIgnore(file, file2);
            set.remove(string);
        }
        HgUtils.writeIgnoreEntries(file, set);
    }

    public static Map<File, Map<File, FileInformation>> getInterestingDirs(Map<File, FileInformation> map, Collection<File> collection) {
        HashMap<File, Map<File, FileInformation>> hashMap = new HashMap<File, Map<File, FileInformation>>();
        Calendar calendar = Calendar.getInstance();
        for (File file : collection) {
            if (file.isDirectory()) {
                if (hashMap.get(file) != null) continue;
                hashMap.put(file, new HashMap());
                continue;
            }
            File file2 = file.getParentFile();
            if (file2 == null) continue;
            if (hashMap.get(file2) == null) {
                hashMap.put(file2, new HashMap());
            }
            FileInformation fileInformation = map.get(file);
            ((Map)hashMap.get(file2)).put(file, fileInformation);
        }
        Calendar calendar2 = Calendar.getInstance();
        Mercurial.LOG.log(Level.FINE, "getInterestingDirs: process interesting Dirs took {0} millisecs", calendar2.getTimeInMillis() - calendar.getTimeInMillis());
        return hashMap;
    }

    public static VCSContext getCurrentContext(Node[] nodeArray, int n, int n2) {
        VCSContext vCSContext = HgUtils.getCurrentContext(nodeArray);
        FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
        for (File file : vCSContext.getRootFiles()) {
            FileInformation fileInformation = fileStatusCache.getStatus(file);
            if (!(file.isDirectory() ? (fileInformation.getStatus() & n2) == 0 : (fileInformation.getStatus() & n) == 0)) continue;
            return VCSContext.EMPTY;
        }
        return vCSContext;
    }

    public static VCSContext getCurrentContext(Node[] nodeArray) {
        if (nodeArray == null) {
            nodeArray = TopComponent.getRegistry().getActivatedNodes();
        }
        return VCSContext.forNodes((Node[])nodeArray);
    }

    public static String getRootPath(VCSContext vCSContext) {
        File file = HgUtils.getRootFile(vCSContext);
        return file == null ? null : file.getAbsolutePath();
    }

    public static File getRootFile(VCSContext vCSContext) {
        if (vCSContext == null) {
            return null;
        }
        Mercurial mercurial = Mercurial.getInstance();
        File[] fileArray = vCSContext.getRootFiles().toArray(new File[vCSContext.getRootFiles().size()]);
        if (fileArray == null || fileArray.length == 0) {
            return null;
        }
        File file = mercurial.getTopmostManagedParent(fileArray[0]);
        return file;
    }

    public static File getProjectFile(VCSContext vCSContext) {
        return HgUtils.getProjectFile(HgUtils.getProject(vCSContext));
    }

    public static Project getProject(VCSContext vCSContext) {
        File[] fileArray;
        if (vCSContext == null) {
            return null;
        }
        for (File file : fileArray = vCSContext.getRootFiles().toArray(new File[vCSContext.getRootFiles().size()])) {
            Project project;
            if (!file.exists()) {
                file = file.getParentFile();
            }
            if ((project = FileOwnerQuery.getOwner((FileObject)FileUtil.toFileObject((File)file))) != null) {
                return project;
            }
            Mercurial.LOG.log(Level.FINE, "HgUtils.getProjectFile(): No project for {0}", file);
        }
        return null;
    }

    public static File getProjectFile(Project project) {
        if (project == null) {
            return null;
        }
        FileObject fileObject = project.getProjectDirectory();
        return FileUtil.toFile((FileObject)fileObject);
    }

    public static File[] getProjectRootFiles(Project project) {
        if (project == null) {
            return null;
        }
        HashSet<File> hashSet = new HashSet<File>();
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            SourceGroup sourceGroup = sourceGroupArray[i];
            FileObject fileObject = sourceGroup.getRootFolder();
            File file = FileUtil.toFile((FileObject)fileObject);
            hashSet.add(file);
        }
        return hashSet.toArray(new File[hashSet.size()]);
    }

    public static boolean isPartOfMercurialMetadata(File file) {
        return metadataPattern.matcher(file.getAbsolutePath()).matches();
    }

    public static void forceStatusRefresh(File file) {
        if (Mercurial.getInstance().isAdministrative(file)) {
            return;
        }
        try {
            Map<File, FileInformation> map;
            FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
            fileStatusCache.refreshCached(file);
            File file2 = Mercurial.getInstance().getTopmostManagedParent(file);
            if (file2 == null) {
                return;
            }
            if (file.isDirectory() && !(map = HgCommand.getInterestingStatus(file2, file)).isEmpty()) {
                Set<File> set = map.keySet();
                for (File file3 : set) {
                    FileInformation fileInformation = map.get(file3);
                    fileStatusCache.refreshFileStatus(file3, fileInformation, null);
                }
            }
        }
        catch (HgException hgException) {
            // empty catch block
        }
    }

    public static void forceStatusRefresh(VCSContext vCSContext) {
        for (File file : vCSContext.getRootFiles()) {
            HgUtils.forceStatusRefresh(file);
        }
    }

    public static void forceStatusRefreshProject(VCSContext vCSContext) {
        Project project = HgUtils.getProject(vCSContext);
        if (project == null) {
            return;
        }
        File[] fileArray = HgUtils.getProjectRootFiles(project);
        for (int i = 0; i < fileArray.length; ++i) {
            HgUtils.forceStatusRefresh(fileArray[i]);
        }
    }

    public static boolean isParentOrEqual(File file, File file2) {
        while (file2 != null) {
            if (file2.equals(file)) {
                return true;
            }
            file2 = file2.getParentFile();
        }
        return false;
    }

    public static String getRelativePath(File file) {
        if (file == null) {
            return NbBundle.getMessage(SyncFileNode.class, (String)"LBL_Location_NotInRepository");
        }
        String string = file.getAbsolutePath();
        if (string == null) {
            return NbBundle.getMessage(SyncFileNode.class, (String)"LBL_Location_NotInRepository");
        }
        Mercurial mercurial = Mercurial.getInstance();
        File file2 = mercurial.getTopmostManagedParent(file);
        if (file2 == null) {
            return NbBundle.getMessage(SyncFileNode.class, (String)"LBL_Location_NotInRepository");
        }
        String string2 = file2.getAbsolutePath();
        if (string.startsWith(string2)) {
            return string.substring(string2.length() + 1);
        }
        return NbBundle.getMessage(SyncFileNode.class, (String)"LBL_Location_NotInRepository");
    }

    public static File[] flatten(File[] fileArray, int n) {
        LinkedList<File> linkedList = new LinkedList<File>();
        FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            FileInformation fileInformation = fileStatusCache.getStatus(file);
            if ((n & fileInformation.getStatus()) != 0) {
                linkedList.add(file);
            }
            File[] fileArray2 = fileStatusCache.listFiles(file);
            for (int j = 0; j < fileArray2.length; ++j) {
                File file2 = fileArray2[j];
                fileInformation = fileStatusCache.getStatus(file2);
                if ((n & fileInformation.getStatus()) == 0) continue;
                linkedList.add(file2);
            }
        }
        return linkedList.toArray(new File[linkedList.size()]);
    }

    public static File[] getModifiedFiles(VCSContext vCSContext, int n) {
        File[] fileArray = Mercurial.getInstance().getFileStatusCache().listFiles(vCSContext, n);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < fileArray.length; ++i) {
            File file = fileArray[i];
            Object object = file.getAbsolutePath();
            if (HgModuleConfig.getDefault().isExcludedFromCommit((String)object)) continue;
            arrayList.add(file);
        }
        FileStatusCache fileStatusCache = Mercurial.getInstance().getFileStatusCache();
        for (Object object : vCSContext.getRootFiles()) {
            if (!((File)object).isFile() || (fileStatusCache.getStatus((File)object).getStatus() & n) == 0 || arrayList.contains(object)) continue;
            arrayList.add(object);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    public static boolean isFileContentBinary(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return false;
        }
        try {
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            return dataObject.getCookie(EditorCookie.class) == null;
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return false;
        }
    }

    public static boolean isBinary(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            if (by >= 32 || by == 9 || by == 10 || by == 13) continue;
            return true;
        }
        return false;
    }

    public static int getComparableStatus(int n) {
        if (0 != (n & 0x40)) {
            return 0;
        }
        if (0 != (n & 0x80)) {
            return 1;
        }
        if (0 != (n & 0x800)) {
            return 10;
        }
        if (0 != (n & 0x100)) {
            return 11;
        }
        if (0 != (n & 4)) {
            return 12;
        }
        if (0 != (n & 0x1000)) {
            return 13;
        }
        if (0 != (n & 0x10)) {
            return 14;
        }
        if (0 != (n & 0x400)) {
            return 30;
        }
        if (0 != (n & 0x200)) {
            return 31;
        }
        if (0 != (n & 0x20)) {
            return 32;
        }
        if (0 != (n & 8)) {
            return 50;
        }
        if (0 != (n & 2)) {
            return 100;
        }
        if (0 != (n & 1)) {
            return 101;
        }
        if (n == 0) {
            return 102;
        }
        throw new IllegalArgumentException("Uncomparable status: " + n);
    }

    protected static int getFileEnabledStatus() {
        return -1;
    }

    protected static int getDirectoryEnabledStatus() {
        return -4;
    }

    public static String ripUserFromHost(String string) {
        int n = string.indexOf(64);
        if (n < 0) {
            return string;
        }
        return string.substring(n + 1);
    }

    private HgUtils() {
    }

    static {
        HG_NUM_PATTERNS_TO_CHECK = 5;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ByImportanceComparator<T>
    implements Comparator<FileInformation> {
        @Override
        public int compare(FileInformation fileInformation, FileInformation fileInformation2) {
            return HgUtils.getComparableStatus(fileInformation.getStatus()) - HgUtils.getComparableStatus(fileInformation2.getStatus());
        }
    }
}

