/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gototest;

import java.awt.EventQueue;
import java.util.Collection;
import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.spi.gototest.TestLocator;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.CallableSystemAction;
import org.openide.windows.TopComponent;

public class GotoOppositeAction
extends CallableSystemAction {
    private TestLocator cachedLocator;
    private FileObject cachedLocatorFo;
    private FileObject cachedFileTypeFo;
    private TestLocator.FileType cachedFileType;

    public GotoOppositeAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
        String string = NbBundle.getMessage(GotoOppositeAction.class, (String)"LBL_Action_GoToTest_trimmed");
        this.putValue("trimmed-text", string);
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)(this.getCurrentFileType() == TestLocator.FileType.TEST ? "LBL_Action_GoToSource" : "LBL_Action_GoToTest"));
    }

    public boolean isEnabled() {
        assert (EventQueue.isDispatchThread());
        return this.getCurrentFileType() != TestLocator.FileType.NEITHER;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void initialize() {
        super.initialize();
        this.putProperty("ShortDescription", NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"HINT_Action_GoToTest"));
    }

    protected boolean asynchronous() {
        return false;
    }

    public void performAction() {
        TestLocator testLocator;
        int[] nArray = new int[1];
        FileObject fileObject = this.getApplicableFileObject(nArray);
        int n = nArray[0];
        if (fileObject != null && (testLocator = this.getLocatorFor(fileObject)) != null && testLocator.appliesTo(fileObject)) {
            if (testLocator.asynchronous()) {
                testLocator.findOpposite(fileObject, n, new TestLocator.LocationListener(){

                    public void foundLocation(FileObject fileObject, TestLocator.LocationResult locationResult) {
                        if (locationResult != null) {
                            GotoOppositeAction.this.handleResult(locationResult);
                        }
                    }
                });
            } else {
                TestLocator.LocationResult locationResult = testLocator.findOpposite(fileObject, n);
                if (locationResult != null) {
                    this.handleResult(locationResult);
                }
            }
        }
    }

    private void handleResult(TestLocator.LocationResult locationResult) {
        if (locationResult.getFileObject() != null) {
            GotoOppositeAction.openFile(locationResult.getFileObject());
        } else if (locationResult.getErrorMessage() != null) {
            String string = locationResult.getErrorMessage();
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
    }

    private TestLocator getLocatorFor(FileObject fileObject) {
        if (fileObject == this.cachedLocatorFo) {
            return this.cachedLocator;
        }
        this.cachedLocatorFo = fileObject;
        this.cachedLocator = null;
        Collection collection = Lookup.getDefault().lookupAll(TestLocator.class);
        for (TestLocator testLocator : collection) {
            if (!testLocator.appliesTo(fileObject)) continue;
            this.cachedLocator = testLocator;
            break;
        }
        return this.cachedLocator;
    }

    private TestLocator.FileType getFileType(FileObject fileObject) {
        if (fileObject == this.cachedFileTypeFo) {
            return this.cachedFileType;
        }
        this.cachedFileTypeFo = fileObject;
        this.cachedFileType = TestLocator.FileType.NEITHER;
        TestLocator testLocator = this.getLocatorFor(fileObject);
        if (testLocator != null) {
            this.cachedFileType = testLocator.getFileType(fileObject);
        }
        return this.cachedFileType;
    }

    private TestLocator.FileType getCurrentFileType() {
        FileObject fileObject = this.getApplicableFileObject(null);
        return fileObject != null ? this.getFileType(fileObject) : TestLocator.FileType.NEITHER;
    }

    public static boolean openFile(FileObject fileObject) {
        DataObject dataObject;
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
            return false;
        }
        assert (dataObject != null);
        EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie != null) {
            editorCookie.open();
            return true;
        }
        OpenCookie openCookie = (OpenCookie)dataObject.getCookie(OpenCookie.class);
        if (openCookie != null) {
            openCookie.open();
            return true;
        }
        return false;
    }

    private FileObject getApplicableFileObject(int[] nArray) {
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        if (topComponent == null) {
            return null;
        }
        if (topComponent instanceof CloneableEditorSupport.Pane) {
            JEditorPane jEditorPane = ((CloneableEditorSupport.Pane)topComponent).getEditorPane();
            if (jEditorPane != null) {
                Document document;
                Object object;
                if (nArray != null && jEditorPane.getCaret() != null) {
                    nArray[0] = jEditorPane.getCaret().getDot();
                }
                if ((object = (document = jEditorPane.getDocument()).getProperty("stream")) instanceof FileObject) {
                    return (FileObject)object;
                }
                if (object instanceof DataObject) {
                    return ((DataObject)object).getPrimaryFile();
                }
            }
        } else {
            DataObject dataObject;
            Node[] nodeArray;
            if (nArray != null) {
                nArray[0] = -1;
            }
            if ((nodeArray = topComponent.getActivatedNodes()) != null && nodeArray.length == 1 && (dataObject = (DataObject)nodeArray[0].getLookup().lookup(DataObject.class)) != null) {
                return dataObject.getPrimaryFile();
            }
        }
        return null;
    }
}

