/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.io.javame;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.project.Project;
import org.netbeans.core.api.multiview.MultiViewHandler;
import org.netbeans.core.api.multiview.MultiViewPerspective;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.CloseOperationState;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.netbeans.modules.mobility.editor.pub.J2MEDataObject;
import org.netbeans.modules.mobility.project.J2MEProject;
import org.netbeans.modules.vmd.api.io.DataEditorView;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.IOUtils;
import org.netbeans.modules.vmd.api.io.ProjectTypeInfo;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.io.providers.DocumentSerializer;
import org.netbeans.modules.vmd.api.io.providers.IOSupport;
import org.netbeans.modules.vmd.api.io.serialization.DocumentErrorHandler;
import org.netbeans.modules.vmd.api.io.serialization.DocumentErrorHandlerSupport;
import org.netbeans.modules.vmd.io.javame.MEDesignDataObject;
import org.netbeans.spi.editor.guards.GuardedEditorSupport;
import org.netbeans.spi.editor.guards.GuardedSectionsFactory;
import org.netbeans.spi.editor.guards.GuardedSectionsProvider;
import org.openide.awt.UndoRedo;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditor;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.windows.CloneableTopComponent;
import org.openide.windows.TopComponent;

public final class MEDesignEditorSupport
extends J2MEDataObject.J2MEEditorSupport
implements EditorCookie.Observable,
OpenCookie,
EditCookie,
PrintCookie {
    private MEDesignDataObject dataObject;
    private CloseOperationHandler closeHandler;
    private TopComponent mvtc;
    private MultiViewDescription[] descriptions;
    private boolean useEditPriority;
    private GuardsEditor guardsEditor;
    private GuardedSectionsProvider sections;
    private UndoRedo.Manager undoRedoManager;
    private FileSystem.AtomicAction atomicSaveAction = new FileSystem.AtomicAction(){

        public void run() throws IOException {
            MEDesignEditorSupport.this.saveDocumentCore();
        }

        public int hashCode() {
            return this.getClass().hashCode();
        }

        public boolean equals(Object object) {
            return this.getClass().equals(object.getClass());
        }
    };

    public MEDesignEditorSupport(MEDesignDataObject mEDesignDataObject) {
        super((J2MEDataObject)mEDesignDataObject, (CloneableEditorSupport.Env)new Env(mEDesignDataObject));
        this.dataObject = mEDesignDataObject;
        this.closeHandler = new CloseHandler(mEDesignDataObject);
    }

    public void saveDocument() throws IOException {
        this.dataObject.getPrimaryFile().getFileSystem().runAtomicAction(this.atomicSaveAction);
    }

    public void saveDocumentCore() throws IOException {
        DocumentSerializer documentSerializer = IOSupport.getDocumentSerializer((DataObject)this.dataObject);
        documentSerializer.waitDocumentLoaded();
        IOSupport.forceUpdateCode((DataObject)this.dataObject);
        documentSerializer.saveDocument();
        super.saveDocument();
    }

    public boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        this.updateDisplayName();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.updateDisplayName();
    }

    protected void notifyClosed() {
        this.mvtc = null;
        super.notifyClosed();
        IOSupport.notifyDataObjectClosed((DataObject)this.dataObject);
    }

    public void open() {
        this.useEditPriority = false;
        DataObjectContext dataObjectContext = IOSupport.getDataObjectContext((DataObject)this.dataObject);
        Project project = ProjectUtils.getProject((DataObjectContext)dataObjectContext);
        if (project == null || !(project instanceof J2MEProject)) {
            DocumentErrorHandler documentErrorHandler = new DocumentErrorHandler().addError(NbBundle.getMessage(MEDesignEditorSupport.class, (String)"MSG_ProjectMissing"));
            DocumentErrorHandlerSupport.showDocumentErrorHandlerDialog((DocumentErrorHandler)documentErrorHandler, (FileObject)this.dataObject.getPrimaryFile());
            return;
        }
        String string = IOSupport.resolveProjectType((DataObjectContext)dataObjectContext);
        if (string == null) {
            return;
        }
        super.open();
        TopComponent topComponent = this.mvtc;
        if (topComponent != null) {
            MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
            int n = this.getIndex();
            if (n >= 0) {
                MultiViewPerspective multiViewPerspective = multiViewHandler.getPerspectives()[n];
                multiViewHandler.requestActive(multiViewPerspective);
                multiViewHandler.requestVisible(multiViewPerspective);
            }
        }
    }

    public void edit() {
        this.useEditPriority = true;
        String string = IOSupport.resolveProjectType((DataObjectContext)IOSupport.getDataObjectContext((DataObject)this.dataObject));
        if (string == null) {
            return;
        }
        super.open();
        TopComponent topComponent = this.mvtc;
        if (topComponent != null) {
            MultiViewHandler multiViewHandler = MultiViews.findMultiViewHandler((TopComponent)topComponent);
            int n = this.getIndex();
            if (n >= 0) {
                MultiViewPerspective multiViewPerspective = multiViewHandler.getPerspectives()[n];
                multiViewHandler.requestActive(multiViewPerspective);
                multiViewHandler.requestVisible(multiViewPerspective);
            }
        }
    }

    private int getIndex() {
        MultiViewDescription[] multiViewDescriptionArray = this.descriptions;
        if (multiViewDescriptionArray == null) {
            return -1;
        }
        int n = Integer.MIN_VALUE;
        int n2 = -1;
        int n3 = 0;
        for (MultiViewDescription multiViewDescription : this.descriptions) {
            int n4;
            DataEditorView dataEditorView = IOSupport.getDataEditorView((MultiViewDescription)multiViewDescription);
            int n5 = n4 = this.useEditPriority ? dataEditorView.getEditPriority() : dataEditorView.getOpenPriority();
            if (n4 > n) {
                n = n4;
                n2 = n3;
            }
            ++n3;
        }
        return n2;
    }

    public void initializeCloneableEditor(CloneableEditor cloneableEditor) {
        super.initializeCloneableEditor(cloneableEditor);
    }

    protected CloneableEditorSupport.Pane createPane() {
        String string = IOSupport.resolveProjectType((DataObjectContext)IOSupport.getDataObjectContext((DataObject)this.dataObject));
        if (string == null) {
            return super.createPane();
        }
        this.descriptions = IOSupport.createEditorSupportPane((DataObjectContext)IOSupport.getDataObjectContext((DataObject)this.dataObject));
        int n = this.getIndex();
        return (CloneableEditorSupport.Pane)MultiViewFactory.createCloneableMultiView((MultiViewDescription[])this.descriptions, (MultiViewDescription)(n >= 0 ? this.descriptions[n] : null), (CloseOperationHandler)this.closeHandler);
    }

    public void setMVTC(TopComponent topComponent) {
        this.mvtc = topComponent;
        this.updateDisplayName();
    }

    protected CloneableTopComponent createCloneableTopComponent() {
        CloneableTopComponent cloneableTopComponent = super.createCloneableTopComponent();
        this.mvtc = cloneableTopComponent;
        this.updateDisplayName();
        return cloneableTopComponent;
    }

    public void updateDisplayName() {
        final TopComponent topComponent = this.mvtc;
        if (topComponent == null) {
            return;
        }
        IOUtils.runInAWTNoBlocking((Runnable)new Runnable(){

            public void run() {
                ProjectTypeInfo projectTypeInfo = ProjectTypeInfo.getProjectTypeInfoFor((String)IOSupport.getDataObjectContext((DataObject)MEDesignEditorSupport.this.dataObject).getProjectType());
                topComponent.setIcon(projectTypeInfo != null ? Utilities.loadImage((String)projectTypeInfo.getIconResource()) : null);
                String string = MEDesignEditorSupport.this.messageName();
                if (!string.equals(topComponent.getDisplayName())) {
                    topComponent.setDisplayName(string);
                }
                topComponent.setToolTipText(MEDesignEditorSupport.this.dataObject.getPrimaryFile().getPath());
            }
        });
    }

    protected UndoRedo.Manager createUndoRedoManager() {
        this.undoRedoManager = super.createUndoRedoManager();
        return this.undoRedoManager;
    }

    void discardAllEdits() {
        this.undoRedoManager.discardAllEdits();
    }

    FileSystem.AtomicAction getAtomicSaveAction() {
        return this.atomicSaveAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromStreamToKitHook(StyledDocument styledDocument, InputStream inputStream, EditorKit editorKit) throws IOException, BadLocationException {
        Object object;
        if (this.sections == null) {
            this.guardsEditor = new GuardsEditor(styledDocument);
            object = ((CloneableEditorSupport.Env)this.env).getMimeType();
            GuardedSectionsFactory guardedSectionsFactory = GuardedSectionsFactory.find((String)object);
            this.sections = guardedSectionsFactory.create((GuardedEditorSupport)this.guardsEditor);
        } else {
            this.guardsEditor.setDocument(styledDocument);
        }
        if (this.sections != null) {
            object = this.sections.createGuardedReader(inputStream, this.getEncoding());
            try {
                editorKit.read((Reader)object, (Document)styledDocument, 0);
            }
            finally {
                ((Reader)object).close();
            }
        } else {
            super.loadFromStreamToKitHook(styledDocument, inputStream, editorKit);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStreamHook(StyledDocument styledDocument, EditorKit editorKit, OutputStream outputStream) throws IOException, BadLocationException {
        if (this.sections != null) {
            Writer writer = this.sections.createGuardedWriter(outputStream, this.getEncoding());
            try {
                editorKit.write(writer, (Document)styledDocument, 0, styledDocument.getLength());
            }
            finally {
                writer.close();
            }
        } else {
            super.saveFromKitToStream(styledDocument, editorKit, outputStream);
        }
    }

    private class GuardsEditor
    implements GuardedEditorSupport {
        private StyledDocument document;

        public GuardsEditor(StyledDocument styledDocument) {
            this.document = styledDocument;
        }

        public StyledDocument getDocument() {
            return this.document;
        }

        public void setDocument(StyledDocument styledDocument) {
            this.document = styledDocument;
        }
    }

    private static class CloseHandler
    implements CloseOperationHandler,
    Serializable {
        private static final long serialVersionUID = -1L;
        private MEDesignDataObject dataObject;

        public CloseHandler(MEDesignDataObject mEDesignDataObject) {
            this.dataObject = mEDesignDataObject;
        }

        public boolean resolveCloseOperation(CloseOperationState[] closeOperationStateArray) {
            MEDesignEditorSupport mEDesignEditorSupport = this.dataObject.getEditorSupport();
            boolean bl = mEDesignEditorSupport.canClose();
            if (bl) {
                mEDesignEditorSupport.notifyClosed();
            }
            return bl;
        }
    }

    protected static class Env
    extends J2MEDataObject.J2MEEditorSupport.Environment {
        private static final long serialVersionUID = -1L;

        public Env(J2MEDataObject j2MEDataObject) {
            super(j2MEDataObject);
        }

        protected FileLock takeLock() throws IOException {
            try {
                FileLock fileLock = super.takeLock();
                IOSupport.setDocumentUpdatingEnabled((DataObject)this.getDataObject(), (boolean)true);
                return fileLock;
            }
            catch (IOException iOException) {
                IOSupport.setDocumentUpdatingEnabled((DataObject)this.getDataObject(), (boolean)false);
                throw iOException;
            }
        }
    }
}

