/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.awt;

import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.util.TSSystem;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.util.Hashtable;

public class TSFont {
    Font font;
    Hashtable currentMap;
    static Hashtable fontNameMap = new Hashtable(20);
    public static final TSFont SANS_SERIF_12 = new TSFont(new Font("SansSerif", 0, 12));
    public static final TSFont SANS_SERIF_10 = new TSFont(new Font("SansSerif", 0, 10));
    public static final TSFont SANS_SERIF_8 = new TSFont(new Font("SansSerif", 0, 8));

    public TSFont() {
        this.setFont(SANS_SERIF_10.getFont());
    }

    public TSFont(Font font) {
        this.setFont(font);
    }

    public TSFont(TSFont tSFont) {
        this.setFont(tSFont.getFont());
    }

    public TSFont(String string) {
        this.setFont(Font.decode(string));
    }

    public void setFont(Font font) {
        Hashtable<Integer, Font> hashtable = (Hashtable<Integer, Font>)fontNameMap.get(this.getFontName(font));
        TSSystem.tsAssert(hashtable instanceof Hashtable || hashtable == null);
        if (hashtable == null) {
            hashtable = new Hashtable<Integer, Font>(20);
            fontNameMap.put(this.getFontName(font), hashtable);
        }
        if (!hashtable.containsKey(new Integer(font.getSize()))) {
            hashtable.put(new Integer(font.getSize()), font);
        }
        this.currentMap = hashtable;
        this.font = font;
    }

    public Font getFont() {
        return this.font;
    }

    public Font getScaledFont(double d) {
        int n = (int)((double)this.font.getSize() * d);
        Font font = (Font)this.currentMap.get(new Integer(n));
        if (font == null) {
            font = new Font(this.font.getName(), this.font.getStyle(), Math.max(1, n));
            this.currentMap.put(new Integer(n), font);
        }
        return font;
    }

    public Font getScaledFont(double d, String string, int n) {
        Font font = this.getScaledFont(d);
        int n2 = Toolkit.getDefaultToolkit().getFontMetrics(font).stringWidth(string);
        for (int i = font.getSize() - 1; n2 > n && i > 0; --i) {
            Font font2 = (Font)this.currentMap.get(new Integer(i));
            if (font2 == null) {
                font2 = new Font(font.getName(), font.getStyle(), i);
                this.currentMap.put(new Integer(i), font2);
            }
            font = font2;
            n2 = Toolkit.getDefaultToolkit().getFontMetrics(font).stringWidth(string);
        }
        return font;
    }

    private String getFontName(Font font) {
        String string = font.isBold() ? (font.isItalic() ? "bolditalic" : "bold") : (font.isItalic() ? "italic" : "plain");
        return font.getName() + "-" + string;
    }

    public boolean equals(Object object) {
        if (object instanceof TSFont) {
            Font font = ((TSFont)object).getFont();
            if (this.font == null || font == null) {
                return this.font == null && font == null;
            }
            return this.font.equals(font);
        }
        return false;
    }

    public int hashCode() {
        return this.font.hashCode();
    }

    public TSConstSize getSizeToFitText(String string) {
        TSConstSize tSConstSize = null;
        int n = 0;
        int n2 = 0;
        if (string != null) {
            int n3 = 0;
            int n4 = 0;
            FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.getFont());
            n3 = fontMetrics.getHeight();
            if (string != null) {
                int n5 = string.length();
                n = 0;
                n4 = 1;
                int n6 = 0;
                int n7 = 0;
                while (n7 < n5) {
                    n7 = string.indexOf(10, n6);
                    if (n7 == -1) {
                        n7 = n5;
                    } else {
                        ++n4;
                    }
                    String string2 = string.substring(n6, n7);
                    int n8 = fontMetrics.stringWidth(string2);
                    if (n8 > n) {
                        n = n8;
                    }
                    n6 = n7 + 1;
                }
                n2 = string.equals("") ? 0 : n3 * n4 - fontMetrics.getLeading();
                tSConstSize = new TSConstSize(n, n2);
            }
        }
        return tSConstSize;
    }

    public String toString() {
        return this.getFontName(this.font) + "-" + this.font.getSize();
    }
}

