/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.complexity;

import com.tomsawyer.complexity.TSDChildGraphForest;
import com.tomsawyer.complexity.TSDChildGraphForestEdge;
import com.tomsawyer.complexity.TSExpandedNodeExtension;
import com.tomsawyer.complexity.event.TSComplexityChangeEvent;
import com.tomsawyer.complexity.event.TSComplexityChangeEventData;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSExpTransform;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.graph.TSChildGraphForestEdge;
import com.tomsawyer.graph.TSChildGraphForestNode;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.de;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.f2;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSNestingManager {
    private static List managerList = new Vector();
    protected TSDGraphManager graphManager;

    protected TSNestingManager(TSDGraphManager tSDGraphManager) {
        if (tSDGraphManager == null) {
            throw new NullPointerException("Cannot create nesting manager, graph manager is null");
        }
        this.graphManager = tSDGraphManager;
        managerList.add(this);
    }

    public TSExpandedNodeExtension newExpandedNodeExtension(TSDNode tSDNode) {
        return new TSExpandedNodeExtension(tSDNode, this.graphManager);
    }

    public static boolean isExpanded(TSGraphMember tSGraphMember) {
        return tSGraphMember.getChildGraphForestEdge() != null && tSGraphMember.getChildGraphForestEdge().isConnected() && tSGraphMember.getChildGraphForestEdge().hasExpandedNodeExtension();
    }

    public static boolean expand(TSDNode tSDNode) {
        boolean bl;
        TSDGraphManager tSDGraphManager;
        f2.a(f2.be);
        TSDGraph tSDGraph = (TSDGraph)tSDNode.getOwner();
        TSDGraph tSDGraph2 = (TSDGraph)tSDNode.getChildGraph();
        boolean bl2 = tSDGraph.isFiringEvents();
        tSDGraph.setFireEvents(false);
        if (tSDGraph2 == null && tSDGraph != null && (tSDGraphManager = (TSDGraphManager)tSDGraph.getOwnerGraphManager()) != null) {
            tSDNode.setChildGraph(tSDGraphManager.addGraph());
        }
        if (tSDGraph2 != null && !TSNestingManager.isExpanded(tSDNode)) {
            Object object;
            Object object2;
            TSSystem.tsAssert(tSDGraph != null);
            TSSystem.tsAssert(tSDGraph.getOwnerGraphManager() == tSDGraph2.getOwnerGraphManager());
            TSSystem.tsAssert(!tSDGraph2.isHideGraph());
            TSSystem.tsAssert(!tSDGraph2.isIntergraph());
            TSSystem.tsAssert(!tSDGraph.isIntergraph());
            tSDGraphManager = (TSDGraphManager)tSDGraph2.getOwner();
            TSDChildGraphForest tSDChildGraphForest = (TSDChildGraphForest)tSDGraphManager.getChildGraphForest();
            tSDChildGraphForest.actOnExpand(tSDNode, tSDGraph2);
            if (tSDNode.getOwnerGraph().isViewable()) {
                object2 = TSNestingManager.getNestedGraphsWithin(tSDGraph2);
                object = object2.iterator();
                while (object.hasNext()) {
                    ((TSDGraph)object.next()).setViewability(true);
                }
            }
            object2 = TSNestingManager.fitToNestedGraph(tSDNode);
            tSDGraph2.updateTransform((TSExpTransform)object2);
            tSDNode.setLocalOriginalWidth(tSDNode.getLocalWidth());
            tSDNode.setLocalOriginalHeight(tSDNode.getLocalHeight());
            object = (Vector)tSDNode.buildIncidentIntergraphEdgeList(true, true, false, true);
            tSDNode.notifyAffectedLowestCommonGraphsOnExpand((List)object);
            bl = true;
        } else {
            bl = false;
        }
        tSDGraph.setFireEvents(bl2);
        if (bl) {
            tSDGraph.fireEvent(new TSComplexityChangeEvent(1L, new TSComplexityChangeEventData(tSDNode, null, null)));
        }
        return bl;
    }

    public static TSDNode getExpandedParentOf(TSDGraph tSDGraph, TSDNode tSDNode) {
        while (tSDNode != null && tSDNode.getOwnerGraph() != null && tSDNode.getOwnerGraph() != tSDGraph) {
            tSDNode = TSNestingManager.nestedWithinNode((TSDGraph)tSDNode.getOwnerGraph());
        }
        return tSDNode;
    }

    public static boolean hasExpandedNodes(TSDGraph tSDGraph) {
        boolean bl = false;
        TSChildGraphForestNode tSChildGraphForestNode = tSDGraph.getChildGraphForestNode();
        if (tSChildGraphForestNode != null) {
            Iterator iterator = tSChildGraphForestNode.outEdges().iterator();
            while (iterator.hasNext() && !bl) {
                TSDChildGraphForestEdge tSDChildGraphForestEdge = (TSDChildGraphForestEdge)iterator.next();
                bl = tSDChildGraphForestEdge.hasExpandedNodeExtension();
            }
        }
        return bl;
    }

    public static TSRect expandRectWithMargins(TSDNode tSDNode, TSConstRect tSConstRect) {
        TSDGraph tSDGraph = (TSDGraph)tSDNode.getChildGraph();
        TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
        double d = tSGraphTailor.getLeftMarginSpacing().getCombinedSpacing(tSConstRect.getWidth());
        double d2 = tSGraphTailor.getRightMarginSpacing().getCombinedSpacing(tSConstRect.getWidth());
        double d3 = tSGraphTailor.getBottomMarginSpacing().getCombinedSpacing(tSConstRect.getHeight());
        double d4 = tSGraphTailor.getTopMarginSpacing().getCombinedSpacing(tSConstRect.getHeight());
        double d5 = tSGraphTailor.getLeftNestedViewSpacing().getCombinedSpacing(tSConstRect.getWidth());
        double d6 = tSGraphTailor.getRightNestedViewSpacing().getCombinedSpacing(tSConstRect.getWidth());
        double d7 = tSGraphTailor.getBottomNestedViewSpacing().getCombinedSpacing(tSConstRect.getHeight());
        double d8 = tSGraphTailor.getTopNestedViewSpacing().getCombinedSpacing(tSConstRect.getHeight());
        TSRect tSRect = new TSRect(tSConstRect.getLeft() - d - d5, tSConstRect.getTop() + d4 + d8, tSConstRect.getRight() + d2 + d6, tSConstRect.getBottom() - d3 - d7);
        return tSRect;
    }

    public static TSExpandedNodeExtension expandedNodeExtension(TSDNode tSDNode) {
        TSExpandedNodeExtension tSExpandedNodeExtension = null;
        if (TSNestingManager.isExpanded(tSDNode)) {
            tSExpandedNodeExtension = ((TSDChildGraphForestEdge)tSDNode.getChildGraphForestEdge()).getExpandedNodeExtension();
        }
        return tSExpandedNodeExtension;
    }

    public static TSDGraph getNestedGraph(TSDNode tSDNode) {
        TSDGraph tSDGraph = TSNestingManager.isExpanded(tSDNode) ? (TSDGraph)((TSChildGraphForestNode)tSDNode.getChildGraphForestEdge().getTargetNode()).getGraph() : null;
        return tSDGraph;
    }

    public boolean containsNestedGraphs() {
        boolean bl = false;
        Iterator iterator = this.graphManager.getChildGraphForest().edges().iterator();
        while (iterator.hasNext() && !bl) {
            bl = ((TSDChildGraphForestEdge)iterator.next()).hasExpandedNodeExtension();
        }
        return bl;
    }

    public static boolean isNested(TSDGraph tSDGraph) {
        TSGraphMember tSGraphMember = null;
        if (!tSDGraph.isHideGraph()) {
            tSGraphMember = tSDGraph.getParent();
        }
        return tSGraphMember != null && TSNestingManager.isExpanded(tSGraphMember);
    }

    public static TSDGraph nestedWithinGraph(TSDGraph tSDGraph) {
        TSDNode tSDNode = TSNestingManager.nestedWithinNode(tSDGraph);
        TSDGraph tSDGraph2 = tSDNode != null ? (TSDGraph)tSDNode.getOwner() : null;
        return tSDGraph2;
    }

    public static TSDNode nestedWithinNode(TSDGraph tSDGraph) {
        TSDNode tSDNode = TSNestingManager.isNested(tSDGraph) ? (TSDNode)((TSChildGraphForestEdge)tSDGraph.getChildGraphForestNode().inEdge()).getGraphMember() : null;
        return tSDNode;
    }

    public static List getNestedGraphsWithin(TSDGraph tSDGraph) {
        de de2 = new de();
        de de3 = new de();
        TSChildGraphForestNode tSChildGraphForestNode = tSDGraph.getChildGraphForestNode();
        if (tSChildGraphForestNode == null) {
            de2.add(tSDGraph);
            return de2;
        }
        de3.add(tSChildGraphForestNode);
        while (!de3.isEmpty()) {
            tSChildGraphForestNode = (TSChildGraphForestNode)de3.remove(0);
            de2.add(tSChildGraphForestNode.getGraph());
            if (tSChildGraphForestNode.outDegree() == 0) continue;
            Iterator iterator = tSChildGraphForestNode.outEdges().iterator();
            while (iterator.hasNext()) {
                TSDChildGraphForestEdge tSDChildGraphForestEdge = (TSDChildGraphForestEdge)iterator.next();
                if (!tSDChildGraphForestEdge.hasExpandedNodeExtension()) continue;
                de3.add(tSDChildGraphForestEdge.getTargetNode());
            }
        }
        return de2;
    }

    public TSDGraph getCommonNestedGraphOwner(TSDEdge tSDEdge) {
        TSDNode tSDNode = (TSDNode)tSDEdge.getSourceNode();
        TSDNode tSDNode2 = (TSDNode)tSDEdge.getTargetNode();
        TSDGraph tSDGraph = this.getCommonNestedGraphOwner((TSDGraph)tSDNode.getOwnerGraph(), (TSDGraph)tSDNode2.getOwnerGraph());
        return tSDGraph;
    }

    public TSDGraph getCommonNestedGraphOwner(TSDGraph tSDGraph, TSDGraph tSDGraph2) {
        TSDGraph tSDGraph3 = null;
        if (tSDGraph != null && tSDGraph2 != null) {
            if (tSDGraph == tSDGraph2) {
                tSDGraph3 = tSDGraph;
            } else {
                TSChildGraphForestNode tSChildGraphForestNode = ((TSDChildGraphForest)this.graphManager.getChildGraphForest()).leastCommonNestedAncestor(tSDGraph.getChildGraphForestNode(), tSDGraph2.getChildGraphForestNode());
                if (tSChildGraphForestNode != null) {
                    tSDGraph3 = (TSDGraph)tSChildGraphForestNode.getGraph();
                }
            }
        }
        return tSDGraph3;
    }

    public void updateOnNestedGraphBoundsChange(TSDNode tSDNode) {
        TSRect tSRect = new TSRect(tSDNode.getLocalBounds(4));
        TSDGraph tSDGraph = TSNestingManager.getNestedGraph(tSDNode);
        TSExpTransform tSExpTransform = tSDGraph.getTransform();
        TSRect tSRect2 = new TSRect();
        tSExpTransform.transformRect(tSDGraph.getLocalBounds(), tSRect2);
        TSRect tSRect3 = TSNestingManager.expandRectWithMargins(tSDNode, tSRect2);
        if (tSDNode.getOwnerGraph().isViewable()) {
            if (tSRect.getLeft() != tSRect3.getLeft() || tSRect.getRight() != tSRect3.getRight() || tSRect.getBottom() != tSRect3.getBottom() || tSRect.getTop() != tSRect3.getTop()) {
                if (tSDGraph.numberOfNodes() == 0) {
                    tSRect3.setCenter(tSDNode.getLocalCenterX(), tSDNode.getLocalCenterY());
                    tSExpTransform.setOffsetX(tSRect3.getCenterX());
                    tSExpTransform.setOffsetY(tSRect3.getCenterY());
                    tSDGraph.updateTransform(tSExpTransform);
                }
                tSDNode.setLocalBounds(tSRect3);
                tSDNode.notifyGraphOnResize(tSRect);
            }
        } else if (tSRect.getLeft() != tSRect3.getLeft() || tSRect.getRight() != tSRect3.getRight() || tSRect.getBottom() != tSRect3.getBottom() || tSRect.getTop() != tSRect3.getTop()) {
            tSDNode.setLocalBounds(tSRect3);
            tSDNode.notifyGraphOnResize(tSRect);
        }
    }

    public static TSExpTransform fitToNestedGraph(TSDNode tSDNode) {
        TSExpTransform tSExpTransform = new TSExpTransform();
        TSConstRect tSConstRect = TSNestingManager.getNestedGraph(tSDNode).getLocalBounds();
        TSRect tSRect = TSNestingManager.expandRectWithMargins(tSDNode, tSConstRect);
        double d = tSConstRect.getLeft() - tSRect.getLeft();
        double d2 = tSRect.getRight() - tSConstRect.getRight();
        double d3 = tSConstRect.getBottom() - tSRect.getBottom();
        double d4 = tSRect.getTop() - tSConstRect.getTop();
        tSDNode.setLocalSize(tSRect.getWidth(), tSRect.getHeight());
        TSConstRect tSConstRect2 = tSDNode.getLocalBounds();
        TSRect tSRect2 = new TSRect(tSConstRect2.getLeft() + d, tSConstRect2.getBottom() + d3, tSConstRect2.getRight() - d2, tSConstRect2.getTop() - d4);
        tSExpTransform.setOffsetX(tSRect2.getCenterX() - tSConstRect.getCenterX());
        tSExpTransform.setOffsetY(tSRect2.getCenterY() - tSConstRect.getCenterY());
        return tSExpTransform;
    }

    public static void buildNestedGraphList(TSDGraph tSDGraph, List list, boolean bl) {
        if (tSDGraph != null && list != null) {
            TSChildGraphForestNode tSChildGraphForestNode = tSDGraph.getChildGraphForestNode();
            if (tSChildGraphForestNode != null) {
                Iterator iterator = tSChildGraphForestNode.outEdges().iterator();
                while (iterator.hasNext()) {
                    TSDChildGraphForestEdge tSDChildGraphForestEdge = (TSDChildGraphForestEdge)iterator.next();
                    if (!tSDChildGraphForestEdge.hasExpandedNodeExtension()) continue;
                    tSChildGraphForestNode = (TSChildGraphForestNode)tSDChildGraphForestEdge.getTargetNode();
                    list.add(tSChildGraphForestNode.getGraph());
                }
            }
            if (bl && tSDGraph.hideGraph() != null && (tSDGraph.hideGraph().numberOfNodes() != 0 || tSDGraph.hideGraph().numberOfEdges() != 0 || tSDGraph.hideGraph().numberOfDisconnectedEdges() != 0)) {
                TSNestingManager.buildNestedGraphList(tSDGraph.hideGraph(), list, false);
            }
        }
    }

    public static void buildAllNestedGraphList(TSDGraph tSDGraph, List list, boolean bl) {
        if (tSDGraph != null && list != null) {
            de de2 = new de();
            de de3 = new de();
            TSNestingManager.buildNestedGraphList(tSDGraph, de2, bl);
            Iterator iterator = de2.iterator();
            while (iterator.hasNext()) {
                TSNestingManager.buildAllNestedGraphList((TSDGraph)iterator.next(), de3, bl);
            }
            list.addAll(de2);
            list.addAll(de3);
        }
    }

    public void collapseAll() {
        f2.a(f2.be);
        ((TSDChildGraphForest)this.graphManager.getChildGraphForest()).actOnCollapseAll();
    }

    public void collapse(TSDGraph tSDGraph) {
        f2.a(f2.be);
        TSGraphMember tSGraphMember = tSDGraph.getParent();
        if (tSGraphMember != null && TSNestingManager.isExpanded(tSGraphMember)) {
            TSNestingManager.collapse((TSDNode)tSGraphMember);
        }
    }

    public static boolean collapse(TSDNode tSDNode) {
        boolean bl;
        f2.a(f2.be);
        TSDGraph tSDGraph = TSNestingManager.getNestedGraph(tSDNode);
        if (tSDGraph != null) {
            boolean bl2 = tSDGraph.isFiringEvents();
            tSDGraph.setFireEvents(false);
            TSDGraph tSDGraph2 = (TSDGraph)tSDNode.getOwner();
            TSSystem.tsAssert(tSDGraph2 != null);
            TSSystem.tsAssert(tSDGraph2.getOwner() == tSDGraph.getOwner() || tSDGraph2.isHideGraph() && tSDGraph2.hideFromGraph().getOwner() == tSDGraph.getOwner());
            TSDGraphManager tSDGraphManager = (TSDGraphManager)tSDGraph2.getOwnerGraphManager();
            TSDChildGraphForest tSDChildGraphForest = (TSDChildGraphForest)tSDGraphManager.getChildGraphForest();
            tSDChildGraphForest.actOnCollapse(tSDNode);
            List list = TSNestingManager.getNestedGraphsWithin(tSDGraph);
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                ((TSDGraph)iterator.next()).setViewability(false);
            }
            Vector vector = (Vector)tSDNode.buildIncidentIntergraphEdgeList(true, true, false, true);
            tSDNode.notifyAffectedLowestCommonGraphsOnCollapse(vector);
            tSDGraph.setFireEvents(bl2);
            bl = true;
        } else {
            bl = false;
        }
        if (bl) {
            tSDGraph.fireEvent(new TSComplexityChangeEvent(2L, new TSComplexityChangeEventData(tSDNode, null, null)));
        }
        return bl;
    }

    public static boolean hasCollapsedNodes(TSDGraph tSDGraph) {
        boolean bl = false;
        Iterator iterator = tSDGraph.nodes().iterator();
        while (iterator.hasNext() && !bl) {
            bl = TSNestingManager.isCollapsed((TSDNode)iterator.next());
        }
        return bl;
    }

    public boolean hasViewableCollapsedNodes() {
        boolean bl = false;
        de de2 = new de();
        de2.add(this.graphManager.getMainDisplayGraph());
        while (!bl && !de2.isEmpty()) {
            TSDGraph tSDGraph = (TSDGraph)de2.remove(0);
            bl = TSNestingManager.hasCollapsedNodes(tSDGraph);
            if (bl) continue;
            Vector vector = new Vector();
            TSNestingManager.buildNestedGraphList(tSDGraph, vector, false);
            de2.addAll(vector);
        }
        return bl;
    }

    public static boolean isCollapsed(TSDNode tSDNode) {
        return tSDNode.hasChildGraph() && !tSDNode.isExpanded();
    }

    public void setGraphManager(TSDGraphManager tSDGraphManager) {
        if (tSDGraphManager != null) {
            this.graphManager = tSDGraphManager;
        }
    }

    public TSDGraphManager getGraphManager() {
        return this.graphManager;
    }

    public static TSNestingManager getManager(TSDGraphManager tSDGraphManager) {
        TSNestingManager tSNestingManager = TSNestingManager.hasManager(tSDGraphManager);
        if (tSNestingManager == null) {
            tSNestingManager = new TSNestingManager(tSDGraphManager);
        }
        return tSNestingManager;
    }

    protected static TSNestingManager hasManager(TSDGraphManager tSDGraphManager) {
        Iterator iterator = managerList.iterator();
        TSNestingManager tSNestingManager = null;
        while (iterator.hasNext() && tSNestingManager == null) {
            TSNestingManager tSNestingManager2 = (TSNestingManager)iterator.next();
            if (tSNestingManager2.getGraphManager() != tSDGraphManager) continue;
            tSNestingManager = tSNestingManager2;
        }
        return tSNestingManager;
    }

    public static void discardManager(TSDGraphManager tSDGraphManager) {
        TSNestingManager tSNestingManager = TSNestingManager.hasManager(tSDGraphManager);
        if (tSNestingManager != null) {
            managerList.remove(tSNestingManager);
        }
    }

    public static void clearManagerList() {
        managerList = new Vector();
    }
}

