/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.complexity.command;

import com.tomsawyer.complexity.TSComplexityManager;
import com.tomsawyer.complexity.TSFoldingManager;
import com.tomsawyer.complexity.event.TSComplexityChangeEvent;
import com.tomsawyer.complexity.event.TSComplexityChangeEventData;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.command.TSCommand;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class TSFoldCommand
extends TSCommand {
    TSDGraph graph;
    List nodeList;
    TSDNode folder;
    TSDGraph foldGraph;
    boolean compressMetaEdges;

    public TSFoldCommand() {
    }

    public TSFoldCommand(List list) {
        TSSystem.tsAssert(list != null && list.size() > 0);
        this.graph = (TSDGraph)((TSDNode)list.get(0)).getOwner();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (((TSDNode)iterator.next()).getOwnerGraph() == this.graph) continue;
            throw new IllegalArgumentException();
        }
        this.nodeList = new LinkedList();
        this.nodeList.addAll(list);
        this.compressMetaEdges = ((TSDGraphManager)this.graph.getOwner()).getCompressMetaEdges();
    }

    protected void doAction() throws Throwable {
        if (!this.nodeList.isEmpty()) {
            Object object;
            TSDGraphManager tSDGraphManager = (TSDGraphManager)this.graph.getOwner();
            Iterator iterator = this.nodeList.iterator();
            while (iterator.hasNext()) {
                object = (TSDNode)iterator.next();
                if (tSDGraphManager.getEventManager().fireEvent(new TSComplexityChangeEvent(4L, new TSComplexityChangeEventData(object, null, null)), true)) continue;
                iterator.remove();
            }
            if (!this.nodeList.isEmpty()) {
                object = TSFoldingManager.getManager(tSDGraphManager);
                if (this.folder == null) {
                    this.folder = (TSDNode)this.graph.addNode();
                    this.folder.setSize(this.folder.getDefaultWidth(), this.folder.getDefaultHeight());
                    this.folder.setTag("Folder");
                }
                if (this.foldGraph == null) {
                    this.foldGraph = (TSDGraph)tSDGraphManager.addGraph();
                }
                boolean bl = ((TSFoldingManager)object).fold(this.folder, this.foldGraph, this.nodeList, true);
                this.setAddToUndoStack(bl);
                ((TSComplexityManager)object).clearResultLists();
            } else {
                this.setAddToUndoStack(false);
            }
        }
    }

    protected void redoAction() throws Throwable {
        if (this.folder != null) {
            this.graph.insert(this.folder);
            TSFoldingManager tSFoldingManager = TSFoldingManager.getManager((TSDGraphManager)this.graph.getOwner());
            tSFoldingManager.fold(this.folder, (TSDGraph)this.folder.getChildGraph(), this.nodeList, true);
            tSFoldingManager.clearResultLists();
        }
    }

    protected void undoAction() throws Throwable {
        if (this.folder != null) {
            TSDGraphManager tSDGraphManager = (TSDGraphManager)this.graph.getOwner();
            TSFoldingManager tSFoldingManager = TSFoldingManager.getManager(tSDGraphManager);
            tSFoldingManager.unfold(this.folder, true);
            this.graph.remove(this.folder);
            tSDGraphManager.remove(this.foldGraph);
            tSFoldingManager.clearResultLists();
        }
    }

    public TSDNode getFolderNode() {
        return this.folder;
    }

    public void setFolderNode(TSDNode tSDNode) {
        this.folder = tSDNode;
    }

    public TSDGraph getFoldGraph() {
        return this.foldGraph;
    }

    public void setFoldGraph(TSDGraph tSDGraph) {
        this.foldGraph = tSDGraph;
    }

    protected void undoCleanup() {
        if (this.folder != null && !this.folder.isOwned()) {
            this.folder.dispose();
        }
        if (this.foldGraph != null && !this.foldGraph.isOwned()) {
            this.foldGraph.dispose();
        }
    }
}

