/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.complexity.command;

import com.tomsawyer.complexity.TSHidingManager;
import com.tomsawyer.complexity.event.TSComplexityChangeEvent;
import com.tomsawyer.complexity.event.TSComplexityChangeEventData;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.command.TSCommand;
import com.tomsawyer.util.df;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class TSHideCommand
extends TSCommand {
    TSDGraph graph;
    List edgeLists;
    List affectedEdges;
    List nodeLists;
    List affectedNodes;
    boolean compressMetaEdges;

    public TSHideCommand() {
    }

    public TSHideCommand(List list, List list2) {
        TSSystem.tsAssert(list != null && list.size() > 0 || list2 != null && list2.size() > 0);
        if (list == null) {
            list = new df();
        } else if (list2 == null) {
            list2 = new df();
        }
        this.nodeLists = new Vector(list);
        this.edgeLists = new Vector(list2);
        this.affectedEdges = new Vector();
        this.affectedNodes = new Vector();
        this.affectedEdges.addAll(list2);
        this.affectedNodes.addAll(list);
        this.graph = list.size() != 0 ? (TSDGraph)((TSDNode)list.get(0)).getOwner() : (TSDGraph)((TSDEdge)list2.get(0)).getOwner();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TSDNode tSDNode = (TSDNode)iterator.next();
            this.affectedEdges.addAll(tSDNode.inEdges());
            this.affectedEdges.addAll(tSDNode.outEdges());
            if (tSDNode.getOwnerGraph() == this.graph) continue;
            throw new IllegalArgumentException();
        }
        iterator = list2.iterator();
        while (iterator.hasNext()) {
            if (((TSDEdge)iterator.next()).getOwnerGraph() == this.graph) continue;
            throw new IllegalArgumentException();
        }
        this.compressMetaEdges = ((TSDGraphManager)this.graph.getOwner()).getCompressMetaEdges();
    }

    protected void doAction() throws Throwable {
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.graph.getOwner();
        TSHidingManager tSHidingManager = TSHidingManager.getManager(tSDGraphManager);
        ListIterator listIterator = this.nodeLists.listIterator();
        ListIterator listIterator2 = this.edgeLists.listIterator();
        List list = null;
        List list2 = null;
        list = (List)listIterator2.next();
        list2 = (List)listIterator.next();
        this.preprocessLists(list2, list, tSDGraphManager);
        tSHidingManager.hide(this.graph, list2, list);
        list2.clear();
        list.clear();
        list2.addAll(tSHidingManager.getResultNodeList());
        list.addAll(tSHidingManager.getResultEdgeList());
        this.setAddToUndoStack(!list2.isEmpty() || !list.isEmpty());
        tSHidingManager.clearResultLists();
    }

    protected void preprocessLists(List list, List list2, TSDGraphManager tSDGraphManager) {
        TSGraphMember tSGraphMember;
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSDEdge)iterator.next();
            if (tSDGraphManager.getEventManager().fireEvent(new TSComplexityChangeEvent(128L, new TSComplexityChangeEventData(tSGraphMember, null, null)), true)) continue;
            iterator.remove();
        }
        iterator = list.iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSDNode)iterator.next();
            if (tSDGraphManager.getEventManager().fireEvent(new TSComplexityChangeEvent(64L, new TSComplexityChangeEventData(tSGraphMember, null, null)), true)) continue;
            iterator.remove();
        }
    }

    protected void redoAction() throws Throwable {
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.graph.getOwner();
        TSHidingManager tSHidingManager = TSHidingManager.getManager(tSDGraphManager);
        tSHidingManager.hide(this.graph, this.nodeLists, this.edgeLists);
        tSHidingManager.clearResultLists();
    }

    protected void undoAction() throws Throwable {
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.graph.getOwner();
        TSHidingManager tSHidingManager = TSHidingManager.getManager(tSDGraphManager);
        tSHidingManager.unhide(this.graph, this.affectedNodes, this.affectedEdges, false);
        tSHidingManager.clearResultLists();
    }
}

