/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.diagramming;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSConnectorLabel;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSEdgeLabel;
import com.tomsawyer.drawing.TSGEdge;
import com.tomsawyer.drawing.TSGNode;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.TSLabel;
import com.tomsawyer.drawing.TSNodeLabel;
import com.tomsawyer.drawing.TSPNode;
import com.tomsawyer.drawing.TSRectangularObjectLabel;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeEventData;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSExpTransform;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.drawing.geometry.TSSize;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSNode;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSMoveControl {
    public static final int IDLE = 100;
    public static final int DRAGGING = 200;
    public static final int DONE = 300;
    public static final int ABORTED = 400;
    Vector draggedDrawableNodes;
    Vector draggedDrawableEdges;
    Vector draggedPathNodes;
    Vector draggedEdgeLabels;
    Vector draggedNodeLabels;
    Vector draggedConnectorLabels;
    Vector draggedAssignedEdgePathNodes;
    Vector selectedDrawableNodes = new Vector();
    Vector selectedPathNodes = new Vector();
    Vector selectedEdgeLabels = new Vector();
    Vector selectedNodeLabels = new Vector();
    Vector selectedConnectorLabels = new Vector();
    List ownerGraphs;
    TSPoint initialCursorPosition;
    TSPoint currentCursorPosition;
    int objectState = 300;
    boolean dropping;
    boolean somethingMoved;

    public TSMoveControl() {
        this.draggedDrawableNodes = new Vector();
        this.draggedDrawableEdges = new Vector();
        this.draggedPathNodes = new Vector();
        this.draggedEdgeLabels = new Vector();
        this.draggedNodeLabels = new Vector();
        this.draggedConnectorLabels = new Vector();
        this.draggedAssignedEdgePathNodes = new Vector();
    }

    public void init(List list, List list2, List list3, List list4, List list5, List list6) {
        block7: {
            block6: {
                if (this.objectState == 300) break block6;
                if (this.objectState != 100) break block7;
            }
            if (list != null) {
                TSEdge tSEdge;
                TSGraphObject tSGraphObject;
                this.ownerGraphs = list;
                this.selectedDrawableNodes.clear();
                this.selectedPathNodes.clear();
                this.selectedEdgeLabels.clear();
                this.selectedNodeLabels.clear();
                this.selectedConnectorLabels.clear();
                this.selectedDrawableNodes.addAll(list2);
                Iterator iterator = list3.iterator();
                while (iterator.hasNext()) {
                    tSGraphObject = (TSPNode)iterator.next();
                    tSEdge = (TSEdge)tSGraphObject.getOwner();
                    if (!tSEdge.isViewable()) continue;
                    this.selectedPathNodes.add(tSGraphObject);
                }
                iterator = list4.iterator();
                while (iterator.hasNext()) {
                    tSGraphObject = (TSEdgeLabel)iterator.next();
                    tSEdge = (TSEdge)tSGraphObject.getOwner();
                    if (!tSEdge.isViewable()) continue;
                    this.selectedEdgeLabels.add(tSGraphObject);
                }
                this.selectedNodeLabels.addAll(list5);
                this.selectedConnectorLabels.addAll(list6);
                this.computeMovedObjects();
                this.objectState = 100;
            }
        }
    }

    public void onStartAt(double d, double d2) {
        if (this.objectState == 100) {
            this.storeInitialPositions();
            this.initialCursorPosition = new TSPoint(d, d2);
            this.currentCursorPosition = new TSPoint(d, d2);
            this.objectState = 200;
        }
    }

    public void onDragTo(double d, double d2) {
        if (this.objectState == 200) {
            double d3;
            double d4;
            TSSize tSSize;
            TSDGraph tSDGraph;
            TSConstPoint tSConstPoint;
            TSGraphObject tSGraphObject;
            this.somethingMoved = false;
            double d5 = d - this.initialCursorPosition.getX();
            double d6 = d2 - this.initialCursorPosition.getY();
            Iterator iterator = this.draggedDrawableNodes.iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSDNode)iterator.next();
                tSConstPoint = (TSConstPoint)tSGraphObject.getUtilityObject();
                tSDGraph = (TSDGraph)((TSNode)tSGraphObject).getOwnerGraph();
                tSSize = new TSSize(d5, d6);
                d4 = tSConstPoint.getX() + tSSize.getWidth();
                d3 = tSConstPoint.getY() + tSSize.getHeight();
                double d7 = d4 - ((TSDNode)tSGraphObject).getLocalCenterX();
                double d8 = d3 - ((TSDNode)tSGraphObject).getLocalCenterY();
                if (this.dropping) {
                    if (tSDGraph.fireEvent(new TSDrawingChangeEvent(4096L, new TSDrawingChangeEventData(tSGraphObject, ((TSGNode)tSGraphObject).getLocalCenter(), new TSConstPoint(d4, d3))), true)) {
                        ((TSDNode)tSGraphObject).setLocalCenter(d4, d3);
                        this.somethingMoved = true;
                    }
                } else {
                    ((TSDNode)tSGraphObject).assignCenter(d4, d3);
                    if (((TSDNode)tSGraphObject).isExpanded()) {
                        TSDGraph tSDGraph2 = TSNestingManager.getNestedGraph((TSDNode)tSGraphObject);
                        TSExpTransform tSExpTransform = tSDGraph2.getTransform();
                        tSExpTransform.setOffsetX(tSExpTransform.getOffsetX() + d7);
                        tSExpTransform.setOffsetY(tSExpTransform.getOffsetY() + d8);
                        tSDGraph2.updateTransform(tSExpTransform);
                        ((TSDNode)tSGraphObject).recomputeClippingPoints();
                    }
                }
                ((TSDNode)tSGraphObject).ltUpdateBoundsOfLabels(this.dropping);
            }
            iterator = this.draggedPathNodes.iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSPNode)iterator.next();
                tSConstPoint = (TSConstPoint)tSGraphObject.getUtilityObject();
                tSDGraph = (TSDGraph)((TSNode)tSGraphObject).getOwnerGraph();
                tSSize = new TSSize(d5, d6);
                tSDGraph.inverseExpandedTransformSize(tSSize);
                d4 = tSConstPoint.getX() + tSSize.getWidth();
                d3 = tSConstPoint.getY() + tSSize.getHeight();
                if (!this.dropping) {
                    ((TSPNode)tSGraphObject).assignCenter(d4, d3);
                    continue;
                }
                if (!tSDGraph.fireEvent(new TSDrawingChangeEvent(16384L, new TSDrawingChangeEventData(tSGraphObject, ((TSPNode)tSGraphObject).getLocalCenter(), new TSConstPoint(d4, d3))), true)) continue;
                ((TSPNode)tSGraphObject).setLocalCenter(d4, d3);
                this.somethingMoved = true;
            }
            iterator = this.draggedAssignedEdgePathNodes.iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSPNode)iterator.next();
                tSConstPoint = (TSConstPoint)tSGraphObject.getUtilityObject();
                tSDGraph = (TSDGraph)((TSNode)tSGraphObject).getOwnerGraph();
                tSSize = new TSSize(d5, d6);
                tSDGraph.inverseExpandedTransformSize(tSSize);
                d4 = tSConstPoint.getX() + tSSize.getWidth();
                d3 = tSConstPoint.getY() + tSSize.getHeight();
                if (!this.dropping) {
                    ((TSPNode)tSGraphObject).assignCenter(d4, d3);
                    continue;
                }
                if (!tSDGraph.fireEvent(new TSDrawingChangeEvent(16384L, new TSDrawingChangeEventData(tSGraphObject, ((TSPNode)tSGraphObject).getLocalCenter(), new TSConstPoint(d4, d3))), true)) continue;
                ((TSPNode)tSGraphObject).setLocalCenter(d4, d3);
                this.somethingMoved = true;
            }
            iterator = this.draggedEdgeLabels.iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSEdgeLabel)iterator.next();
                tSConstPoint = (TSConstPoint)tSGraphObject.getUtilityObject();
                tSDGraph = (TSDGraph)((TSLabel)tSGraphObject).getOwnerGraph();
                tSSize = new TSSize(d5, d6);
                tSDGraph.inverseExpandedTransformSize(tSSize);
                d4 = tSConstPoint.getX() + tSSize.getWidth();
                d3 = tSConstPoint.getY() + tSSize.getHeight();
                if (!this.dropping) {
                    ((TSEdgeLabel)tSGraphObject).assignCenter(d4, d3);
                    continue;
                }
                if (!tSDGraph.fireEvent(new TSDrawingChangeEvent(8192L, new TSDrawingChangeEventData(tSGraphObject, ((TSLabel)tSGraphObject).getLocalCenter(), new TSConstPoint(d4, d3))), true)) continue;
                ((TSEdgeLabel)tSGraphObject).setLocalCenter(d4, d3);
                this.somethingMoved = true;
            }
            iterator = this.draggedNodeLabels.iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSNodeLabel)iterator.next();
                tSConstPoint = (TSConstPoint)tSGraphObject.getUtilityObject();
                tSDGraph = (TSDGraph)((TSLabel)tSGraphObject).getOwnerGraph();
                tSSize = new TSSize(d5, d6);
                tSDGraph.inverseExpandedTransformSize(tSSize);
                d4 = tSConstPoint.getX() + tSSize.getWidth();
                d3 = tSConstPoint.getY() + tSSize.getHeight();
                if (!this.dropping) {
                    ((TSRectangularObjectLabel)tSGraphObject).assignCenter(d4, d3);
                    continue;
                }
                if (!tSDGraph.fireEvent(new TSDrawingChangeEvent(8192L, new TSDrawingChangeEventData(tSGraphObject, ((TSLabel)tSGraphObject).getLocalCenter(), new TSConstPoint(d4, d3))), true)) continue;
                ((TSRectangularObjectLabel)tSGraphObject).setLocalCenter(d4, d3);
                this.somethingMoved = true;
            }
            iterator = this.draggedConnectorLabels.iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSConnectorLabel)iterator.next();
                tSConstPoint = (TSConstPoint)tSGraphObject.getUtilityObject();
                tSDGraph = (TSDGraph)((TSConnectorLabel)tSGraphObject).getOwnerGraph();
                tSSize = new TSSize(d5, d6);
                tSDGraph.inverseExpandedTransformSize(tSSize);
                d4 = tSConstPoint.getX() + tSSize.getWidth();
                d3 = tSConstPoint.getY() + tSSize.getHeight();
                if (!this.dropping) {
                    ((TSRectangularObjectLabel)tSGraphObject).assignCenter(d4, d3);
                    continue;
                }
                if (!tSDGraph.fireEvent(new TSDrawingChangeEvent(8192L, new TSDrawingChangeEventData(tSGraphObject, ((TSLabel)tSGraphObject).getLocalCenter(), new TSConstPoint(d4, d3))), true)) continue;
                ((TSRectangularObjectLabel)tSGraphObject).setLocalCenter(d4, d3);
                this.somethingMoved = true;
            }
            iterator = this.draggedDrawableEdges.iterator();
            while (iterator.hasNext()) {
                tSGraphObject = (TSDEdge)iterator.next();
                ((TSDEdge)tSGraphObject).ltUpdateBoundsOfLabels(this.dropping);
            }
            this.currentCursorPosition.setLocation(d, d2);
        }
    }

    public void onDropAt(double d, double d2) {
        if (this.objectState == 200) {
            this.dropping = true;
            this.onDragTo(d, d2);
            this.updateGraphsBounds();
            this.deleteInitialPositions();
            this.selectedDrawableNodes.clear();
            this.selectedPathNodes.clear();
            this.selectedEdgeLabels.clear();
            this.selectedNodeLabels.clear();
            this.selectedConnectorLabels.clear();
            this.draggedDrawableNodes.clear();
            this.draggedDrawableEdges.clear();
            this.draggedPathNodes.clear();
            this.draggedEdgeLabels.clear();
            this.draggedNodeLabels.clear();
            this.draggedConnectorLabels.clear();
        }
        this.objectState = 300;
    }

    public void updateGraphsBounds() {
        Object object;
        TSGraphObject tSGraphObject;
        Vector<Object> vector = new Vector<Object>(this.ownerGraphs);
        Iterator iterator = this.draggedEdges().iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSDEdge)iterator.next();
            object = (TSDGraph)((TSGEdge)tSGraphObject).getTransformGraph();
            if (vector.contains(object)) continue;
            vector.add(object);
        }
        iterator = this.draggedEdgeLabels().iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSEdgeLabel)iterator.next();
            object = ((TSEdgeLabel)tSGraphObject).getTransformGraph();
            if (vector.contains(object)) continue;
            vector.add(object);
        }
        iterator = this.draggedPathNodes().iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSPNode)iterator.next();
            object = (TSDGraph)((TSGNode)tSGraphObject).getTransformGraph();
            if (vector.contains(object)) continue;
            vector.add(object);
        }
        object = vector.iterator();
        while (object.hasNext()) {
            tSGraphObject = (TSDGraph)object.next();
            TSGraphTailor tSGraphTailor = ((TSDGraph)tSGraphObject).getTailor();
            tSGraphTailor.setTopConstantMargin(tSGraphTailor.getOriginalTopConstantMargin());
            tSGraphTailor.setBottomConstantMargin(tSGraphTailor.getOriginalBottomConstantMargin());
            tSGraphTailor.setLeftConstantMargin(tSGraphTailor.getOriginalLeftConstantMargin());
            tSGraphTailor.setRightConstantMargin(tSGraphTailor.getOriginalRightConstantMargin());
            ((TSDGraph)tSGraphObject).updateBounds();
        }
    }

    public void onCancel() {
        if (this.objectState == 200) {
            this.restoreInitialPositions();
            Iterator iterator = this.draggedDrawableNodes.iterator();
            while (iterator.hasNext()) {
                TSDNode tSDNode = (TSDNode)iterator.next();
                if (!tSDNode.isExpanded()) continue;
                TSGraph tSGraph = tSDNode.getOwnerGraph();
                boolean bl = tSGraph.isFiringEvents();
                tSGraph.setFireEvents(false);
                TSExpTransform tSExpTransform = TSNestingManager.fitToNestedGraph(tSDNode);
                TSNestingManager.getNestedGraph(tSDNode).updateTransform(tSExpTransform);
                tSGraph.setFireEvents(bl);
            }
            this.deleteInitialPositions();
            this.currentCursorPosition.setLocation(this.initialCursorPosition);
            this.objectState = 400;
        }
    }

    public void reset() {
        if (this.objectState == 400) {
            this.objectState = 300;
        }
    }

    public List draggedNodes() {
        return this.draggedDrawableNodes;
    }

    public List draggedEdges() {
        return this.draggedDrawableEdges;
    }

    public List draggedEdgeLabels() {
        return this.draggedEdgeLabels;
    }

    public List draggedNodeLabels() {
        return this.draggedNodeLabels;
    }

    public List draggedConnectorLabels() {
        return this.draggedConnectorLabels;
    }

    public List draggedPathNodes() {
        return this.draggedPathNodes;
    }

    public int getState() {
        return this.objectState;
    }

    private void computeMovedObjects() {
        Object object;
        Object object2;
        Cloneable cloneable;
        Object object3;
        Object object4;
        TSDGraphManager tSDGraphManager = (TSDGraphManager)((TSDGraph)this.ownerGraphs.get(0)).getOwnerGraphManager();
        this.draggedDrawableNodes.clear();
        this.draggedDrawableEdges.clear();
        this.draggedPathNodes.clear();
        Iterator iterator = this.selectedDrawableNodes.iterator();
        while (iterator.hasNext()) {
            object4 = iterator.next();
            if (!(object4 instanceof TSDNode)) continue;
            object3 = (TSDNode)object4;
            if (((TSGraphObject)object3).isDiscarded()) {
                throw new RuntimeException("Moving discarded nodes");
            }
            if (!this.ownerGraphs.contains(((TSGraphObject)object3).getOwner())) continue;
            if (!this.hasSelectedAncestor((TSDGraph)((TSGNode)object3).getTransformGraph())) {
                this.draggedDrawableNodes.add(object3);
                cloneable = (Vector)((TSNode)object3).buildIncidentIntergraphEdgeList(true, false, true, true);
                object2 = ((Vector)cloneable).iterator();
                while (object2.hasNext()) {
                    object = (TSDEdge)object2.next();
                    if (this.draggedDrawableEdges.contains(object) || this.hasSelectedAncestor((TSDGraph)((TSGEdge)object).getTransformGraph())) continue;
                    this.draggedDrawableEdges.add(object);
                }
            }
            ((TSNode)object3).setVisited(true);
        }
        Iterator iterator2 = this.ownerGraphs.iterator();
        while (iterator2.hasNext()) {
            TSDGraph tSDGraph = (TSDGraph)iterator2.next();
            object4 = tSDGraph.edges().iterator();
            while (object4.hasNext()) {
                object3 = (TSDEdge)object4.next();
                if (((TSGraphObject)object3).isDiscarded()) {
                    throw new RuntimeException("Moving discarded edge");
                }
                cloneable = ((TSEdge)object3).getSourceNode();
                object2 = ((TSEdge)object3).getTargetNode();
                if (!((TSNode)cloneable).isVisited() && !((TSNode)object2).isVisited() || ((TSEdge)object3).isTraversed() || this.hasSelectedAncestor((TSDGraph)((TSGEdge)object3).getTransformGraph()) || !((TSDEdge)object3).isViewable()) continue;
                this.draggedDrawableEdges.add(object3);
                ((TSEdge)object3).setTraversed(true);
                this.adjust((TSDEdge)object3);
                if (cloneable != object2) continue;
                object = ((TSDEdge)object3).bendIterator();
                while (object.hasNext()) {
                    TSPNode tSPNode = (TSPNode)object.next();
                    this.draggedPathNodes.add(tSPNode);
                    tSPNode.setVisited(true);
                }
            }
        }
        object4 = this.selectedPathNodes.iterator();
        while (object4.hasNext()) {
            object3 = (TSPNode)object4.next();
            if (((TSGraphObject)object3).isDiscarded()) {
                throw new RuntimeException("Moving discared bends");
            }
            if (((TSNode)object3).isVisited() || this.hasSelectedAncestor((TSDGraph)((TSGNode)object3).getTransformGraph())) continue;
            cloneable = (TSDEdge)((TSGraphObject)object3).getOwner();
            this.draggedPathNodes.add(object3);
            if (((TSEdge)cloneable).isTraversed() || !((TSDEdge)cloneable).isViewable()) continue;
            this.draggedDrawableEdges.add(cloneable);
            ((TSEdge)cloneable).setTraversed(true);
        }
        this.draggedEdgeLabels.clear();
        object3 = this.selectedEdgeLabels.iterator();
        while (object3.hasNext()) {
            cloneable = (TSEdgeLabel)object3.next();
            if (cloneable == null || ((TSEdge)(object2 = (TSDEdge)((TSGraphObject)cloneable).getOwner())).isTraversed() || this.hasSelectedAncestor((TSDGraph)((TSGEdge)object2).getTransformGraph()) || !((TSDEdge)object2).isViewable()) continue;
            this.draggedEdgeLabels.add(cloneable);
        }
        this.draggedNodeLabels.clear();
        object3 = this.selectedNodeLabels.iterator();
        while (object3.hasNext()) {
            cloneable = (TSNodeLabel)object3.next();
            if (cloneable == null || ((TSNode)(object2 = (TSDNode)((TSGraphObject)cloneable).getOwner())).isVisited() || this.hasSelectedAncestor((TSDGraph)((TSGNode)object2).getTransformGraph())) continue;
            this.draggedNodeLabels.add(cloneable);
        }
        this.draggedConnectorLabels.clear();
        object3 = this.selectedConnectorLabels.iterator();
        while (object3.hasNext()) {
            cloneable = (TSConnectorLabel)object3.next();
            if (cloneable == null || ((TSNode)(object2 = (TSDNode)((TSGraphObject)cloneable).getOwner().getOwner())).isVisited() || this.hasSelectedAncestor((TSDGraph)((TSGNode)object2).getTransformGraph())) continue;
            this.draggedConnectorLabels.add(cloneable);
        }
        tSDGraphManager.setAllMarked(false);
        tSDGraphManager.setAllNodesVisited(false);
        tSDGraphManager.setAllPathNodesVisited(false);
        tSDGraphManager.setAllEdgesTraversed(false);
    }

    protected void adjust(TSDEdge tSDEdge) {
    }

    private boolean hasSelectedAncestor(TSDGraph tSDGraph) {
        while (!tSDGraph.isMainDisplayGraph() && tSDGraph.getParent() != null) {
            TSGraphMember tSGraphMember = tSDGraph.getParent();
            if (this.selectedDrawableNodes.contains(tSGraphMember)) {
                return true;
            }
            tSDGraph = (TSDGraph)tSGraphMember.getOwnerGraph();
        }
        return false;
    }

    private void storeInitialPositions() {
        TSGraphObject tSGraphObject;
        Iterator iterator = this.draggedDrawableNodes.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSDNode)iterator.next();
            tSGraphObject.setUtilityObject(((TSGNode)tSGraphObject).getLocalCenter());
        }
        iterator = this.draggedEdgeLabels.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSEdgeLabel)iterator.next();
            tSGraphObject.setUtilityObject(((TSLabel)tSGraphObject).getLocalCenter());
        }
        iterator = this.draggedNodeLabels.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSNodeLabel)iterator.next();
            tSGraphObject.setUtilityObject(((TSLabel)tSGraphObject).getLocalCenter());
        }
        iterator = this.draggedConnectorLabels.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSConnectorLabel)iterator.next();
            tSGraphObject.setUtilityObject(((TSLabel)tSGraphObject).getLocalCenter());
        }
        iterator = this.draggedPathNodes.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSPNode)iterator.next();
            tSGraphObject.setUtilityObject(new TSConstPoint(((TSPNode)tSGraphObject).getLocalCenter()));
        }
        iterator = this.draggedAssignedEdgePathNodes.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSPNode)iterator.next();
            tSGraphObject.setUtilityObject(new TSConstPoint(((TSPNode)tSGraphObject).getLocalCenter()));
        }
    }

    private void restoreInitialPositions() {
        TSConstPoint tSConstPoint;
        TSGraphObject tSGraphObject;
        Iterator iterator = this.draggedDrawableNodes.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSDNode)iterator.next();
            tSConstPoint = (TSConstPoint)tSGraphObject.getUtilityObject();
            ((TSDNode)tSGraphObject).assignCenter(tSConstPoint.getX(), tSConstPoint.getY());
            tSGraphObject.setUtilityObject(null);
            ((TSDNode)tSGraphObject).ltUpdateBoundsOfLabels();
        }
        iterator = this.draggedPathNodes.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSPNode)iterator.next();
            tSConstPoint = (TSConstPoint)tSGraphObject.getUtilityObject();
            ((TSPNode)tSGraphObject).assignCenter(tSConstPoint.getX(), tSConstPoint.getY());
            tSGraphObject.setUtilityObject(null);
        }
        iterator = this.draggedAssignedEdgePathNodes.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSPNode)iterator.next();
            tSConstPoint = (TSConstPoint)tSGraphObject.getUtilityObject();
            ((TSPNode)tSGraphObject).assignCenter(tSConstPoint.getX(), tSConstPoint.getY());
            tSGraphObject.setUtilityObject(null);
        }
        iterator = this.draggedEdgeLabels.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSEdgeLabel)iterator.next();
            tSConstPoint = (TSConstPoint)tSGraphObject.getUtilityObject();
            ((TSEdgeLabel)tSGraphObject).assignCenter(tSConstPoint.getX(), tSConstPoint.getY());
            tSGraphObject.setUtilityObject(null);
        }
        iterator = this.draggedNodeLabels.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSNodeLabel)iterator.next();
            tSConstPoint = (TSConstPoint)tSGraphObject.getUtilityObject();
            ((TSRectangularObjectLabel)tSGraphObject).assignCenter(tSConstPoint.getX(), tSConstPoint.getY());
            tSGraphObject.setUtilityObject(null);
        }
        iterator = this.draggedConnectorLabels.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSConnectorLabel)iterator.next();
            tSConstPoint = (TSConstPoint)tSGraphObject.getUtilityObject();
            ((TSRectangularObjectLabel)tSGraphObject).assignCenter(tSConstPoint.getX(), tSConstPoint.getY());
            tSGraphObject.setUtilityObject(null);
        }
        iterator = this.draggedDrawableEdges.iterator();
        while (iterator.hasNext()) {
            ((TSDEdge)iterator.next()).ltUpdateBoundsOfLabels();
        }
    }

    private void deleteInitialPositions() {
        TSGraphObject tSGraphObject;
        Iterator iterator = this.draggedDrawableNodes.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSDNode)iterator.next();
            tSGraphObject.setUtilityObject(null);
        }
        iterator = this.draggedEdgeLabels.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSEdgeLabel)iterator.next();
            tSGraphObject.setUtilityObject(null);
        }
        iterator = this.draggedNodeLabels.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSNodeLabel)iterator.next();
            tSGraphObject.setUtilityObject(null);
        }
        iterator = this.draggedConnectorLabels.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSConnectorLabel)iterator.next();
            tSGraphObject.setUtilityObject(null);
        }
        iterator = this.draggedPathNodes.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSPNode)iterator.next();
            tSGraphObject.setUtilityObject(null);
        }
        iterator = this.draggedAssignedEdgePathNodes.iterator();
        while (iterator.hasNext()) {
            tSGraphObject = (TSPNode)iterator.next();
            tSGraphObject.setUtilityObject(null);
        }
    }

    public boolean isSomethingMoved() {
        return this.somethingMoved;
    }
}

