/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.diagramming.command;

import com.tomsawyer.complexity.TSNestingManager;
import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSGraphTailor;
import com.tomsawyer.drawing.TSPEdge;
import com.tomsawyer.drawing.TSPNode;
import com.tomsawyer.drawing.ct;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.event.TSGraphChangeEvent;
import com.tomsawyer.graph.event.TSGraphChangeEventData;
import com.tomsawyer.util.command.TSCommand;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class TSReconnectEdgeCommand
extends TSCommand {
    TSDNode oldNode = null;
    TSConnector oldConnector = null;
    private ct oldClipping = new ct();
    TSDNode newNode;
    TSConnector newConnector;
    boolean reconnectSource;
    TSDGraph oldGraph;
    TSDGraph graph;
    TSDEdge edge = null;
    List pointList;
    List oldPointList;
    List graphs;
    List margins;

    public TSReconnectEdgeCommand(TSDGraph tSDGraph, TSDEdge tSDEdge, TSDNode tSDNode, TSConnector tSConnector, boolean bl, List list, List list2) {
        this.oldGraph = (TSDGraph)tSDEdge.getOwnerGraph();
        this.graph = tSDGraph;
        this.edge = tSDEdge;
        this.newNode = tSDNode;
        this.newConnector = tSConnector;
        this.reconnectSource = bl;
        this.pointList = list;
        this.oldPointList = list2;
    }

    protected void doAction() throws Throwable {
        if (this.mustReconnectSource()) {
            this.oldNode = (TSDNode)this.edge.getSourceNode();
            this.oldConnector = this.edge.getSourceConnector();
            this.oldClipping = new ct(this.edge.getSourceClipping());
            this.edge.discardCalculatedSourceClipping();
        } else {
            this.oldNode = (TSDNode)this.edge.getTargetNode();
            this.oldConnector = this.edge.getTargetConnector();
            this.oldClipping = new ct(this.edge.getTargetClipping());
            this.edge.discardCalculatedTargetClipping();
        }
        if (this.graph.fireEvent(new TSGraphChangeEvent(4096L, new TSGraphChangeEventData(this.edge, this.oldNode, this.newNode)), true)) {
            this.storeOldMargins();
            this.transformBendPoints(true);
            boolean bl = this.getGraph().getOwnerGraphManager().getEventManager().isFiringEvents();
            this.getGraph().getOwnerGraphManager().getEventManager().setFireEvents(false);
            if (this.mustReconnectSource()) {
                this.edge.setSourceNode(this.newNode);
                this.edge.setSourceConnector(this.newConnector);
            } else {
                this.edge.setTargetNode(this.newNode);
                this.edge.setTargetConnector(this.newConnector);
            }
            this.getGraph().getOwnerGraphManager().insert(this.edge, this.edge.getSourceNode(), this.edge.getTargetNode());
            this.getGraph().getOwnerGraphManager().getEventManager().setFireEvents(bl);
            if (this.oldNode != this.newNode) {
                this.edge.fireEndNodeChangedEvent(this.oldNode, this.newNode);
            }
            if (this.oldConnector != this.newConnector) {
                this.edge.fireEndConnectorChangedEvent(this.oldConnector, this.newConnector);
            }
            if (this.mustReconnectSource()) {
                TSPEdge tSPEdge = this.edge.getSourceEdge();
                for (int i = this.pointList.size() - this.oldPointList.size() - 1; i >= 0; --i) {
                    TSPNode tSPNode = this.edge.addPathNode(tSPEdge, (TSConstPoint)this.pointList.get(i));
                    tSPEdge = this.edge.getSourceEdge();
                }
            } else {
                TSPEdge tSPEdge = this.edge.getTargetEdge();
                for (int i = this.oldPointList.size(); i < this.pointList.size(); ++i) {
                    TSPNode tSPNode = this.edge.addPathNode(tSPEdge, (TSConstPoint)this.pointList.get(i));
                    tSPEdge = this.edge.getTargetEdge();
                }
            }
            ((TSDGraph)this.edge.getOwnerGraph()).updateBounds();
        } else {
            this.setAddToUndoStack(false);
        }
    }

    protected void undoAction() throws Throwable {
        if (this.getOldNode() != null) {
            this.transformBendPoints(false);
            boolean bl = this.getGraph().getOwnerGraphManager().getEventManager().isFiringEvents();
            this.getGraph().getOwnerGraphManager().getEventManager().setFireEvents(false);
            this.getGraph().getOwnerGraphManager().remove(this.edge);
            if (this.oldConnector != null && this.oldConnector.isDiscarded()) {
                this.oldConnector = null;
            }
            if (this.mustReconnectSource()) {
                this.edge.setSourceNode(this.oldNode);
                this.edge.setSourceConnector(this.oldConnector);
            } else {
                this.edge.setTargetNode(this.oldNode);
                this.edge.setTargetConnector(this.oldConnector);
            }
            this.getGraph().getOwnerGraphManager().insert(this.edge, this.edge.getSourceNode(), this.edge.getTargetNode());
            if (this.mustReconnectSource()) {
                this.edge.setSourceClipping(this.oldClipping);
            } else {
                this.edge.setTargetClipping(this.oldClipping);
            }
            this.getGraph().getOwnerGraphManager().getEventManager().setFireEvents(bl);
            if (this.mustReconnectSource()) {
                for (int i = this.pointList.size() - this.oldPointList.size(); i > 0; --i) {
                    TSPEdge tSPEdge = this.edge.getSourceEdge();
                    this.edge.removePathSegment((TSPNode)tSPEdge.getTargetNode());
                }
            } else {
                for (int i = this.pointList.size() - this.oldPointList.size(); i > 0; --i) {
                    TSPEdge tSPEdge = this.edge.getTargetEdge();
                    this.edge.removePathSegment((TSPNode)tSPEdge.getSourceNode());
                }
            }
            ((TSDGraph)this.edge.getOwnerGraph()).updateBounds();
            this.restoreMargins();
            if (this.oldNode != this.newNode) {
                this.edge.fireEndNodeChangedEvent(this.newNode, this.oldNode);
            }
            if (this.oldConnector != this.newConnector) {
                this.edge.fireEndConnectorChangedEvent(this.newConnector, this.oldConnector);
            }
        }
    }

    protected void redoAction() throws Throwable {
        if (this.getOldNode() != null) {
            this.transformBendPoints(true);
            boolean bl = this.getGraph().getOwnerGraphManager().getEventManager().isFiringEvents();
            this.getGraph().getOwnerGraphManager().getEventManager().setFireEvents(false);
            this.getGraph().getOwnerGraphManager().remove(this.edge);
            if (this.mustReconnectSource()) {
                this.oldNode = (TSDNode)this.edge.getSourceNode();
                this.edge.setSourceNode(this.newNode);
                this.edge.setSourceConnector(this.newConnector);
                this.edge.discardCalculatedSourceClipping();
            } else {
                this.oldNode = (TSDNode)this.edge.getTargetNode();
                this.edge.setTargetNode(this.newNode);
                this.edge.setTargetConnector(this.newConnector);
                this.edge.discardCalculatedTargetClipping();
            }
            this.getGraph().getOwnerGraphManager().insert(this.edge, this.edge.getSourceNode(), this.edge.getTargetNode());
            this.getGraph().getOwnerGraphManager().getEventManager().setFireEvents(bl);
            if (this.oldNode != this.newNode) {
                this.edge.fireEndNodeChangedEvent(this.oldNode, this.newNode);
            }
            if (this.oldConnector != this.newConnector) {
                this.edge.fireEndConnectorChangedEvent(this.oldConnector, this.newConnector);
            }
            if (this.mustReconnectSource()) {
                TSPEdge tSPEdge = this.edge.getSourceEdge();
                for (int i = this.pointList.size() - this.oldPointList.size() - 1; i >= 0; --i) {
                    TSPNode tSPNode = this.edge.addPathNode(tSPEdge, (TSConstPoint)this.pointList.get(i));
                    tSPEdge = this.edge.getSourceEdge();
                }
            } else {
                TSPEdge tSPEdge = this.edge.getTargetEdge();
                for (int i = this.oldPointList.size(); i < this.pointList.size(); ++i) {
                    TSPNode tSPNode = this.edge.addPathNode(tSPEdge, (TSConstPoint)this.pointList.get(i));
                    tSPEdge = this.edge.getTargetEdge();
                }
            }
            ((TSDGraph)this.edge.getOwnerGraph()).updateBounds();
        }
    }

    private void transformBendPoints(boolean bl) {
        TSDGraph tSDGraph;
        TSDNode tSDNode;
        TSDGraph tSDGraph2;
        if (bl) {
            tSDGraph2 = (TSDGraph)this.getGraph().getOwnerGraphManager().getCommonOwnerGraph(this.edge);
            tSDNode = this.mustReconnectSource() ? (TSDNode)this.edge.getTargetNode() : (TSDNode)this.edge.getSourceNode();
            tSDGraph = (TSDGraph)this.getGraph().getOwnerGraphManager().getCommonOwnerGraph(tSDNode.getOwnerGraph(), this.newNode.getOwnerGraph());
        } else {
            tSDGraph2 = (TSDGraph)this.getGraph().getOwnerGraphManager().getCommonOwnerGraph(this.edge);
            tSDNode = this.mustReconnectSource() ? (TSDNode)this.edge.getTargetNode() : (TSDNode)this.edge.getSourceNode();
            tSDGraph = (TSDGraph)this.getGraph().getOwnerGraphManager().getCommonOwnerGraph(tSDNode.getOwnerGraph(), this.oldNode.getOwnerGraph());
        }
        if (tSDGraph2 != tSDGraph) {
            TSConstPoint tSConstPoint;
            TSGraphObject tSGraphObject;
            boolean bl2 = this.getGraph().getOwnerGraphManager().getEventManager().isFiringEvents();
            this.getGraph().getOwnerGraphManager().getEventManager().setFireEvents(false);
            Vector<TSPoint> vector = new Vector<TSPoint>();
            Iterator iterator = this.edge.bendPoints().iterator();
            while (iterator.hasNext()) {
                tSGraphObject = ((TSDGraphManager)this.getGraph().getOwnerGraphManager()).getMainDisplayGraph();
                tSConstPoint = new TSPoint((TSConstPoint)iterator.next());
                boolean bl3 = false;
                if (tSDGraph2 != tSGraphObject && !tSDGraph2.isIntergraph()) {
                    bl3 = tSDGraph2.expandedTransformPoint((TSPoint)tSConstPoint);
                }
                if (tSDGraph != tSGraphObject && !tSDGraph.isIntergraph()) {
                    bl3 = tSDGraph.inverseExpandedTransformPoint((TSPoint)tSConstPoint);
                }
                if (!bl3) continue;
                vector.add((TSPoint)tSConstPoint);
            }
            iterator = vector.iterator();
            tSGraphObject = this.edge.getSourceEdge();
            while (iterator.hasNext()) {
                tSConstPoint = (TSConstPoint)iterator.next();
                TSPNode tSPNode = (TSPNode)((TSEdge)tSGraphObject).getTargetNode();
                tSPNode.setCenter(tSConstPoint);
                tSGraphObject = tSPNode.getOutEdge();
            }
            this.getGraph().getOwnerGraphManager().getEventManager().setFireEvents(bl2);
            tSDGraph2.updateBounds();
            tSDGraph.updateBounds();
        }
    }

    public TSDNode getOldNode() {
        return this.oldNode;
    }

    public TSDNode getNewNode() {
        return this.newNode;
    }

    public TSConnector getOldConnector() {
        return this.oldConnector;
    }

    public TSConnector getNewConnector() {
        return this.newConnector;
    }

    public ct getOldClipping() {
        return this.oldClipping;
    }

    public boolean mustReconnectSource() {
        return this.reconnectSource;
    }

    public TSDGraph getGraph() {
        return this.graph;
    }

    public TSDEdge getEdge() {
        return this.edge;
    }

    public List getPointList() {
        return this.pointList;
    }

    private void storeOldMargins() {
        TSDGraphManager tSDGraphManager = (TSDGraphManager)this.graph.getOwnerGraphManager();
        if (tSDGraphManager != null) {
            this.graphs = new Vector();
            this.margins = new Vector();
            TSNestingManager.buildNestedGraphList(tSDGraphManager.getMainDisplayGraph(), this.graphs, false);
            if (this.graphs != null) {
                Iterator iterator = this.graphs.iterator();
                while (iterator.hasNext()) {
                    double[] dArray = new double[4];
                    TSGraphTailor tSGraphTailor = ((TSDGraph)iterator.next()).getTailor();
                    dArray[0] = tSGraphTailor.getLeftConstantMargin();
                    dArray[1] = tSGraphTailor.getRightConstantMargin();
                    dArray[2] = tSGraphTailor.getBottomConstantMargin();
                    dArray[3] = tSGraphTailor.getTopConstantMargin();
                    this.margins.add(dArray);
                }
            }
        }
    }

    private void restoreMargins() {
        if (this.graphs != null) {
            Iterator iterator = this.graphs.iterator();
            Iterator iterator2 = this.margins.iterator();
            while (iterator.hasNext()) {
                TSDGraph tSDGraph = (TSDGraph)iterator.next();
                TSGraphTailor tSGraphTailor = tSDGraph.getTailor();
                double[] dArray = (double[])iterator2.next();
                double d = tSGraphTailor.getOriginalLeftConstantMargin();
                double d2 = tSGraphTailor.getOriginalRightConstantMargin();
                double d3 = tSGraphTailor.getOriginalBottomConstantMargin();
                double d4 = tSGraphTailor.getOriginalTopConstantMargin();
                tSGraphTailor.setLeftConstantMargin(dArray[0]);
                tSGraphTailor.setRightConstantMargin(dArray[1]);
                tSGraphTailor.setBottomConstantMargin(dArray[2]);
                tSGraphTailor.setTopConstantMargin(dArray[3]);
                tSGraphTailor.setOriginalLeftConstantMargin(d);
                tSGraphTailor.setOriginalRightConstantMargin(d2);
                tSGraphTailor.setOriginalBottomConstantMargin(d3);
                tSGraphTailor.setOriginalTopConstantMargin(d4);
                tSDGraph.updateBounds();
            }
        }
    }
}

