/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing;

import com.tomsawyer.drawing.TSAbstractShape;
import com.tomsawyer.drawing.TSConnectorLabel;
import com.tomsawyer.drawing.TSDEdge;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSHasShape;
import com.tomsawyer.drawing.TSLabel;
import com.tomsawyer.drawing.TSOvalShape;
import com.tomsawyer.drawing.TSSolidGeometricObject;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeEventData;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSConstSize;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.drawing.geometry.TSShape;
import com.tomsawyer.drawing.geometry.TSSize;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphMember;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSGraphObjectTable;
import com.tomsawyer.graph.de;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.f0;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TSConnector
extends TSGraphObject
implements TSSolidGeometricObject,
TSHasShape {
    protected TSSize connectorSize;
    double proportionalOffsetX;
    double proportionalOffsetY;
    double constantOffsetX;
    double constantOffsetY;
    de labelSet;
    TSAbstractShape connectorShape;
    public static String CONNECTOR_LEFT = "left";
    public static String CONNECTOR_RIGHT = "right";
    public static String CONNECTOR_TOP = "top";
    public static String CONNECTOR_BOTTOM = "bottom";

    protected TSConnector() {
    }

    protected void initGraphObject() {
        super.initGraphObject();
        this.connectorShape = new TSOvalShape();
        this.connectorSize = new TSSize(0.0, 0.0);
        this.proportionalOffsetX = 0.0;
        this.proportionalOffsetY = 0.0;
        this.constantOffsetX = 0.0;
        this.constantOffsetY = 0.0;
        this.labelSet = new de();
    }

    public boolean isViewable() {
        return this.isOwned() && this.getOwner().isViewable();
    }

    public TSGraph getOwnerGraph() {
        TSDGraph tSDGraph = null;
        if (this.getOwner() != null) {
            tSDGraph = (TSDGraph)this.getOwner().getOwner();
        }
        return tSDGraph;
    }

    public TSDGraph getTransformGraph() {
        return (TSDGraph)this.getOwnerGraph();
    }

    public double getConstantXOffset() {
        return this.getLocalConstantXOffset();
    }

    public double getLocalConstantXOffset() {
        return this.constantOffsetX;
    }

    public double getConstantYOffset() {
        return this.getLocalConstantYOffset();
    }

    public double getLocalConstantYOffset() {
        return this.constantOffsetY;
    }

    public double getProportionalXOffset() {
        return this.proportionalOffsetX;
    }

    public double getProportionalYOffset() {
        return this.proportionalOffsetY;
    }

    public void setConstantXOffset(double d) {
        this.setLocalConstantXOffset(d);
    }

    public void setLocalConstantXOffset(double d) {
        TSConstRect tSConstRect = this.getLocalBounds(7);
        this.constantOffsetX = d;
        this.notifyOwnerOnMove(tSConstRect);
    }

    public void setConstantYOffset(double d) {
        this.setLocalConstantYOffset(d);
    }

    public void setLocalConstantYOffset(double d) {
        TSConstRect tSConstRect = this.getLocalBounds(7);
        this.constantOffsetY = d;
        this.notifyOwnerOnMove(tSConstRect);
    }

    public void setProportionalXOffset(double d) {
        if (this.getProportionalXOffset() != d) {
            TSConstRect tSConstRect = this.getLocalBounds(7);
            this.proportionalOffsetX = d;
            this.notifyOwnerOnMove(tSConstRect);
        }
    }

    public void setProportionalYOffset(double d) {
        if (this.getProportionalYOffset() != d) {
            TSConstRect tSConstRect = this.getLocalBounds(7);
            this.proportionalOffsetY = d;
            this.notifyOwnerOnMove(tSConstRect);
        }
    }

    protected TSConnectorLabel newLabel() {
        return new TSConnectorLabel();
    }

    public TSConnectorLabel addLabel() {
        TSConnectorLabel tSConnectorLabel = this.newLabel();
        this.insert(tSConnectorLabel);
        return tSConnectorLabel;
    }

    public String getDefaultLabelDirection() {
        return CONNECTOR_BOTTOM;
    }

    public double getDefaultLabelDistance() {
        return 10.0;
    }

    public void discard(TSLabel tSLabel) {
        TSSystem.tsAssert(tSLabel != null);
        TSSystem.tsAssert(tSLabel.isOwned());
        TSSystem.tsAssert(tSLabel.getOwner() == this);
        if (this.getOwnerGraph() != null && this.getOwnerGraph().isFiringEvents()) {
            this.getOwnerGraph().setFireEvents(false);
            this.remove(tSLabel);
            this.getOwnerGraph().setFireEvents(true);
        } else {
            this.remove(tSLabel);
        }
        tSLabel.onDiscard(this);
    }

    public void discardAllLabels() {
        f0 f02 = this.labelSet.a();
        while (f02 != null) {
            f0 f03 = f02.a();
            this.discard((TSConnectorLabel)f02.b());
            f02 = f03;
        }
    }

    public int numberOfLabels() {
        if (this.labelSet == null) {
            return 0;
        }
        return this.labelSet.size();
    }

    public void insert(TSConnectorLabel tSConnectorLabel) {
        TSSystem.tsAssert(tSConnectorLabel != null);
        TSSystem.tsAssert(!tSConnectorLabel.isOwned());
        this.labelSet.add(tSConnectorLabel);
        TSGraphObject tSGraphObject = null;
        if (this.getOwner() != null) {
            tSGraphObject = this.getOwner().getOwner();
        }
        if (this.isOwned() && tSGraphObject != null) {
            ++((TSDGraph)tSGraphObject).connectorLabelCount;
        }
        tSConnectorLabel.onInsert(this);
        tSConnectorLabel.ltShiftBounds();
        if (this.isOwned() && tSGraphObject != null && ((TSDGraph)tSGraphObject).isGeometryChangeNotified()) {
            ((TSDNode)this.getOwner()).notifyGraphOnInsert(tSConnectorLabel.getLocalBounds());
        }
    }

    public List labels() {
        return this.labelSet;
    }

    public void remove(TSLabel tSLabel) {
        TSSystem.tsAssert(tSLabel != null);
        TSSystem.tsAssert(tSLabel.isOwned());
        TSSystem.tsAssert(tSLabel.getOwner() == this);
        TSConstRect tSConstRect = tSLabel.getLocalBounds();
        this.labelSet.remove(tSLabel);
        tSLabel.onRemove(this);
        TSGraphObject tSGraphObject = this.getOwner().getOwner();
        if (this.isOwned()) {
            --((TSDGraph)tSGraphObject).connectorLabelCount;
        }
        if (this.isOwned() && ((TSDGraph)tSGraphObject).isGeometryChangeNotified()) {
            ((TSDNode)this.getOwner()).notifyGraphOnRemove(tSConstRect);
        }
    }

    public void emptyTopology() {
        this.discardAllLabels();
    }

    public List getLabelsTouchingBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDNode tSDNode = (TSDNode)this.getOwner();
        TSDGraph tSDGraph = null;
        if (tSDNode != null) {
            tSDGraph = (TSDGraph)this.getOwner();
        }
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalLabelsTouchingBounds(tSRect, list);
    }

    public List getLocalLabelsTouchingBounds(TSConstRect tSConstRect, List vector) {
        if (vector == null) {
            vector = new Vector<TSConnectorLabel>();
        }
        for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)f02.b();
            if (!tSConnectorLabel.isVisible() || !tSConnectorLabel.locallyIntersects(tSConstRect)) continue;
            vector.add(0, tSConnectorLabel);
        }
        return vector;
    }

    public TSConnectorLabel getFirstLabelTouchingBounds(TSConstRect tSConstRect, Object object) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDNode tSDNode = (TSDNode)this.getOwner();
        TSDGraph tSDGraph = null;
        if (tSDNode != null) {
            tSDGraph = (TSDGraph)this.getOwner();
        }
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalFirstLabelTouchingBounds(tSRect, object);
    }

    TSConnectorLabel getLocalFirstLabelTouchingBounds(TSConstRect tSConstRect, Object object) {
        boolean bl = object == null;
        for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)f02.b();
            if (!tSConnectorLabel.isVisible() || !tSConnectorLabel.locallyIntersects(tSConstRect)) continue;
            if (bl) {
                return tSConnectorLabel;
            }
            bl = tSConnectorLabel.equals(object);
        }
        return null;
    }

    public TSConnectorLabel getLastLabelTouchingBounds(TSConstRect tSConstRect, Object object) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDNode tSDNode = (TSDNode)this.getOwner();
        TSDGraph tSDGraph = null;
        if (tSDNode != null) {
            tSDGraph = (TSDGraph)this.getOwner();
        }
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalLastLabelTouchingBounds(tSRect, object);
    }

    public TSConnectorLabel getLocalLastLabelTouchingBounds(TSConstRect tSConstRect, Object object) {
        boolean bl = object == null;
        for (f0 f02 = this.labelSet.b(); f02 != null; f02 = f02.d()) {
            TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)f02.b();
            if (!tSConnectorLabel.isVisible() || !tSConnectorLabel.locallyIntersects(tSConstRect)) continue;
            if (bl) {
                return tSConnectorLabel;
            }
            bl = tSConnectorLabel.equals(object);
        }
        return null;
    }

    public List getLabelsInsideBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDNode tSDNode = (TSDNode)this.getOwner();
        TSDGraph tSDGraph = null;
        if (tSDNode != null) {
            tSDGraph = (TSDGraph)this.getOwner();
        }
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalLabelsInsideBounds(tSRect, list);
    }

    public List getLocalLabelsInsideBounds(TSConstRect tSConstRect, List vector) {
        if (vector == null) {
            vector = new Vector<TSConnectorLabel>();
        }
        for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)f02.b();
            if (!tSConnectorLabel.isVisible() || !tSConnectorLabel.locallyInside(tSConstRect)) continue;
            vector.add(0, tSConnectorLabel);
        }
        return vector;
    }

    void updateBoundsOfLabels() {
        for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)f02.b();
            tSConnectorLabel.updateBounds();
        }
    }

    public void ltUpdateBoundsOfLabels() {
        this.ltUpdateBoundsOfLabels(false);
    }

    public void ltUpdateBoundsOfLabels(boolean bl) {
        TSDNode tSDNode = (TSDNode)this.getOwner();
        for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)f02.b();
            TSConstPoint tSConstPoint = tSConnectorLabel.getLocalCenter();
            tSConnectorLabel.ltShiftBounds();
            if (!bl || tSDNode == null || !tSDNode.isOwned() || this.getOwnerGraph() == null) continue;
            this.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(8192L, new TSDrawingChangeEventData(tSConnectorLabel, tSConstPoint, tSConnectorLabel.getLocalCenter())));
        }
    }

    void updateConnectorBoundsOnLabelMove(TSConstRect tSConstRect, TSConstRect tSConstRect2) {
        if (this.isOwned()) {
            TSDNode tSDNode = (TSDNode)this.getOwner();
            TSDGraph tSDGraph = null;
            if (tSDNode != null && tSDNode.isOwned()) {
                tSDGraph = (TSDGraph)tSDNode.getOwner();
                tSDGraph.updateGraphBoundsOnMove(tSConstRect, tSConstRect2);
            }
        }
    }

    void updateConnectorBoundsOnLabelResize(TSConstRect tSConstRect, TSConstRect tSConstRect2) {
        if (this.isOwned()) {
            TSDNode tSDNode = (TSDNode)this.getOwner();
            TSDGraph tSDGraph = null;
            if (tSDNode != null && tSDNode.isOwned()) {
                tSDGraph = (TSDGraph)tSDNode.getOwner();
                tSDGraph.updateGraphBoundsOnResize(tSConstRect, tSConstRect2);
            }
        }
    }

    public boolean isOverLabel(TSConstPoint tSConstPoint) {
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformPoint(tSPoint);
        }
        return this.isLocallyOverLabel(tSPoint);
    }

    public boolean isLocallyOverLabel(TSConstPoint tSConstPoint) {
        for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)f02.b();
            if (!tSConnectorLabel.isVisible() || !tSConnectorLabel.locallyContains(tSConstPoint)) continue;
            return true;
        }
        return false;
    }

    public long assignIDs(TSGraphObjectTable tSGraphObjectTable, long l) {
        if (l >= 0L) {
            tSGraphObjectTable.put(l++, this);
        } else {
            tSGraphObjectTable.put(this.getID(), this);
        }
        for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)f02.b();
            l = tSConnectorLabel.assignIDs(tSGraphObjectTable, l);
        }
        return l;
    }

    public boolean userObjectInUse() {
        boolean bl = super.userObjectInUse();
        Iterator iterator = this.labels().iterator();
        while (!bl && iterator.hasNext()) {
            bl = ((TSConnectorLabel)iterator.next()).userObjectInUse();
        }
        return bl;
    }

    public void nullifyUserObject() {
        super.nullifyUserObject();
        Iterator iterator = this.labels().iterator();
        while (iterator.hasNext()) {
            ((TSConnectorLabel)iterator.next()).nullifyUserObject();
        }
    }

    public boolean utilityObjectInUse() {
        boolean bl = super.utilityObjectInUse();
        Iterator iterator = this.labels().iterator();
        while (!bl && iterator.hasNext()) {
            bl = ((TSConnectorLabel)iterator.next()).utilityObjectInUse();
        }
        return bl;
    }

    public void nullifyUtilityObject() {
        super.nullifyUtilityObject();
        for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)f02.b();
            tSConnectorLabel.nullifyUtilityObject();
        }
    }

    public void setAllMarked(boolean bl) {
        super.setAllMarked(bl);
        for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)f02.b();
            tSConnectorLabel.setMarked(bl);
        }
    }

    public boolean hasMarkedObject() {
        boolean bl = this.isMarked();
        Iterator iterator = this.labelSet.iterator();
        while (!bl && iterator.hasNext()) {
            TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)iterator.next();
            bl = tSConnectorLabel.isMarked();
        }
        return bl;
    }

    public TSConstPoint getCenter() {
        TSPoint tSPoint = new TSPoint(this.getLocalCenter());
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null) {
            tSDGraph.expandedTransformPoint(tSPoint);
        }
        return tSPoint;
    }

    public TSConstPoint getLocalCenter() {
        TSConstPoint tSConstPoint = new TSConstPoint(this.getLocalCenterX(), this.getLocalCenterY());
        return tSConstPoint;
    }

    public void setCenterX(double d) {
        TSPoint tSPoint = new TSPoint(d, d);
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformPoint(tSPoint);
        }
        this.setLocalCenterX(tSPoint.getX());
    }

    public void setLocalCenterX(double d) {
        this.setLocalCenter(d, this.getLocalCenterY());
    }

    public void setCenterY(double d) {
        TSPoint tSPoint = new TSPoint(d, d);
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformPoint(tSPoint);
        }
        this.setLocalCenterY(tSPoint.getY());
    }

    public void setLocalCenterY(double d) {
        this.setLocalCenter(this.getLocalCenterX(), d);
    }

    public void setCenter(TSConstPoint tSConstPoint) {
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformPoint(tSPoint);
        }
        this.setLocalCenter(tSPoint.getX(), tSPoint.getY());
    }

    public void setCenter(double d, double d2) {
        TSPoint tSPoint = new TSPoint(d, d2);
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformPoint(tSPoint);
        }
        this.setLocalCenter(tSPoint.getX(), tSPoint.getY());
    }

    public void setLocalCenter(TSConstPoint tSConstPoint) {
        this.setLocalCenter(tSConstPoint.getX(), tSConstPoint.getY());
    }

    public void setLocalCenter(double d, double d2) {
        TSDNode tSDNode = (TSDNode)this.getOwner();
        double d3 = this.getLocalCenterX();
        double d4 = this.getLocalCenterY();
        if (tSDNode != null && (d != d3 || d2 != d4)) {
            TSConstRect tSConstRect = this.getLocalBounds(7);
            TSConstRect tSConstRect2 = tSDNode.getLocalBounds();
            if (d >= tSConstRect2.getRight()) {
                this.proportionalOffsetX = 0.5;
                this.constantOffsetX = d - tSConstRect2.getRight();
            } else if (d <= tSConstRect2.getLeft()) {
                this.proportionalOffsetX = -0.5;
                this.constantOffsetX = d - tSConstRect2.getLeft();
            } else {
                this.proportionalOffsetX = (d - tSConstRect2.getCenterX()) / tSConstRect2.getWidth();
                this.constantOffsetX = 0.0;
            }
            if (d2 >= tSConstRect2.getTop()) {
                this.proportionalOffsetY = 0.5;
                this.constantOffsetY = d2 - tSConstRect2.getTop();
            } else if (d2 <= tSConstRect2.getBottom()) {
                this.proportionalOffsetY = -0.5;
                this.constantOffsetY = d2 - tSConstRect2.getBottom();
            } else {
                this.proportionalOffsetY = (d2 - tSConstRect2.getCenterY()) / tSConstRect2.getHeight();
                this.constantOffsetY = 0.0;
            }
            this.notifyOwnerOnMove(tSConstRect);
        }
    }

    public double getCenterX() {
        double d = this.getLocalCenterX();
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null) {
            d = tSDGraph.expandedTransformX(d);
        }
        return d;
    }

    public double getLocalCenterX() {
        double d = 0.0;
        if (this.isOwned()) {
            TSDNode tSDNode = (TSDNode)this.getOwner();
            d = tSDNode.getLocalCenterX() + this.getLocalConstantXOffset() + this.getProportionalXOffset() * tSDNode.getLocalWidth();
        }
        return d;
    }

    public double getCenterY() {
        double d = this.getLocalCenterY();
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null) {
            d = tSDGraph.expandedTransformY(d);
        }
        return d;
    }

    public double getLocalCenterY() {
        double d = 0.0;
        if (this.isOwned()) {
            TSDNode tSDNode = (TSDNode)this.getOwner();
            d = tSDNode.getLocalCenterY() + this.getLocalConstantYOffset() + this.getProportionalYOffset() * tSDNode.getLocalHeight();
        }
        return d;
    }

    public boolean contains(TSConstPoint tSConstPoint) {
        return this.contains(tSConstPoint.getX(), tSConstPoint.getY());
    }

    public boolean locallyContains(TSConstPoint tSConstPoint) {
        return this.locallyContains(tSConstPoint.getX(), tSConstPoint.getY());
    }

    public boolean contains(double d, double d2) {
        TSPoint tSPoint = new TSPoint(d, d2);
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformPoint(tSPoint);
        }
        return this.locallyContains(tSPoint.getX(), tSPoint.getY());
    }

    public boolean locallyContains(double d, double d2) {
        boolean bl = false;
        if (this.getLocalBounds().contains(d, d2)) {
            bl = this.getShape().contains(d, d2);
        }
        return bl;
    }

    public boolean contains(TSConstRect tSConstRect) {
        return this.contains(tSConstRect.getLeft(), tSConstRect.getBottom(), tSConstRect.getRight(), tSConstRect.getTop());
    }

    public boolean locallyContains(TSConstRect tSConstRect) {
        return this.locallyContains(tSConstRect.getLeft(), tSConstRect.getBottom(), tSConstRect.getRight(), tSConstRect.getTop());
    }

    public boolean contains(double d, double d2, double d3, double d4) {
        TSRect tSRect = new TSRect(d, d2, d3, d4);
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.locallyContains(tSRect.getLeft(), tSRect.getBottom(), tSRect.getRight(), tSRect.getTop());
    }

    public boolean locallyContains(double d, double d2, double d3, double d4) {
        boolean bl = false;
        if (this.getLocalBounds().contains(d, d2, d3, d4)) {
            bl = this.getShape().contains(d, d2, d3, d4);
        }
        return bl;
    }

    public TSConstSize getSize() {
        return this.getLocalSize();
    }

    public TSConstSize getLocalSize() {
        return this.connectorSize;
    }

    public double getWidth() {
        return this.getLocalWidth();
    }

    public double getLocalWidth() {
        return this.connectorSize.getWidth();
    }

    public double getHeight() {
        return this.getLocalHeight();
    }

    public double getLocalHeight() {
        return this.connectorSize.getHeight();
    }

    public void setSize(TSConstSize tSConstSize) {
        this.setLocalSize(tSConstSize);
    }

    public void setLocalSize(TSConstSize tSConstSize) {
        this.setLocalSize(tSConstSize.getWidth(), tSConstSize.getHeight());
    }

    public void setSize(double d, double d2) {
        this.setLocalSize(d, d2);
    }

    public void setLocalSize(double d, double d2) {
        if (this.connectorSize.getWidth() != d || this.connectorSize.getHeight() != d2) {
            TSConstRect tSConstRect = this.getLocalBounds(7);
            this.assignSize(d, d2);
            TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
            if (tSDGraph != null && this.isOwned() && this.getOwner().isOwned() && tSDGraph.isGeometryChangeNotified()) {
                if (tSDGraph.isGeometryChangeNotified()) {
                    this.ltUpdateBoundsOfLabels();
                    this.notifyOwnerOnResize(tSConstRect);
                }
                tSDGraph.fireEvent(new TSDrawingChangeEvent(262144L, new TSDrawingChangeEventData(this, tSConstRect, this.getLocalBounds())));
            }
        }
    }

    public void setWidth(double d) {
        this.setLocalWidth(d);
    }

    public void setLocalWidth(double d) {
        this.setLocalSize(d, this.getLocalHeight());
    }

    public void setHeight(double d) {
        this.setLocalHeight(d);
    }

    public void setLocalHeight(double d) {
        this.setLocalSize(this.getLocalWidth(), d);
    }

    public void setBounds(TSConstRect tSConstRect) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        this.setLocalBounds(tSRect);
    }

    public void setLocalBounds(TSConstRect tSConstRect) {
        this.setLocalBounds(tSConstRect.getLeft(), tSConstRect.getBottom(), tSConstRect.getRight(), tSConstRect.getTop());
    }

    public void setBounds(double d, double d2, double d3, double d4) {
        TSRect tSRect = new TSRect(d, d2, d3, d4);
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        this.setLocalBounds(tSRect.getLeft(), tSRect.getBottom(), tSRect.getRight(), tSRect.getTop());
    }

    public void setLocalBounds(double d, double d2, double d3, double d4) {
        this.setLocalSize(Math.abs(d3 - d), Math.abs(d4 - d2));
        this.setLocalCenter((d + d3) / 2.0, (d2 + d4) / 2.0);
    }

    public void moveBy(TSConstSize tSConstSize) {
        this.moveBy(tSConstSize.getWidth(), tSConstSize.getHeight());
    }

    public void moveByLocal(TSConstSize tSConstSize) {
        this.setLocalCenter(this.getLocalCenterX() + tSConstSize.getWidth(), this.getLocalCenterY() + tSConstSize.getHeight());
    }

    public void moveBy(double d, double d2) {
        this.moveByLocal(d, d2);
    }

    public void moveByLocal(double d, double d2) {
        this.setLocalCenter(this.getLocalCenterX() + d, this.getLocalCenterY() + d2);
    }

    public boolean intersects(TSConstRect tSConstRect) {
        return this.intersects(tSConstRect.getLeft(), tSConstRect.getBottom(), tSConstRect.getRight(), tSConstRect.getTop());
    }

    public boolean locallyIntersects(TSConstRect tSConstRect) {
        return this.locallyIntersects(tSConstRect.getLeft(), tSConstRect.getBottom(), tSConstRect.getRight(), tSConstRect.getTop());
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        TSRect tSRect = new TSRect(d, d2, d3, d4);
        TSDGraph tSDGraph = (TSDGraph)this.getOwner().getOwner();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.locallyIntersects(tSRect.getLeft(), tSRect.getBottom(), tSRect.getRight(), tSRect.getTop());
    }

    public boolean locallyIntersects(double d, double d2, double d3, double d4) {
        boolean bl = false;
        bl = d == d3 && d4 == d2 ? this.locallyContains(d, d2) : (!this.getLocalBounds().intersects(d, d2, d3, d4) ? false : this.getShape().intersects(d, d2, d3, d4));
        return bl;
    }

    public boolean inside(TSConstRect tSConstRect) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.locallyInside(tSRect);
    }

    public boolean locallyInside(TSConstRect tSConstRect) {
        return tSConstRect.contains(this.getLocalBounds());
    }

    public TSConstRect getBounds() {
        TSRect tSRect = new TSRect(this.getLocalBounds());
        TSDGraph tSDGraph = (TSDGraph)this.getOwner().getOwner();
        if (tSDGraph != null) {
            tSDGraph.expandedTransformRect(tSRect);
        }
        return tSRect;
    }

    public TSConstRect getLocalBounds() {
        double d = this.getLocalCenterX();
        double d2 = this.getLocalCenterY();
        return new TSConstRect(d - this.getLocalWidth() / 2.0, d2 - this.getLocalHeight() / 2.0, d + this.getLocalWidth() / 2.0, d2 + this.getLocalHeight() / 2.0);
    }

    public double getBottom() {
        double d = this.getLocalBottom();
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null) {
            d = tSDGraph.expandedTransformY(d);
        }
        return d;
    }

    public double getLocalBottom() {
        return this.getLocalCenterY() - this.getLocalHeight() / 2.0;
    }

    public double getLeft() {
        double d = this.getLocalLeft();
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null) {
            d = tSDGraph.expandedTransformX(d);
        }
        return d;
    }

    public double getLocalLeft() {
        return this.getLocalCenterX() - this.getLocalWidth() / 2.0;
    }

    public double getRight() {
        double d = this.getLocalRight();
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null) {
            d = tSDGraph.expandedTransformX(d);
        }
        return d;
    }

    public double getLocalRight() {
        return this.getLocalCenterX() + this.getLocalWidth() / 2.0;
    }

    public double getTop() {
        double d = this.getLocalTop();
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null) {
            d = tSDGraph.expandedTransformY(d);
        }
        return d;
    }

    public double getLocalTop() {
        return this.getLocalCenterY() + this.getLocalHeight() / 2.0;
    }

    public TSConstRect getBounds(int n) {
        TSRect tSRect = new TSRect(this.getLocalBounds(n));
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null) {
            tSDGraph.expandedTransformRect(tSRect);
        }
        return tSRect;
    }

    public TSConstRect getLocalBounds(int n) {
        TSRect tSRect = new TSRect(this.getLocalBounds());
        if ((n & 2) != 0) {
            for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
                TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)f02.b();
                tSConnectorLabel.mergeLocalBounds(tSRect);
            }
        }
        return tSRect;
    }

    public void mergeLocalBounds(TSRect tSRect) {
        double d = this.getLocalCenterX();
        double d2 = this.getLocalCenterY();
        tSRect.merge(d - this.getLocalWidth() / 2.0, d2 - this.getLocalHeight() / 2.0, d + this.getLocalWidth() / 2.0, d2 + this.getLocalHeight() / 2.0);
    }

    public void mergeLocalBounds(TSRect tSRect, int n) {
        this.mergeLocalBounds(tSRect);
        if ((n & 2) != 0) {
            for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
                TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)f02.b();
                tSConnectorLabel.mergeLocalBounds(tSRect);
            }
        }
    }

    public double getBottom(int n) {
        double d = this.getLocalBottom(n);
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformY(d);
        }
        return d;
    }

    public double getLocalBottom(int n) {
        double d = this.getLocalBottom();
        if ((n & 2) != 0) {
            for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
                TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)f02.b();
                double d2 = tSConnectorLabel.getLocalBottom();
                if (!(d2 < d)) continue;
                d = d2;
            }
        }
        return d;
    }

    public double getLeft(int n) {
        double d = this.getLocalLeft(n);
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformX(d);
        }
        return d;
    }

    public double getLocalLeft(int n) {
        double d = this.getLocalLeft();
        if ((n & 2) != 0) {
            for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
                TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)f02.b();
                double d2 = tSConnectorLabel.getLocalLeft();
                if (!(d2 < d)) continue;
                d = d2;
            }
        }
        return d;
    }

    public double getRight(int n) {
        double d = this.getLocalRight(n);
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformX(d);
        }
        return d;
    }

    public double getLocalRight(int n) {
        double d = this.getLocalRight();
        if ((n & 2) != 0) {
            for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
                TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)f02.b();
                double d2 = tSConnectorLabel.getLocalRight();
                if (!(d2 > d)) continue;
                d = d2;
            }
        }
        return d;
    }

    public double getTop(int n) {
        double d = this.getLocalTop(n);
        TSDGraph tSDGraph = (TSDGraph)this.getOwnerGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformY(d);
        }
        return d;
    }

    public double getLocalTop(int n) {
        double d = this.getLocalTop();
        if ((n & 2) != 0) {
            for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
                TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)f02.b();
                double d2 = tSConnectorLabel.getLocalTop();
                if (!(d2 > d)) continue;
                d = d2;
            }
        }
        return d;
    }

    public List buildIncidentEdges(int n) {
        de de2 = new de();
        TSDNode tSDNode = (TSDNode)this.getOwner();
        if (tSDNode != null) {
            Object object;
            Object object2;
            Vector<Object> vector = new Vector<Object>();
            Iterator iterator = tSDNode.inEdges().iterator();
            while (iterator.hasNext()) {
                object2 = (TSDEdge)iterator.next();
                if (((TSDEdge)object2).getTargetConnector() != this) continue;
                vector.add(object2);
            }
            iterator = tSDNode.outEdges().iterator();
            while (iterator.hasNext()) {
                object2 = (TSDEdge)iterator.next();
                if (((TSDEdge)object2).getSourceConnector() != this) continue;
                vector.add(object2);
            }
            object2 = this.getOwnerGraph().getOwnerGraphManager().intergraphEdges().iterator();
            while (object2.hasNext()) {
                object = (TSDEdge)object2.next();
                if (((TSDEdge)object).getSourceConnector() != this && ((TSDEdge)object).getTargetConnector() != this) continue;
                vector.add(object);
            }
            object = vector.iterator();
            while (object.hasNext()) {
                TSDEdge tSDEdge = (TSDEdge)object.next();
                if (((n & 1) == 0 || tSDEdge.isIntergraphEdge()) && (n & 1) != 0 || ((n & 2) == 0 || !tSDEdge.isIntergraphEdge()) && (n & 2) != 0 || ((n & 4) == 0 || !tSDEdge.isMetaEdge()) && (n & 4) != 0 || ((n & 8) == 0 || tSDEdge.isMetaEdge()) && (n & 8) != 0 || ((n & 0x10) == 0 || !tSDEdge.isViewable()) && (n & 0x10) != 0 || ((n & 0x20) == 0 || tSDEdge.isViewable()) && (n & 0x20) != 0 || ((n & 0x40) == 0 || !tSDEdge.isReachable()) && (n & 0x40) != 0 || ((n & 0x80) == 0 || tSDEdge.isReachable()) && (n & 0x80) != 0) continue;
                de2.add(tSDEdge);
            }
        }
        return de2;
    }

    public int degree() {
        return this.incidentEdges().size();
    }

    public List disconnectedEdges() {
        Vector<TSDEdge> vector = new Vector<TSDEdge>();
        TSDNode tSDNode = (TSDNode)this.getOwner();
        if (tSDNode != null) {
            Iterator iterator = tSDNode.disconnectedEdges().iterator();
            while (iterator.hasNext()) {
                TSDEdge tSDEdge = (TSDEdge)iterator.next();
                if (tSDEdge.getTargetConnector() != this && tSDEdge.getSourceConnector() != this) continue;
                vector.add(tSDEdge);
            }
        }
        return vector;
    }

    public List incidentEdges() {
        Vector<TSDEdge> vector = new Vector<TSDEdge>();
        TSDNode tSDNode = (TSDNode)this.getOwner();
        if (tSDNode != null) {
            TSDEdge tSDEdge;
            Iterator iterator = tSDNode.inEdges().iterator();
            while (iterator.hasNext()) {
                tSDEdge = (TSDEdge)iterator.next();
                if (tSDEdge.getTargetConnector() != this) continue;
                vector.add(tSDEdge);
            }
            iterator = tSDNode.outEdges().iterator();
            while (iterator.hasNext()) {
                tSDEdge = (TSDEdge)iterator.next();
                if (tSDEdge.getSourceConnector() != this) continue;
                vector.add(tSDEdge);
            }
        }
        return vector;
    }

    public boolean isVisible() {
        return super.isVisible();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    void notifyOwnerOnMove(TSConstRect tSConstRect) {
        TSDNode tSDNode = (TSDNode)this.getOwner();
        if (this.isOwned() && tSDNode.isOwned() && ((TSDGraph)tSDNode.getOwner()).isGeometryChangeNotified()) {
            this.ltUpdateBoundsOfLabels();
            tSDNode.notifyGraphOnMove(tSConstRect);
            tSDNode.notifyEdgesOnGeometryChange();
            if (tSDNode != null && tSDNode.isOwned() && tSDNode.getOwnerGraph() != null && !this.getCenter().equals(tSConstRect.getCenter())) {
                tSDNode.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(32768L, new TSDrawingChangeEventData(this, tSConstRect, this.getLocalBounds())));
            }
        }
    }

    void notifyOwnerOnResize(TSConstRect tSConstRect) {
        TSDNode tSDNode = (TSDNode)this.getOwner();
        if (this.isOwned() && tSDNode.isOwned() && ((TSDGraph)tSDNode.getOwner()).isGeometryChangeNotified()) {
            this.ltUpdateBoundsOfLabels();
            tSDNode.notifyGraphOnResize(tSConstRect);
            tSDNode.notifyEdgesOnGeometryChange();
            if (tSDNode != null && tSDNode.isOwned() && tSDNode.getOwnerGraph() != null && !this.getCenter().equals(tSConstRect.getCenter())) {
                tSDNode.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(262144L, new TSDrawingChangeEventData(this, tSConstRect, this.getLocalBounds())));
            }
        }
    }

    public void onInsert(TSGraphObject tSGraphObject) {
        TSSystem.tsAssert(tSGraphObject != null);
        TSSystem.tsAssert(tSGraphObject instanceof TSDNode);
        super.onInsert(tSGraphObject);
        TSDNode tSDNode = (TSDNode)tSGraphObject;
        tSDNode.onConnectorBecomesInserted(this);
        if (tSGraphObject.isOwned() && tSGraphObject.getOwnerGraph() != null) {
            tSGraphObject.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(8L, new TSDrawingChangeEventData(this, null, tSGraphObject)));
        }
    }

    public void onRemove(TSGraphObject tSGraphObject) {
        TSGraphMember tSGraphMember;
        Iterator iterator = this.incidentEdges().iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSDEdge)iterator.next();
            if (((TSDEdge)tSGraphMember).getTargetConnector() == this) {
                ((TSDEdge)tSGraphMember).setTargetConnector(null);
            }
            if (((TSDEdge)tSGraphMember).getSourceConnector() != this) continue;
            ((TSDEdge)tSGraphMember).setSourceConnector(null);
        }
        iterator = this.disconnectedEdges().iterator();
        while (iterator.hasNext()) {
            tSGraphMember = (TSDEdge)iterator.next();
            if (((TSDEdge)tSGraphMember).getTargetConnector() == this) {
                ((TSDEdge)tSGraphMember).setTargetConnector(null);
            }
            if (((TSDEdge)tSGraphMember).getSourceConnector() != this) continue;
            ((TSDEdge)tSGraphMember).setSourceConnector(null);
        }
        tSGraphMember = (TSDNode)tSGraphObject;
        ((TSDNode)tSGraphMember).onConnectorBecomesRemoved(this);
        if (tSGraphObject.isOwned() && tSGraphObject.getOwner() != null) {
            tSGraphObject.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(64L, new TSDrawingChangeEventData(this, tSGraphObject, null)));
        }
        super.onRemove(tSGraphObject);
        ((TSDNode)tSGraphObject).recomputeClippingPoints();
    }

    public void onDiscard(TSGraphObject tSGraphObject) {
        TSGraph tSGraph = this.getOwnerGraph();
        if (tSGraph != null && this.isOwned() && this.getOwner().isOwned()) {
            tSGraph.fireEvent(new TSDrawingChangeEvent(512L, new TSDrawingChangeEventData(this, tSGraphObject, null)));
        }
        super.onDiscard(tSGraphObject);
    }

    public void copy(Object object, boolean bl) {
        super.copy(object, bl);
        if (object instanceof TSConnector) {
            Cloneable cloneable;
            TSConnector tSConnector = (TSConnector)object;
            if (tSConnector.connectorShape != null) {
                cloneable = (TSAbstractShape)tSConnector.connectorShape.clone();
                ((TSAbstractShape)cloneable).setOwner(this);
                this.setShape((TSShape)((Object)cloneable));
            }
            this.setLocalSize(tSConnector.getLocalSize());
            this.setLocalConstantXOffset(tSConnector.getLocalConstantXOffset());
            this.setLocalConstantYOffset(tSConnector.getLocalConstantYOffset());
            this.setProportionalXOffset(tSConnector.getProportionalXOffset());
            this.setProportionalYOffset(tSConnector.getProportionalYOffset());
            for (cloneable = tSConnector.labelSet.a(); cloneable != null; cloneable = ((f0)cloneable).a()) {
                TSConnectorLabel tSConnectorLabel;
                TSConnectorLabel tSConnectorLabel2 = (TSConnectorLabel)((f0)cloneable).b();
                if (!bl) {
                    tSConnectorLabel = this.newLabel();
                    tSConnectorLabel2.setUtilityObject(tSConnectorLabel);
                } else {
                    tSConnectorLabel = (TSConnectorLabel)tSConnectorLabel2.clone(true);
                }
                this.insert(tSConnectorLabel);
                tSConnectorLabel.copy(tSConnectorLabel2, bl);
            }
        }
    }

    protected void createMapping(Map map, Map map2) {
        Object object;
        if (this.getUtilityObject() instanceof TSConnector) {
            object = (TSConnector)this.getUtilityObject();
            TSGraph.map(this, (TSGraphObject)object, map, map2);
        }
        object = this.labels().iterator();
        while (object.hasNext()) {
            TSConnectorLabel tSConnectorLabel = (TSConnectorLabel)object.next();
            if (!(tSConnectorLabel.getUtilityObject() instanceof TSConnectorLabel)) continue;
            TSConnectorLabel tSConnectorLabel2 = (TSConnectorLabel)tSConnectorLabel.getUtilityObject();
            TSGraph.map(tSConnectorLabel, tSConnectorLabel2, map, map2);
        }
    }

    public void dispose() {
        if (this.isOwned()) {
            ((TSDNode)this.getOwner()).discard(this);
        } else if (!this.isDiscarded()) {
            this.onDiscard(this.getOwner());
        }
    }

    public TSShape getShape() {
        if (this.connectorShape == null) {
            TSSystem.tsAssert(this.connectorShape != null);
        }
        return this.connectorShape;
    }

    public void setShape(TSShape tSShape) {
        TSAbstractShape tSAbstractShape = this.connectorShape;
        if (tSShape != tSAbstractShape) {
            TSAbstractShape tSAbstractShape2 = (TSAbstractShape)tSShape;
            if (tSAbstractShape2 == null) {
                tSAbstractShape2 = new TSOvalShape();
            }
            this.connectorShape = tSAbstractShape2;
            tSAbstractShape2.setOwner(this);
            this.recomputeClippingPoints();
            if (this.isOwned() && this.getOwner().isOwned() && this.getOwnerGraph() != null) {
                this.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(0x100000L, new TSDrawingChangeEventData(this, tSAbstractShape, tSAbstractShape2)));
            }
        }
    }

    public void assignSize(double d, double d2) {
        this.connectorSize.setSize(d, d2);
        this.recomputeClippingPoints();
    }

    public void recomputeClippingPoints() {
        Iterator iterator = this.incidentEdges().iterator();
        while (iterator.hasNext()) {
            ((TSDEdge)iterator.next()).recomputeClippingPoints();
        }
        iterator = this.disconnectedEdges().iterator();
        while (iterator.hasNext()) {
            ((TSDEdge)iterator.next()).recomputeClippingPoints();
        }
    }

    public void adjustIncidentClippings() {
        TSDEdge tSDEdge;
        Iterator iterator = this.incidentEdges().iterator();
        while (iterator.hasNext()) {
            tSDEdge = (TSDEdge)iterator.next();
            if (tSDEdge.getSourceConnector() == this) {
                tSDEdge.adjustClipping(true);
                continue;
            }
            if (tSDEdge.getTargetConnector() != this) continue;
            tSDEdge.adjustClipping(false);
        }
        iterator = this.disconnectedEdges().iterator();
        while (iterator.hasNext()) {
            tSDEdge = (TSDEdge)iterator.next();
            if (tSDEdge.getSourceConnector() == this) {
                if (tSDEdge.isIntergraphEdge() && tSDEdge.isViewable()) {
                    tSDEdge.adjustClipping(true);
                    continue;
                }
                tSDEdge.discardCalculatedSourceClipping();
                continue;
            }
            if (tSDEdge.getTargetConnector() != this) continue;
            if (tSDEdge.isIntergraphEdge() && tSDEdge.isViewable()) {
                tSDEdge.adjustClipping(false);
                continue;
            }
            tSDEdge.discardCalculatedTargetClipping();
        }
    }

    public void setTag(Object object) {
        Object object2 = this.getTag();
        super.setTag(object);
        if (this.getOwnerGraph() != null && !TSSystem.equals(object2, object)) {
            this.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(2048L, new TSDrawingChangeEventData(this, object2, object)));
        }
    }
}

