/*
 * Decompiled with CFR 0.152.
 */
package com.tomsawyer.drawing;

import com.tomsawyer.drawing.TSConnector;
import com.tomsawyer.drawing.TSDGraph;
import com.tomsawyer.drawing.TSDGraphManager;
import com.tomsawyer.drawing.TSDNode;
import com.tomsawyer.drawing.TSEdgeLabel;
import com.tomsawyer.drawing.TSGEdge;
import com.tomsawyer.drawing.TSGNode;
import com.tomsawyer.drawing.TSLabel;
import com.tomsawyer.drawing.TSPEdge;
import com.tomsawyer.drawing.TSPNode;
import com.tomsawyer.drawing.ct;
import com.tomsawyer.drawing.cy;
import com.tomsawyer.drawing.cz;
import com.tomsawyer.drawing.event.TSDrawingChangeEvent;
import com.tomsawyer.drawing.event.TSDrawingChangeEventData;
import com.tomsawyer.drawing.geometry.TSConstPoint;
import com.tomsawyer.drawing.geometry.TSConstRect;
import com.tomsawyer.drawing.geometry.TSExpTransform;
import com.tomsawyer.drawing.geometry.TSPoint;
import com.tomsawyer.drawing.geometry.TSRect;
import com.tomsawyer.drawing.geometry.TSShape;
import com.tomsawyer.graph.TSEdge;
import com.tomsawyer.graph.TSGraph;
import com.tomsawyer.graph.TSGraphObject;
import com.tomsawyer.graph.TSGraphObjectTable;
import com.tomsawyer.graph.TSNode;
import com.tomsawyer.graph.de;
import com.tomsawyer.util.TSSystem;
import com.tomsawyer.util.f0;
import com.tomsawyer.util.f2;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class TSDEdge
extends TSGEdge {
    static final int META_EDGE = 32;
    TSPEdge sourceEdge;
    TSPEdge targetEdge;
    TSConnector sourceConnector;
    TSConnector targetConnector;
    de labelSet;
    int segmentCount;
    private ct sourceClipping;
    private ct targetClipping;
    private TSConstPoint sourceCashPoint;
    private TSConstPoint targetCashPoint;

    protected TSDEdge() {
    }

    protected void initGraphObject() {
        super.initGraphObject();
        this.sourceClipping = new ct(0.0, 0.0);
        this.targetClipping = new ct(0.0, 0.0);
        this.labelSet = new de();
        this.sourceEdge = this.targetEdge = this.newPathEdge();
        this.sourceConnector = null;
        this.targetConnector = null;
        this.sourceEdge.setOwner(this);
        this.sourceEdge.setOwned(true);
        this.segmentCount = 1;
    }

    public void copy(Object object, boolean bl) {
        super.copy(object, bl);
        if (object instanceof TSDEdge) {
            TSDEdge tSDEdge = (TSDEdge)object;
            TSConnector tSConnector = tSDEdge.getSourceConnector();
            TSConnector tSConnector2 = tSDEdge.getTargetConnector();
            TSConnector tSConnector3 = null;
            TSConnector tSConnector4 = null;
            if (tSConnector != null) {
                tSConnector3 = (TSConnector)tSConnector.getUtilityObject();
                if (tSConnector3 == null) {
                    this.setSourceConnector(tSConnector);
                } else {
                    this.setSourceConnector(tSConnector3);
                }
            }
            if (tSConnector2 != null) {
                tSConnector4 = (TSConnector)tSConnector2.getUtilityObject();
                if (tSConnector4 == null) {
                    this.setTargetConnector(tSConnector2);
                } else {
                    this.setTargetConnector(tSConnector4);
                }
            }
            this.getSourceEdge().connect();
            this.copyPath(tSDEdge);
            for (f0 f02 = tSDEdge.labelSet.a(); f02 != null; f02 = f02.a()) {
                TSEdgeLabel tSEdgeLabel;
                TSEdgeLabel tSEdgeLabel2 = (TSEdgeLabel)f02.b();
                if (!bl) {
                    tSEdgeLabel = this.newLabel();
                    tSEdgeLabel2.setUtilityObject(tSEdgeLabel);
                } else {
                    tSEdgeLabel = (TSEdgeLabel)tSEdgeLabel2.clone(true);
                }
                this.insert(tSEdgeLabel);
                tSEdgeLabel.copy(tSEdgeLabel2, bl);
            }
            this.segmentCount = tSDEdge.segmentCount;
            this.setMetaEdge(tSDEdge.isMetaEdge());
            this.sourceClipping.copy(tSDEdge.sourceClipping);
            this.targetClipping.copy(tSDEdge.targetClipping);
        }
        this.recomputeClippingPoints();
    }

    protected void createMapping(Map map, Map map2) {
        TSGraphObject tSGraphObject;
        TSGraphObject tSGraphObject2;
        super.createMapping(map, map2);
        Iterator iterator = this.labels().iterator();
        while (iterator.hasNext()) {
            tSGraphObject2 = (TSEdgeLabel)iterator.next();
            if (!(tSGraphObject2.getUtilityObject() instanceof TSEdgeLabel)) continue;
            tSGraphObject = (TSEdgeLabel)tSGraphObject2.getUtilityObject();
            TSGraph.map(tSGraphObject2, tSGraphObject, map, map2);
        }
        iterator = this.pathNodes().iterator();
        while (iterator.hasNext()) {
            tSGraphObject2 = (TSPNode)iterator.next();
            if (!(tSGraphObject2.getUtilityObject() instanceof TSPNode)) continue;
            tSGraphObject = (TSPNode)tSGraphObject2.getUtilityObject();
            TSGraph.map(this, tSGraphObject, map, map2);
        }
    }

    void copyPath(TSDEdge tSDEdge) {
        TSSystem.tsAssert(tSDEdge != null);
        this.discardAllPathNodes();
        TSPEdge tSPEdge = this.getSourceEdge();
        if (tSDEdge.numberOfPathNodes() > 0) {
            TSPoint tSPoint = new TSPoint();
            Iterator iterator = tSDEdge.pathNodes().iterator();
            while (iterator.hasNext()) {
                TSPNode tSPNode = (TSPNode)iterator.next();
                tSPNode.getLocalCenter(tSPoint);
                this.addLocalPathNode(tSPEdge, tSPoint);
                tSPEdge = this.getTargetEdge();
            }
        }
    }

    public TSPNode addPathNode(TSPEdge tSPEdge, TSConstPoint tSConstPoint) {
        return this.addPNode(tSPEdge, tSConstPoint, false);
    }

    public TSPNode addLocalPathNode(TSPEdge tSPEdge, TSConstPoint tSConstPoint) {
        return this.addPNode(tSPEdge, tSConstPoint, true);
    }

    public void discard(TSPNode tSPNode) {
        TSSystem.tsAssert(tSPNode != null);
        TSSystem.tsAssert(tSPNode.isOwned());
        TSSystem.tsAssert(tSPNode.getOwner() == this);
        TSPEdge tSPEdge = tSPNode.getInEdge();
        TSPEdge tSPEdge2 = tSPNode.getOutEdge();
        TSGNode tSGNode = (TSGNode)tSPEdge2.getTargetNode();
        this.discard(tSPEdge2);
        tSPEdge.setTargetNode(tSGNode);
        if (this.getTargetEdge() == null) {
            this.setTargetEdge(tSPEdge);
        }
        this.discardBend(tSPNode);
        if (this.isOwned() && ((TSDGraph)this.getOwner()).isGeometryChangeNotified()) {
            this.updateBoundsOfLabels();
            this.recomputeClippingPoints();
        }
    }

    public void discardAllPathNodes() {
        if (this.sourceEdge != null) {
            while (this.segmentCount > 1) {
                this.discard((TSPNode)this.sourceEdge.getTargetNode());
            }
        }
    }

    public TSPEdge removePathSegment(TSPNode tSPNode) {
        TSSystem.tsAssert(tSPNode != null);
        TSSystem.tsAssert(tSPNode.isOwned());
        TSSystem.tsAssert(tSPNode.getOwner() == this);
        TSPEdge tSPEdge = tSPNode.getInEdge();
        TSPEdge tSPEdge2 = tSPNode.getOutEdge();
        this.remove(tSPEdge2);
        if (this.getTargetEdge() == null) {
            this.setTargetEdge(tSPEdge);
        }
        tSPEdge.setTargetNode(tSPEdge2.getTargetNode());
        this.remove(tSPNode);
        if (this.isOwned() && ((TSDGraph)this.getOwner()).isGeometryChangeNotified()) {
            this.updateBoundsOfLabels();
            this.recomputeClippingPoints();
        }
        return tSPEdge2;
    }

    public void insertPathSegment(TSPNode tSPNode, TSPEdge tSPEdge) {
        TSPEdge tSPEdge2;
        TSSystem.tsAssert(tSPNode != null);
        TSSystem.tsAssert(tSPNode.degree() == 0);
        TSSystem.tsAssert(tSPNode.disconnectedEdges().size() >= 1);
        TSSystem.tsAssert(tSPNode.disconnectedEdges().contains(tSPEdge));
        TSGNode tSGNode = (TSGNode)tSPEdge.getTargetNode();
        TSSystem.tsAssert(tSGNode.isOwned());
        TSSystem.tsAssert(!tSGNode.isPathNode() || tSGNode.disconnectedEdges().contains(tSPEdge));
        if (tSGNode.isPathNode()) {
            TSSystem.tsAssert(tSGNode.getOwner() == this, "Incorrect bend owner");
            tSPEdge2 = ((TSPNode)tSGNode).getInEdge();
        } else {
            TSSystem.tsAssert(tSGNode == this.getTargetNode(), "Incorrect target node");
            tSPEdge2 = this.getTargetEdge();
        }
        this.insert(tSPNode);
        tSPEdge2.setTargetNode(tSPNode);
        this.insert(tSPEdge);
        if (tSPEdge2 == this.getTargetEdge()) {
            this.setTargetEdge(tSPEdge);
        }
        if (this.isOwned() && ((TSDGraph)this.getOwner()).isGeometryChangeNotified()) {
            this.updateBoundsOfLabels();
            this.recomputeClippingPoints();
            this.notifyGraphOnInsert(this.getLocalBounds(7));
        }
        if (this.getOwnerGraph() != null) {
            this.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(4L, new TSDrawingChangeEventData(tSPNode, null, this)));
        }
    }

    public boolean reroute(List list) {
        if (list == null) {
            return false;
        }
        this.discardAllPathNodes();
        Iterator iterator = list.iterator();
        TSPEdge tSPEdge = this.getSourceEdge();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            if (e instanceof TSConstPoint) {
                TSPNode tSPNode = this.addPathNode(tSPEdge, (TSConstPoint)e);
                tSPEdge = tSPNode.getOutEdge();
            }
            this.recomputeClippingPoints();
        }
        return true;
    }

    public int numberOfPathEdges() {
        return this.segmentCount;
    }

    public int numberOfPathNodes() {
        return this.segmentCount - 1;
    }

    public Iterator pathIterator() {
        return new cy(this);
    }

    public Iterator bendIterator() {
        return new cz(this);
    }

    public List pathNodes() {
        Vector<TSPNode> vector = new Vector<TSPNode>(this.numberOfPathNodes());
        if (this.numberOfPathEdges() > 1) {
            TSPEdge tSPEdge = this.getSourceEdge();
            while (tSPEdge != this.getTargetEdge()) {
                TSPNode tSPNode = (TSPNode)tSPEdge.getTargetNode();
                vector.add(tSPNode);
                tSPEdge = tSPNode.getOutEdge();
            }
        }
        return vector;
    }

    public List pathEdges() {
        Vector<TSPEdge> vector = new Vector<TSPEdge>();
        if (this.getSourceEdge() != null) {
            TSPEdge tSPEdge = this.getSourceEdge();
            while (tSPEdge != this.getTargetEdge()) {
                vector.add(tSPEdge);
                tSPEdge = ((TSPNode)tSPEdge.getTargetNode()).getOutEdge();
            }
            vector.add(this.getTargetEdge());
        }
        return vector;
    }

    public List bendPoints() {
        Vector<TSPoint> vector = new Vector<TSPoint>();
        if (this.numberOfPathEdges() > 1) {
            TSPEdge tSPEdge = this.getSourceEdge();
            while (tSPEdge != this.getTargetEdge()) {
                TSPNode tSPNode = (TSPNode)tSPEdge.getTargetNode();
                vector.add(new TSPoint(tSPNode.getCenter()));
                tSPEdge = tSPNode.getOutEdge();
            }
        }
        return vector;
    }

    public List localBendPoints() {
        Vector<TSPoint> vector = new Vector<TSPoint>();
        if (this.numberOfPathEdges() > 1) {
            TSPEdge tSPEdge = this.getSourceEdge();
            while (tSPEdge != this.getTargetEdge()) {
                TSPNode tSPNode = (TSPNode)tSPEdge.getTargetNode();
                vector.add(new TSPoint(tSPNode.getLocalCenter()));
                tSPEdge = tSPNode.getOutEdge();
            }
        }
        return vector;
    }

    public boolean isStraight() {
        return this.getSourceEdge() == this.getTargetEdge();
    }

    public int getPathNodeIndex(TSPNode tSPNode) {
        int n = 0;
        if (tSPNode.isOwned() && tSPNode.getOwner() == this) {
            boolean bl = false;
            Iterator iterator = this.pathNodes().iterator();
            while (iterator.hasNext() && !bl) {
                ++n;
                if (iterator.next() != tSPNode) continue;
                bl = true;
            }
            if (!bl) {
                n = 0;
            }
        }
        return n;
    }

    public TSPNode getPathNodeAt(int n) {
        TSNode tSNode = null;
        if (n > 0 && n <= this.numberOfPathNodes()) {
            tSNode = this.sourceEdge.getTargetNode();
            while (n > 1) {
                tSNode = tSNode.outEdge().getTargetNode();
                --n;
            }
        }
        return (TSPNode)tSNode;
    }

    public TSPEdge getPathEdgeAtIndex(int n) {
        TSPEdge tSPEdge = null;
        if (n > 0 && n <= this.numberOfPathEdges()) {
            tSPEdge = this.sourceEdge;
            while (n > 1) {
                tSPEdge = (TSPEdge)tSPEdge.getTargetNode().outEdge();
                --n;
            }
        }
        return tSPEdge;
    }

    public void setAllPathNodesVisited(boolean bl) {
        TSPEdge tSPEdge = this.getSourceEdge();
        while (tSPEdge != this.getTargetEdge()) {
            TSPNode tSPNode = (TSPNode)tSPEdge.getTargetNode();
            tSPNode.setVisited(bl);
            tSPEdge = tSPNode.getOutEdge();
        }
    }

    public boolean isViewable() {
        TSDNode tSDNode = (TSDNode)this.getSourceNode();
        TSDNode tSDNode2 = (TSDNode)this.getTargetNode();
        return this.isValid() && tSDNode.isViewable() && tSDNode2.isViewable();
    }

    public boolean isReachable() {
        TSDGraph tSDGraph = (TSDGraph)this.getOwner();
        if (tSDGraph == null || tSDGraph.isHideGraph() || !tSDGraph.isOwned()) {
            return false;
        }
        return ((TSDNode)this.getSourceNode()).isReachable() && ((TSDNode)this.getTargetNode()).isReachable();
    }

    public void setChildGraph(TSGraph tSGraph) {
        f2.a(f2.a5);
        if (this.getChildGraph() != tSGraph) {
            TSDGraph tSDGraph = (TSDGraph)this.getOwner();
            if (tSGraph != null && (tSGraph.getParent() != null || tSDGraph != null && tSGraph.getOwner() != tSDGraph.getOwner() && tSGraph.isHideGraph() || tSGraph.isIntergraph())) {
                throw new IllegalStateException();
            }
            super.setChildGraph(tSGraph);
        }
    }

    public void setIntergraphEdge(boolean bl) {
        super.setIntergraphEdge(bl);
        this.recomputeClippingPoints();
    }

    public boolean isMetaEdge() {
        return (this.flags & 0x20) != 0;
    }

    public void setMetaEdge(boolean bl) {
        this.flags = bl ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }

    public TSEdgeLabel addLabel() {
        TSEdgeLabel tSEdgeLabel = this.newLabel();
        this.insert(tSEdgeLabel);
        this.moveToDefaultPosition(tSEdgeLabel);
        return tSEdgeLabel;
    }

    public void discard(TSLabel tSLabel) {
        TSSystem.tsAssert(tSLabel != null);
        TSSystem.tsAssert(tSLabel.isOwned());
        TSSystem.tsAssert(tSLabel.getOwner() == this);
        if (this.getOwnerGraph() != null && this.getOwnerGraph().isFiringEvents()) {
            this.getOwnerGraph().setFireEvents(false);
            this.remove(tSLabel);
            this.getOwnerGraph().setFireEvents(true);
        } else {
            this.remove(tSLabel);
        }
        tSLabel.onDiscard(this);
    }

    public void discardAllLabels() {
        f0 f02 = this.labelSet.a();
        while (f02 != null) {
            f0 f03 = f02.a();
            this.discard((TSEdgeLabel)f02.b());
            f02 = f03;
        }
    }

    public int numberOfLabels() {
        int n = 0;
        if (this.labelSet != null) {
            n = this.labelSet.size();
        }
        return n;
    }

    public void insert(TSEdgeLabel tSEdgeLabel) {
        TSSystem.tsAssert(tSEdgeLabel != null);
        TSSystem.tsAssert(!tSEdgeLabel.isOwned());
        this.labelSet.add(tSEdgeLabel);
        TSGraphObject tSGraphObject = this.getOwner();
        if (this.isOwned() && (this.isConnected() || this.isIntergraphEdge())) {
            ++((TSDGraph)tSGraphObject).edgeLabelCount;
        }
        tSEdgeLabel.onInsert(this);
        tSEdgeLabel.ltShiftBounds();
        if (this.isOwned() && ((TSDGraph)tSGraphObject).isGeometryChangeNotified()) {
            this.notifyGraphOnInsert(tSEdgeLabel.getLocalBounds());
        }
    }

    public List labels() {
        return this.labelSet;
    }

    public void remove(TSLabel tSLabel) {
        TSSystem.tsAssert(tSLabel != null);
        TSSystem.tsAssert(tSLabel.isOwned());
        TSSystem.tsAssert(tSLabel.getOwner() == this);
        TSConstRect tSConstRect = tSLabel.getLocalBounds();
        this.labelSet.remove(tSLabel);
        tSLabel.onRemove(this);
        TSGraphObject tSGraphObject = this.getOwner();
        if (this.isOwned()) {
            --((TSDGraph)tSGraphObject).edgeLabelCount;
        }
        if (this.isOwned() && ((TSDGraph)tSGraphObject).isGeometryChangeNotified()) {
            this.notifyGraphOnRemove(tSConstRect);
        }
    }

    protected void moveToDefaultPosition(TSEdgeLabel tSEdgeLabel) {
        TSPEdge tSPEdge = this.getSourceEdge();
        double d = tSPEdge.length();
        for (double d2 = this.length() * tSEdgeLabel.getDistanceFromSource(); tSPEdge != this.getTargetEdge() && !(d >= d2); d2 -= d) {
            tSPEdge = ((TSPNode)tSPEdge.getTargetNode()).getOutEdge();
            d = tSPEdge.length();
        }
        double d3 = tSEdgeLabel.getLocalWidth() / 2.0;
        TSConstPoint tSConstPoint = tSPEdge.getLocalSourcePoint();
        TSConstPoint tSConstPoint2 = tSPEdge.getLocalTargetPoint();
        double d4 = tSConstPoint.getX() > tSConstPoint2.getX() ? (tSConstPoint.getY() >= tSConstPoint2.getY() ? -tSEdgeLabel.getLocalHeight() / 2.0 : tSEdgeLabel.getLocalHeight() / 2.0) : (tSConstPoint.getY() <= tSConstPoint2.getY() ? -tSEdgeLabel.getLocalHeight() / 2.0 : tSEdgeLabel.getLocalHeight() / 2.0);
        tSEdgeLabel.setLocalOffset(d3, d4);
    }

    public List getLabelsTouchingBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalLabelsTouchingBounds(tSRect, list);
    }

    public List getLocalLabelsTouchingBounds(TSConstRect tSConstRect, List vector) {
        if (vector == null) {
            vector = new Vector<TSEdgeLabel>();
        }
        for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            TSEdgeLabel tSEdgeLabel = (TSEdgeLabel)f02.b();
            if (!tSEdgeLabel.isVisible() || !tSEdgeLabel.locallyIntersects(tSConstRect)) continue;
            vector.add(0, tSEdgeLabel);
        }
        return vector;
    }

    public List getPathEdgesTouchingBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalPathEdgesTouchingBounds(tSRect, list);
    }

    public List getLocalPathEdgesTouchingBounds(TSConstRect tSConstRect, List vector) {
        if (vector == null) {
            vector = new Vector<TSPEdge>();
        }
        cy cy2 = new cy(this);
        while (cy2.hasNext()) {
            TSPEdge tSPEdge = (TSPEdge)cy2.next();
            if (!tSPEdge.isVisible() || !tSPEdge.locallyIntersects(tSConstRect)) continue;
            vector.add(0, tSPEdge);
        }
        return vector;
    }

    public List getPathNodesTouchingBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalPathNodesTouchingBounds(tSRect, list);
    }

    public List getLocalPathNodesTouchingBounds(TSConstRect tSConstRect, List vector) {
        if (vector == null) {
            vector = new Vector<TSPNode>();
        }
        if (this.getSourceEdge() != null) {
            TSPEdge tSPEdge = this.getSourceEdge();
            while (tSPEdge != this.getTargetEdge()) {
                TSPNode tSPNode = (TSPNode)tSPEdge.getTargetNode();
                if (tSPNode.isVisible() && tSPNode.locallyIntersects(tSConstRect)) {
                    vector.add(0, tSPNode);
                }
                tSPEdge = tSPNode.getOutEdge();
            }
        }
        return vector;
    }

    public TSEdgeLabel getFirstLabelTouchingBounds(TSConstRect tSConstRect, Object object) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalFirstLabelTouchingBounds(tSRect, object);
    }

    public TSEdgeLabel getLocalFirstLabelTouchingBounds(TSConstRect tSConstRect, Object object) {
        boolean bl = object == null;
        for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            TSEdgeLabel tSEdgeLabel = (TSEdgeLabel)f02.b();
            if (!tSEdgeLabel.isVisible() || !tSEdgeLabel.locallyIntersects(tSConstRect)) continue;
            if (bl) {
                return tSEdgeLabel;
            }
            bl = tSEdgeLabel.equals(object);
        }
        return null;
    }

    public TSEdgeLabel getLastLabelTouchingBounds(TSConstRect tSConstRect, Object object) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalLastLabelTouchingBounds(tSRect, object);
    }

    public TSEdgeLabel getLocalLastLabelTouchingBounds(TSConstRect tSConstRect, Object object) {
        boolean bl = object == null;
        for (f0 f02 = this.labelSet.b(); f02 != null; f02 = f02.d()) {
            TSEdgeLabel tSEdgeLabel = (TSEdgeLabel)f02.b();
            if (!tSEdgeLabel.isVisible() || !tSEdgeLabel.locallyIntersects(tSConstRect)) continue;
            if (bl) {
                return tSEdgeLabel;
            }
            bl = tSEdgeLabel.equals(object);
        }
        return null;
    }

    public TSPEdge getFirstPathEdgeTouchingBounds(TSConstRect tSConstRect, Object object) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalFirstPathEdgeTouchingBounds(tSRect, object);
    }

    public TSPEdge getLocalFirstPathEdgeTouchingBounds(TSConstRect tSConstRect, Object object) {
        boolean bl = object == null;
        TSPEdge tSPEdge = this.getSourceEdge();
        while (tSPEdge != null) {
            if (tSPEdge.isVisible() && tSPEdge.locallyIntersects(tSConstRect)) {
                if (bl) {
                    return tSPEdge;
                }
                bl = tSPEdge.equals(object);
            }
            if (tSPEdge != this.getTargetEdge()) {
                tSPEdge = ((TSPNode)tSPEdge.getTargetNode()).getOutEdge();
                continue;
            }
            tSPEdge = null;
        }
        return null;
    }

    public TSPEdge getLastPathEdgeTouchingBounds(TSConstRect tSConstRect, Object object) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalLastPathEdgeTouchingBounds(tSRect, object);
    }

    public TSPEdge getLocalLastPathEdgeTouchingBounds(TSConstRect tSConstRect, Object object) {
        boolean bl = object == null;
        TSPEdge tSPEdge = this.getTargetEdge();
        while (tSPEdge != null) {
            if (tSPEdge.isVisible() && tSPEdge.locallyIntersects(tSConstRect)) {
                if (bl) {
                    return tSPEdge;
                }
                bl = tSPEdge.equals(object);
            }
            if (tSPEdge != this.getSourceEdge()) {
                tSPEdge = ((TSPNode)tSPEdge.getSourceNode()).getInEdge();
                continue;
            }
            tSPEdge = null;
        }
        return null;
    }

    public TSPNode getFirstPathNodeTouchingBounds(TSConstRect tSConstRect, Object object) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalFirstPathNodeTouchingBounds(tSRect, object);
    }

    public TSPNode getLocalFirstPathNodeTouchingBounds(TSConstRect tSConstRect, Object object) {
        boolean bl = object == null;
        TSPEdge tSPEdge = this.getSourceEdge();
        while (tSPEdge != null && tSPEdge != this.getTargetEdge()) {
            TSPNode tSPNode = (TSPNode)tSPEdge.getTargetNode();
            if (tSPNode.isVisible() && tSPNode.locallyIntersects(tSConstRect)) {
                if (bl) {
                    return tSPNode;
                }
                bl = tSPNode.equals(object);
            }
            tSPEdge = tSPNode.getOutEdge();
        }
        return null;
    }

    public TSPNode getLastPathNodeTouchingBounds(TSConstRect tSConstRect, Object object) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalLastPathNodeTouchingBounds(tSRect, object);
    }

    public TSPNode getLocalLastPathNodeTouchingBounds(TSConstRect tSConstRect, Object object) {
        boolean bl = object == null;
        TSPEdge tSPEdge = this.getTargetEdge();
        while (tSPEdge != null && tSPEdge != this.getSourceEdge()) {
            TSPNode tSPNode = (TSPNode)tSPEdge.getSourceNode();
            if (tSPNode.isVisible() && tSPNode.locallyIntersects(tSConstRect)) {
                if (bl) {
                    return tSPNode;
                }
                bl = tSPNode.equals(object);
            }
            tSPEdge = tSPNode.getInEdge();
        }
        return null;
    }

    public List getLabelsInsideBounds(TSConstRect tSConstRect, List vector) {
        if (this.isIntergraphEdge()) {
            if (vector == null) {
                vector = new Vector<TSEdgeLabel>();
            }
            for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
                TSEdgeLabel tSEdgeLabel = (TSEdgeLabel)f02.b();
                if (!tSEdgeLabel.isVisible() || !tSEdgeLabel.inside(tSConstRect)) continue;
                vector.add(0, tSEdgeLabel);
            }
            return vector;
        }
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalLabelsInsideBounds(tSRect, vector);
    }

    public List getLocalLabelsInsideBounds(TSConstRect tSConstRect, List vector) {
        if (vector == null) {
            vector = new Vector<TSEdgeLabel>();
        }
        for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            TSEdgeLabel tSEdgeLabel = (TSEdgeLabel)f02.b();
            if (!tSEdgeLabel.isVisible() || !tSEdgeLabel.locallyInside(tSConstRect)) continue;
            vector.add(0, tSEdgeLabel);
        }
        return vector;
    }

    public List getPathEdgesInsideBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalPathEdgesInsideBounds(tSRect, list);
    }

    public List getLocalPathEdgesInsideBounds(TSConstRect tSConstRect, List vector) {
        if (vector == null) {
            vector = new Vector<TSPEdge>();
        }
        cy cy2 = new cy(this);
        while (cy2.hasNext()) {
            TSPEdge tSPEdge = (TSPEdge)cy2.next();
            if (!tSPEdge.isVisible() || !tSPEdge.locallyInside(tSConstRect)) continue;
            vector.add(0, tSPEdge);
        }
        return vector;
    }

    public List getPathNodesInsideBounds(TSConstRect tSConstRect, List list) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.getLocalPathNodesInsideBounds(tSRect, list);
    }

    public List getLocalPathNodesInsideBounds(TSConstRect tSConstRect, List vector) {
        if (vector == null) {
            vector = new Vector<TSPNode>();
        }
        if (this.getSourceEdge() != null) {
            TSPEdge tSPEdge = this.getSourceEdge();
            while (tSPEdge != this.getTargetEdge()) {
                TSPNode tSPNode = (TSPNode)tSPEdge.getTargetNode();
                if (tSPNode.isVisible() && tSPNode.locallyInside(tSConstRect)) {
                    vector.add(0, tSPNode);
                }
                tSPEdge = tSPNode.getOutEdge();
            }
        }
        return vector;
    }

    public TSExpTransform getLocalToMainDisplayGraphTransform() {
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        return tSDGraph.getLocalToMainDisplayGraphTransform();
    }

    public boolean isOverPathEdge(TSConstRect tSConstRect) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.isLocallyOverPathEdge(tSRect);
    }

    public boolean isLocallyOverPathEdge(TSConstRect tSConstRect) {
        TSPEdge tSPEdge = this.getSourceEdge();
        while (tSPEdge != this.getTargetEdge()) {
            if (tSPEdge.isVisible() && tSPEdge.locallyIntersects(tSConstRect)) {
                return true;
            }
            tSPEdge = ((TSPNode)tSPEdge.getTargetNode()).getOutEdge();
        }
        return false;
    }

    public boolean isOverLabel(TSConstPoint tSConstPoint) {
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformPoint(tSPoint);
        }
        return this.isLocallyOverLabel(tSPoint);
    }

    public boolean isLocallyOverLabel(TSConstPoint tSConstPoint) {
        for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            TSEdgeLabel tSEdgeLabel = (TSEdgeLabel)f02.b();
            if (!tSEdgeLabel.isVisible() || !tSEdgeLabel.locallyContains(tSConstPoint)) continue;
            return true;
        }
        return false;
    }

    public boolean isOverPathNode(TSConstPoint tSConstPoint) {
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformPoint(tSPoint);
        }
        return this.isLocallyOverPathNode(tSPoint);
    }

    public boolean isLocallyOverPathNode(TSConstPoint tSConstPoint) {
        if (this.numberOfPathEdges() > 1) {
            TSPEdge tSPEdge = this.getSourceEdge();
            while (tSPEdge != this.getTargetEdge()) {
                TSPNode tSPNode = (TSPNode)tSPEdge.getTargetNode();
                if (tSPNode.isVisible() && tSPNode.locallyContains(tSConstPoint)) {
                    return true;
                }
                tSPEdge = tSPNode.getOutEdge();
            }
        }
        return false;
    }

    public TSConnector getSourceConnector() {
        return this.sourceConnector;
    }

    public TSPEdge getSourceEdge() {
        return this.sourceEdge;
    }

    public TSConnector getTargetConnector() {
        return this.targetConnector;
    }

    public TSPEdge getTargetEdge() {
        return this.targetEdge;
    }

    public void recomputeClippingPoints() {
        if (!this.sourceClipping.c()) {
            this.sourceClipping.b(false);
        }
        if (!this.targetClipping.c()) {
            this.targetClipping.b(false);
        }
        this.sourceCashPoint = null;
        this.targetCashPoint = null;
    }

    public ct getSourceClipping() {
        return this.sourceClipping;
    }

    public void setSourceClipping(TSConstPoint tSConstPoint, boolean bl) {
        if (this.getSourceNode() != null) {
            TSPoint tSPoint = new TSPoint(tSConstPoint);
            TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
            if (tSDGraph != null) {
                tSDGraph.inverseExpandedTransformPoint(tSPoint);
            }
            this.setLocalSourceClipping(tSPoint, bl);
        }
    }

    public void setLocalSourceClipping(TSConstPoint tSConstPoint, boolean bl) {
        TSDNode tSDNode = (TSDNode)this.getSourceNode();
        TSConnector tSConnector = this.getSourceConnector();
        TSConstRect tSConstRect = null;
        tSConstRect = tSConnector != null ? tSConnector.getLocalBounds() : tSDNode.getLocalBounds();
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        if (this.isIntergraphEdge()) {
            TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
            TSDGraph tSDGraph2 = (TSDGraph)tSDNode.getOwnerGraph();
            if (tSDGraph != null && tSDGraph2 != null) {
                tSDGraph2.inverseExpandedTransformPoint(tSDGraph, tSPoint);
            }
        }
        this.sourceClipping.a(tSPoint, tSConstRect);
        this.sourceClipping.a(bl);
        this.sourceClipping.b(true);
        this.sourceCashPoint = null;
    }

    public void setSourceClipping(double d, double d2, boolean bl) {
        this.sourceClipping.a(d, d2);
        this.sourceClipping.a(bl);
        this.sourceClipping.b(true);
        this.sourceCashPoint = null;
    }

    public void setSourceClipping(ct ct2) {
        this.sourceClipping.copy(ct2);
        this.sourceCashPoint = null;
    }

    public void discardCalculatedSourceClipping() {
        if (this.sourceClipping.c()) {
            this.sourceClipping.a(false);
            this.sourceClipping.b(false);
        }
        this.sourceCashPoint = null;
    }

    public void adjustClipping(boolean bl) {
        if (bl && this.getSourceClipping().c()) {
            TSConstPoint tSConstPoint;
            TSDNode tSDNode = (TSDNode)this.getSourceNode();
            TSConnector tSConnector = this.getSourceConnector();
            TSPoint tSPoint = new TSPoint(this.getSourcePoint());
            TSConstRect tSConstRect = null;
            TSShape tSShape = null;
            if (tSConnector != null) {
                tSShape = tSConnector.getShape();
                tSConstRect = tSConnector.getBounds();
            } else {
                tSShape = tSDNode.getShape();
                tSConstRect = tSDNode.getBounds();
            }
            TSGNode tSGNode = (TSGNode)this.getSourceEdge().getTargetNode();
            TSPoint tSPoint2 = null;
            tSPoint2 = tSGNode.isPathNode() ? new TSPoint(tSGNode.getCenter()) : new TSPoint(this.getTargetPoint());
            if (Math.abs(tSPoint.getY() - tSPoint2.getY()) < 0.01) {
                if (tSPoint.getX() > tSPoint2.getX()) {
                    tSPoint.setX(tSConstRect.getRight());
                } else {
                    tSPoint.setX(tSConstRect.getLeft());
                }
            } else if (Math.abs(tSPoint.getX() - tSPoint2.getX()) < 0.01) {
                if (tSPoint.getY() > tSPoint2.getY()) {
                    tSPoint.setY(tSConstRect.getTop());
                } else {
                    tSPoint.setY(tSConstRect.getBottom());
                }
            }
            TSDGraph tSDGraph = (TSDGraph)tSDNode.getOwner();
            if (tSDGraph != null) {
                tSDGraph.inverseExpandedTransformPoint(tSPoint);
                tSDGraph.inverseExpandedTransformPoint(tSPoint2);
            }
            if ((tSConstPoint = tSShape.intersection(tSPoint.getX(), tSPoint.getY(), tSPoint2.getX(), tSPoint2.getY())) != null) {
                double d;
                double d2;
                if (tSConnector != null) {
                    d2 = (tSConstPoint.getX() - tSConnector.getLocalCenterX()) / tSConnector.getLocalWidth();
                    d = (tSConstPoint.getY() - tSConnector.getLocalCenterY()) / tSConnector.getLocalHeight();
                } else {
                    d2 = (tSConstPoint.getX() - tSDNode.getLocalCenterX()) / tSDNode.getLocalWidth();
                    d = (tSConstPoint.getY() - tSDNode.getLocalCenterY()) / tSDNode.getLocalHeight();
                }
                this.setSourceClipping(d2, d, true);
            } else {
                this.discardCalculatedSourceClipping();
            }
        } else if (!bl && this.getTargetClipping().c()) {
            TSConstPoint tSConstPoint;
            TSDNode tSDNode = (TSDNode)this.getTargetNode();
            TSConnector tSConnector = this.getTargetConnector();
            TSPoint tSPoint = new TSPoint(this.getTargetPoint());
            TSConstRect tSConstRect = null;
            TSShape tSShape = null;
            if (tSConnector != null) {
                tSShape = tSConnector.getShape();
                tSConstRect = tSConnector.getBounds();
            } else {
                tSShape = tSDNode.getShape();
                tSConstRect = tSDNode.getBounds();
            }
            TSGNode tSGNode = (TSGNode)this.getTargetEdge().getSourceNode();
            TSPoint tSPoint3 = null;
            tSPoint3 = tSGNode.isPathNode() ? new TSPoint(tSGNode.getCenter()) : new TSPoint(this.getSourcePoint());
            if (Math.abs(tSPoint.getY() - tSPoint3.getY()) < 0.01) {
                if (tSPoint.getX() > tSPoint3.getX()) {
                    tSPoint.setX(tSConstRect.getRight());
                } else {
                    tSPoint.setX(tSConstRect.getLeft());
                }
            } else if (Math.abs(tSPoint.getX() - tSPoint3.getX()) < 0.01) {
                if (tSPoint.getY() > tSPoint3.getY()) {
                    tSPoint.setY(tSConstRect.getTop());
                } else {
                    tSPoint.setY(tSConstRect.getBottom());
                }
            }
            TSDGraph tSDGraph = (TSDGraph)tSDNode.getOwner();
            if (tSDGraph != null) {
                tSDGraph.inverseExpandedTransformPoint(tSPoint);
                tSDGraph.inverseExpandedTransformPoint(tSPoint3);
            }
            if ((tSConstPoint = tSShape.intersection(tSPoint.getX(), tSPoint.getY(), tSPoint3.getX(), tSPoint3.getY())) != null) {
                double d;
                double d3;
                if (tSConnector != null) {
                    d3 = (tSConstPoint.getX() - tSConnector.getLocalCenterX()) / tSConnector.getLocalWidth();
                    d = (tSConstPoint.getY() - tSConnector.getLocalCenterY()) / tSConnector.getLocalHeight();
                } else {
                    d3 = (tSConstPoint.getX() - tSDNode.getLocalCenterX()) / tSDNode.getLocalWidth();
                    d = (tSConstPoint.getY() - tSDNode.getLocalCenterY()) / tSDNode.getLocalHeight();
                }
                this.setTargetClipping(d3, d, true);
            } else {
                this.discardCalculatedTargetClipping();
            }
        }
    }

    public ct getTargetClipping() {
        return this.targetClipping;
    }

    public void setTargetClipping(TSConstPoint tSConstPoint, boolean bl) {
        if (this.getTargetNode() != null) {
            TSPoint tSPoint = new TSPoint(tSConstPoint);
            TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
            if (tSDGraph != null) {
                tSDGraph.inverseExpandedTransformPoint(tSPoint);
            }
            this.setLocalTargetClipping(tSPoint, bl);
        }
    }

    public void setLocalTargetClipping(TSConstPoint tSConstPoint, boolean bl) {
        TSDNode tSDNode = (TSDNode)this.getTargetNode();
        TSConnector tSConnector = this.getTargetConnector();
        TSConstRect tSConstRect = null;
        tSConstRect = tSConnector != null ? tSConnector.getLocalBounds() : tSDNode.getLocalBounds();
        TSPoint tSPoint = new TSPoint(tSConstPoint);
        if (this.isIntergraphEdge()) {
            TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
            TSDGraph tSDGraph2 = (TSDGraph)tSDNode.getOwnerGraph();
            if (tSDGraph != null && tSDGraph2 != null) {
                tSDGraph2.inverseExpandedTransformPoint(tSDGraph, tSPoint);
            }
        }
        this.targetClipping.a(tSPoint, tSConstRect);
        this.targetClipping.a(bl);
        this.targetClipping.b(true);
        this.targetCashPoint = null;
    }

    public void setTargetClipping(double d, double d2, boolean bl) {
        this.targetClipping.a(d, d2);
        this.targetClipping.a(bl);
        this.targetClipping.b(true);
        this.targetCashPoint = null;
    }

    public void setTargetClipping(ct ct2) {
        this.targetClipping.copy(ct2);
        this.targetCashPoint = null;
    }

    public void discardCalculatedTargetClipping() {
        if (this.targetClipping.c()) {
            this.targetClipping.a(false);
            this.targetClipping.b(false);
        }
        this.targetCashPoint = null;
    }

    public void discardCalculatedClippings() {
        this.discardCalculatedSourceClipping();
        this.discardCalculatedTargetClipping();
    }

    public TSConstPoint getLocalSourcePoint() {
        if (!this.sourceClipping.d()) {
            this.updateSourceClippingPoint();
        }
        if (this.sourceCashPoint == null) {
            TSDNode tSDNode = (TSDNode)this.getSourceNode();
            TSConnector tSConnector = this.getSourceConnector();
            TSPoint tSPoint = new TSPoint(0.0, 0.0);
            if (tSDNode != null) {
                TSConstRect tSConstRect = null;
                tSConstRect = tSConnector != null ? tSConnector.getLocalBounds() : tSDNode.getLocalBounds();
                this.sourceClipping.a(tSConstRect, tSPoint);
                if (this.isIntergraphEdge()) {
                    TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
                    TSDGraph tSDGraph2 = (TSDGraph)tSDNode.getOwnerGraph();
                    tSDGraph2.expandedTransformPoint(tSDGraph, tSPoint);
                }
            }
            this.sourceCashPoint = tSPoint;
        }
        return this.sourceCashPoint;
    }

    private void updateSourceClippingPoint() {
        TSGraphObject tSGraphObject;
        Object object;
        TSPEdge tSPEdge = this.getSourceEdge();
        if (this.sourceClipping.d() || this.getSourceNode() == null || this.getTargetNode() == null) {
            return;
        }
        this.sourceCashPoint = null;
        TSDNode tSDNode = (TSDNode)this.getSourceNode();
        TSConnector tSConnector = this.getSourceConnector();
        TSPoint tSPoint = new TSPoint(this.getLocalSourceCenter());
        if (tSDNode.isOwned() && (tSConnector == null || tSConnector.isOwned())) {
            object = null;
            object = tSConnector != null ? tSConnector.getShape() : tSDNode.getShape();
            tSGraphObject = (TSGNode)tSPEdge.getTargetNode();
            TSPoint tSPoint2 = null;
            tSPoint2 = ((TSNode)tSGraphObject).isPathNode() ? new TSPoint(((TSGNode)tSGraphObject).getLocalCenterX(), ((TSGNode)tSGraphObject).getLocalCenterY()) : new TSPoint(this.getLocalTargetCenter());
            if (this.isIntergraphEdge() && this.isReachable()) {
                TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
                if (tSDGraph == null) {
                    return;
                }
                TSDGraph tSDGraph2 = (TSDGraph)((TSGNode)tSGraphObject).getTransformGraph();
                TSDGraph tSDGraph3 = (TSDGraph)tSDNode.getTransformGraph();
                tSDGraph2.expandedTransformPoint(tSDGraph, tSPoint2);
                tSDGraph3.inverseExpandedTransformPoint(tSDGraph, tSPoint2);
                TSConstPoint tSConstPoint = object.intersection(tSPoint.getX(), tSPoint.getY(), tSPoint2.getX(), tSPoint2.getY());
                if (tSConstPoint != null) {
                    tSPoint.setLocation(tSConstPoint.getX(), tSConstPoint.getY());
                }
                tSDGraph3.expandedTransformPoint(tSDGraph, tSPoint);
                this.setLocalSourceClipping(tSPoint, false);
                return;
            }
            TSConstPoint tSConstPoint = object.intersection(tSPoint.getX(), tSPoint.getY(), tSPoint2.getX(), tSPoint2.getY());
            if (tSConstPoint != null) {
                tSPoint.setLocation(tSConstPoint.getX(), tSConstPoint.getY());
            }
        }
        if (this.isIntergraphEdge()) {
            object = (TSDGraph)this.getTransformGraph();
            tSGraphObject = (TSDGraph)tSDNode.getOwnerGraph();
            ((TSDGraph)tSGraphObject).expandedTransformPoint((TSDGraph)object, tSPoint);
        }
        this.setLocalSourceClipping(tSPoint, false);
    }

    public TSConstPoint getLocalTargetPoint() {
        if (!this.targetClipping.d()) {
            this.updateTargetClippingPoint();
        }
        if (this.targetCashPoint == null) {
            TSDNode tSDNode = (TSDNode)this.getTargetNode();
            TSConnector tSConnector = this.getTargetConnector();
            TSPoint tSPoint = new TSPoint(0.0, 0.0);
            if (tSDNode != null) {
                TSConstRect tSConstRect = null;
                tSConstRect = tSConnector != null ? tSConnector.getLocalBounds() : tSDNode.getLocalBounds();
                this.targetClipping.a(tSConstRect, tSPoint);
                if (this.isIntergraphEdge()) {
                    TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
                    TSDGraph tSDGraph2 = (TSDGraph)tSDNode.getOwnerGraph();
                    tSDGraph2.expandedTransformPoint(tSDGraph, tSPoint);
                }
            }
            this.targetCashPoint = tSPoint;
        }
        return this.targetCashPoint;
    }

    private void updateTargetClippingPoint() {
        TSGraphObject tSGraphObject;
        Object object;
        TSPEdge tSPEdge = this.getTargetEdge();
        if (this.targetClipping.d() || this.getSourceNode() == null || this.getTargetNode() == null) {
            return;
        }
        this.targetCashPoint = null;
        TSDNode tSDNode = (TSDNode)this.getTargetNode();
        TSConnector tSConnector = this.getTargetConnector();
        TSPoint tSPoint = new TSPoint(this.getLocalTargetCenter());
        if (tSDNode.isOwned() && (tSConnector == null || tSConnector.isOwned())) {
            object = null;
            object = tSConnector != null ? tSConnector.getShape() : tSDNode.getShape();
            tSGraphObject = (TSGNode)tSPEdge.getSourceNode();
            TSPoint tSPoint2 = null;
            tSPoint2 = ((TSNode)tSGraphObject).isPathNode() ? new TSPoint(((TSGNode)tSGraphObject).getLocalCenterX(), ((TSGNode)tSGraphObject).getLocalCenterY()) : new TSPoint(this.getLocalSourceCenter());
            if (this.isIntergraphEdge()) {
                TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
                if (tSDGraph == null) {
                    return;
                }
                TSDGraph tSDGraph2 = (TSDGraph)tSDNode.getTransformGraph();
                TSDGraph tSDGraph3 = (TSDGraph)((TSGNode)tSGraphObject).getTransformGraph();
                tSDGraph3.expandedTransformPoint(tSDGraph, tSPoint2);
                tSDGraph2.inverseExpandedTransformPoint(tSDGraph, tSPoint2);
                TSConstPoint tSConstPoint = object.intersection(tSPoint.getX(), tSPoint.getY(), tSPoint2.getX(), tSPoint2.getY());
                if (tSConstPoint != null) {
                    tSPoint.setLocation(tSConstPoint.getX(), tSConstPoint.getY());
                }
                tSDGraph2.expandedTransformPoint(tSDGraph, tSPoint);
                this.setLocalTargetClipping(tSPoint, false);
                return;
            }
            TSConstPoint tSConstPoint = object.intersection(tSPoint.getX(), tSPoint.getY(), tSPoint2.getX(), tSPoint2.getY());
            if (tSConstPoint != null) {
                tSPoint.setLocation(tSConstPoint.getX(), tSConstPoint.getY());
            }
        }
        if (this.isIntergraphEdge()) {
            object = (TSDGraph)this.getTransformGraph();
            tSGraphObject = (TSDGraph)tSDNode.getOwnerGraph();
            ((TSDGraph)tSGraphObject).expandedTransformPoint((TSDGraph)object, tSPoint);
        }
        this.setLocalTargetClipping(tSPoint, false);
    }

    public double length() {
        TSPEdge tSPEdge = this.getSourceEdge();
        TSGNode tSGNode = (TSGNode)tSPEdge.getTargetNode();
        TSNode tSNode = this.getTargetNode();
        double d = tSPEdge.length();
        while (tSGNode != tSNode) {
            if (tSGNode.isPathNode()) {
                tSPEdge = ((TSPNode)tSGNode).getOutEdge();
                tSGNode = (TSGNode)tSPEdge.getTargetNode();
                d += tSPEdge.length();
                continue;
            }
            TSSystem.tsAssert(tSGNode.isPathNode(), "Invalid target bend");
            break;
        }
        return d;
    }

    public double lengthSquared() {
        double d = this.length();
        return Math.pow(d, 2.0);
    }

    public double getBottom() {
        double d = this.getLocalBottom();
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformY(d);
        }
        return d;
    }

    public double getLocalBottom() {
        return this.getLocalBottom(1);
    }

    public double getLeft() {
        double d = this.getLocalLeft();
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformX(d);
        }
        return d;
    }

    public double getLocalLeft() {
        return this.getLocalLeft(1);
    }

    public double getRight() {
        double d = this.getLocalRight();
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformX(d);
        }
        return d;
    }

    public double getLocalRight() {
        return this.getLocalRight(1);
    }

    public double getTop() {
        double d = this.getLocalTop();
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformY(d);
        }
        return d;
    }

    public double getLocalTop() {
        return this.getLocalTop(1);
    }

    public double getBottom(int n) {
        double d = this.getLocalBottom(n);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformY(d);
        }
        return d;
    }

    public double getLocalBottom(int n) {
        double d;
        Cloneable cloneable;
        double d2 = this.getLocalSourceY();
        double d3 = this.getLocalTargetY();
        double d4 = Math.min(d2, d3);
        TSPEdge tSPEdge = this.sourceEdge;
        if ((n & 1) != 0) {
            while (tSPEdge != this.targetEdge) {
                cloneable = (TSPNode)tSPEdge.getTargetNode();
                d = ((TSGNode)cloneable).getLocalBottom();
                if (d < d4) {
                    d4 = d;
                }
                tSPEdge = ((TSPNode)cloneable).getOutEdge();
            }
        }
        if ((n & 2) != 0) {
            for (cloneable = this.labelSet.a(); cloneable != null; cloneable = ((f0)cloneable).a()) {
                d = ((TSEdgeLabel)((f0)cloneable).b()).getLocalBottom();
                if (!(d < d4)) continue;
                d4 = d;
            }
        }
        return d4;
    }

    public double getLeft(int n) {
        double d = this.getLocalLeft(n);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformX(d);
        }
        return d;
    }

    public double getLocalLeft(int n) {
        double d;
        Cloneable cloneable;
        double d2 = this.getLocalSourceX();
        double d3 = this.getLocalTargetX();
        double d4 = Math.min(d2, d3);
        TSPEdge tSPEdge = this.sourceEdge;
        if ((n & 1) != 0) {
            while (tSPEdge != this.targetEdge) {
                cloneable = (TSPNode)tSPEdge.getTargetNode();
                d = ((TSGNode)cloneable).getLocalLeft();
                if (d < d4) {
                    d4 = d;
                }
                tSPEdge = ((TSPNode)cloneable).getOutEdge();
            }
        }
        if ((n & 2) != 0) {
            for (cloneable = this.labelSet.a(); cloneable != null; cloneable = ((f0)cloneable).a()) {
                d = ((TSEdgeLabel)((f0)cloneable).b()).getLocalLeft();
                if (!(d < d4)) continue;
                d4 = d;
            }
        }
        return d4;
    }

    public double getRight(int n) {
        double d = this.getLocalRight(n);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformX(d);
        }
        return d;
    }

    public double getLocalRight(int n) {
        double d;
        Cloneable cloneable;
        double d2 = this.getLocalSourceX();
        double d3 = this.getLocalTargetX();
        double d4 = Math.max(d2, d3);
        TSPEdge tSPEdge = this.sourceEdge;
        if ((n & 1) != 0) {
            while (tSPEdge != this.targetEdge) {
                cloneable = (TSPNode)tSPEdge.getTargetNode();
                d = ((TSGNode)cloneable).getLocalRight();
                if (d > d4) {
                    d4 = d;
                }
                tSPEdge = ((TSPNode)cloneable).getOutEdge();
            }
        }
        if ((n & 2) != 0) {
            for (cloneable = this.labelSet.a(); cloneable != null; cloneable = ((f0)cloneable).a()) {
                d = ((TSEdgeLabel)((f0)cloneable).b()).getLocalRight();
                if (!(d > d4)) continue;
                d4 = d;
            }
        }
        return d4;
    }

    public double getTop(int n) {
        double d = this.getLocalTop(n);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null && !tSDGraph.isMainDisplayGraph()) {
            d = tSDGraph.expandedTransformY(d);
        }
        return d;
    }

    public double getLocalTop(int n) {
        double d;
        Cloneable cloneable;
        double d2 = this.getLocalSourceY();
        double d3 = this.getLocalTargetY();
        double d4 = Math.max(d2, d3);
        TSPEdge tSPEdge = this.sourceEdge;
        if ((n & 1) != 0) {
            while (tSPEdge != this.targetEdge) {
                cloneable = (TSPNode)tSPEdge.getTargetNode();
                d = ((TSGNode)cloneable).getLocalTop();
                if (d > d4) {
                    d4 = d;
                }
                tSPEdge = ((TSPNode)cloneable).getOutEdge();
            }
        }
        if ((n & 2) != 0) {
            for (cloneable = this.labelSet.a(); cloneable != null; cloneable = ((f0)cloneable).a()) {
                d = ((TSEdgeLabel)((f0)cloneable).b()).getLocalTop();
                if (!(d > d4)) continue;
                d4 = d;
            }
        }
        return d4;
    }

    public TSConstRect getBounds() {
        TSRect tSRect = new TSRect(this.getLocalBounds());
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.expandedTransformRect(tSRect);
        }
        return tSRect;
    }

    public TSConstRect getLocalBounds() {
        return this.getLocalBounds(1);
    }

    public TSConstRect getBounds(int n) {
        TSRect tSRect = new TSRect(this.getLocalBounds(n));
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.expandedTransformRect(tSRect);
        }
        return tSRect;
    }

    public TSConstRect getLocalBounds(int n) {
        TSRect tSRect = new TSRect(0.0, 0.0, 0.0, 0.0);
        TSDNode tSDNode = (TSDNode)this.getSourceNode();
        TSDNode tSDNode2 = (TSDNode)this.getTargetNode();
        if (tSDNode != null && tSDNode2 != null) {
            TSGraphObject tSGraphObject;
            Cloneable cloneable;
            TSConstPoint tSConstPoint = this.getLocalSourcePoint();
            tSRect.setBounds(tSConstPoint, tSConstPoint);
            tSRect.merge(this.getLocalTargetPoint());
            if ((n & 1) != 0) {
                cloneable = this.sourceEdge;
                while (cloneable != this.targetEdge) {
                    tSGraphObject = (TSPNode)((TSEdge)cloneable).getTargetNode();
                    tSRect.merge(((TSGNode)tSGraphObject).getLocalLeft(), ((TSGNode)tSGraphObject).getLocalBottom(), ((TSGNode)tSGraphObject).getLocalRight(), ((TSGNode)tSGraphObject).getLocalTop());
                    cloneable = ((TSPNode)tSGraphObject).getOutEdge();
                }
            }
            if ((n & 2) != 0) {
                for (cloneable = this.labelSet.a(); cloneable != null; cloneable = ((f0)cloneable).a()) {
                    tSGraphObject = (TSEdgeLabel)((f0)cloneable).b();
                    ((TSLabel)tSGraphObject).mergeLocalBounds(tSRect);
                }
            }
        }
        return tSRect;
    }

    public void mergeLocalBounds(TSRect tSRect, int n) {
        TSDNode tSDNode = (TSDNode)this.getSourceNode();
        TSDNode tSDNode2 = (TSDNode)this.getTargetNode();
        if (tSDNode != null && tSDNode2 != null) {
            TSGraphObject tSGraphObject;
            Cloneable cloneable;
            tSRect.merge(this.getLocalSourcePoint());
            tSRect.merge(this.getLocalTargetPoint());
            if ((n & 1) != 0) {
                cloneable = this.sourceEdge;
                while (cloneable != this.targetEdge) {
                    tSGraphObject = (TSPNode)((TSEdge)cloneable).getTargetNode();
                    tSRect.merge(((TSGNode)tSGraphObject).getLocalLeft(), ((TSGNode)tSGraphObject).getLocalBottom(), ((TSGNode)tSGraphObject).getLocalRight(), ((TSGNode)tSGraphObject).getLocalTop());
                    cloneable = ((TSPNode)tSGraphObject).getOutEdge();
                }
            }
            if ((n & 2) != 0) {
                for (cloneable = this.labelSet.a(); cloneable != null; cloneable = ((f0)cloneable).a()) {
                    tSGraphObject = (TSEdgeLabel)((f0)cloneable).b();
                    ((TSLabel)tSGraphObject).mergeLocalBounds(tSRect);
                }
            }
        }
    }

    public boolean intersects(TSConstRect tSConstRect) {
        return this.intersects(tSConstRect.getLeft(), tSConstRect.getBottom(), tSConstRect.getRight(), tSConstRect.getTop());
    }

    public boolean intersects(double d, double d2, double d3, double d4) {
        TSRect tSRect = new TSRect(d, d2, d3, d4);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.locallyIntersects(tSRect.getLeft(), tSRect.getBottom(), tSRect.getRight(), tSRect.getTop());
    }

    public boolean locallyIntersects(TSConstRect tSConstRect) {
        return this.locallyIntersects(tSConstRect.getLeft(), tSConstRect.getBottom(), tSConstRect.getRight(), tSConstRect.getTop());
    }

    public boolean locallyIntersects(double d, double d2, double d3, double d4) {
        if (this.getSourceEdge() == null) {
            return false;
        }
        TSPEdge tSPEdge = this.getSourceEdge();
        while (tSPEdge != this.getTargetEdge()) {
            if (tSPEdge.locallyIntersects(d, d2, d3, d4)) {
                return true;
            }
            tSPEdge = ((TSPNode)tSPEdge.getTargetNode()).getOutEdge();
        }
        return tSPEdge.locallyIntersects(d, d2, d3, d4);
    }

    public boolean inside(TSConstRect tSConstRect) {
        TSRect tSRect = new TSRect(tSConstRect);
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.inverseExpandedTransformRect(tSRect);
        }
        return this.locallyInside(tSRect);
    }

    public boolean locallyInside(TSConstRect tSConstRect) {
        Iterator iterator = this.pathEdges().iterator();
        while (iterator.hasNext()) {
            TSPEdge tSPEdge = (TSPEdge)iterator.next();
            if (tSConstRect.contains(tSPEdge.getLocalBounds())) continue;
            return false;
        }
        return true;
    }

    void notifyGraphOnResize(TSConstRect tSConstRect) {
        if (this.isOwned()) {
            TSSystem.tsAssert(this.getOwner() != null);
            TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
            if (tSDGraph != null && this.needsToNotifyOwnerGraph()) {
                tSDGraph.updateGraphBoundsOnResize(tSConstRect, this.getLocalBounds(7));
            }
            this.recomputeClippingPoints();
        }
    }

    void notifyGraphOnInsert(TSConstRect tSConstRect) {
        if (this.isOwned()) {
            TSSystem.tsAssert(this.getOwner() != null);
            TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
            if (tSDGraph != null && this.needsToNotifyOwnerGraph()) {
                tSDGraph.updateGraphBoundsOnInsert(tSConstRect);
            }
            this.recomputeClippingPoints();
        }
    }

    void notifyGraphOnRemove(TSConstRect tSConstRect) {
        if (this.isOwned()) {
            TSSystem.tsAssert(this.getOwner() != null);
            TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
            if (tSDGraph != null && this.needsToNotifyOwnerGraph()) {
                tSDGraph.updateGraphBoundsOnRemove(tSConstRect);
            }
        }
        this.recomputeClippingPoints();
    }

    void updateEdgeBoundsOnLabelMove(TSConstRect tSConstRect, TSConstRect tSConstRect2) {
        TSDGraph tSDGraph;
        if (this.isOwned() && (tSDGraph = (TSDGraph)this.getTransformGraph()) != null && this.needsToNotifyOwnerGraph()) {
            tSDGraph.updateGraphBoundsOnMove(tSConstRect, tSConstRect2);
        }
    }

    void updateEdgeBoundsOnLabelResize(TSConstRect tSConstRect, TSConstRect tSConstRect2) {
        TSDGraph tSDGraph;
        if (this.isOwned() && (tSDGraph = (TSDGraph)this.getTransformGraph()) != null && this.needsToNotifyOwnerGraph()) {
            tSDGraph.updateGraphBoundsOnResize(tSConstRect, tSConstRect2);
        }
    }

    void updateEdgeBoundsOnBendMove(TSConstRect tSConstRect, TSConstRect tSConstRect2) {
        TSDGraph tSDGraph;
        if (this.isOwned() && (tSDGraph = (TSDGraph)this.getTransformGraph()) != null && this.needsToNotifyOwnerGraph()) {
            tSDGraph.updateGraphBoundsOnMove(tSConstRect, tSConstRect2);
        }
        this.updateBoundsOfLabels();
        this.recomputeClippingPoints();
    }

    boolean needsToNotifyOwnerGraph() {
        boolean bl;
        boolean bl2 = bl = this.getSourceNode() != null && this.getTargetNode() != null && this.getSourceNode().isOwned() && this.getTargetNode().isOwned();
        if (bl) {
            if (this.isIntergraphEdge()) {
                TSDGraphManager tSDGraphManager = (TSDGraphManager)this.getOwnerGraphManager();
                if (tSDGraphManager != null && tSDGraphManager.getCommonNestedGraphOwner(this) != null) {
                    bl = true;
                }
            } else {
                bl = true;
            }
        }
        return bl;
    }

    void updateBoundsOfLabels() {
        for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            TSEdgeLabel tSEdgeLabel = (TSEdgeLabel)f02.b();
            tSEdgeLabel.updateBounds();
        }
    }

    public void ltUpdateBoundsOfLabels() {
        this.ltUpdateBoundsOfLabels(false);
    }

    public void ltUpdateBoundsOfLabels(boolean bl) {
        for (f0 f02 = this.labelSet.a(); f02 != null; f02 = f02.a()) {
            TSEdgeLabel tSEdgeLabel = (TSEdgeLabel)f02.b();
            TSConstPoint tSConstPoint = tSEdgeLabel.getLocalCenter();
            tSEdgeLabel.ltShiftBounds();
            if (!bl || this.getOwnerGraph() == null) continue;
            this.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(8192L, new TSDrawingChangeEventData(tSEdgeLabel, tSConstPoint, tSEdgeLabel.getLocalCenter())));
        }
    }

    public TSConstPoint getPointOnEdge(double d) {
        TSPoint tSPoint = new TSPoint(this.getLocalPointOnEdge(d));
        ((TSDGraph)this.getTransformGraph()).expandedTransformPoint(tSPoint);
        return tSPoint;
    }

    public TSConstPoint getLocalPointOnEdge(double d) {
        TSConstPoint tSConstPoint;
        block5: {
            block4: {
                tSConstPoint = new TSConstPoint(0.0, 0.0);
                if (!(d <= 0.0) && !(d >= 1.0)) break block4;
                TSDNode tSDNode = d <= 0.0 ? (TSDNode)this.getSourceNode() : (TSDNode)this.getTargetNode();
                tSConstPoint = tSDNode.getLocalCenter();
                if (!this.isIntergraphEdge()) break block5;
                tSConstPoint = new TSPoint(tSConstPoint);
                ((TSDGraph)tSDNode.getOwnerGraph()).expandedTransformPoint((TSDGraph)this.getTransformGraph(), (TSPoint)tSConstPoint);
                break block5;
            }
            if (this.numberOfPathEdges() <= 1) {
                tSConstPoint = new TSConstPoint(this.getSourceEdge().getLocalPointOnEdge(d));
            } else {
                double d2 = 0.0;
                double d3 = this.length();
                Iterator iterator = this.pathEdges().iterator();
                while (iterator.hasNext()) {
                    TSPEdge tSPEdge = (TSPEdge)iterator.next();
                    double d4 = tSPEdge.length() / d3 + d2;
                    if (d4 <= d) {
                        d2 = d4;
                        continue;
                    }
                    double d5 = (d - d2) * d3 / tSPEdge.length();
                    tSConstPoint = new TSConstPoint(tSPEdge.getLocalPointOnEdge(d5));
                    break;
                }
            }
        }
        return tSConstPoint;
    }

    private boolean intersectionImpossible() {
        TSDNode tSDNode = (TSDNode)this.getSourceNode();
        TSDNode tSDNode2 = (TSDNode)this.getTargetNode();
        if (this.isStraight()) {
            if (!this.isIntergraphEdge()) {
                return !tSDNode.getLocalBounds().intersects(tSDNode2.getLocalBounds());
            }
            return !tSDNode.getBounds().intersects(tSDNode2.getBounds());
        }
        return false;
    }

    public TSPEdge getFirstDrawablePEdge() {
        TSPEdge tSPEdge = this.getSourceEdge();
        if (this.intersectionImpossible()) {
            return tSPEdge;
        }
        TSDNode tSDNode = (TSDNode)this.getSourceNode();
        TSDNode tSDNode2 = (TSDNode)this.getTargetNode();
        TSConnector tSConnector = this.getSourceConnector();
        TSConnector tSConnector2 = this.getTargetConnector();
        TSDGraph tSDGraph = (TSDGraph)tSDNode.getOwnerGraph();
        TSDGraph tSDGraph2 = (TSDGraph)tSDNode2.getOwnerGraph();
        TSDGraph tSDGraph3 = (TSDGraph)this.getTransformGraph();
        TSPoint tSPoint = new TSPoint(tSPEdge.getLocalTargetPoint());
        if (this.isIntergraphEdge()) {
            tSDGraph.inverseExpandedTransformPoint(tSDGraph3, tSPoint);
        }
        boolean bl = tSConnector != null ? tSConnector.locallyContains(tSPoint) : tSDNode.locallyContains(tSPoint);
        while (tSPEdge != null && bl) {
            if (tSPEdge.getTargetNode().isPathNode()) {
                tSPEdge = (TSPEdge)tSPEdge.getTargetNode().outEdge();
                tSPoint.setLocation(tSPEdge.getLocalTargetPoint());
                if (this.isIntergraphEdge()) {
                    tSDGraph.inverseExpandedTransformPoint(tSDGraph3, tSPoint);
                }
                if (tSConnector != null) {
                    bl = tSConnector.locallyContains(tSPoint);
                    continue;
                }
                bl = tSDNode.locallyContains(tSPoint);
                continue;
            }
            tSPEdge = null;
        }
        if (tSPEdge == null) {
            return tSPEdge;
        }
        TSPEdge tSPEdge2 = tSPEdge;
        boolean bl2 = true;
        while (bl2 && tSPEdge2 != this.getTargetEdge()) {
            tSPoint.setLocation(tSPEdge2.getLocalTargetPoint());
            if (this.isIntergraphEdge()) {
                tSDGraph2.inverseExpandedTransformPoint(tSDGraph3, tSPoint);
            }
            bl2 = tSConnector2 != null ? tSConnector2.locallyContains(tSPoint) : tSDNode2.locallyContains(tSPoint);
            TSEdge tSEdge = tSPEdge2.getTargetNode().outEdge();
            if (!(tSEdge instanceof TSPEdge)) break;
            tSPEdge2 = (TSPEdge)tSEdge;
        }
        if (!bl2) {
            return tSPEdge;
        }
        boolean bl3 = true;
        TSConstRect tSConstRect = null;
        TSConstRect tSConstRect2 = null;
        TSConstRect tSConstRect3 = null;
        TSConstRect tSConstRect4 = null;
        if (tSConnector != null) {
            tSConstRect = tSConnector.getBounds();
            tSConstRect2 = tSConnector.getLocalBounds();
        } else {
            tSConstRect = tSDNode.getBounds();
            tSConstRect2 = tSDNode.getLocalBounds();
        }
        if (tSConnector2 != null) {
            tSConstRect3 = tSConnector2.getBounds();
            tSConstRect4 = tSConnector2.getLocalBounds();
        } else {
            tSConstRect3 = tSDNode2.getBounds();
            tSConstRect4 = tSDNode2.getLocalBounds();
        }
        bl3 = !this.isIntergraphEdge() ? tSConstRect2.intersects(tSConstRect4) : tSConstRect.intersects(tSConstRect3);
        if (bl3) {
            TSPoint tSPoint2 = new TSPoint(tSPEdge.getLocalSourcePoint());
            tSPoint.setLocation(tSPEdge.getLocalTargetPoint());
            if (this.isIntergraphEdge()) {
                tSDGraph.inverseExpandedTransformPoint(tSDGraph3, tSPoint2);
                tSDGraph.inverseExpandedTransformPoint(tSDGraph3, tSPoint);
            }
            TSShape tSShape = null;
            tSShape = tSConnector != null ? tSConnector.getShape() : tSDNode.getShape();
            TSConstPoint tSConstPoint = tSShape.intersection(tSPoint2.getX(), tSPoint2.getY(), tSPoint.getX(), tSPoint.getY());
            if (tSConstPoint != null) {
                TSPoint tSPoint3 = new TSPoint(tSConstPoint);
                if (this.isIntergraphEdge()) {
                    tSDGraph.expandedTransformPoint(tSDGraph3, tSPoint3);
                    tSDGraph2.inverseExpandedTransformPoint(tSDGraph3, tSPoint3);
                }
                if (tSConnector2 != null ? tSConnector2.locallyContains(tSPoint3) : tSDNode2.locallyContains(tSPoint3)) {
                    return null;
                }
            }
        }
        return tSPEdge;
    }

    public TSPEdge getLastDrawablePEdge() {
        TSPEdge tSPEdge = this.getTargetEdge();
        if (this.intersectionImpossible()) {
            return tSPEdge;
        }
        if (tSPEdge == null) {
            return tSPEdge;
        }
        TSDNode tSDNode = (TSDNode)this.getSourceNode();
        TSDNode tSDNode2 = (TSDNode)this.getTargetNode();
        TSConnector tSConnector = this.getSourceConnector();
        TSConnector tSConnector2 = this.getTargetConnector();
        TSDGraph tSDGraph = (TSDGraph)tSDNode.getOwnerGraph();
        TSDGraph tSDGraph2 = (TSDGraph)tSDNode2.getOwnerGraph();
        TSDGraph tSDGraph3 = (TSDGraph)this.getTransformGraph();
        TSPoint tSPoint = new TSPoint(tSPEdge.getLocalSourcePoint());
        if (this.isIntergraphEdge()) {
            tSDGraph2.inverseExpandedTransformPoint(tSDGraph3, tSPoint);
        }
        boolean bl = tSConnector2 != null ? tSConnector2.locallyContains(tSPoint) : tSDNode2.locallyContains(tSPoint);
        while (tSPEdge != null && bl) {
            if (tSPEdge.getSourceNode().isPathNode()) {
                tSPEdge = (TSPEdge)tSPEdge.getSourceNode().inEdge();
                tSPoint.setLocation(tSPEdge.getLocalSourcePoint());
                if (this.isIntergraphEdge()) {
                    tSDGraph2.inverseExpandedTransformPoint(tSDGraph3, tSPoint);
                }
                if (tSConnector2 != null) {
                    bl = tSConnector2.locallyContains(tSPoint);
                    continue;
                }
                bl = tSDNode2.locallyContains(tSPoint);
                continue;
            }
            tSPEdge = null;
        }
        if (tSPEdge == null) {
            return tSPEdge;
        }
        TSPEdge tSPEdge2 = tSPEdge;
        boolean bl2 = true;
        while (bl2 && tSPEdge2 != this.getSourceEdge()) {
            tSPoint.setLocation(tSPEdge2.getLocalSourcePoint());
            if (this.isIntergraphEdge()) {
                tSDGraph.inverseExpandedTransformPoint(tSDGraph3, tSPoint);
            }
            bl2 = tSConnector != null ? tSConnector.locallyContains(tSPoint) : tSDNode.locallyContains(tSPoint);
            tSPEdge2 = (TSPEdge)tSPEdge2.getSourceNode().inEdge();
        }
        if (!bl2) {
            return tSPEdge;
        }
        boolean bl3 = true;
        TSConstRect tSConstRect = null;
        TSConstRect tSConstRect2 = null;
        TSConstRect tSConstRect3 = null;
        TSConstRect tSConstRect4 = null;
        if (tSConnector != null) {
            tSConstRect = tSConnector.getBounds();
            tSConstRect2 = tSConnector.getLocalBounds();
        } else {
            tSConstRect = tSDNode.getBounds();
            tSConstRect2 = tSDNode.getLocalBounds();
        }
        if (tSConnector2 != null) {
            tSConstRect3 = tSConnector2.getBounds();
            tSConstRect4 = tSConnector2.getLocalBounds();
        } else {
            tSConstRect3 = tSDNode2.getBounds();
            tSConstRect4 = tSDNode2.getLocalBounds();
        }
        bl3 = !this.isIntergraphEdge() ? tSConstRect2.intersects(tSConstRect4) : tSConstRect.intersects(tSConstRect3);
        if (bl3) {
            TSPoint tSPoint2 = new TSPoint(tSPEdge.getLocalTargetPoint());
            tSPoint.setLocation(tSPEdge.getLocalSourcePoint());
            if (this.isIntergraphEdge()) {
                tSDGraph2.inverseExpandedTransformPoint(tSDGraph3, tSPoint2);
                tSDGraph2.inverseExpandedTransformPoint(tSDGraph3, tSPoint);
            }
            TSShape tSShape = null;
            tSShape = tSConnector2 != null ? tSConnector2.getShape() : tSDNode2.getShape();
            TSConstPoint tSConstPoint = tSShape.intersection(tSPoint.getX(), tSPoint.getY(), tSPoint2.getX(), tSPoint2.getY());
            if (tSConstPoint != null) {
                TSPoint tSPoint3 = new TSPoint(tSConstPoint);
                if (this.isIntergraphEdge()) {
                    tSDGraph2.expandedTransformPoint(tSDGraph3, tSPoint3);
                    tSDGraph.inverseExpandedTransformPoint(tSDGraph3, tSPoint3);
                }
                if (tSConnector != null ? tSConnector.locallyContains(tSPoint3) : tSDNode.locallyContains(tSPoint3)) {
                    return null;
                }
            }
        }
        return tSPEdge;
    }

    public TSConstPoint getSourceClippingPoint() {
        TSPoint tSPoint = new TSPoint(this.getLocalSourceClippingPoint());
        ((TSDGraph)this.getTransformGraph()).expandedTransformPoint(tSPoint);
        return tSPoint;
    }

    public TSConstPoint getLocalSourceClippingPoint() {
        TSPEdge tSPEdge = this.getFirstDrawablePEdge();
        if (tSPEdge == null || tSPEdge == this.getSourceEdge() && !this.getSourceClipping().c()) {
            return this.getLocalSourcePoint();
        }
        TSPoint tSPoint = new TSPoint(tSPEdge.getLocalSourcePoint());
        TSPoint tSPoint2 = new TSPoint(tSPEdge.getLocalTargetPoint());
        TSShape tSShape = null;
        tSShape = this.getSourceConnector() != null ? this.getSourceConnector().getShape() : ((TSDNode)this.getSourceNode()).getShape();
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        TSDGraph tSDGraph2 = (TSDGraph)this.getSourceNode().getOwnerGraph();
        if (this.isIntergraphEdge()) {
            tSDGraph2.inverseExpandedTransformPoint(tSDGraph, tSPoint);
            tSDGraph2.inverseExpandedTransformPoint(tSDGraph, tSPoint2);
            TSConstPoint tSConstPoint = tSShape.intersection(tSPoint.getX(), tSPoint.getY(), tSPoint2.getX(), tSPoint2.getY());
            if (tSConstPoint != null) {
                tSPoint.setLocation(tSConstPoint.getX(), tSConstPoint.getY());
            }
            TSPoint tSPoint3 = new TSPoint(tSPoint);
            tSDGraph2.expandedTransformPoint(tSDGraph, tSPoint3);
            return tSPoint3;
        }
        TSConstPoint tSConstPoint = tSShape.intersection(tSPoint.getX(), tSPoint.getY(), tSPoint2.getX(), tSPoint2.getY());
        if (tSConstPoint != null) {
            tSPoint.setLocation(tSConstPoint.getX(), tSConstPoint.getY());
        }
        return tSPoint;
    }

    public TSConstPoint getTargetClippingPoint() {
        TSPoint tSPoint = new TSPoint(this.getLocalTargetClippingPoint());
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        if (tSDGraph != null) {
            tSDGraph.expandedTransformPoint(tSPoint);
        }
        return tSPoint;
    }

    public TSConstPoint getLocalTargetClippingPoint() {
        TSPEdge tSPEdge = this.getLastDrawablePEdge();
        if (tSPEdge == null || tSPEdge == this.getTargetEdge() && !this.getTargetClipping().c()) {
            return this.getLocalTargetPoint();
        }
        TSPoint tSPoint = new TSPoint(tSPEdge.getLocalTargetPoint());
        TSPoint tSPoint2 = new TSPoint(tSPEdge.getLocalSourcePoint());
        TSShape tSShape = null;
        tSShape = this.getTargetConnector() != null ? this.getTargetConnector().getShape() : ((TSDNode)this.getTargetNode()).getShape();
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        TSDGraph tSDGraph2 = (TSDGraph)this.getTargetNode().getOwnerGraph();
        if (this.isIntergraphEdge()) {
            tSDGraph2.inverseExpandedTransformPoint(tSDGraph, tSPoint);
            tSDGraph2.inverseExpandedTransformPoint(tSDGraph, tSPoint2);
            TSConstPoint tSConstPoint = tSShape.intersection(tSPoint.getX(), tSPoint.getY(), tSPoint2.getX(), tSPoint2.getY());
            if (tSConstPoint != null) {
                tSPoint.setLocation(tSConstPoint.getX(), tSConstPoint.getY());
            }
            TSPoint tSPoint3 = new TSPoint(tSPoint);
            tSDGraph2.expandedTransformPoint(tSDGraph, tSPoint3);
            return tSPoint3;
        }
        TSConstPoint tSConstPoint = tSShape.intersection(tSPoint.getX(), tSPoint.getY(), tSPoint2.getX(), tSPoint2.getY());
        if (tSConstPoint != null) {
            tSPoint.setLocation(tSConstPoint.getX(), tSConstPoint.getY());
        }
        return tSPoint;
    }

    public TSConstPoint getSourceCenter() {
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        TSPoint tSPoint = new TSPoint(this.getLocalSourceCenter());
        if (tSDGraph != null) {
            tSDGraph.expandedTransformPoint(tSPoint);
        }
        return tSPoint;
    }

    public TSConstPoint getLocalSourceCenter() {
        TSPoint tSPoint = new TSPoint();
        TSConnector tSConnector = this.getSourceConnector();
        TSDNode tSDNode = (TSDNode)this.getSourceNode();
        if (tSConnector != null) {
            tSPoint.setLocation(tSConnector.getLocalCenterX(), tSConnector.getLocalCenterY());
        } else if (tSDNode != null) {
            tSPoint.setLocation(tSDNode.getLocalCenterX(), tSDNode.getLocalCenterY());
        }
        return tSPoint;
    }

    public TSConstPoint getTargetCenter() {
        TSDGraph tSDGraph = (TSDGraph)this.getTransformGraph();
        TSPoint tSPoint = new TSPoint(this.getLocalTargetCenter());
        if (tSDGraph != null) {
            tSDGraph.expandedTransformPoint(tSPoint);
        }
        return tSPoint;
    }

    public TSConstPoint getLocalTargetCenter() {
        TSPoint tSPoint = new TSPoint();
        TSConnector tSConnector = this.getTargetConnector();
        TSDNode tSDNode = (TSDNode)this.getTargetNode();
        if (tSConnector != null) {
            tSPoint.setLocation(tSConnector.getLocalCenterX(), tSConnector.getLocalCenterY());
        } else if (tSDNode != null) {
            tSPoint.setLocation(tSDNode.getLocalCenterX(), tSDNode.getLocalCenterY());
        }
        return tSPoint;
    }

    public void onDiscard(TSGraphObject tSGraphObject) {
        this.getSourceEdge().setSourceNode(null);
        this.getTargetEdge().setTargetNode(null);
        this.setSourceConnector(null);
        this.setTargetConnector(null);
        super.onDiscard(tSGraphObject);
    }

    public void onInsert(TSGraphObject tSGraphObject) {
        super.onInsert(tSGraphObject);
        this.updateBoundsOfLabels();
    }

    public void onRemove(TSGraphObject tSGraphObject) {
        super.onRemove(tSGraphObject);
        this.recomputeClippingPoints();
    }

    public void emptyTopology() {
        this.discardAllLabels();
        this.discardAllPathNodes();
        super.emptyTopology();
    }

    protected String getAttributeString() {
        return super.getAttributeString() + TSSystem.eol + "\tpathSegments = " + this.numberOfPathEdges() + TSSystem.eol + "\tlabels = " + this.numberOfLabels();
    }

    protected TSPEdge newPathEdge() {
        return new TSPEdge();
    }

    protected TSPNode newPathNode() {
        return new TSPNode(this);
    }

    protected TSEdgeLabel newLabel() {
        return new TSEdgeLabel(this);
    }

    public void setSourceNode(TSNode tSNode) {
        TSSystem.tsAssert(tSNode == null || tSNode instanceof TSDNode);
        if (this.getSourceNode() != tSNode) {
            super.setSourceNode(tSNode);
            if (this.getSourceNode() != null) {
                TSSystem.tsAssert(this.getSourceEdge() != null, "Null source edge");
                if (this.getSourceEdge() != null) {
                    this.getSourceEdge().setSourceNode(this.getSourceNode());
                }
                this.discardCalculatedSourceClipping();
                this.recomputeClippingPoints();
            }
        }
    }

    public void setTargetNode(TSNode tSNode) {
        TSSystem.tsAssert(tSNode == null || tSNode instanceof TSDNode);
        if (this.getTargetNode() != tSNode) {
            super.setTargetNode(tSNode);
            if (this.getTargetNode() != null) {
                TSSystem.tsAssert(this.getTargetEdge() != null, "Null target edge");
                if (this.getTargetEdge() != null) {
                    this.getTargetEdge().setTargetNode(this.getTargetNode());
                }
                this.discardCalculatedTargetClipping();
                this.recomputeClippingPoints();
            }
        }
    }

    TSPEdge addPEdge(TSGNode tSGNode, TSGNode tSGNode2) {
        TSSystem.tsAssert(tSGNode != null);
        TSSystem.tsAssert(tSGNode2 != null);
        TSSystem.tsAssert(tSGNode.isOwned() || !tSGNode.isPathNode());
        TSSystem.tsAssert(tSGNode2.isOwned() || !tSGNode2.isPathNode());
        TSPEdge tSPEdge = this.newPathEdge();
        tSPEdge.setSourceNode(tSGNode);
        tSPEdge.setTargetNode(tSGNode2);
        this.insert(tSPEdge);
        return tSPEdge;
    }

    TSPNode addPNode(TSPEdge tSPEdge, TSConstPoint tSConstPoint, boolean bl) {
        TSSystem.tsAssert(tSPEdge != null);
        TSSystem.tsAssert(tSConstPoint != null);
        TSSystem.tsAssert(tSPEdge.getOwner() == this);
        TSPNode tSPNode = this.newPathNode();
        this.insert(tSPNode);
        if (bl) {
            tSPNode.setLocalCenter(tSConstPoint.getX(), tSConstPoint.getY());
        } else {
            tSPNode.setCenter(tSConstPoint.getX(), tSConstPoint.getY());
        }
        TSGNode tSGNode = (TSGNode)tSPEdge.getTargetNode();
        tSPEdge.setTargetNode(tSPNode);
        if (tSPEdge == this.getTargetEdge()) {
            this.setTargetEdge(null);
        }
        this.addPEdge(tSPNode, tSGNode);
        if (this.isOwned() && ((TSDGraph)this.getOwner()).isGeometryChangeNotified()) {
            this.updateBoundsOfLabels();
            this.recomputeClippingPoints();
        }
        if (this.getOwnerGraph() != null) {
            this.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(4L, new TSDrawingChangeEventData(tSPNode, null, this)));
        }
        return tSPNode;
    }

    void discard(TSPEdge tSPEdge) {
        TSSystem.tsAssert(tSPEdge != null);
        TSSystem.tsAssert(tSPEdge.isOwned());
        TSSystem.tsAssert(tSPEdge.getOwner() == this);
        this.remove(tSPEdge);
        tSPEdge.onDiscard(this);
    }

    void discardBend(TSPNode tSPNode) {
        TSSystem.tsAssert(tSPNode != null);
        TSSystem.tsAssert(tSPNode.isOwned());
        TSSystem.tsAssert(tSPNode.getOwner() == this);
        if (this.getOwnerGraph() != null && this.getOwnerGraph().isFiringEvents()) {
            this.getOwnerGraph().setFireEvents(false);
            this.remove(tSPNode);
            this.getOwnerGraph().setFireEvents(true);
        } else {
            this.remove(tSPNode);
        }
        tSPNode.onDiscard(this);
    }

    void insert(TSPEdge tSPEdge) {
        TSSystem.tsAssert(tSPEdge != null);
        TSSystem.tsAssert(!tSPEdge.isOwned());
        TSSystem.tsAssert(tSPEdge.getSourceNode() != null);
        TSSystem.tsAssert(tSPEdge.getTargetNode() != null);
        tSPEdge.onInsert(this);
        if (this.getSourceEdge() == null) {
            this.setSourceEdge(tSPEdge);
        }
        if (this.getTargetEdge() == null) {
            this.setTargetEdge(tSPEdge);
        }
        ++this.segmentCount;
    }

    void insert(TSPNode tSPNode) {
        TSSystem.tsAssert(tSPNode != null);
        TSSystem.tsAssert(!tSPNode.isOwned());
        tSPNode.onInsert(this);
        TSGraphObject tSGraphObject = this.getOwner();
        if (this.isOwned() && ((TSDGraph)tSGraphObject).isGeometryChangeNotified()) {
            this.notifyGraphOnInsert(this.getLocalBounds(7));
        }
    }

    void remove(TSPNode tSPNode) {
        TSSystem.tsAssert(tSPNode != null);
        TSSystem.tsAssert(tSPNode.isOwned());
        TSSystem.tsAssert(tSPNode.getOwner() == this);
        tSPNode.onRemove(this);
        TSGraphObject tSGraphObject = this.getOwner();
        if (this.isOwned() && ((TSDGraph)tSGraphObject).isGeometryChangeNotified()) {
            this.notifyGraphOnRemove(tSPNode.getLocalBounds());
        }
    }

    void remove(TSPEdge tSPEdge) {
        TSSystem.tsAssert(tSPEdge != null);
        TSSystem.tsAssert(tSPEdge.isOwned());
        TSSystem.tsAssert(tSPEdge.getOwner() == this);
        tSPEdge.onRemove(this);
        if (tSPEdge == this.getSourceEdge()) {
            this.setSourceEdge(null);
        }
        if (tSPEdge == this.getTargetEdge()) {
            this.setTargetEdge(null);
        }
        --this.segmentCount;
    }

    protected void setSourceEdge(TSPEdge tSPEdge) {
        this.sourceEdge = tSPEdge;
    }

    protected void setTargetEdge(TSPEdge tSPEdge) {
        this.targetEdge = tSPEdge;
    }

    public void setSourceConnector(TSConnector tSConnector) {
        if (tSConnector != null) {
            TSSystem.tsAssert(tSConnector.isOwned());
            TSSystem.tsAssert(tSConnector.getOwner() == this.getSourceNode());
        }
        if (tSConnector != this.getSourceConnector()) {
            TSConnector tSConnector2 = this.getSourceConnector();
            this.sourceConnector = tSConnector;
            this.discardCalculatedSourceClipping();
            if (this.isOwned() && ((TSDGraph)this.getOwner()).isGeometryChangeNotified()) {
                this.updateBoundsOfLabels();
                this.recomputeClippingPoints();
            }
            this.fireEndConnectorChangedEvent(tSConnector2, tSConnector);
        }
    }

    public void setTargetConnector(TSConnector tSConnector) {
        if (tSConnector != null) {
            TSSystem.tsAssert(tSConnector.isOwned());
            TSSystem.tsAssert(tSConnector.getOwner() == this.getTargetNode());
        }
        if (tSConnector != this.getTargetConnector()) {
            TSConnector tSConnector2 = this.getTargetConnector();
            this.targetConnector = tSConnector;
            this.discardCalculatedTargetClipping();
            if (this.isOwned() && ((TSDGraph)this.getOwner()).isGeometryChangeNotified()) {
                this.updateBoundsOfLabels();
                this.recomputeClippingPoints();
            }
            this.fireEndConnectorChangedEvent(tSConnector2, tSConnector);
        }
    }

    public void disconnect() {
        if (this.isConnected() || this.isIntergraphEdge()) {
            TSConstRect tSConstRect = null;
            if (this.getTransformGraph() != null) {
                tSConstRect = this.getLocalBounds(7);
            }
            if (this.getSourceEdge() != null) {
                this.getSourceEdge().disconnect();
            }
            if (this.getTargetEdge() != null) {
                this.getTargetEdge().disconnect();
            }
            super.disconnect();
            if (this.getTransformGraph() != null && tSConstRect != null && this.isOwned() && ((TSDGraph)this.getOwner()).isGeometryChangeNotified()) {
                this.notifyGraphOnRemove(tSConstRect);
            }
        }
    }

    protected void connect() {
        if (!this.isConnected()) {
            TSDGraphManager tSDGraphManager;
            if (this.getSourceEdge() != null) {
                this.getSourceEdge().connect();
            }
            if (this.getTargetEdge() != null) {
                this.getTargetEdge().connect();
            }
            super.connect();
            TSDGraph tSDGraph = (TSDGraph)this.getSourceNode().getOwnerGraph();
            if (!tSDGraph.isHideGraph() && (tSDGraphManager = (TSDGraphManager)tSDGraph.getOwnerGraphManager()) != null && tSDGraphManager.getCommonNestedGraphOwner(this) != null && this.isOwned() && ((TSDGraph)this.getOwner()).isGeometryChangeNotified()) {
                this.notifyGraphOnInsert(this.getLocalBounds(7));
            }
        }
    }

    public boolean userObjectInUse() {
        boolean bl = super.userObjectInUse();
        Iterator iterator = this.bendIterator();
        while (!bl && iterator.hasNext()) {
            bl = ((TSPNode)iterator.next()).userObjectInUse();
        }
        iterator = this.pathIterator();
        while (!bl && iterator.hasNext()) {
            bl = ((TSPEdge)iterator.next()).userObjectInUse();
        }
        iterator = this.labels().iterator();
        while (!bl && iterator.hasNext()) {
            bl = ((TSEdgeLabel)iterator.next()).userObjectInUse();
        }
        return bl;
    }

    public void nullifyUserObject() {
        super.nullifyUserObject();
        Iterator iterator = this.bendIterator();
        while (iterator.hasNext()) {
            ((TSPNode)iterator.next()).nullifyUserObject();
        }
        iterator = this.pathIterator();
        while (iterator.hasNext()) {
            ((TSPEdge)iterator.next()).nullifyUserObject();
        }
        iterator = this.labels().iterator();
        while (iterator.hasNext()) {
            ((TSEdgeLabel)iterator.next()).nullifyUserObject();
        }
    }

    public long assignIDs(TSGraphObjectTable tSGraphObjectTable, long l) {
        Cloneable cloneable;
        Object object;
        if (l >= 0L) {
            tSGraphObjectTable.put(l++, this);
        } else {
            tSGraphObjectTable.put(this.getID(), this);
        }
        Iterator iterator = this.bendIterator();
        while (iterator.hasNext()) {
            object = (TSPNode)iterator.next();
            l = ((TSNode)object).assignIDs(tSGraphObjectTable, l);
        }
        object = this.pathIterator();
        while (object.hasNext()) {
            cloneable = (TSPEdge)object.next();
            l = ((TSEdge)cloneable).assignIDs(tSGraphObjectTable, l);
        }
        for (cloneable = this.labelSet.a(); cloneable != null; cloneable = ((f0)cloneable).a()) {
            TSEdgeLabel tSEdgeLabel = (TSEdgeLabel)((f0)cloneable).b();
            l = tSEdgeLabel.assignIDs(tSGraphObjectTable, l);
        }
        return l;
    }

    public boolean utilityObjectInUse() {
        boolean bl = super.utilityObjectInUse();
        Iterator iterator = this.bendIterator();
        while (!bl && iterator.hasNext()) {
            bl = ((TSPNode)iterator.next()).utilityObjectInUse();
        }
        iterator = this.pathIterator();
        while (!bl && iterator.hasNext()) {
            bl = ((TSPEdge)iterator.next()).utilityObjectInUse();
        }
        iterator = this.labels().iterator();
        while (!bl && iterator.hasNext()) {
            bl = ((TSEdgeLabel)iterator.next()).utilityObjectInUse();
        }
        return bl;
    }

    public void nullifyUtilityObject() {
        Cloneable cloneable;
        Object object;
        super.nullifyUtilityObject();
        Iterator iterator = this.bendIterator();
        while (iterator.hasNext()) {
            object = (TSPNode)iterator.next();
            ((TSGraphObject)object).nullifyUtilityObject();
        }
        object = this.pathIterator();
        while (object.hasNext()) {
            cloneable = (TSPEdge)object.next();
            ((TSGraphObject)cloneable).nullifyUtilityObject();
        }
        for (cloneable = this.labelSet.a(); cloneable != null; cloneable = ((f0)cloneable).a()) {
            TSEdgeLabel tSEdgeLabel = (TSEdgeLabel)((f0)cloneable).b();
            tSEdgeLabel.nullifyUtilityObject();
        }
    }

    public void setAllMarked(boolean bl) {
        Cloneable cloneable;
        Object object;
        super.setAllMarked(bl);
        Iterator iterator = this.bendIterator();
        while (iterator.hasNext()) {
            object = (TSPNode)iterator.next();
            ((TSGraphObject)object).setMarked(bl);
        }
        object = this.pathIterator();
        while (object.hasNext()) {
            cloneable = (TSPEdge)object.next();
            ((TSGraphObject)cloneable).setMarked(bl);
        }
        for (cloneable = this.labelSet.a(); cloneable != null; cloneable = ((f0)cloneable).a()) {
            TSEdgeLabel tSEdgeLabel = (TSEdgeLabel)((f0)cloneable).b();
            tSEdgeLabel.setMarked(bl);
        }
    }

    public boolean hasMarkedObject() {
        Cloneable cloneable;
        Object object;
        if (super.hasMarkedObject()) {
            return true;
        }
        Iterator iterator = this.bendIterator();
        while (iterator.hasNext()) {
            object = (TSPNode)iterator.next();
            if (!((TSGraphObject)object).isMarked()) continue;
            return true;
        }
        object = this.pathIterator();
        while (object.hasNext()) {
            cloneable = (TSPEdge)object.next();
            if (!((TSGraphObject)cloneable).isMarked()) continue;
            return true;
        }
        for (cloneable = this.labelSet.a(); cloneable != null; cloneable = ((f0)cloneable).a()) {
            TSEdgeLabel tSEdgeLabel = (TSEdgeLabel)((f0)cloneable).b();
            if (!tSEdgeLabel.isMarked()) continue;
            return true;
        }
        return false;
    }

    public boolean isVisible() {
        return super.isVisible();
    }

    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    public void fireEndConnectorChangedEvent(Object object, Object object2) {
        if (this.getOwnerGraphManager() == null) {
            return;
        }
        TSGraphObject tSGraphObject = this.getSourceConnector();
        if (tSGraphObject == null) {
            tSGraphObject = this.getTargetConnector();
        }
        if (tSGraphObject == null) {
            tSGraphObject = this;
        }
        if (tSGraphObject != null && tSGraphObject.getOwnerGraph() instanceof TSGraph) {
            tSGraphObject.getOwnerGraph().fireEvent(new TSDrawingChangeEvent(0x200000L, new TSDrawingChangeEventData(this, object, object2)));
        }
    }
}

